/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.io.File;
import net.java.sip.communicator.service.protocol.AbstractFileTransfer;
import net.java.sip.communicator.service.protocol.Contact;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransferImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ProgressStatusProvider;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionEventListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ControllerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.BuddyCancelledEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionTimedOutEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.LocallyCancelledEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferringFileEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailureEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SuccessfulStateInfo;

public class FileTransferImpl
extends AbstractFileTransfer {
    private String id = null;
    private Contact contact = null;
    private File file = null;
    private int direction = -1;
    private long transferedBytes;
    private FileTransfer fileTransfer;

    public FileTransferImpl(FileTransfer fileTransfer, String id, Contact contact, File file, int direction) {
        this.fileTransfer = fileTransfer;
        this.id = id;
        this.contact = contact;
        this.file = file;
        this.direction = direction;
        fileTransfer.addEventListener(new IcqFileTransferEventListener());
    }

    public void cancel() {
        this.fileTransfer.close();
    }

    public long getTransferedBytes() {
        return this.transferedBytes;
    }

    public String getID() {
        return this.id;
    }

    public int getDirection() {
        return this.direction;
    }

    public Contact getContact() {
        return this.contact;
    }

    public File getLocalFile() {
        return this.file;
    }

    public void setTransferedBytes(long transferedBytes) {
        this.transferedBytes = transferedBytes;
    }

    class IcqFileTransferEventListener
    implements RvConnectionEventListener {
        IcqFileTransferEventListener() {
        }

        @Override
        public void handleEventWithStateChange(final RvConnection transfer, RvConnectionState state, RvConnectionEvent event) {
            if (state == FileTransferState.CONNECTING) {
                if (transfer instanceof OutgoingFileTransferImpl) {
                    ((OutgoingFileTransferImpl)transfer).getStateController().addControllerListener(new ControllerListener(){

                        @Override
                        public void handleControllerSucceeded(StateController controller, SuccessfulStateInfo info) {
                        }

                        @Override
                        public void handleControllerFailed(StateController controller, FailedStateInfo info) {
                            if (info instanceof FailureEventInfo && ((FailureEventInfo)info).getEvent() instanceof ConnectionTimedOutEvent) {
                                FileTransferImpl.this.fireStatusChangeEvent(1);
                                FileTransferImpl.this.fileTransfer.close();
                            }
                        }
                    });
                }
            } else if (state == FileTransferState.FINISHED) {
                FileTransferImpl.this.fireStatusChangeEvent(0);
            } else if (state == FileTransferState.FAILED) {
                if (event instanceof LocallyCancelledEvent) {
                    FileTransferImpl.this.fireStatusChangeEvent(1);
                } else if (event instanceof BuddyCancelledEvent) {
                    if (FileTransferImpl.this.getTransferedBytes() > 0L) {
                        FileTransferImpl.this.fireStatusChangeEvent(1);
                    } else {
                        FileTransferImpl.this.fireStatusChangeEvent(3);
                    }
                } else if (event instanceof UnknownErrorEvent) {
                    FileTransferImpl.this.fireStatusChangeEvent(1);
                } else {
                    FileTransferImpl.this.fireStatusChangeEvent(2);
                }
            } else if (state == FileTransferState.TRANSFERRING && event instanceof TransferringFileEvent) {
                FileTransferImpl.this.fireStatusChangeEvent(4);
                final ProgressStatusProvider psp = ((TransferringFileEvent)event).getProgressProvider();
                new Thread("Transfer for " + transfer.getBuddyScreenname()){

                    @Override
                    public void run() {
                        while (transfer.isOpen()) {
                            long transfered = psp.getPosition();
                            FileTransferImpl.this.setTransferedBytes(transfered);
                            FileTransferImpl.this.fireProgressChangeEvent(System.currentTimeMillis(), transfered);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }.start();
            }
        }

        @Override
        public void handleEvent(RvConnection transfer, RvConnectionEvent event) {
        }
    }
}

