/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.io.IOException;
import org.jitsi.sctp4j.DirectLink;
import org.jitsi.sctp4j.Sctp;
import org.jitsi.sctp4j.SctpDataCallback;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.util.Logger;

public class SampleLoop {
    private static final Logger logger = Logger.getLogger(SampleLoop.class);

    public static void main(String[] args) throws Exception {
        Sctp.init();
        final SctpSocket server = Sctp.createSocket(5001);
        final SctpSocket client = Sctp.createSocket(5002);
        DirectLink link = new DirectLink(server, client);
        server.setLink(link);
        client.setLink(link);
        server.listen();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    client.connect(server.getPort());
                    logger.info("Client: connect");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int sent = client.send(new byte[200], false, 0, 0);
                    logger.info("Client sent: " + sent);
                }
                catch (IOException e) {
                    logger.error(e, e);
                }
            }
        }).start();
        server.setDataCallback(new SctpDataCallback(){

            @Override
            public void onSctpPacket(byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
                logger.info("Server got some data: " + data.length + " stream: " + sid + " payload protocol id: " + ppid);
            }
        });
        Thread.sleep(5000L);
        server.close();
        client.close();
        Sctp.finish();
    }
}

