/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.ice4j.util.RateStatistics;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtp.FrameDesc;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.util.ArrayUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.TimeUtils;

public class RTPEncodingDesc {
    private static final Logger logger = Logger.getLogger(RTPEncodingDesc.class);
    private static final int AVERAGE_BITRATE_WINDOW_MS = 5000;
    private final long primarySSRC;
    private final long rtxSSRC;
    private final int idx;
    private final int temporalId;
    private final MediaStreamTrackDesc track;
    private final RateStatistics rateStatistics = new RateStatistics(5000);
    private final TreeMap<Long, FrameDesc> frames = new TreeMap<Long, FrameDesc>(){
        private LinkedList<Long> tsl = new LinkedList();

        @Override
        public FrameDesc put(Long key, FrameDesc value) {
            FrameDesc previous = super.put(key, value);
            if (this.tsl.add(key) && this.tsl.size() > 300) {
                Long first = this.tsl.removeFirst();
                this.remove(first);
            }
            return previous;
        }
    };
    private final RTPEncodingDesc[] dependencyEncodings;
    private boolean active = false;
    private long lastStableBitrateBps;
    private FrameDesc lastReceivedFrame;

    public RTPEncodingDesc(MediaStreamTrackDesc track, long primarySSRC) {
        this(track, primarySSRC, -1L);
    }

    public RTPEncodingDesc(MediaStreamTrackDesc track, long primarySSRC, long rtxSSRC) {
        this(track, 0, primarySSRC, rtxSSRC, -1, null);
    }

    public RTPEncodingDesc(MediaStreamTrackDesc track, int idx, long primarySSRC, long rtxSSRC, int temporalId, RTPEncodingDesc[] dependencyEncodings) {
        this.primarySSRC = primarySSRC;
        this.rtxSSRC = rtxSSRC;
        this.track = track;
        this.idx = idx;
        this.temporalId = temporalId;
        this.dependencyEncodings = dependencyEncodings;
    }

    private static void applyFrameBoundsHeuristics(FrameDesc a, FrameDesc b) {
        int end = a.getEnd();
        int start = b.getStart();
        if (end != -1 && start != -1) {
            return;
        }
        long tsDiff = b.getTimestamp() - a.getTimestamp() & 0xFFFFFFFFL;
        if (tsDiff > 0x40000000L && tsDiff < 0xC0000000L) {
            return;
        }
        if (tsDiff >= 0xC0000000L) {
            logger.warn("Frames that are out of order detected.");
        } else {
            int min = b.getMinSeen();
            int max = a.getMaxSeen();
            int snDiff = max - min & 0xFFFF;
            if (start != -1 || end != -1) {
                if (snDiff == 2) {
                    if (end == -1) {
                        a.setEnd(max + 1 & 0xFFFF);
                    } else {
                        b.setStart(min - 1 & 0xFFFF);
                    }
                } else if (snDiff < 2 || snDiff > 65533) {
                    logger.warn("Frame corruption or packets that are out of order detected.");
                }
            } else if (snDiff == 3) {
                a.setEnd(max + 1 & 0xFFFF);
                b.setStart(min - 1 & 0xFFFF);
            } else if (snDiff < 3 || snDiff > 65532) {
                logger.warn("Frame corruption or packets that are out of order detected.");
            }
        }
    }

    public long getLastStableBitrateBps() {
        return this.lastStableBitrateBps;
    }

    public long getPrimarySSRC() {
        return this.primarySSRC;
    }

    public long getRTXSSRC() {
        return this.rtxSSRC;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return "subjective_quality=" + this.idx + ",primary_ssrc=" + this.getPrimarySSRC() + ",rtx_ssrc=" + this.getRTXSSRC() + ",temporal_id=" + this.temporalId + ",active=" + this.active + ",last_stable_bitrate_bps=" + this.lastStableBitrateBps;
    }

    public MediaStreamTrackDesc getMediaStreamTrack() {
        return this.track;
    }

    public int getIndex() {
        return this.idx;
    }

    boolean requires(int idx) {
        if (idx < 0) {
            return false;
        }
        if (idx == this.idx) {
            return true;
        }
        boolean requires = false;
        if (!ArrayUtils.isNullOrEmpty(this.dependencyEncodings)) {
            for (RTPEncodingDesc enc : this.dependencyEncodings) {
                if (!enc.requires(idx)) continue;
                requires = true;
                break;
            }
        }
        return requires;
    }

    public boolean matches(byte[] buf, int off, int len) {
        long ssrc = RawPacket.getSSRCAsLong(buf, off, len);
        if (this.primarySSRC != ssrc && this.rtxSSRC != ssrc) {
            return false;
        }
        if (this.temporalId == -1) {
            return true;
        }
        int tid = this.track.getMediaStreamTrackReceiver().getStream().getTemporalID(buf, off, len);
        return tid == -1 && this.idx == 0 || tid == this.temporalId;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrameDesc update(RawPacket pkt, long nowMs) {
        boolean frameChanged;
        this.rateStatistics.update(pkt.getLength(), nowMs);
        long ts = pkt.getTimestamp();
        FrameDesc frame = this.frames.get(ts);
        if (frame == null) {
            TreeMap<Long, FrameDesc> treeMap = this.frames;
            synchronized (treeMap) {
                frame = new FrameDesc(this, ts, nowMs);
                this.frames.put(ts, frame);
            }
            this.lastStableBitrateBps = this.getBitrateBps(nowMs);
            if (this.lastReceivedFrame == null || TimeUtils.rtpDiff(ts, this.lastReceivedFrame.getTimestamp()) > 0L) {
                this.lastReceivedFrame = frame;
            }
        }
        boolean bl = frameChanged = pkt.getPayloadLength(true) > 0 && frame.update(pkt);
        if (frameChanged) {
            Map.Entry<Long, FrameDesc> floorEntry;
            Map.Entry<Long, FrameDesc> ceilingEntry = this.frames.ceilingEntry(ts + 1L & 0xFFFFFFFFL);
            if (ceilingEntry != null) {
                RTPEncodingDesc.applyFrameBoundsHeuristics(frame, ceilingEntry.getValue());
            }
            if ((floorEntry = this.frames.floorEntry(ts - 1L & 0xFFFFFFFFL)) != null) {
                RTPEncodingDesc.applyFrameBoundsHeuristics(floorEntry.getValue(), frame);
            }
        }
        return frameChanged ? frame : null;
    }

    private long getBitrateBps(long nowMs) {
        RTPEncodingDesc[] encodings = this.track.getRTPEncodings();
        if (ArrayUtils.isNullOrEmpty(encodings)) {
            return 0L;
        }
        long[] rates = new long[encodings.length];
        this.getBitrateBps(nowMs, rates);
        long bitrate = 0L;
        for (int i = 0; i < rates.length; ++i) {
            bitrate += rates[i];
        }
        return bitrate;
    }

    private void getBitrateBps(long nowMs, long[] rates) {
        if (rates[this.idx] == 0L) {
            rates[this.idx] = this.rateStatistics.getRate(nowMs);
        }
        if (!ArrayUtils.isNullOrEmpty(this.dependencyEncodings)) {
            for (RTPEncodingDesc dependency : this.dependencyEncodings) {
                dependency.getBitrateBps(nowMs, rates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameDesc findFrameDesc(byte[] buf, int off, int len) {
        long ts = RawPacket.getTimestamp(buf, off, len);
        TreeMap<Long, FrameDesc> treeMap = this.frames;
        synchronized (treeMap) {
            return this.frames.get(ts);
        }
    }

    public FrameDesc getLastReceivedFrame() {
        return this.lastReceivedFrame;
    }
}

