/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.globalchooser;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.plaf.TextUI;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTextFieldUI;
import net.java.sip.communicator.plugin.keybindingchooser.KeybindingChooserActivator;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.GlobalShortcutEntry;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.Resources;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutEvent;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutListener;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.OSUtils;

public class GlobalShortcutDialog
extends SIPCommDialog
implements ActionListener,
GlobalShortcutListener {
    private static final long serialVersionUID = 0L;
    private static final String PRESS_TO_SETUP_SHORTCUT = Resources.getString("plugin.keybindings.globalchooser.PRESS_BTN");
    private final GlobalShortcutEntry entry;
    private final JButton btnOK = new JButton(Resources.getString("service.gui.OK"));
    private final JButton btnCancel = new JButton(Resources.getString("service.gui.CANCEL"));
    private final JCheckBox specialBox = new SIPCommCheckBox(Resources.getString("plugin.keybindings.globalchooser.ENABLE_SPECIAL"));
    private final ShortcutField fldShortcut = new ShortcutField(PRESS_TO_SETUP_SHORTCUT);
    private final ShortcutField fldShortcut2 = new ShortcutField(PRESS_TO_SETUP_SHORTCUT);
    private int retCode = 0;

    public GlobalShortcutDialog(Dialog dialog, GlobalShortcutEntry entry) {
        super(dialog);
        this.setModal(true);
        this.setTitle("Global shortcut: " + entry.getAction());
        this.entry = entry;
        this.init();
    }

    private void init() {
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel btnPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        TransparentPanel shortcutPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 2, 0, 10));
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        KeyAdapter keyAdapter = new KeyAdapter(){
            private KeyEvent buffer = null;

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    SIPCommTextField field = (SIPCommTextField)event.getSource();
                    AWTKeyStroke ks = null;
                    if (field == GlobalShortcutDialog.this.fldShortcut) {
                        ks = GlobalShortcutDialog.this.entry.getShortcut();
                    } else if (field == GlobalShortcutDialog.this.fldShortcut2) {
                        ks = GlobalShortcutDialog.this.entry.getShortcut2();
                    }
                    if (ks == null) {
                        field.setText(PRESS_TO_SETUP_SHORTCUT);
                    } else if (ks.getModifiers() == 16367) {
                        field.setText("Special");
                    } else {
                        field.setText(GlobalShortcutEntry.getShortcutText(GlobalShortcutDialog.this.entry.getShortcut()));
                    }
                    GlobalShortcutDialog.this.btnOK.requestFocusInWindow();
                    return;
                }
                if (event.getKeyCode() == 0) {
                    return;
                }
                this.buffer = event;
            }

            @Override
            public void keyReleased(KeyEvent event) {
                if (this.buffer != null) {
                    SIPCommTextField field = (SIPCommTextField)event.getSource();
                    KeyStroke input = KeyStroke.getKeyStrokeForEvent(this.buffer);
                    this.buffer = null;
                    GlobalShortcutEntry en = GlobalShortcutDialog.this.entry;
                    ArrayList<AWTKeyStroke> kss = new ArrayList<AWTKeyStroke>();
                    if (field == GlobalShortcutDialog.this.fldShortcut) {
                        kss.add(input);
                        kss.add(en.getShortcut2());
                    } else if (field == GlobalShortcutDialog.this.fldShortcut2) {
                        kss.add(en.getShortcut());
                        kss.add(input);
                    }
                    en.setShortcuts(kss);
                    en.setEditShortcut1(false);
                    en.setEditShortcut2(false);
                    field.setText(GlobalShortcutEntry.getShortcutText(input));
                    GlobalShortcutDialog.this.btnOK.requestFocus();
                }
            }
        };
        AWTKeyStroke ks = this.entry.getShortcut();
        AWTKeyStroke ks2 = this.entry.getShortcut2();
        if (ks != null) {
            if (ks.getModifiers() != 16367) {
                this.fldShortcut.setText(GlobalShortcutEntry.getShortcutText(ks));
            } else {
                this.fldShortcut.setText("Special");
            }
        }
        if (ks2 != null) {
            if (ks2.getModifiers() != 16367) {
                this.fldShortcut2.setText(GlobalShortcutEntry.getShortcutText(ks2));
            } else {
                this.fldShortcut2.setText("Special");
            }
        }
        this.fldShortcut.addKeyListener(keyAdapter);
        this.fldShortcut2.addKeyListener(keyAdapter);
        this.specialBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                KeybindingChooserActivator.getGlobalShortcutService().setSpecialKeyDetection(evt.getStateChange() == 1, (GlobalShortcutListener)GlobalShortcutDialog.this);
            }
        });
        shortcutPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        shortcutPanel.add(new JLabel("Primary shortcut"));
        shortcutPanel.add((Component)((Object)this.fldShortcut));
        shortcutPanel.add(new JLabel("Secondary shortcut"));
        shortcutPanel.add((Component)((Object)this.fldShortcut2));
        if (OSUtils.IS_WINDOWS) {
            shortcutPanel.add((Component)new TransparentPanel());
            shortcutPanel.add(this.specialBox);
        }
        mainPanel.add((Component)shortcutPanel, (Object)"Center");
        btnPanel.add(this.btnOK);
        btnPanel.add(this.btnCancel);
        mainPanel.add((Component)btnPanel, (Object)"South");
        this.btnOK.requestFocus();
        this.getContentPane().add((Component)mainPanel);
        this.pack();
    }

    protected void close(boolean isEscaped) {
        super.close(isEscaped);
        KeybindingChooserActivator.getGlobalShortcutService().setSpecialKeyDetection(false, (GlobalShortcutListener)this);
    }

    public int showDialog() {
        this.setVisible(true);
        this.setVisible(false);
        return this.retCode;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.btnOK) {
            this.retCode = 1;
            this.dispose();
        } else if (obj == this.btnCancel) {
            this.retCode = 0;
            this.dispose();
        }
    }

    public void shortcutReceived(GlobalShortcutEvent evt) {
        AWTKeyStroke ksr = evt.getKeyStroke();
        if (ksr.getModifiers() != 16367) {
            return;
        }
        if (!this.fldShortcut.isFocusOwner() && !this.fldShortcut2.isFocusOwner()) {
            return;
        }
        ArrayList<AWTKeyStroke> kss = new ArrayList<AWTKeyStroke>();
        if (this.fldShortcut.isFocusOwner()) {
            kss.add(ksr);
            kss.add(this.entry.getShortcut2());
            this.fldShortcut.setText("Special");
        } else if (this.fldShortcut2.isFocusOwner()) {
            kss.add(this.entry.getShortcut());
            kss.add(ksr);
            this.fldShortcut2.setText("Special");
        }
        this.entry.setShortcuts(kss);
        KeybindingChooserActivator.getGlobalShortcutService().setSpecialKeyDetection(false, (GlobalShortcutListener)this);
    }

    public void clearTextField(SIPCommTextFieldUI ui) {
        ArrayList<AWTKeyStroke> kss = new ArrayList<AWTKeyStroke>();
        if (ui == this.fldShortcut.getUI()) {
            kss.add(null);
            kss.add(this.entry.getShortcut2());
            this.entry.setShortcuts(kss);
            this.btnOK.requestFocusInWindow();
        } else if (ui == this.fldShortcut2.getUI()) {
            kss.add(this.entry.getShortcut());
            kss.add(null);
            this.entry.setShortcuts(kss);
            this.btnOK.requestFocusInWindow();
        }
    }

    public class ShortcutFieldUI
    extends SIPCommTextFieldUI
    implements Skinnable {
        public ShortcutFieldUI() {
            this.loadSkin();
        }

        protected void installListeners() {
            super.installListeners();
        }

        protected void updateDeleteIcon(MouseEvent evt) {
            super.updateDeleteIcon(evt);
            Rectangle deleteRect = this.getDeleteButtonRect();
            if (deleteRect.contains(evt.getX(), evt.getY()) && evt.getID() == 500) {
                GlobalShortcutDialog.this.clearTextField(this);
            }
        }

        protected void paintSafely(Graphics g) {
            this.customPaintBackground(g);
            super.paintSafely(g);
        }

        protected void customPaintBackground(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                AntialiasingManager.activateAntialiasing((Graphics)g2);
                super.customPaintBackground((Graphics)g2);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private class ShortcutField
    extends SIPCommTextField
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private ShortcutFieldUI textFieldUI;

        public ShortcutField(String text) {
            super(text);
            this.textFieldUI = new ShortcutFieldUI();
            this.textFieldUI.setDeleteButtonEnabled(true);
            this.setPreferredSize(new Dimension(200, 23));
            this.setUI((TextUI)((Object)this.textFieldUI));
            this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            this.setOpaque(false);
            this.setDragEnabled(true);
            this.loadSkin();
        }

        public void loadSkin() {
            this.textFieldUI.loadSkin();
        }
    }
}

