/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.chooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;

public class BindingEntry
extends TransparentPanel {
    public static final KeyStroke DISABLED = null;
    private static final int LINE_HEIGHT = 25;
    private static final int INDENT_WIDTH = 25;
    private static final int ACTION_WIDTH = 150;
    private static final int SHORTCUT_WIDTH = 150;
    private static final long serialVersionUID = 0L;
    private JLabel indentField = new JLabel();
    private JLabel actionField = new JLabel();
    private JLabel shortcutField = new JLabel();
    private KeyStroke shortcut;

    public BindingEntry(KeyStroke shortcut, String action) {
        this.indentField.setPreferredSize(new Dimension(25, 25));
        this.indentField.setForeground(Color.BLACK);
        this.actionField.setPreferredSize(new Dimension(150, 25));
        this.actionField.setForeground(Color.BLACK);
        this.shortcutField.setPreferredSize(new Dimension(150, 25));
        this.shortcutField.setForeground(Color.BLACK);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setAction(action);
        this.setShortcut(shortcut);
        this.add(this.indentField);
        this.add(this.actionField);
        this.add(this.shortcutField);
    }

    public KeyStroke getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(KeyStroke shortcut) {
        this.shortcut = shortcut;
        if (this.shortcut == DISABLED) {
            this.shortcutField.setText(" Disabled");
        } else {
            StringBuffer buffer = new StringBuffer();
            if (this.shortcut.getKeyEventType() == 400) {
                buffer.append(this.shortcut.getKeyChar());
            } else {
                boolean altMask;
                int keycode = this.shortcut.getKeyCode();
                int modifiers = this.shortcut.getModifiers();
                boolean shiftMask = (modifiers & 1) != 0;
                boolean ctrlMask = (modifiers & 2) != 0;
                boolean metaMask = (modifiers & 4) != 0;
                boolean bl = altMask = (modifiers & 8) != 0;
                if (shiftMask && keycode != 16) {
                    buffer.append("Shift + ");
                }
                if (ctrlMask && keycode != 17) {
                    buffer.append("Ctrl + ");
                }
                if (metaMask && keycode != 157) {
                    buffer.append("Meta + ");
                }
                if (altMask && keycode != 18) {
                    buffer.append("Alt + ");
                }
                buffer.append(KeyEvent.getKeyText(keycode));
            }
            this.shortcutField.setText(" " + buffer.toString());
        }
    }

    public String getAction() {
        return this.actionField.getText().substring(1);
    }

    public void setAction(String action) {
        this.actionField.setText(" " + action);
    }

    public boolean isDisabled() {
        return this.shortcut == DISABLED;
    }

    public JLabel getField(Field field) {
        if (field == Field.INDENT) {
            return this.indentField;
        }
        if (field == Field.ACTION) {
            return this.actionField;
        }
        if (field == Field.SHORTCUT) {
            return this.shortcutField;
        }
        assert (false) : "Unrecognized field: " + (Object)((Object)field);
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BindingEntry (");
        if (this.isDisabled()) {
            builder.append("Disabled");
        } else {
            builder.append(this.getShortcut());
        }
        builder.append(" \u2192 ");
        builder.append(this.getAction());
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BindingEntry)) {
            return false;
        }
        BindingEntry entry = (BindingEntry)((Object)obj);
        boolean equals = true;
        String action = this.getAction();
        equals = action == null ? (equals &= entry.getAction() == null) : (equals &= action.equals(entry.getAction()));
        KeyStroke shortcut = this.getShortcut();
        equals = shortcut == null ? (equals &= entry.getShortcut() == null) : (equals &= shortcut.equals(entry.getShortcut()));
        return equals;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hash = 37 * hash + (this.getShortcut() == null ? 0 : this.getShortcut().hashCode());
        return hash;
    }

    public static enum Field {
        INDENT,
        ACTION,
        SHORTCUT;

    }
}

