/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.OSUtils;

public class SIPCommScrollPane
extends JScrollPane
implements Skinnable {
    private static final long serialVersionUID = 0L;

    public SIPCommScrollPane() {
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        this.setViewport(new SCViewport());
        this.getVerticalScrollBar().setUnitIncrement(100);
    }

    @Override
    public void setViewportView(Component view) {
        if (view instanceof JComponent) {
            JComponent viewAsJComponent = (JComponent)view;
            viewAsJComponent.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            viewAsJComponent.setOpaque(false);
        }
        super.setViewportView(view);
    }

    public void loadSkin() {
        ((SCViewport)this.getViewport()).loadSkin();
    }

    public void dispose() {
        block4: {
            if (OSUtils.IS_MAC) {
                try {
                    PropertyChangeListener[] pcl;
                    Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                    for (PropertyChangeListener pc : pcl = defaultToolkit.getPropertyChangeListeners("apple.awt.contentScaleFactor")) {
                        Field f = pc.getClass().getDeclaredField("this$0");
                        f.setAccessible(true);
                        if (!f.get(pc).equals(this.getViewport())) continue;
                        defaultToolkit.removePropertyChangeListener("apple.awt.contentScaleFactor", pc);
                        break;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block4;
                    throw (ThreadDeath)t;
                }
            }
        }
    }

    private static class SCViewport
    extends JViewport
    implements Skinnable {
        private static final long serialVersionUID = 1L;
        private BufferedImage bgImage;
        private Color color;
        private TexturePaint texture;

        public SCViewport() {
            this.setBackground(Color.WHITE);
            this.loadSkin();
        }

        private boolean getSettingsBoolean(String key) {
            return Boolean.parseBoolean(DesktopUtilActivator.getResources().getSettingsString(key));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g = g.create();
            try {
                AntialiasingManager.activateAntialiasing(g);
                Graphics2D g2 = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                if (this.bgImage != null) {
                    if (this.texture != null) {
                        g2.setPaint(this.texture);
                        g2.fillRect(0, 0, width, height);
                    } else {
                        g.setColor(this.color);
                        g.fillRect(0, 0, width, height);
                        g2.drawImage((Image)this.bgImage, width - this.bgImage.getWidth(), height - this.bgImage.getHeight(), this);
                    }
                }
            }
            finally {
                g.dispose();
            }
        }

        public void loadSkin() {
            if (this.getSettingsBoolean("impl.gui.IS_CONTACT_LIST_IMG_BG_ENABLED")) {
                this.bgImage = DesktopUtilActivator.getImage("service.gui.MAIN_WINDOW_BACKGROUND");
                if (this.getSettingsBoolean("impl.gui.IS_CONTACT_LIST_TEXTURE_BG_ENABLED") && this.bgImage != null) {
                    this.texture = new TexturePaint(this.bgImage, new Rectangle(0, 0, this.bgImage.getWidth(null), this.bgImage.getHeight(null)));
                    this.color = null;
                } else {
                    this.texture = null;
                    this.color = new Color(DesktopUtilActivator.getResources().getColor("service.gui.CONTACT_LIST_BACKGROUND"));
                }
            } else {
                this.bgImage = null;
                this.texture = null;
                this.color = null;
            }
        }
    }
}

