/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.cert.Certificate;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.AuthenticationWindow;
import net.java.sip.communicator.plugin.desktoputil.MasterPasswordInputDialog;
import net.java.sip.communicator.plugin.desktoputil.VerifyCertificateDialogImpl;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.certificate.VerifyCertificateDialogService;
import net.java.sip.communicator.service.credentialsstorage.MasterPasswordInputService;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.gui.AuthenticationWindowService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class DesktopUtilActivator
implements BundleActivator,
VerifyCertificateDialogService {
    private static final Logger logger = Logger.getLogger(DesktopUtilActivator.class);
    private static ConfigurationService configurationService;
    private static ResourceManagementService resourceService;
    private static KeybindingsService keybindingsService;
    private static BrowserLauncherService browserLauncherService;
    private static UIService uiService;
    private static AccountManager accountManager;
    private static FileAccessService fileAccessService;
    private static MediaService mediaService;
    private static AudioNotifierService audioNotifierService;
    private static GlobalDisplayDetailsService globalDisplayDetailsService;
    static BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        bundleContext.registerService(VerifyCertificateDialogService.class.getName(), (Object)this, null);
        bundleContext.registerService(MasterPasswordInputService.class.getName(), (Object)new MasterPasswordInputService(){

            public String showInputDialog(boolean prevSuccess) {
                return MasterPasswordInputDialog.showInput(prevSuccess);
            }
        }, null);
        bundleContext.registerService(AuthenticationWindowService.class.getName(), (Object)new AuthenticationWindowService(){

            public AuthenticationWindowService.AuthenticationWindow create(String userName, char[] password, String server, boolean isUserNameEditable, boolean isRememberPassword, Object icon, String windowTitle, String windowText, String usernameLabelText, String passwordLabelText, String errorMessage, String signupLink) {
                ImageIcon imageIcon = null;
                if (icon instanceof ImageIcon) {
                    imageIcon = (ImageIcon)icon;
                }
                AuthenticationWindowCreator creator = new AuthenticationWindowCreator(userName, password, server, isUserNameEditable, isRememberPassword, imageIcon, windowTitle, windowText, usernameLabelText, passwordLabelText, errorMessage, signupLink);
                try {
                    SwingUtilities.invokeAndWait(creator);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Error creating dialog", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)"Error creating dialog", (Throwable)e);
                }
                return creator.authenticationWindow;
            }
        }, null);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public static BufferedImage getImage(String imageID) {
        BufferedImage image = null;
        URL path = DesktopUtilActivator.getResources().getImageURL(imageID);
        if (path == null) {
            return null;
        }
        try {
            image = ImageIO.read(path);
        }
        catch (Exception exc) {
            logger.error((Object)("Failed to load image:" + path), (Throwable)exc);
        }
        return image;
    }

    public static KeybindingsService getKeybindingsService() {
        if (keybindingsService == null) {
            keybindingsService = (KeybindingsService)ServiceUtils.getService((BundleContext)bundleContext, KeybindingsService.class);
        }
        return keybindingsService;
    }

    public static BrowserLauncherService getBrowserLauncher() {
        if (browserLauncherService == null) {
            browserLauncherService = (BrowserLauncherService)ServiceUtils.getService((BundleContext)bundleContext, BrowserLauncherService.class);
        }
        return browserLauncherService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public VerifyCertificateDialogService.VerifyCertificateDialog createDialog(Certificate[] certs, String title, String message) {
        VerifyCertificateDialogCreator creator = new VerifyCertificateDialogCreator(certs, title, message);
        try {
            SwingUtilities.invokeAndWait(creator);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error creating dialog", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"Error creating dialog", (Throwable)e);
        }
        return creator.dialog;
    }

    public static AccountManager getAccountManager() {
        if (accountManager == null) {
            accountManager = (AccountManager)ServiceUtils.getService((BundleContext)bundleContext, AccountManager.class);
        }
        return accountManager;
    }

    public static FileAccessService getFileAccessService() {
        if (fileAccessService == null) {
            fileAccessService = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        }
        return fileAccessService;
    }

    public static MediaService getMediaService() {
        if (mediaService == null) {
            mediaService = (MediaService)ServiceUtils.getService((BundleContext)bundleContext, MediaService.class);
        }
        return mediaService;
    }

    public static AudioNotifierService getAudioNotifier() {
        if (audioNotifierService == null) {
            audioNotifierService = (AudioNotifierService)ServiceUtils.getService((BundleContext)bundleContext, AudioNotifierService.class);
        }
        return audioNotifierService;
    }

    public static GlobalDisplayDetailsService getGlobalDisplayDetailsService() {
        if (globalDisplayDetailsService == null) {
            globalDisplayDetailsService = (GlobalDisplayDetailsService)ServiceUtils.getService((BundleContext)bundleContext, GlobalDisplayDetailsService.class);
        }
        return globalDisplayDetailsService;
    }

    private class AuthenticationWindowCreator
    implements Runnable {
        String userName;
        char[] password;
        String server;
        boolean isUserNameEditable;
        boolean isRememberPassword;
        String windowTitle;
        String windowText;
        String usernameLabelText;
        String passwordLabelText;
        String errorMessage;
        String signupLink;
        ImageIcon imageIcon;
        AuthenticationWindowService.AuthenticationWindow authenticationWindow;

        public AuthenticationWindowCreator(String userName, char[] password, String server, boolean isUserNameEditable, boolean isRememberPassword, ImageIcon imageIcon, String windowTitle, String windowText, String usernameLabelText, String passwordLabelText, String errorMessage, String signupLink) {
            this.userName = userName;
            this.password = password;
            this.server = server;
            this.isUserNameEditable = isUserNameEditable;
            this.isRememberPassword = isRememberPassword;
            this.windowTitle = windowTitle;
            this.windowText = windowText;
            this.usernameLabelText = usernameLabelText;
            this.passwordLabelText = passwordLabelText;
            this.errorMessage = errorMessage;
            this.signupLink = signupLink;
            this.imageIcon = imageIcon;
        }

        @Override
        public void run() {
            this.authenticationWindow = new AuthenticationWindow(this.userName, this.password, this.server, this.isUserNameEditable, this.isRememberPassword, this.imageIcon, this.windowTitle, this.windowText, this.usernameLabelText, this.passwordLabelText, this.errorMessage, this.signupLink);
        }
    }

    private class VerifyCertificateDialogCreator
    implements Runnable {
        private final Certificate[] certs;
        private final String title;
        private final String message;
        VerifyCertificateDialogImpl dialog = null;

        private VerifyCertificateDialogCreator(Certificate[] certs, String title, String message) {
            this.certs = certs;
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            this.dialog = new VerifyCertificateDialogImpl(this.certs, this.title, this.message);
        }
    }
}

