/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.media.CaptureDeviceInfo;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.service.neomedia.MediaUseCase;

public class DeviceConfigurationComboBoxModel
implements ComboBoxModel,
ListModel,
PropertyChangeListener {
    public static final int AUDIO = 1;
    public static final int AUDIO_CAPTURE = 3;
    public static final int AUDIO_NOTIFY = 5;
    public static final int AUDIO_PLAYBACK = 4;
    public static final int VIDEO = 2;
    private AudioSystem[] audioSystems;
    private final DeviceConfiguration deviceConfiguration;
    private CaptureDevice[] devices;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private final int type;

    public DeviceConfigurationComboBoxModel(DeviceConfiguration deviceConfiguration, int type) {
        if (deviceConfiguration == null) {
            throw new IllegalArgumentException("deviceConfiguration");
        }
        if (type != 1 && type != 3 && type != 5 && type != 4 && type != 2) {
            throw new IllegalArgumentException("type");
        }
        this.deviceConfiguration = deviceConfiguration;
        this.type = type;
        if (type == 1 || type == 3 || type == 5 || type == 4) {
            deviceConfiguration.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void fireContentsChanged(int index0, int index1) {
        ListDataListener[] listeners = this.listeners.toArray(new ListDataListener[this.listeners.size()]);
        ListDataEvent event = new ListDataEvent(this, 0, index0, index1);
        for (ListDataListener listener : listeners) {
            listener.contentsChanged(event);
        }
    }

    private AudioSystem[] getAudioSystems() {
        if (this.type != 1) {
            throw new IllegalStateException("type");
        }
        this.audioSystems = this.deviceConfiguration.getAvailableAudioSystems();
        return this.audioSystems;
    }

    private CaptureDevice[] getDevices() {
        if (this.type == 1) {
            throw new IllegalStateException("type");
        }
        if (this.devices != null) {
            return this.devices;
        }
        List infos = null;
        switch (this.type) {
            case 3: {
                AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                infos = audioSystem == null ? null : audioSystem.getDevices(AudioSystem.DataFlow.CAPTURE);
                break;
            }
            case 5: {
                AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                infos = audioSystem == null ? null : audioSystem.getDevices(AudioSystem.DataFlow.NOTIFY);
                break;
            }
            case 4: {
                AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                infos = audioSystem == null ? null : audioSystem.getDevices(AudioSystem.DataFlow.PLAYBACK);
                break;
            }
            case 2: {
                infos = this.deviceConfiguration.getAvailableVideoCaptureDevices(MediaUseCase.CALL);
                break;
            }
            default: {
                throw new IllegalStateException("type");
            }
        }
        int deviceCount = infos == null ? 0 : infos.size();
        this.devices = new CaptureDevice[deviceCount + 1];
        if (deviceCount > 0) {
            for (int i = 0; i < deviceCount; ++i) {
                this.devices[i] = new CaptureDevice((CaptureDeviceInfo)infos.get(i));
            }
        }
        this.devices[deviceCount] = new CaptureDevice(null);
        return this.devices;
    }

    public Object getElementAt(int index) {
        if (this.type == 1) {
            return this.getAudioSystems()[index];
        }
        return this.getDevices()[index];
    }

    private CaptureDevice getSelectedDevice() {
        CaptureDeviceInfo info;
        switch (this.type) {
            case 3: {
                AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                info = audioSystem == null ? null : audioSystem.getSelectedDevice(AudioSystem.DataFlow.CAPTURE);
                break;
            }
            case 5: {
                AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                info = audioSystem == null ? null : audioSystem.getSelectedDevice(AudioSystem.DataFlow.NOTIFY);
                break;
            }
            case 4: {
                AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                info = audioSystem == null ? null : audioSystem.getSelectedDevice(AudioSystem.DataFlow.PLAYBACK);
                break;
            }
            case 2: {
                info = this.deviceConfiguration.getVideoCaptureDevice(MediaUseCase.ANY);
                break;
            }
            default: {
                throw new IllegalStateException("type");
            }
        }
        for (CaptureDevice device : this.getDevices()) {
            if (!device.equals(info)) continue;
            return device;
        }
        return null;
    }

    @Override
    public Object getSelectedItem() {
        if (this.type == 1) {
            return this.deviceConfiguration.getAudioSystem();
        }
        return this.getSelectedDevice();
    }

    @Override
    public int getSize() {
        if (this.type == 1) {
            return this.getAudioSystems().length;
        }
        return this.getDevices().length;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent ev) {
        if ("net.java.sip.communicator.impl.neomedia.audioSystem.devices".equals(ev.getPropertyName())) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.audioSystems = null;
                this.devices = null;
                this.fireContentsChanged(0, this.getSize() - 1);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeviceConfigurationComboBoxModel.this.propertyChange(ev);
                    }
                });
            }
        }
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        this.listeners.remove(listener);
    }

    private void setSelectedDevice(CaptureDevice device) {
        if (device == null) {
            return;
        }
        CaptureDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice != device) {
            switch (this.type) {
                case 3: {
                    AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                    if (audioSystem == null) break;
                    audioSystem.setDevice(AudioSystem.DataFlow.CAPTURE, (CaptureDeviceInfo2)device.info, true);
                    break;
                }
                case 5: {
                    AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                    if (audioSystem == null) break;
                    audioSystem.setDevice(AudioSystem.DataFlow.NOTIFY, (CaptureDeviceInfo2)device.info, true);
                    break;
                }
                case 4: {
                    AudioSystem audioSystem = this.deviceConfiguration.getAudioSystem();
                    if (audioSystem == null) break;
                    audioSystem.setDevice(AudioSystem.DataFlow.PLAYBACK, (CaptureDeviceInfo2)device.info, true);
                    break;
                }
                case 2: {
                    this.deviceConfiguration.setVideoCaptureDevice(device.info, true);
                }
            }
            this.fireContentsChanged(-1, -1);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        if (this.type == 1) {
            AudioSystem audioSystem = (AudioSystem)item;
            if (!audioSystem.equals(this.deviceConfiguration.getAudioSystem())) {
                this.deviceConfiguration.setAudioSystem(audioSystem, true);
                this.fireContentsChanged(-1, -1);
            }
        } else {
            this.setSelectedDevice((CaptureDevice)item);
        }
    }

    public static class CaptureDevice {
        public final CaptureDeviceInfo info;

        public CaptureDevice(CaptureDeviceInfo info) {
            this.info = info;
        }

        public boolean equals(CaptureDeviceInfo cdi) {
            return this.info == null ? cdi == null : this.info.equals((Object)cdi);
        }

        public String toString() {
            String s;
            if (this.info == null) {
                s = NeomediaActivator.getResources().getI18NString("impl.media.configform.NO_DEVICE");
            } else {
                String transportType;
                s = this.info.getName();
                if (this.info instanceof CaptureDeviceInfo2 && (transportType = ((CaptureDeviceInfo2)this.info).getTransportType()) != null) {
                    s = s + " (" + transportType + ")";
                }
            }
            return s;
        }
    }
}

