/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.contactsourceconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.java.sip.communicator.plugin.contactsourceconfig.ContactSourceConfigActivator;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ContactSourceConfigForm
extends TransparentPanel
implements ServiceListener {
    private static final long serialVersionUID = 0L;
    private final JComboBox contactSourceComboBox = new JComboBox();

    public ContactSourceConfigForm() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.contactSourceComboBox.setRenderer(new ContactSourceRenderer());
        TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        centerPanel.setPreferredSize(new Dimension(450, 300));
        this.contactSourceComboBox.addItemListener(new ItemListener((JPanel)centerPanel){
            final /* synthetic */ JPanel val$centerPanel;
            {
                this.val$centerPanel = jPanel;
            }

            @Override
            public void itemStateChanged(ItemEvent event) {
                ConfigurationForm form = (ConfigurationForm)ContactSourceConfigForm.this.contactSourceComboBox.getSelectedItem();
                this.val$centerPanel.removeAll();
                JComponent c = (JComponent)form.getForm();
                c.setOpaque(false);
                this.val$centerPanel.add((Component)c, "Center");
                this.val$centerPanel.revalidate();
                this.val$centerPanel.repaint();
            }
        });
        this.init();
        this.add(this.contactSourceComboBox);
        this.add(Box.createVerticalStrut(10));
        this.add((Component)centerPanel);
        ContactSourceConfigActivator.bundleContext.addServiceListener((ServiceListener)this);
    }

    private void init() {
        String osgiFilter = "(FORM_TYPE=CONTACT_SOURCE_TYPE)";
        ServiceReference[] confFormsRefs = null;
        try {
            confFormsRefs = ContactSourceConfigActivator.bundleContext.getServiceReferences(ConfigurationForm.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (confFormsRefs != null) {
            for (int i = 0; i < confFormsRefs.length; ++i) {
                ConfigurationForm form = (ConfigurationForm)ContactSourceConfigActivator.bundleContext.getService(confFormsRefs[i]);
                Object formComponent = form.getForm();
                if (!(formComponent instanceof Component)) continue;
                this.addConfigForm(form);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object property = serviceRef.getProperty("FORM_TYPE");
        if (property != "CONTACT_SOURCE_TYPE") {
            return;
        }
        Object sService = ContactSourceConfigActivator.bundleContext.getService(serviceRef);
        if (!(sService instanceof ConfigurationForm)) {
            return;
        }
        ConfigurationForm configForm = (ConfigurationForm)sService;
        if (!configForm.isAdvanced()) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                Object formComponent = configForm.getForm();
                if (!(formComponent instanceof Component)) break;
                this.addConfigForm(configForm);
                break;
            }
            case 4: {
                Object formComponent = configForm.getForm();
                if (!(formComponent instanceof Component)) break;
                this.remove((Component)formComponent);
            }
        }
    }

    private void addConfigForm(ConfigurationForm form) {
        int cIndex = form.getIndex();
        if (cIndex >= this.contactSourceComboBox.getItemCount() || cIndex == -1) {
            this.contactSourceComboBox.addItem(form);
        } else {
            this.contactSourceComboBox.insertItemAt(form, cIndex);
        }
    }

    private class ContactSourceRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;

        private ContactSourceRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value != null) {
                ConfigurationForm form = (ConfigurationForm)value;
                renderer.setText(form.getTitle());
            }
            return renderer;
        }
    }
}

