/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;

public class FromMatchesFilter
implements PacketFilter {
    private final String address;
    private final boolean ignoreResourcepart;

    @Deprecated
    public FromMatchesFilter(String address) {
        this(address, "".equals(StringUtils.parseResource(address)));
    }

    public FromMatchesFilter(String address, boolean ignoreResourcepart) {
        this.address = address != null && ignoreResourcepart ? StringUtils.parseBareAddress(address) : address;
        this.ignoreResourcepart = ignoreResourcepart;
    }

    public static FromMatchesFilter create(String address) {
        return new FromMatchesFilter(address, "".equals(StringUtils.parseResource(address)));
    }

    public static FromMatchesFilter createBare(String address) {
        address = address == null ? null : address;
        return new FromMatchesFilter(address, true);
    }

    public static FromMatchesFilter createFull(String address) {
        return new FromMatchesFilter(address, false);
    }

    @Override
    public boolean accept(Packet packet) {
        String from = packet.getFrom();
        if (from == null) {
            return this.address == null;
        }
        if (this.ignoreResourcepart) {
            from = StringUtils.parseBareAddress(from);
        }
        return from.equals(this.address);
    }

    public String toString() {
        String matchMode = this.ignoreResourcepart ? "ignoreResourcepart" : "full";
        return this.getClass().getSimpleName() + " (" + matchMode + "): " + this.address;
    }
}

