/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.lang.ref.WeakReference;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPHeaderUtils;
import org.jitsi.impl.neomedia.rtcp.RTCPIterator;
import org.jitsi.impl.neomedia.rtcp.RTCPSenderInfoUtils;
import org.jitsi.impl.neomedia.rtp.FrameDesc;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.Transformation;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.util.ArrayUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.RTPUtils;
import org.jitsi.util.TimeUtils;

public class SimulcastController {
    private static final Logger logger = Logger.getLogger(SimulcastController.class);
    private static final SimTransformation dropState = new SimTransformation(-1L, -1, null);
    private final long targetSSRC;
    private final WeakReference<MediaStreamTrackDesc> weakSource;
    private final FilterState filterState = new FilterState();
    private int targetIdx = -1;
    private SimTransformation transformState = dropState;

    public SimulcastController(MediaStreamTrackDesc source) {
        this.weakSource = new WeakReference<MediaStreamTrackDesc>(source);
        this.targetSSRC = source.getRTPEncodings()[0].getPrimarySSRC();
    }

    public boolean accept(byte[] buf, int off, int len) {
        MediaStreamTrackDesc sourceTrack = (MediaStreamTrackDesc)this.weakSource.get();
        assert (sourceTrack != null);
        long sourceSSRC = RawPacket.getSSRCAsLong(buf, off, len);
        boolean currentRTPEncodingIsActive = false;
        if (this.transformState.currentIdx > -1) {
            RTPEncodingDesc currentRTPEncodingDesc = sourceTrack.getRTPEncodings()[this.transformState.currentIdx];
            currentRTPEncodingIsActive = currentRTPEncodingDesc.isActive();
        }
        if (this.transformState.currentIdx == this.targetIdx && currentRTPEncodingIsActive) {
            boolean accept;
            boolean bl = accept = sourceSSRC == this.transformState.currentSSRC;
            if (accept) {
                this.onAccept(buf, off, len);
            }
            return accept;
        }
        FrameDesc sourceFrameDesc = sourceTrack.findFrameDesc(buf, off, len);
        int sourceIdx = sourceFrameDesc.getRTPEncoding().getIndex();
        if (!sourceFrameDesc.isIndependent() || sourceIdx == this.transformState.currentIdx) {
            boolean accept;
            boolean bl = accept = sourceSSRC == this.transformState.currentSSRC;
            if (accept) {
                this.onAccept(buf, off, len);
            }
            return accept;
        }
        if (this.targetIdx <= sourceIdx && sourceIdx < this.transformState.currentIdx || this.transformState.currentIdx < sourceIdx && sourceIdx <= this.targetIdx || !currentRTPEncodingIsActive && sourceIdx <= this.targetIdx) {
            long tsDelta;
            int seqNumDelta;
            if (this.filterState.maxSeqNum != -1) {
                seqNumDelta = this.filterState.maxSeqNum + 1 - sourceFrameDesc.getStart() & 0xFFFF;
                tsDelta = this.filterState.maxTs + 3000L - sourceFrameDesc.getTimestamp() & 0xFFFFFFFFL;
            } else {
                seqNumDelta = 0;
                tsDelta = 0L;
            }
            if (logger.isInfoEnabled()) {
                logger.info("new_transform src_ssrc=" + sourceSSRC + ",src_idx=" + sourceIdx + ",ts_delta=" + tsDelta + ",seq_delta=" + seqNumDelta);
            }
            this.transformState = new SimTransformation(tsDelta, seqNumDelta, sourceFrameDesc);
            this.onAccept(buf, off, len);
            return true;
        }
        return false;
    }

    public void update(int targetIdx) {
        RTPEncodingDesc[] sourceEncodings;
        MediaStreamTrackDesc sourceTrack;
        if (this.targetIdx == targetIdx) {
            return;
        }
        if (logger.isInfoEnabled() && (sourceTrack = (MediaStreamTrackDesc)this.weakSource.get()) != null && !ArrayUtils.isNullOrEmpty(sourceEncodings = sourceTrack.getRTPEncodings())) {
            long ssrc = sourceEncodings[0].getPrimarySSRC();
            logger.info("target_update ssrc=" + ssrc + ",new_target=" + targetIdx + ",old_target=" + this.targetIdx);
        }
        this.targetIdx = targetIdx;
        if (targetIdx < 0) {
            this.transformState = dropState;
        } else {
            sourceTrack = (MediaStreamTrackDesc)this.weakSource.get();
            if (sourceTrack == null) {
                return;
            }
            ((RTPTranslatorImpl)sourceTrack.getMediaStreamTrackReceiver().getStream().getRTPTranslator()).getRtcpFeedbackMessageSender().sendFIR((int)this.targetSSRC);
        }
    }

    private void onAccept(byte[] buf, int off, int len) {
        long ts = this.transformState.rewriteTimestamp(RawPacket.getTimestamp(buf, off, len));
        if (this.filterState.maxTs == -1L || TimeUtils.rtpDiff(ts, this.filterState.maxTs) > 0L) {
            this.filterState.maxTs = ts;
        }
        int seqNum = this.transformState.rewriteSeqNum(RawPacket.getSequenceNumber(buf, off, len));
        if (this.filterState.maxSeqNum == -1 || RTPUtils.sequenceNumberDiff(seqNum, this.filterState.maxSeqNum) > 0) {
            this.filterState.maxSeqNum = seqNum;
        }
        FilterState filterState = this.filterState;
        filterState.transmittedBytes = filterState.transmittedBytes + (long)len;
        this.filterState.transmittedPackets++;
    }

    public RawPacket[] rtpTransform(RawPacket pkt) {
        RawPacket[] pkts;
        FrameDesc startFrame;
        if (!RTPPacketPredicate.INSTANCE.test(pkt)) {
            return new RawPacket[]{pkt};
        }
        SimTransformation state = this.transformState;
        long srcSSRC = pkt.getSSRCAsLong();
        if (srcSSRC != state.currentSSRC) {
            return null;
        }
        if (this.transformState.maybeFixInitialIndependentFrame && (startFrame = (FrameDesc)state.weakStartFrame.get()) != null && startFrame.matches(pkt)) {
            this.transformState.maybeFixInitialIndependentFrame = false;
            if (startFrame.getStart() != pkt.getSequenceNumber()) {
                RawPacketCache inCache = startFrame.getRTPEncoding().getMediaStreamTrack().getMediaStreamTrackReceiver().getStream().getCachingTransformer().getIncomingRawPacketCache();
                int start = startFrame.getStart();
                int len = startFrame.getMaxSeen() - start & 0xFFFF;
                pkts = new RawPacket[len];
                for (int i = 0; i <= len; ++i) {
                    pkts[i] = inCache.get(srcSSRC, start + i & 0xFFFF);
                }
            } else {
                pkts = new RawPacket[]{pkt};
            }
        } else {
            pkts = new RawPacket[]{pkt};
        }
        for (int i = 0; i < pkts.length; ++i) {
            if (pkts[i] == null) continue;
            int srcSeqNum = pkt.getSequenceNumber();
            int dstSeqNum = state.rewriteSeqNum(srcSeqNum);
            long srcTs = pkt.getTimestamp();
            long dstTs = state.rewriteTimestamp(srcTs);
            if (logger.isDebugEnabled()) {
                logger.debug("src_ssrc=" + pkt.getSSRCAsLong() + ",src_seq=" + srcSeqNum + ",src_ts=" + srcTs + ",dst_ssrc=" + this.targetSSRC + ",dst_seq=" + dstSeqNum + ",dst_ts=" + dstTs);
            }
            if (srcSeqNum != dstSeqNum) {
                pkt.setSequenceNumber(dstSeqNum);
            }
            if (dstTs != srcTs) {
                pkt.setTimestamp(dstTs);
            }
            if (srcSSRC == this.targetSSRC) continue;
            pkt.setSSRC((int)this.targetSSRC);
        }
        return pkts;
    }

    public RawPacket rtcpTransform(RawPacket pkt) {
        if (!RTCPPacketPredicate.INSTANCE.test(pkt)) {
            return pkt;
        }
        SimTransformation state = this.transformState;
        RTCPIterator it = new RTCPIterator(pkt);
        while (it.hasNext()) {
            ByteArrayBuffer baf = it.next();
            switch (RTCPHeaderUtils.getPacketType(baf)) {
                case 200: {
                    if (RawPacket.getRTCPSSRC(pkt) != state.currentSSRC) {
                        it.remove();
                        break;
                    }
                    RTCPHeaderUtils.setSenderSSRC(pkt, (int)this.targetSSRC);
                    long srcTs = RTCPSenderInfoUtils.getTimestamp(baf);
                    long dstTs = state.rewriteTimestamp(srcTs);
                    if (srcTs != dstTs) {
                        RTCPSenderInfoUtils.setTimestamp(baf, (int)dstTs);
                    }
                    RTCPSenderInfoUtils.setOctetCount(baf, (int)this.filterState.transmittedBytes);
                    RTCPSenderInfoUtils.setPacketCount(baf, (int)this.filterState.transmittedPackets);
                }
            }
        }
        return pkt;
    }

    private static class FilterState {
        private int maxSeqNum = -1;
        private long maxTs = -1L;
        private long transmittedBytes = 0L;
        private long transmittedPackets = 0L;

        private FilterState() {
        }
    }

    private static class SimTransformation
    extends Transformation {
        private final WeakReference<FrameDesc> weakStartFrame;
        private final long currentSSRC;
        private final int currentIdx;
        private boolean maybeFixInitialIndependentFrame = true;

        SimTransformation(long tsDelta, int seqNumDelta, FrameDesc startFrame) {
            super(tsDelta, seqNumDelta);
            if (startFrame != null) {
                this.currentSSRC = startFrame.getRTPEncoding().getPrimarySSRC();
                this.currentIdx = startFrame.getRTPEncoding().getIndex();
            } else {
                this.currentIdx = -1;
                this.currentSSRC = -1L;
            }
            this.weakStartFrame = new WeakReference<FrameDesc>(startFrame);
        }
    }
}

