/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import net.java.sip.communicator.impl.ldap.LdapServiceImpl;
import net.java.sip.communicator.util.Logger;

public class LdapSSLSocketFactoryDelegate {
    private static final Logger logger = Logger.getLogger(LdapSSLSocketFactoryDelegate.class);

    public static Object getDefault() {
        return new LdapSSLSocketFactoryDelegate();
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        try {
            return LdapServiceImpl.getCertificateService().getSSLContext(LdapServiceImpl.getCertificateService().getTrustManager(host)).getSocketFactory().createSocket(host, port);
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)"unable to create socket through the certificate service", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }
}

