/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.ArrayList;
import java.util.List;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.ConfigureCompleteEvent;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.Duration;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaTimeSetEvent;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.ConfigureWorkThread;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PrefetchWorkThread;
import net.sf.fmj.media.RealizeWorkThread;
import net.sf.fmj.media.SendEventQueue;
import net.sf.fmj.media.StopTimeThread;
import net.sf.fmj.media.TimedStartThread;

public abstract class BasicController
implements Controller,
Duration {
    private int targetState = 100;
    protected int state = 100;
    private List<ControllerListener> listenerList = null;
    private SendEventQueue sendEvtQueue;
    private ConfigureWorkThread configureThread = null;
    private RealizeWorkThread realizeThread = null;
    private PrefetchWorkThread prefetchThread = null;
    protected String processError = null;
    private Clock clock;
    private TimedStartThread startThread = null;
    private StopTimeThread stopTimeThread = null;
    private boolean interrupted = false;
    private Object interruptSync = new Object();
    static final int Configuring = 140;
    static final int Configured = 180;
    protected boolean stopThreadEnabled = true;
    static String TimeBaseError = "Cannot set time base on an unrealized controller.";
    static String SyncStartError = "Cannot start the controller before it has been prefetched.";
    static String StopTimeError = "Cannot set stop time on an unrealized controller.";
    static String MediaTimeError = "Cannot set media time on a unrealized controller";
    static String GetTimeBaseError = "Cannot get Time Base from an unrealized controller";
    static String SetRateError = "Cannot set rate on an unrealized controller.";
    static String LatencyError = "Cannot get start latency from an unrealized controller";
    static String DeallocateError = "deallocate cannot be used on a started controller.";

    public BasicController() {
        this.sendEvtQueue = new SendEventQueue(this);
        this.sendEvtQueue.setName(this.sendEvtQueue.getName() + ": SendEventQueue: " + this.getClass().getName());
        this.sendEvtQueue.start();
        this.clock = new BasicClock();
    }

    protected void abortConfigure() {
    }

    protected abstract void abortPrefetch();

    protected abstract void abortRealize();

    private boolean activateStopThread(long timeToStop) {
        if (this.getStopTime().getNanoseconds() == Long.MAX_VALUE) {
            return false;
        }
        if (this.stopTimeThread != null && this.stopTimeThread.isAlive()) {
            this.stopTimeThread.abort();
            this.stopTimeThread = null;
        }
        if (timeToStop > 100000000L) {
            this.stopTimeThread = new StopTimeThread(this, timeToStop);
            this.stopTimeThread.start();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addControllerListener(ControllerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<ControllerListener>();
        }
        List<ControllerListener> list = this.listenerList;
        synchronized (list) {
            if (!this.listenerList.contains(listener)) {
                this.listenerList.add(listener);
            }
        }
    }

    private long checkStopTime() {
        long stopTime = this.getStopTime().getNanoseconds();
        if (stopTime == Long.MAX_VALUE) {
            return 1L;
        }
        return (long)((float)(stopTime - this.getMediaTime().getNanoseconds()) / this.getRate());
    }

    @Override
    public final void close() {
        this.doClose();
        this.interrupt();
        if (this.startThread != null) {
            this.startThread.abort();
        }
        if (this.stopTimeThread != null) {
            this.stopTimeThread.abort();
        }
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.kill();
            this.sendEvtQueue = null;
        }
    }

    protected synchronized void completeConfigure() {
        this.state = 180;
        this.sendEvent(new ConfigureCompleteEvent(this, 140, 180, this.getTargetState()));
        if (this.getTargetState() >= 300) {
            this.realize();
        }
    }

    protected void completePrefetch() {
        this.clock.stop();
        this.state = 500;
        this.sendEvent(new PrefetchCompleteEvent(this, 400, 500, this.getTargetState()));
    }

    protected synchronized void completeRealize() {
        this.state = 300;
        this.sendEvent(new RealizeCompleteEvent(this, 200, 300, this.getTargetState()));
        if (this.getTargetState() >= 500) {
            this.prefetch();
        }
    }

    public synchronized void configure() {
        if (this.getTargetState() < 180) {
            this.setTargetState(180);
        }
        switch (this.state) {
            case 180: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new ConfigureCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: {
                break;
            }
            case 100: {
                this.state = 140;
                this.sendEvent(new TransitionEvent(this, 100, 140, this.getTargetState()));
                this.configureThread = new ConfigureWorkThread(this);
                this.configureThread.setName(this.configureThread.getName() + "[ " + this + " ]" + " ( configureThread)");
                this.configureThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deallocate() {
        int previousState = this.getState();
        if (this.state == 600) {
            this.throwError(new ClockStartedError(DeallocateError));
        }
        switch (this.state) {
            case 140: 
            case 200: {
                this.interrupt();
                this.state = 100;
                break;
            }
            case 400: {
                this.interrupt();
                this.state = 300;
                break;
            }
            case 500: {
                this.abortPrefetch();
                this.state = 300;
                this.resetInterrupt();
            }
        }
        this.setTargetState(this.state);
        this.doDeallocate();
        Object object = this.interruptSync;
        synchronized (object) {
            while (this.isInterrupted()) {
                try {
                    this.interruptSync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.sendEvent(new DeallocateEvent(this, previousState, this.state, this.state, this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatchEvent(ControllerEvent evt) {
        if (this.listenerList == null) {
            return;
        }
        List<ControllerListener> list = this.listenerList;
        synchronized (list) {
            for (ControllerListener listener : this.listenerList) {
                listener.controllerUpdate(evt);
            }
        }
    }

    protected void doClose() {
    }

    protected boolean doConfigure() {
        return true;
    }

    protected void doDeallocate() {
    }

    protected void doFailedConfigure() {
        this.state = 100;
        this.setTargetState(100);
        String msg = "Failed to configure";
        if (this.processError != null) {
            msg = msg + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, msg));
        this.processError = null;
    }

    protected void doFailedPrefetch() {
        this.state = 300;
        this.setTargetState(300);
        String msg = "Failed to prefetch";
        if (this.processError != null) {
            msg = msg + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, msg));
        this.processError = null;
    }

    protected void doFailedRealize() {
        this.state = 100;
        this.setTargetState(100);
        String msg = "Failed to realize";
        if (this.processError != null) {
            msg = msg + ": " + this.processError;
        }
        this.sendEvent(new ResourceUnavailableEvent(this, msg));
        this.processError = null;
    }

    protected abstract boolean doPrefetch();

    protected abstract boolean doRealize();

    protected void doSetMediaTime(Time when) {
    }

    protected float doSetRate(float factor) {
        return factor;
    }

    protected abstract void doStart();

    protected void doStop() {
    }

    protected Clock getClock() {
        return this.clock;
    }

    @Override
    public Control getControl(String type) {
        Class<?> cls;
        try {
            cls = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Control[] cs = this.getControls();
        for (int i = 0; i < cs.length; ++i) {
            if (!cls.isInstance(cs[i])) continue;
            return cs[i];
        }
        return null;
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    @Override
    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    @Override
    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    @Override
    public float getRate() {
        return this.clock.getRate();
    }

    @Override
    public Time getStartLatency() {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(LatencyError));
        }
        return LATENCY_UNKNOWN;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    @Override
    public Time getSyncTime() {
        return new Time(0L);
    }

    @Override
    public final int getTargetState() {
        return this.targetState;
    }

    @Override
    public TimeBase getTimeBase() {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(GetTimeBaseError));
        }
        return this.clock.getTimeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interrupt() {
        Object object = this.interruptSync;
        synchronized (object) {
            this.interrupted = true;
            this.interruptSync.notify();
        }
    }

    protected abstract boolean isConfigurable();

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    @Override
    public final void prefetch() {
        if (this.getTargetState() <= 300) {
            this.setTargetState(500);
        }
        switch (this.state) {
            case 500: 
            case 600: {
                this.sendEvent(new PrefetchCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: 
            case 200: 
            case 400: {
                break;
            }
            case 100: 
            case 180: {
                this.realize();
                break;
            }
            case 300: {
                this.state = 400;
                this.sendEvent(new TransitionEvent(this, 300, 400, this.getTargetState()));
                this.prefetchThread = new PrefetchWorkThread(this);
                this.prefetchThread.setName(this.prefetchThread.getName() + " ( prefetchThread)");
                this.prefetchThread.start();
            }
        }
    }

    @Override
    public final synchronized void realize() {
        if (this.getTargetState() < 300) {
            this.setTargetState(300);
        }
        switch (this.state) {
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new RealizeCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 140: 
            case 200: {
                break;
            }
            case 100: {
                if (this.isConfigurable()) {
                    this.configure();
                    break;
                }
            }
            case 180: {
                int oldState = this.state;
                this.state = 200;
                this.sendEvent(new TransitionEvent(this, oldState, 200, this.getTargetState()));
                this.realizeThread = new RealizeWorkThread(this);
                this.realizeThread.setName(this.realizeThread.getName() + "[ " + this + " ]" + " ( realizeThread)");
                this.realizeThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeControllerListener(ControllerListener listener) {
        if (this.listenerList == null) {
            return;
        }
        List<ControllerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInterrupt() {
        Object object = this.interruptSync;
        synchronized (object) {
            this.interrupted = false;
            this.interruptSync.notify();
        }
    }

    protected final void sendEvent(ControllerEvent evt) {
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.postEvent(evt);
        }
    }

    protected void setClock(Clock c) {
        this.clock = c;
    }

    protected void setMediaLength(long t) {
        if (this.clock instanceof BasicClock) {
            ((BasicClock)this.clock).setMediaLength(t);
        }
    }

    @Override
    public void setMediaTime(Time when) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(MediaTimeError));
        }
        this.clock.setMediaTime(when);
        this.doSetMediaTime(when);
        this.sendEvent(new MediaTimeSetEvent(this, when));
    }

    @Override
    public float setRate(float factor) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(SetRateError));
        }
        float oldRate = this.getRate();
        float rateSet = this.doSetRate(factor);
        float newRate = this.clock.setRate(rateSet);
        if (newRate != oldRate) {
            this.sendEvent(new RateChangeEvent(this, newRate));
        }
        return newRate;
    }

    @Override
    public void setStopTime(Time t) {
        long timeToStop;
        if (this.state < 300) {
            this.throwError(new NotRealizedError(StopTimeError));
        }
        Time oldStopTime = this.getStopTime();
        this.clock.setStopTime(t);
        boolean stopTimeHasPassed = false;
        if (this.state == 600 && ((timeToStop = this.checkStopTime()) < 0L || this.stopThreadEnabled && this.activateStopThread(timeToStop))) {
            stopTimeHasPassed = true;
        }
        if (oldStopTime.getNanoseconds() != t.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, t));
        }
        if (stopTimeHasPassed) {
            this.stopAtTime();
        }
    }

    protected final void setTargetState(int state) {
        this.targetState = state;
    }

    @Override
    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        if (this.state < 300) {
            this.throwError(new NotRealizedError(TimeBaseError));
        }
        this.clock.setTimeBase(tb);
    }

    @Override
    public void stop() {
        if (this.state == 600 || this.state == 400) {
            this.stopControllerOnly();
            this.doStop();
        }
    }

    protected void stopAtTime() {
        this.stop();
        this.setStopTime(Clock.RESET);
        this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected void stopControllerOnly() {
        if (this.state == 600 || this.state == 400) {
            this.clock.stop();
            this.state = 500;
            this.setTargetState(500);
            if (this.stopTimeThread != null && this.stopTimeThread.isAlive() && Thread.currentThread() != this.stopTimeThread) {
                this.stopTimeThread.abort();
            }
            if (this.startThread != null && this.startThread.isAlive()) {
                this.startThread.abort();
            }
        }
    }

    @Override
    public void syncStart(Time tbt) {
        if (this.state < 500) {
            this.throwError(new NotPrefetchedError(SyncStartError));
        }
        this.clock.syncStart(tbt);
        this.state = 600;
        this.setTargetState(600);
        this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), tbt));
        long timeToStop = this.checkStopTime();
        if (timeToStop < 0L || this.stopThreadEnabled && this.activateStopThread(timeToStop)) {
            this.stopAtTime();
            return;
        }
        this.startThread = new TimedStartThread(this, tbt.getNanoseconds());
        this.startThread.setName(this.startThread.getName() + " ( startThread: " + this + " )");
        this.startThread.start();
    }

    protected boolean syncStartInProgress() {
        return this.startThread != null && this.startThread.isAlive();
    }

    protected void throwError(Error e) {
        Log.dumpStack(e);
        throw e;
    }
}

