/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationContact;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationContactSource;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationGroup;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.FilterQuery;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.gui.UIGroup;

public class CallHistoryFilter
implements ContactListFilter {
    public void applyFilter(FilterQuery filterQuery) {
        NotificationContactSource notificationSource = TreeContactList.getNotificationContactSource();
        if (notificationSource != null) {
            this.addMatching(notificationSource);
        }
        List<UIContactSource> contactSources = GuiActivator.getContactList().getContactSources(2);
        TreeContactList contactList = GuiActivator.getContactList();
        for (UIContactSource contactSource : contactSources) {
            ContactQuery query = contactSource.getContactSourceService().createContactQuery("", 50);
            if (query == null) continue;
            query.addContactQueryListener((ContactQueryListener)contactList);
            filterQuery.addContactQuery((Object)query);
            query.start();
        }
        filterQuery.close();
    }

    public boolean isMatching(UIContact uiContact) {
        SourceContact sourceContact;
        Object descriptor = uiContact.getDescriptor();
        return descriptor instanceof SourceContact ? (sourceContact = (SourceContact)descriptor).getContactSource().getType() == 2 : uiContact instanceof NotificationContact;
    }

    public boolean isMatching(UIGroup uiGroup) {
        return uiGroup instanceof NotificationGroup;
    }

    private void addMatching(NotificationContactSource notifSource) {
        Iterator<? extends UIGroup> notifGroups = notifSource.getNotificationGroups();
        while (notifGroups.hasNext()) {
            UIGroup uiGroup = notifGroups.next();
            Iterator<? extends UIContact> notfications = notifSource.getNotifications(uiGroup);
            while (notfications.hasNext()) {
                GuiActivator.getContactList().addContact(notfications.next(), uiGroup, false, true);
            }
        }
    }
}

