/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.AccountRegWizardContainerImpl;
import net.java.sip.communicator.impl.gui.main.account.EmptyAccountRegistrationWizard;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.CreateAccountWindow;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class NewAccountDialog
extends SIPCommDialog
implements CreateAccountWindow,
ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(NewAccountDialog.class);
    private final TransparentPanel accountPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final JComboBox networkComboBox = new JComboBox();
    private final JButton advancedButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ADVANCED"));
    private final JButton addAccountButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ADD"));
    private final JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private final EmptyAccountRegistrationWizard emptyWizard = new EmptyAccountRegistrationWizard();
    private static NewAccountDialog newAccountDialog;
    private JTextArea errorMessagePane;
    private boolean isCurrentlySigningIn = false;
    private final JLabel statusLabel = new JLabel();
    private final AccountRegWizardContainerImpl wizardContainer;

    public NewAccountDialog() {
        super((Frame)((Object)GuiActivator.getUIService().getMainFrame()), false);
        ResourceManagementService resources = GuiActivator.getResources();
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        TransparentPanel networkPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        JLabel networkLabel = new JLabel(resources.getI18NString("service.gui.NETWORK"));
        TransparentPanel rightButtonPanel = new TransparentPanel((LayoutManager)new FlowLayout(2, 0, 0));
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        String title = resources.getI18NString("service.gui.NEW_ACCOUNT");
        if (title != null && title.endsWith("...")) {
            title = title.substring(0, title.length() - 3);
        }
        this.setTitle(title);
        this.getContentPane().add((Component)mainPanel);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        networkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        TransparentPanel statusPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
        statusPanel.add(this.statusLabel);
        mainPanel.add((Component)buttonPanel, (Object)"South");
        if (!ConfigurationUtils.isAdvancedAccountConfigDisabled()) {
            buttonPanel.add((Component)this.advancedButton, (Object)"West");
            this.advancedButton.addActionListener(this);
        }
        buttonPanel.add((Component)rightButtonPanel, (Object)"East");
        buttonPanel.add((Component)statusPanel, (Object)"Center");
        rightButtonPanel.add((Component)this.addAccountButton);
        rightButtonPanel.add((Component)this.cancelButton);
        this.addAccountButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        mainPanel.add((Component)networkPanel, (Object)"North");
        networkPanel.add((Component)networkLabel, (Object)"West");
        networkPanel.add((Component)this.networkComboBox, (Object)"Center");
        this.networkComboBox.setRenderer(new NetworkListCellRenderer());
        this.networkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountRegistrationWizard wizard = (AccountRegistrationWizard)NewAccountDialog.this.networkComboBox.getSelectedItem();
                NewAccountDialog.this.loadSelectedWizard(wizard);
            }
        });
        mainPanel.add((Component)this.accountPanel, (Object)"Center");
        this.initNetworkList();
        this.wizardContainer = (AccountRegWizardContainerImpl)GuiActivator.getUIService().getAccountRegWizardContainer();
        this.wizardContainer.getModel().addPropertyChangeListener(this);
    }

    private void initNetworkList() {
        Collection accountWizardRefs;
        String prefWName = GuiActivator.getResources().getSettingsString("impl.gui.PREFERRED_ACCOUNT_WIZARD");
        String preferredWizardName = prefWName != null && prefWName.length() > 0 ? prefWName : null;
        try {
            accountWizardRefs = GuiActivator.bundleContext.getServiceReferences(AccountRegistrationWizard.class, null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (accountWizardRefs != null && !accountWizardRefs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + accountWizardRefs.size() + " already installed providers."));
            }
            ArrayList<AccountRegistrationWizard> networksList = new ArrayList<AccountRegistrationWizard>(accountWizardRefs.size());
            AccountRegistrationWizard prefWiz = null;
            for (ServiceReference serRef : accountWizardRefs) {
                AccountRegistrationWizard wizard = (AccountRegistrationWizard)GuiActivator.bundleContext.getService(serRef);
                networksList.add(wizard);
                if (preferredWizardName == null || !wizard.getClass().getName().equals(preferredWizardName)) continue;
                prefWiz = wizard;
            }
            Collections.sort(networksList, new Comparator<AccountRegistrationWizard>(){

                @Override
                public int compare(AccountRegistrationWizard arg0, AccountRegistrationWizard arg1) {
                    return arg0.getProtocolName().compareToIgnoreCase(arg1.getProtocolName());
                }
            });
            for (int i = 0; i < networksList.size(); ++i) {
                this.networkComboBox.addItem(networksList.get(i));
            }
            if (prefWiz != null) {
                this.networkComboBox.setSelectedItem(prefWiz);
            } else {
                this.networkComboBox.insertItemAt(this.emptyWizard, 0);
                this.networkComboBox.setSelectedItem((Object)this.emptyWizard);
                this.advancedButton.setEnabled(false);
                this.addAccountButton.setEnabled(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("cancelButtonEnabledProperty")) {
            if (evt.getNewValue() instanceof Boolean) {
                this.cancelButton.setEnabled((Boolean)evt.getNewValue());
            }
        } else if (evt.getPropertyName().equals("nextButtonEnabledProperty") && evt.getNewValue() instanceof Boolean) {
            this.addAccountButton.setEnabled((Boolean)evt.getNewValue());
        }
    }

    private void loadSelectedWizard(AccountRegistrationWizard wizard) {
        this.accountPanel.removeAll();
        TransparentPanel fixedWidthPanel = new TransparentPanel();
        Dimension fixedWidthSize = new Dimension(430, 3);
        fixedWidthPanel.setPreferredSize(fixedWidthSize);
        fixedWidthPanel.setMinimumSize(fixedWidthSize);
        fixedWidthPanel.setMaximumSize(fixedWidthSize);
        this.accountPanel.add((Component)fixedWidthPanel, (Object)"South");
        JComponent simpleWizardForm = (JComponent)wizard.getSimpleForm(false);
        simpleWizardForm.setOpaque(false);
        this.accountPanel.add((Component)simpleWizardForm);
        boolean isEmptyAccountRegistrationWizard = wizard instanceof EmptyAccountRegistrationWizard;
        this.addAccountButton.setEnabled(!isEmptyAccountRegistrationWizard);
        this.advancedButton.setEnabled(!isEmptyAccountRegistrationWizard);
        if (!isEmptyAccountRegistrationWizard) {
            this.getRootPane().setDefaultButton(this.addAccountButton);
        }
        if (!wizard.isAdvancedConfigurationEnabled()) {
            this.advancedButton.setVisible(false);
        } else if (!this.advancedButton.isVisible()) {
            this.advancedButton.setVisible(true);
        }
        this.accountPanel.revalidate();
        this.accountPanel.repaint();
        this.pack();
    }

    private void loadErrorMessage(String errorMessage) {
        if (this.errorMessagePane == null) {
            this.errorMessagePane = new JTextArea();
            this.errorMessagePane.setLineWrap(true);
            this.errorMessagePane.setWrapStyleWord(true);
            this.errorMessagePane.setOpaque(false);
            this.errorMessagePane.setForeground(Color.RED);
            this.accountPanel.add((Component)this.errorMessagePane, (Object)"North");
            if (this.isVisible()) {
                this.pack();
            }
            this.setSize(this.getWidth(), this.getHeight() + this.errorMessagePane.getHeight());
        }
        this.errorMessagePane.setText(errorMessage);
        this.accountPanel.revalidate();
        this.accountPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton sourceButton = (JButton)event.getSource();
        AccountRegistrationWizard wizard = (AccountRegistrationWizard)this.networkComboBox.getSelectedItem();
        if (sourceButton.equals(this.advancedButton)) {
            wizard.setModification(false);
            this.wizardContainer.setTitle(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT_REGISTRATION_WIZARD"));
            this.wizardContainer.setCurrentWizard(wizard);
            this.wizardContainer.showDialog(false);
            this.dispose();
        } else if (sourceButton.equals(this.addAccountButton)) {
            this.startConnecting(this.wizardContainer);
            new Thread(new ProtocolSignInThread(wizard)).start();
        } else if (sourceButton.equals(this.cancelButton)) {
            this.dispose();
        }
    }

    public static void showNewAccountDialog() {
        if (newAccountDialog == null) {
            newAccountDialog = new NewAccountDialog();
        }
        newAccountDialog.pack();
        newAccountDialog.setVisible(true);
        newAccountDialog.requestFocus();
    }

    protected void close(boolean isEscaped) {
        if (this.isCurrentlySigningIn) {
            return;
        }
        this.dispose();
    }

    public void dispose() {
        if (this.isCurrentlySigningIn) {
            return;
        }
        if (newAccountDialog == this) {
            newAccountDialog = null;
        }
        this.wizardContainer.getModel().removePropertyChangeListener(this);
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (this.isCurrentlySigningIn) {
            return;
        }
        super.setVisible(visible);
    }

    private void startConnecting(AccountRegWizardContainerImpl wizardContainer) {
        this.isCurrentlySigningIn = true;
        this.advancedButton.setEnabled(false);
        this.addAccountButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.statusLabel.setText(GuiActivator.getResources().getI18NString("service.gui.CONNECTING"));
        this.setCursor(new Cursor(3));
    }

    private void stopConnecting(AccountRegWizardContainerImpl wizardContainer) {
        this.isCurrentlySigningIn = false;
        this.statusLabel.setText("");
        this.setCursor(new Cursor(0));
        this.advancedButton.setEnabled(true);
        this.addAccountButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public void setSelectedWizard(AccountRegistrationWizard wizard, boolean isCreateAccount) {
        this.networkComboBox.setSelectedItem(wizard);
    }

    private class ProtocolSignInThread
    implements Runnable {
        private final AccountRegistrationWizard wizard;

        ProtocolSignInThread(AccountRegistrationWizard wizard) {
            this.wizard = wizard;
        }

        @Override
        public void run() {
            try {
                ProtocolProviderService protocolProvider;
                if (this.wizard == NewAccountDialog.this.emptyWizard) {
                    NewAccountDialog.this.loadErrorMessage(GuiActivator.getResources().getI18NString("service.gui.CHOOSE_NETWORK"));
                }
                if ((protocolProvider = this.wizard.signin()) != null) {
                    NewAccountDialog.this.wizardContainer.saveAccountWizard(protocolProvider, this.wizard);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewAccountDialog.this.stopConnecting(NewAccountDialog.this.wizardContainer);
                            NewAccountDialog.this.dispose();
                        }
                    });
                } else {
                    NewAccountDialog.this.stopConnecting(NewAccountDialog.this.wizardContainer);
                }
            }
            catch (OperationFailedException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewAccountDialog.this.stopConnecting(NewAccountDialog.this.wizardContainer);
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The sign in operation has failed.");
                }
                if (e.getErrorCode() == 11) {
                    NewAccountDialog.this.loadErrorMessage(GuiActivator.getResources().getI18NString("service.gui.USERNAME_NULL"));
                } else if (e.getErrorCode() == 10) {
                    NewAccountDialog.this.loadErrorMessage(GuiActivator.getResources().getI18NString("service.gui.USER_EXISTS_ERROR"));
                } else if (e.getErrorCode() == 17) {
                    NewAccountDialog.this.loadErrorMessage(GuiActivator.getResources().getI18NString("service.gui.SPECIFY_SERVER"));
                } else {
                    NewAccountDialog.this.loadErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT_CREATION_FAILED", new String[]{e.getMessage()}));
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error creating account: " + e.getMessage()), (Throwable)e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewAccountDialog.this.stopConnecting(NewAccountDialog.this.wizardContainer);
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The sign in operation has failed.");
                }
                NewAccountDialog.this.loadErrorMessage(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT_CREATION_FAILED", new String[]{e.getMessage()}));
            }
        }
    }

    private static class NetworkListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 0L;

        public NetworkListCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AccountRegistrationWizard wizard = (AccountRegistrationWizard)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(wizard.getProtocolName());
            byte[] icon = wizard.getIcon();
            this.setIcon(icon != null && icon.length > 0 ? new ImageIcon(icon) : null);
            return this;
        }
    }
}

