/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.java.sip.communicator.impl.gui.main.UINotification;
import net.java.sip.communicator.impl.gui.main.UINotificationGroup;
import net.java.sip.communicator.impl.gui.main.UINotificationListener;

public class UINotificationManager {
    private static Collection<UINotificationGroup> notificationGroups = new ArrayList<UINotificationGroup>();
    private static Collection<UINotificationListener> notificationListeners = new ArrayList<UINotificationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNotificationListener(UINotificationListener l) {
        UINotificationListener uINotificationListener = l;
        synchronized (uINotificationListener) {
            notificationListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNotificationListener(UINotificationListener l) {
        UINotificationListener uINotificationListener = l;
        synchronized (uINotificationListener) {
            notificationListeners.remove(l);
        }
    }

    public static void addNotification(UINotification notification) {
        UINotificationGroup group = notification.getGroup();
        if (!notificationGroups.contains(group)) {
            notificationGroups.add(group);
        }
        group.addNotification(notification);
        UINotificationManager.fireNotificationEvent(notification);
    }

    public static void removeAllNotifications(UINotificationGroup group) {
        group.removeAllNotifications();
    }

    public static void removeAllNotifications() {
        Iterator<UINotificationGroup> groups = notificationGroups.iterator();
        while (groups.hasNext()) {
            groups.next().removeAllNotifications();
        }
    }

    public static Iterator<UINotification> getUnreadNotifications(UINotificationGroup group) {
        return group.getUnreadNotifications();
    }

    public static Collection<UINotificationGroup> getNotificationGroups() {
        return new ArrayList<UINotificationGroup>(notificationGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireNotificationEvent(UINotification notification) {
        Collection<UINotificationListener> collection = notificationListeners;
        synchronized (collection) {
            Iterator<UINotificationListener> listeners = notificationListeners.iterator();
            while (listeners.hasNext()) {
                listeners.next().notificationReceived(notification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireClearedEvent(UINotification notification) {
        Collection<UINotificationListener> collection = notificationListeners;
        synchronized (collection) {
            Iterator<UINotificationListener> listeners = notificationListeners.iterator();
            while (listeners.hasNext()) {
                listeners.next().notificationCleared(notification);
            }
        }
    }
}

