/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractNickChangeListener {
    private Map<String, Callback<String>> callbacks = new HashMap<String, Callback<String>>();

    protected abstract void changeNick(String var1);

    public void submit(String aNewNick, Callback<String> aCallback) {
        this.callbacks.put(aNewNick, aCallback);
    }

    public void onNickChange(NickMessage aMsg) {
        Callback<String> _callback = this.callbacks.get(aMsg.getNewNick());
        if (_callback != null) {
            _callback.onSuccess(aMsg.getNewNick());
        } else {
            this.changeNick(aMsg.getNewNick());
        }
    }

    public void onServerMessage(ServerNumericMessage aServerMessage) {
        Callback<String> _callback = this.callbacks.remove(aServerMessage.getText().split(" ")[0]);
        if (_callback != null) {
            if (aServerMessage.getNumericCode().equals(433)) {
                _callback.onFailure(new IRCException(aServerMessage.getText()));
            } else if (aServerMessage.getNumericCode().equals(432)) {
                _callback.onFailure(new IRCException(aServerMessage.getText()));
            } else if (aServerMessage.getNumericCode().equals(438)) {
                _callback.onFailure(new IRCException(aServerMessage.getText()));
            }
        }
    }
}

