/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.simpleaccreg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.simpleaccreg.Resources;
import net.java.sip.communicator.plugin.simpleaccreg.SimpleAccountRegistrationActivator;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.CreateAccountWindow;
import net.java.sip.communicator.service.gui.ExtendedAccountRegistrationWizard;
import net.java.sip.communicator.service.gui.PopupDialog;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class InitialAccountRegistrationFrame
extends SIPCommFrame {
    private static final long serialVersionUID = 0L;
    private ConfigurationService configurationService;
    private final Logger logger = Logger.getLogger(InitialAccountRegistrationFrame.class);
    private final TransparentPanel mainAccountsPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final TransparentPanel accountsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 2, 10, 10));
    private final TransparentPanel southPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final JButton signinButton = new JButton(Resources.getString("service.gui.SIGN_IN"));
    private final Collection<AccountRegistrationPanel> registrationForms = new Vector<AccountRegistrationPanel>();

    public InitialAccountRegistrationFrame() {
        super(false);
        this.setDefaultCloseOperation(2);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.southPanel.add((Component)buttonPanel, (Object)"East");
        JButton cancelButton = new JButton(Resources.getString("service.gui.CANCEL"));
        this.setTitle(Resources.getString("service.gui.SIGN_IN"));
        this.setIconImage(Resources.getImage("service.gui.SIP_COMMUNICATOR_LOGO").getImage());
        JOptionPane.getRootFrame().setIconImage(Resources.getImage("service.gui.SIP_COMMUNICATOR_LOGO").getImage());
        this.mainAccountsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)mainPanel);
        mainPanel.add((Component)this.createTitleComponent(), (Object)"North");
        JScrollPane scroller = new JScrollPane((Component)this.mainAccountsPanel);
        scroller.setOpaque(false);
        scroller.getViewport().setOpaque(false);
        mainPanel.add((Component)scroller, (Object)"Center");
        mainPanel.add((Component)this.southPanel, (Object)"South");
        this.mainAccountsPanel.add((Component)this.accountsPanel, (Object)"Center");
        this.initProvisioningPanel();
        this.mainAccountsPanel.setOpaque(false);
        this.accountsPanel.setOpaque(false);
        buttonPanel.setOpaque(false);
        SigninActionListener actionListener = new SigninActionListener();
        this.signinButton.addActionListener(actionListener);
        cancelButton.addActionListener(actionListener);
        buttonPanel.add(this.signinButton);
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(this.signinButton);
        this.initAccountWizards();
        String groupName = Resources.getApplicationProperty("impl.gui.DEFAULT_GROUP_NAME");
        if (groupName != null && groupName.length() > 0) {
            MetaContactListService contactList = SimpleAccountRegistrationActivator.getContactList();
            Iterator iter = contactList.getRoot().getSubgroups();
            while (iter.hasNext()) {
                MetaContactGroup gr = (MetaContactGroup)iter.next();
                if (!groupName.equals(gr.getGroupName())) continue;
                return;
            }
            contactList.createMetaContactGroup(contactList.getRoot(), groupName);
            this.getConfigurationService().setProperty("net.java.sip.communicator.impl.gui.addcontact.lastContactParent", (Object)groupName);
        }
        this.getRootPane().validate();
        this.pack();
        if ((double)scroller.getViewport().getHeight() < Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 230.0) {
            this.setSize(scroller.getViewport().getWidth() + 100, scroller.getViewport().getHeight() + 150);
        } else {
            this.setSize(this.getSize().width + 20, this.getSize().height - 10);
        }
    }

    private void initProvisioningPanel() {
        String isInitialProv = SimpleAccountRegistrationActivator.getResources().getSettingsString("plugin.provisioning.IS_INITIAL_PROVISIONING_LINK");
        if (isInitialProv != null && isInitialProv.length() > 0 && !Boolean.parseBoolean(isInitialProv)) {
            return;
        }
        String useProvisioningString = SimpleAccountRegistrationActivator.getResources().getI18NString("service.gui.USE_PROVISIONING");
        JLabel provisioningLabel = new JLabel("<html><a href=''>" + useProvisioningString + "</a></html>");
        provisioningLabel.setCursor(new Cursor(12));
        provisioningLabel.setToolTipText(useProvisioningString);
        provisioningLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ConfigurationContainer configContainer = SimpleAccountRegistrationActivator.getUIService().getConfigurationContainer();
                ConfigurationForm advancedConfigForm = SimpleAccountRegistrationActivator.getAdvancedConfigForm();
                if (advancedConfigForm != null) {
                    ConfigurationForm provisioningForm;
                    configContainer.setSelected(advancedConfigForm);
                    if (advancedConfigForm instanceof ConfigurationContainer && (provisioningForm = SimpleAccountRegistrationActivator.getProvisioningConfigForm()) != null) {
                        ((ConfigurationContainer)advancedConfigForm).setSelected(provisioningForm);
                    }
                }
                configContainer.setVisible(true);
            }
        });
        this.southPanel.add((Component)provisioningLabel, (Object)"West");
    }

    private void initAccountWizards() {
        String simpleWizards = SimpleAccountRegistrationActivator.getConfigService().getString("plugin.simpleaccreg.PROTOCOL_ORDER");
        StringTokenizer tokenizer = new StringTokenizer(simpleWizards, "|");
        ServiceReference[] serviceRefs = null;
        while (tokenizer.hasMoreTokens()) {
            String protocolToken = tokenizer.nextToken();
            String osgiFilter = "(PROTOCOL_NAME=" + protocolToken + ")";
            try {
                serviceRefs = SimpleAccountRegistrationActivator.bundleContext.getServiceReferences(AccountRegistrationWizard.class.getName(), osgiFilter);
                if (serviceRefs == null || serviceRefs.length <= 0) continue;
                AccountRegistrationWizard wizard = (AccountRegistrationWizard)SimpleAccountRegistrationActivator.bundleContext.getService(serviceRefs[0]);
                this.addAccountRegistrationForm(wizard);
            }
            catch (InvalidSyntaxException ex) {
                this.logger.error((Object)"GuiActivator : ", (Throwable)ex);
            }
        }
    }

    private void addAccountRegistrationForm(AccountRegistrationWizard wizard) {
        AccountRegistrationPanel accountPanel;
        if (!wizard.isSimpleFormEnabled()) {
            return;
        }
        String preferredWizardName = Resources.getLoginProperty("impl.gui.PREFERRED_ACCOUNT_WIZARD");
        if (preferredWizardName != null && preferredWizardName.equals(wizard.getClass().getName())) {
            accountPanel = new AccountRegistrationPanel(wizard, true);
            this.mainAccountsPanel.add((Component)accountPanel, (Object)"North");
            this.mainAccountsPanel.validate();
        } else {
            accountPanel = new AccountRegistrationPanel(wizard, false);
            this.accountsPanel.add((Component)accountPanel);
            this.accountsPanel.validate();
        }
        this.registrationForms.add(accountPanel);
    }

    private void saveAccountWizard(ProtocolProviderService protocolProvider, AccountRegistrationWizard wizard) {
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        ConfigurationService configService = this.getConfigurationService();
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        boolean savedAccount = false;
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            configService.setProperty(accountRootPropName + ".wizard", (Object)wizard.getClass().getName().replace('.', '_'));
            savedAccount = true;
        }
        if (!savedAccount) {
            String accNodeName = "acc" + Long.toString(System.currentTimeMillis());
            String accountPackage = "net.java.sip.communicator.impl.gui.accounts." + accNodeName;
            configService.setProperty(accountPackage, (Object)protocolProvider.getAccountID().getAccountUniqueID());
            configService.setProperty(accountPackage + ".wizard", (Object)wizard);
        }
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            BundleContext bundleContext = SimpleAccountRegistrationActivator.bundleContext;
            ServiceReference configReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            this.configurationService = (ConfigurationService)bundleContext.getService(configReference);
        }
        return this.configurationService;
    }

    private JComponent createTitleComponent() {
        JTextPane titlePane = new JTextPane();
        SimpleAttributeSet aSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(aSet, 1);
        StyleConstants.setBold(aSet, true);
        StyleConstants.setFontFamily(aSet, titlePane.getFont().getFamily());
        titlePane.setParagraphAttributes(aSet, true);
        titlePane.setEditable(false);
        titlePane.setText(Resources.getString("plugin.simpleaccregwizz.INITIAL_ACCOUNT_REGISTRATION"));
        titlePane.setOpaque(false);
        return titlePane;
    }

    private void showCreateAccountWindow(AccountRegistrationWizard wizard) {
        CreateAccountWindow createAccountWindow = SimpleAccountRegistrationActivator.getUIService().getCreateAccountWindow();
        createAccountWindow.setSelectedWizard(wizard, true);
        if (wizard instanceof ExtendedAccountRegistrationWizard) {
            ((ExtendedAccountRegistrationWizard)wizard).setCreateAccountView();
        }
        createAccountWindow.setVisible(true);
    }

    protected void close(boolean isEscaped) {
    }

    private class SigninActionListener
    implements ActionListener {
        private SigninActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JButton button = (JButton)evt.getSource();
            if (button.equals(InitialAccountRegistrationFrame.this.signinButton)) {
                Iterator regIterator = InitialAccountRegistrationFrame.this.registrationForms.iterator();
                if (regIterator.hasNext()) {
                    InitialAccountRegistrationFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                }
                while (regIterator.hasNext()) {
                    AccountRegistrationPanel regForm = (AccountRegistrationPanel)regIterator.next();
                    try {
                        if (!regForm.isFilled()) continue;
                        regForm.signin();
                    }
                    catch (OperationFailedException e) {
                        if (InitialAccountRegistrationFrame.this.logger.isDebugEnabled()) {
                            InitialAccountRegistrationFrame.this.logger.debug((Object)"The sign in operation has failed.");
                        }
                        PopupDialog popupDialog = SimpleAccountRegistrationActivator.getUIService().getPopupDialog();
                        if (e.getErrorCode() == 11) {
                            popupDialog.showMessagePopupDialog((Object)Resources.getString("service.gui.USERNAME_NULL"), Resources.getString("service.gui.ERROR"), 0);
                            continue;
                        }
                        if (e.getErrorCode() == 10) {
                            popupDialog.showMessagePopupDialog((Object)Resources.getString("service.gui.USER_EXISTS_ERROR"), Resources.getString("service.gui.ERROR"), 0);
                            continue;
                        }
                        if (e.getErrorCode() != 17) continue;
                        popupDialog.showMessagePopupDialog((Object)Resources.getString("service.gui.SPECIFY_SERVER"), Resources.getString("service.gui.ERROR"), 0);
                    }
                }
            }
            InitialAccountRegistrationFrame initialAccountRegistrationFrame = InitialAccountRegistrationFrame.this;
            initialAccountRegistrationFrame.setVisible(false);
            initialAccountRegistrationFrame.dispose();
        }
    }

    private class AccountRegistrationPanel
    extends JPanel {
        private static final long serialVersionUID = 0L;
        private JLabel usernameLabel;
        private JLabel passwordLabel;
        private JTextField usernameField;
        private JLabel usernameExampleLabel;
        private JPasswordField passwordField;
        private JPanel labelsPanel;
        private JPanel fieldsPanel;
        private JPanel emptyPanel;
        private JPanel inputPanel;
        private JPanel iconDescriptionPanel;
        private JTextArea descriptionArea;
        private final AccountRegistrationWizard wizard;

        public AccountRegistrationPanel(AccountRegistrationWizard accountWizard, boolean isPreferredWizard) {
            super(new BorderLayout(5, 5));
            this.usernameLabel = new JLabel(Resources.getString("plugin.simpleaccregwizz.LOGIN_USERNAME"));
            this.passwordLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
            this.usernameField = new JTextField();
            this.usernameExampleLabel = new JLabel();
            this.passwordField = new JPasswordField();
            this.labelsPanel = new JPanel(new GridLayout(0, 1, 5, 0));
            this.fieldsPanel = new JPanel(new GridLayout(0, 1, 5, 0));
            this.emptyPanel = new JPanel();
            this.inputPanel = new JPanel(new BorderLayout(5, 5));
            this.iconDescriptionPanel = new JPanel(new BorderLayout());
            this.descriptionArea = new JTextArea();
            this.wizard = accountWizard;
            this.wizard.getSimpleForm(false);
            JLabel protocolLabel = new JLabel();
            JPanel inputRegisterPanel = new JPanel(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setOpaque(false);
            this.inputPanel.setOpaque(false);
            this.labelsPanel.setOpaque(false);
            this.fieldsPanel.setOpaque(false);
            this.emptyPanel.setOpaque(false);
            inputRegisterPanel.setOpaque(false);
            this.iconDescriptionPanel.setOpaque(false);
            this.add((Component)inputRegisterPanel, "Center");
            inputRegisterPanel.add((Component)this.inputPanel, "North");
            if (this.wizard instanceof ExtendedAccountRegistrationWizard && ((ExtendedAccountRegistrationWizard)this.wizard).isSignupSupported() || this.wizard.isWebSignupSupported()) {
                String textKey = isPreferredWizard ? "plugin.simpleaccregwizz.SPECIAL_SIGNUP" : "plugin.simpleaccregwizz.SIGNUP";
                JLabel signupLabel = new JLabel("<html><a href=''>" + Resources.getString(textKey) + "</a></html>", 4);
                signupLabel.setFont(signupLabel.getFont().deriveFont(10.0f));
                signupLabel.setCursor(new Cursor(12));
                signupLabel.setToolTipText(Resources.getString("plugin.simpleaccregwizz.SPECIAL_SIGNUP"));
                signupLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        try {
                            if (AccountRegistrationPanel.this.wizard instanceof ExtendedAccountRegistrationWizard && ((ExtendedAccountRegistrationWizard)AccountRegistrationPanel.this.wizard).isSignupSupported()) {
                                InitialAccountRegistrationFrame.this.showCreateAccountWindow(AccountRegistrationPanel.this.wizard);
                                InitialAccountRegistrationFrame.this.dispose();
                            } else if (AccountRegistrationPanel.this.wizard.isWebSignupSupported()) {
                                AccountRegistrationPanel.this.wizard.webSignup();
                            }
                        }
                        catch (UnsupportedOperationException ex) {
                            InitialAccountRegistrationFrame.this.logger.error((Object)"The web sign up is not supported.", (Throwable)ex);
                        }
                    }
                });
                inputRegisterPanel.add((Component)signupLabel, "South");
            }
            this.inputPanel.add((Component)this.labelsPanel, "West");
            this.inputPanel.add((Component)this.fieldsPanel, "Center");
            this.iconDescriptionPanel.add((Component)protocolLabel, "North");
            protocolLabel.setFont(protocolLabel.getFont().deriveFont(1, 14.0f));
            this.usernameExampleLabel.setForeground(Color.DARK_GRAY);
            this.usernameExampleLabel.setFont(this.usernameExampleLabel.getFont().deriveFont(8.0f));
            this.emptyPanel.setMaximumSize(new Dimension(40, 25));
            this.labelsPanel.add(this.usernameLabel);
            this.labelsPanel.add(this.emptyPanel);
            this.labelsPanel.add(this.passwordLabel);
            this.fieldsPanel.add(this.usernameField);
            this.fieldsPanel.add(this.usernameExampleLabel);
            this.fieldsPanel.add(this.passwordField);
            this.usernameExampleLabel.setText(this.wizard.getUserNameExample());
            protocolLabel.setText(this.wizard.getProtocolName());
            Image image = null;
            try {
                image = ImageIO.read(new ByteArrayInputStream(this.wizard.getPageImage()));
            }
            catch (IOException e) {
                InitialAccountRegistrationFrame.this.logger.error((Object)"Unable to load image.", (Throwable)e);
            }
            if (image != null) {
                image = image.getScaledInstance(28, 28, 4);
                protocolLabel.setIcon(new ImageIcon(image));
            }
            if (isPreferredWizard) {
                this.descriptionArea.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(10.0f));
                this.descriptionArea.setPreferredSize(new Dimension(220, 50));
                this.descriptionArea.setLineWrap(true);
                this.descriptionArea.setWrapStyleWord(true);
                this.descriptionArea.setText(this.wizard.getProtocolDescription());
                this.descriptionArea.setEditable(false);
                this.descriptionArea.setOpaque(false);
                this.iconDescriptionPanel.add((Component)this.descriptionArea, "Center");
                this.add((Component)this.iconDescriptionPanel, "West");
            } else {
                this.add((Component)this.iconDescriptionPanel, "North");
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g = g.create();
            try {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.GRAY);
                g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 15, 15);
            }
            finally {
                g.dispose();
            }
        }

        public boolean isFilled() {
            String username = this.usernameField.getText();
            return username != null && username.length() > 0;
        }

        public void signin() throws OperationFailedException {
            ProtocolProviderService protocolProvider = this.wizard.signin(this.usernameField.getText(), new String(this.passwordField.getPassword()));
            InitialAccountRegistrationFrame.this.saveAccountWizard(protocolProvider, this.wizard);
        }
    }
}

