/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.LineHighlightManager;
import org.fife.ui.rtextarea.RTADefaultInputMap;
import org.fife.ui.rtextarea.RTATextTransferHandler;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class RTextAreaUI
extends BasicTextAreaUI {
    private static final String SHARED_ACTION_MAP_NAME = "RTextAreaUI.actionMap";
    private static final String SHARED_INPUT_MAP_NAME = "RTextAreaUI.inputMap";
    protected RTextArea textArea;
    private static final EditorKit defaultKit = new RTextAreaEditorKit();
    private static final TransferHandler defaultTransferHandler = new RTATextTransferHandler();
    private static final String RTEXTAREA_KEYMAP_NAME = "RTextAreaKeymap";

    public static ComponentUI createUI(JComponent jComponent) {
        return new RTextAreaUI(jComponent);
    }

    public RTextAreaUI(JComponent jComponent) {
        if (!(jComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("RTextAreaUI is for instances of RTextArea only!");
        }
        this.textArea = (RTextArea)jComponent;
    }

    private void correctNimbusDefaultProblems(JTextComponent jTextComponent) {
        Insets insets;
        Border border;
        Color color = jTextComponent.getCaretColor();
        if (color == null) {
            jTextComponent.setCaretColor(RTextArea.getDefaultCaretColor());
        }
        if ((color = jTextComponent.getSelectionColor()) == null) {
            color = UIManager.getColor("nimbusSelectionBackground");
            if (color == null && (color = UIManager.getColor("textHighlight")) == null) {
                color = new ColorUIResource(Color.BLUE);
            }
            jTextComponent.setSelectionColor(color);
        }
        if ((color = jTextComponent.getSelectedTextColor()) == null) {
            color = UIManager.getColor("nimbusSelectedText");
            if (color == null && (color = UIManager.getColor("textHighlightText")) == null) {
                color = new ColorUIResource(Color.WHITE);
            }
            jTextComponent.setSelectedTextColor(color);
        }
        if ((color = jTextComponent.getDisabledTextColor()) == null) {
            color = UIManager.getColor("nimbusDisabledText");
            if (color == null && (color = UIManager.getColor("textInactiveText")) == null) {
                color = new ColorUIResource(Color.DARK_GRAY);
            }
            jTextComponent.setDisabledTextColor(color);
        }
        if ((border = jTextComponent.getBorder()) == null) {
            jTextComponent.setBorder(new BasicBorders.MarginBorder());
        }
        if ((insets = jTextComponent.getMargin()) == null) {
            jTextComponent.setMargin(new InsetsUIResource(2, 2, 2, 2));
        }
    }

    @Override
    public View create(Element element) {
        if (this.textArea.getLineWrap()) {
            return new WrappedPlainView(element, this.textArea.getWrapStyleWord());
        }
        return new PlainView(element);
    }

    @Override
    protected Caret createCaret() {
        ConfigurableCaret configurableCaret = new ConfigurableCaret();
        configurableCaret.setBlinkRate(500);
        return configurableCaret;
    }

    @Override
    protected Keymap createKeymap() {
        Keymap keymap = JTextComponent.getKeymap(RTEXTAREA_KEYMAP_NAME);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(RTEXTAREA_KEYMAP_NAME, keymap2);
            keymap.setDefaultAction(new RTextAreaEditorKit.DefaultKeyTypedAction());
        }
        return keymap;
    }

    protected ActionMap createRTextAreaActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        for (Action action : this.textArea.getActions()) {
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected String getActionMapName() {
        return SHARED_ACTION_MAP_NAME;
    }

    @Override
    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    public RTextArea getRTextArea() {
        return this.textArea;
    }

    private ActionMap getRTextAreaActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get(this.getActionMapName());
        if (actionMap == null) {
            actionMap = this.createRTextAreaActionMap();
            UIManager.put(this.getActionMapName(), actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        if (actionMap != null) {
            actionMapUIResource.setParent(actionMap);
        }
        return actionMapUIResource;
    }

    protected InputMap getRTextAreaInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)UIManager.get(SHARED_INPUT_MAP_NAME);
        if (inputMap == null) {
            inputMap = new RTADefaultInputMap();
            UIManager.put(SHARED_INPUT_MAP_NAME, inputMap);
        }
        inputMapUIResource.setParent(inputMap);
        return inputMapUIResource;
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = this.textArea.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.textArea.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JTextComponent jTextComponent = this.getComponent();
        jTextComponent.setFont(RTextAreaBase.getDefaultFont());
        this.correctNimbusDefaultProblems(jTextComponent);
        jTextComponent.setTransferHandler(defaultTransferHandler);
    }

    @Override
    protected void installKeyboardActions() {
        RTextArea rTextArea = this.getRTextArea();
        rTextArea.setKeymap(this.createKeymap());
        InputMap inputMap = this.getRTextAreaInputMap();
        SwingUtilities.replaceUIInputMap(rTextArea, 0, inputMap);
        ActionMap actionMap = this.getRTextAreaActionMap();
        if (actionMap != null) {
            SwingUtilities.replaceUIActionMap(rTextArea, actionMap);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (!(jComponent instanceof RTextArea)) {
            throw new Error("RTextAreaUI needs an instance of RTextArea!");
        }
        super.installUI(jComponent);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Color color = this.textArea.getBackground();
        if (color != null) {
            graphics.setColor(color);
            Rectangle rectangle = graphics.getClipBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintEditorAugmentations(graphics);
    }

    protected void paintCurrentLineHighlight(Graphics graphics, Rectangle rectangle) {
        Caret caret;
        if (this.textArea.getHighlightCurrentLine() && (caret = this.textArea.getCaret()).getDot() == caret.getMark()) {
            Color color = this.textArea.getCurrentLineHighlightColor();
            int n = this.textArea.getLineHeight();
            if (this.textArea.getFadeCurrentLineHighlight()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color2 = this.textArea.getBackground();
                GradientPaint gradientPaint = new GradientPaint(rectangle.x, 0.0f, color, rectangle.x + rectangle.width, 0.0f, color2 == null ? Color.WHITE : color2);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(rectangle.x, this.textArea.currentCaretY, rectangle.width, n);
            } else {
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, this.textArea.currentCaretY, rectangle.width, n);
            }
        }
    }

    protected void paintEditorAugmentations(Graphics graphics) {
        Rectangle rectangle = this.textArea.getVisibleRect();
        this.paintLineHighlights(graphics);
        this.paintCurrentLineHighlight(graphics, rectangle);
        this.paintMarginLine(graphics, rectangle);
    }

    protected void paintLineHighlights(Graphics graphics) {
        LineHighlightManager lineHighlightManager = this.textArea.getLineHighlightManager();
        if (lineHighlightManager != null) {
            lineHighlightManager.paintLineHighlights(graphics);
        }
    }

    protected void paintMarginLine(Graphics graphics, Rectangle rectangle) {
        if (this.textArea.isMarginLineEnabled()) {
            graphics.setColor(this.textArea.getMarginLineColor());
            Insets insets = this.textArea.getInsets();
            int n = this.textArea.getMarginLinePixelLocation() + (insets == null ? 0 : insets.left);
            graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
        }
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        if (!this.textArea.isOpaque()) {
            this.paintEditorAugmentations(graphics);
        }
        super.paintSafely(graphics);
    }

    public int yForLine(int n) throws BadLocationException {
        int n2 = this.textArea.getLineStartOffset(n);
        return this.yForLineContaining(n2);
    }

    public int yForLineContaining(int n) throws BadLocationException {
        Rectangle rectangle = this.modelToView(this.textArea, n);
        return rectangle != null ? rectangle.y : -1;
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RTextAreaUI.this.textArea.requestFocus();
        }

        @Override
        public boolean isEnabled() {
            return RTextAreaUI.this.textArea.isEditable();
        }
    }
}

