/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public class BufferedImageBackgroundPainterStrategy
extends ImageBackgroundPainterStrategy {
    private BufferedImage bgImage;

    public BufferedImageBackgroundPainterStrategy(RTextAreaBase rTextAreaBase) {
        super(rTextAreaBase);
    }

    @Override
    protected void paintImage(Graphics graphics, int n, int n2) {
        if (this.bgImage != null) {
            graphics.drawImage(this.bgImage, n, n2, null);
        }
    }

    @Override
    protected void rescaleImage(int n, int n2, int n3) {
        Image image = this.getMasterImage();
        if (image != null) {
            HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
            switch (n3) {
                default: 
            }
            hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.bgImage = this.createAcceleratedImage(n, n2);
            Graphics2D graphics2D = this.bgImage.createGraphics();
            graphics2D.addRenderingHints(hashMap);
            graphics2D.drawImage(image, 0, 0, n, n2, null);
            graphics2D.dispose();
        } else {
            this.bgImage = null;
        }
    }

    private BufferedImage createAcceleratedImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = this.getRTextAreaBase().getGraphicsConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        return bufferedImage;
    }
}

