/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class JsonFoldParser
implements FoldParser {
    private static final Object OBJECT_BLOCK = new Object();
    private static final Object ARRAY_BLOCK = new Object();

    @Override
    public List<Fold> getFolds(RSyntaxTextArea rSyntaxTextArea) {
        Stack<Object> stack = new Stack<Object>();
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Fold fold = null;
        int n = rSyntaxTextArea.getLineCount();
        try {
            for (int i = 0; i < n; ++i) {
                for (Token token = rSyntaxTextArea.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                    Fold fold2;
                    if (token.isLeftCurly()) {
                        if (fold == null) {
                            fold = new Fold(0, rSyntaxTextArea, token.getOffset());
                            arrayList.add(fold);
                        } else {
                            fold = fold.createChild(0, token.getOffset());
                        }
                        stack.push(OBJECT_BLOCK);
                        continue;
                    }
                    if (token.isRightCurly() && JsonFoldParser.popOffTop(stack, OBJECT_BLOCK)) {
                        if (fold == null) continue;
                        fold.setEndOffset(token.getOffset());
                        fold2 = fold.getParent();
                        if (fold.isOnSingleLine() && !fold.removeFromParent()) {
                            arrayList.remove(arrayList.size() - 1);
                        }
                        fold = fold2;
                        continue;
                    }
                    if (JsonFoldParser.isLeftBracket(token)) {
                        if (fold == null) {
                            fold = new Fold(0, rSyntaxTextArea, token.getOffset());
                            arrayList.add(fold);
                        } else {
                            fold = fold.createChild(0, token.getOffset());
                        }
                        stack.push(ARRAY_BLOCK);
                        continue;
                    }
                    if (!JsonFoldParser.isRightBracket(token) || !JsonFoldParser.popOffTop(stack, ARRAY_BLOCK) || fold == null) continue;
                    fold.setEndOffset(token.getOffset());
                    fold2 = fold.getParent();
                    if (fold.isOnSingleLine() && !fold.removeFromParent()) {
                        arrayList.remove(arrayList.size() - 1);
                    }
                    fold = fold2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }

    private static final boolean isLeftBracket(Token token) {
        return token.getType() == 22 && token.isSingleChar('[');
    }

    private static final boolean isRightBracket(Token token) {
        return token.getType() == 22 && token.isSingleChar(']');
    }

    private static final boolean popOffTop(Stack<Object> stack, Object object) {
        if (stack.size() > 0 && stack.peek() == object) {
            stack.pop();
            return true;
        }
        return false;
    }
}

