/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.annotation;

import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import com.thoughtworks.qdox.model.annotation.AnnotationVisitor;
import java.util.StringTokenizer;

public class AnnotationFieldRef
implements AnnotationValue {
    String[] myArray = new String[]{"unchecked"};
    private final int[] parts;
    private final String name;
    private AbstractBaseJavaEntity context;
    private JavaField field;
    private int fieldIndex = -1;

    public AnnotationFieldRef(String string) {
        this.name = string;
        int n = new StringTokenizer(string, ".").countTokens();
        this.parts = new int[n + 1];
        this.parts[0] = -1;
        for (int i = 1; i < n; ++i) {
            this.parts[i] = string.indexOf(46, this.parts[i - 1] + 1);
        }
        this.parts[n] = string.length();
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix(int n) {
        return this.name.substring(0, this.parts[n + 1]);
    }

    public String getNamePart(int n) {
        return this.name.substring(this.parts[n] + 1, this.parts[n + 1]);
    }

    public int getPartCount() {
        return this.parts.length - 1;
    }

    @Override
    public Object accept(AnnotationVisitor annotationVisitor) {
        return annotationVisitor.visitAnnotationFieldRef(this);
    }

    @Override
    public Object getParameterValue() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public AbstractBaseJavaEntity getContext() {
        return this.context;
    }

    public void setContext(AbstractBaseJavaEntity abstractBaseJavaEntity) {
        this.context = abstractBaseJavaEntity;
    }

    public String getClassPart() {
        String string = null;
        if (this.getField() != null) {
            string = this.name.substring(0, this.parts[this.fieldIndex]);
        }
        return string;
    }

    public String getFieldPart() {
        String string = null;
        if (this.getField() != null) {
            string = this.name.substring(this.parts[this.fieldIndex] + 1);
        }
        return string;
    }

    protected JavaField resolveField(JavaClass javaClass, int n, int n2) {
        JavaField javaField = null;
        for (int i = n; i < n2 && (javaField = javaClass.getFieldByName(this.getNamePart(i))) != null; ++i) {
            javaClass = javaField.getType().getJavaClass();
        }
        return javaField;
    }

    public JavaField getField() {
        if (this.fieldIndex < 0) {
            JavaClass javaClass;
            if (this.context.getParentClass() != null) {
                javaClass = this.context.getParentClass();
                this.field = this.resolveField(javaClass, 0, this.parts.length - 1);
                this.fieldIndex = 0;
            }
            if (this.field == null) {
                javaClass = this.context.getParentClass();
                if (javaClass == null) {
                    javaClass = (JavaClass)this.context;
                }
                for (int i = 0; i < this.parts.length - 1; ++i) {
                    Type type;
                    JavaClass javaClass2;
                    String string = this.getNamePrefix(i);
                    String string2 = javaClass.resolveType(string);
                    if (string2 == null || (javaClass2 = (type = Type.createUnresolved(string2, 0, (JavaClassParent)javaClass)).getJavaClass()) == null) continue;
                    this.fieldIndex = i + 1;
                    this.field = this.resolveField(javaClass2, i + 1, this.parts.length - 1);
                    break;
                }
            }
        }
        return this.field;
    }
}

