/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.ant;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractQdoxTask
extends Task {
    private Vector filesets = new Vector();
    protected HashMap fileMap = new HashMap();
    protected ArrayList allSources = new ArrayList();
    protected ArrayList allClasses = new ArrayList();

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    protected void buildFileMap() {
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.buildFileMap(fileSet.getDir(this.getProject()), stringArray);
        }
    }

    protected void buildFileMap(File file, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            this.fileMap.put(file2.getAbsolutePath(), file2);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.buildFileMap();
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder(this.createDocletTagFactory());
        javaDocBuilder.getClassLibrary().addClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.mergeBuilderSources(javaDocBuilder);
        JavaSource[] javaSourceArray = javaDocBuilder.getSources();
        this.processSources(javaSourceArray);
    }

    protected DocletTagFactory createDocletTagFactory() {
        return new DefaultDocletTagFactory();
    }

    private void mergeBuilderSources(JavaDocBuilder javaDocBuilder) {
        for (String string : this.fileMap.keySet()) {
            javaDocBuilder.addSourceTree((File)this.fileMap.get(string));
        }
    }

    protected void processSources(JavaSource[] javaSourceArray) {
        for (int i = 0; i < javaSourceArray.length; ++i) {
            JavaSource javaSource = javaSourceArray[i];
            this.allSources.add(javaSource);
            JavaClass[] javaClassArray = javaSource.getClasses();
            this.processClasses(javaClassArray);
        }
    }

    protected void processClasses(JavaClass[] javaClassArray) {
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            this.allClasses.add(javaClass);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source fileset.");
        }
    }
}

