/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.io.IOException;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SMTPSClient;
import org.apache.commons.net.util.Base64;

public class AuthenticatingSMTPClient
extends SMTPSClient {
    public AuthenticatingSMTPClient() {
    }

    public AuthenticatingSMTPClient(String string) {
        super(string);
    }

    public AuthenticatingSMTPClient(String string, boolean bl) {
        super(string, bl);
    }

    public AuthenticatingSMTPClient(String string, boolean bl, String string2) {
        super(string, bl, string2);
    }

    public AuthenticatingSMTPClient(boolean bl, SSLContext sSLContext) {
        super(bl, sSLContext);
    }

    public AuthenticatingSMTPClient(String string, String string2) {
        super(string, false, string2);
    }

    public int ehlo(String string) throws IOException {
        return this.sendCommand(15, string);
    }

    public boolean elogin(String string) throws IOException {
        return SMTPReply.isPositiveCompletion(this.ehlo(string));
    }

    public boolean elogin() throws IOException {
        InetAddress inetAddress = this.getLocalAddress();
        String string = inetAddress.getHostName();
        if (string == null) {
            return false;
        }
        return SMTPReply.isPositiveCompletion(this.ehlo(string));
    }

    public int[] getEnhancedReplyCode() {
        String string = this.getReplyString().substring(4);
        String[] stringArray = string.substring(0, string.indexOf(32)).split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public boolean auth(AUTH_METHOD aUTH_METHOD, String string, String string2) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!SMTPReply.isPositiveIntermediate(this.sendCommand(14, AUTH_METHOD.getAuthName(aUTH_METHOD)))) {
            return false;
        }
        if (aUTH_METHOD.equals((Object)AUTH_METHOD.PLAIN)) {
            return SMTPReply.isPositiveCompletion(this.sendCommand(Base64.encodeBase64StringUnChunked(("\u0000" + string + "\u0000" + string2).getBytes(this.getCharsetName()))));
        }
        if (aUTH_METHOD.equals((Object)AUTH_METHOD.CRAM_MD5)) {
            byte[] byArray = Base64.decodeBase64(this.getReplyString().substring(4).trim());
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(new SecretKeySpec(string2.getBytes(this.getCharsetName()), "HmacMD5"));
            byte[] byArray2 = this._convertToHexString(mac.doFinal(byArray)).getBytes(this.getCharsetName());
            byte[] byArray3 = string.getBytes(this.getCharsetName());
            byte[] byArray4 = new byte[byArray3.length + 1 + byArray2.length];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            byArray4[byArray3.length] = 32;
            System.arraycopy(byArray2, 0, byArray4, byArray3.length + 1, byArray2.length);
            return SMTPReply.isPositiveCompletion(this.sendCommand(Base64.encodeBase64StringUnChunked(byArray4)));
        }
        if (aUTH_METHOD.equals((Object)AUTH_METHOD.LOGIN)) {
            if (!SMTPReply.isPositiveIntermediate(this.sendCommand(Base64.encodeBase64StringUnChunked(string.getBytes(this.getCharsetName()))))) {
                return false;
            }
            return SMTPReply.isPositiveCompletion(this.sendCommand(Base64.encodeBase64StringUnChunked(string2.getBytes(this.getCharsetName()))));
        }
        if (aUTH_METHOD.equals((Object)AUTH_METHOD.XOAUTH)) {
            return SMTPReply.isPositiveIntermediate(this.sendCommand(Base64.encodeBase64StringUnChunked(string.getBytes(this.getCharsetName()))));
        }
        return false;
    }

    private String _convertToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            if ((by & 0xFF) <= 15) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static enum AUTH_METHOD {
        PLAIN,
        CRAM_MD5,
        LOGIN,
        XOAUTH;


        public static final String getAuthName(AUTH_METHOD aUTH_METHOD) {
            if (aUTH_METHOD.equals((Object)PLAIN)) {
                return "PLAIN";
            }
            if (aUTH_METHOD.equals((Object)CRAM_MD5)) {
                return "CRAM-MD5";
            }
            if (aUTH_METHOD.equals((Object)LOGIN)) {
                return "LOGIN";
            }
            if (aUTH_METHOD.equals((Object)XOAUTH)) {
                return "XOAUTH";
            }
            return null;
        }
    }
}

