/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.pop3;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.net.pop3.POP3SClient;
import org.apache.commons.net.util.Base64;

public class ExtendedPOP3Client
extends POP3SClient {
    public boolean auth(AUTH_METHOD aUTH_METHOD, String string, String string2) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (this.sendCommand(13, aUTH_METHOD.getAuthName()) != 2) {
            return false;
        }
        switch (aUTH_METHOD) {
            case PLAIN: {
                return this.sendCommand(new String(Base64.encodeBase64(("\u0000" + string + "\u0000" + string2).getBytes(this.getCharsetName())), this.getCharsetName())) == 0;
            }
            case CRAM_MD5: {
                byte[] byArray = Base64.decodeBase64(this.getReplyString().substring(2).trim());
                Mac mac = Mac.getInstance("HmacMD5");
                mac.init(new SecretKeySpec(string2.getBytes(this.getCharsetName()), "HmacMD5"));
                byte[] byArray2 = this._convertToHexString(mac.doFinal(byArray)).getBytes(this.getCharsetName());
                byte[] byArray3 = string.getBytes(this.getCharsetName());
                byte[] byArray4 = new byte[byArray3.length + 1 + byArray2.length];
                System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                byArray4[byArray3.length] = 32;
                System.arraycopy(byArray2, 0, byArray4, byArray3.length + 1, byArray2.length);
                return this.sendCommand(Base64.encodeBase64StringUnChunked(byArray4)) == 0;
            }
        }
        return false;
    }

    private String _convertToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            if ((by & 0xFF) <= 15) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static enum AUTH_METHOD {
        PLAIN("PLAIN"),
        CRAM_MD5("CRAM-MD5");

        private final String methodName;

        private AUTH_METHOD(String string2) {
            this.methodName = string2;
        }

        public final String getAuthName() {
            return this.methodName;
        }
    }
}

