/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;

public class FTPFile
implements Serializable {
    private static final long serialVersionUID = 9010790363003271996L;
    public static final int FILE_TYPE = 0;
    public static final int DIRECTORY_TYPE = 1;
    public static final int SYMBOLIC_LINK_TYPE = 2;
    public static final int UNKNOWN_TYPE = 3;
    public static final int USER_ACCESS = 0;
    public static final int GROUP_ACCESS = 1;
    public static final int WORLD_ACCESS = 2;
    public static final int READ_PERMISSION = 0;
    public static final int WRITE_PERMISSION = 1;
    public static final int EXECUTE_PERMISSION = 2;
    private int _type;
    private int _hardLinkCount;
    private long _size;
    private String _rawListing;
    private String _user;
    private String _group;
    private String _name;
    private String _link;
    private Calendar _date;
    private final boolean[][] _permissions;

    public FTPFile() {
        this._permissions = new boolean[3][3];
        this._type = 3;
        this._hardLinkCount = 0;
        this._size = -1L;
        this._user = "";
        this._group = "";
        this._date = null;
        this._name = null;
    }

    FTPFile(String string) {
        this._permissions = null;
        this._rawListing = string;
        this._type = 3;
        this._hardLinkCount = 0;
        this._size = -1L;
        this._user = "";
        this._group = "";
        this._date = null;
        this._name = null;
    }

    public void setRawListing(String string) {
        this._rawListing = string;
    }

    public String getRawListing() {
        return this._rawListing;
    }

    public boolean isDirectory() {
        return this._type == 1;
    }

    public boolean isFile() {
        return this._type == 0;
    }

    public boolean isSymbolicLink() {
        return this._type == 2;
    }

    public boolean isUnknown() {
        return this._type == 3;
    }

    public boolean isValid() {
        return this._permissions != null;
    }

    public void setType(int n) {
        this._type = n;
    }

    public int getType() {
        return this._type;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setSize(long l) {
        this._size = l;
    }

    public long getSize() {
        return this._size;
    }

    public void setHardLinkCount(int n) {
        this._hardLinkCount = n;
    }

    public int getHardLinkCount() {
        return this._hardLinkCount;
    }

    public void setGroup(String string) {
        this._group = string;
    }

    public String getGroup() {
        return this._group;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public String getUser() {
        return this._user;
    }

    public void setLink(String string) {
        this._link = string;
    }

    public String getLink() {
        return this._link;
    }

    public void setTimestamp(Calendar calendar) {
        this._date = calendar;
    }

    public Calendar getTimestamp() {
        return this._date;
    }

    public void setPermission(int n, int n2, boolean bl) {
        this._permissions[n][n2] = bl;
    }

    public boolean hasPermission(int n, int n2) {
        if (this._permissions == null) {
            return false;
        }
        return this._permissions[n][n2];
    }

    public String toString() {
        return this.getRawListing();
    }

    public String toFormattedString() {
        return this.toFormattedString(null);
    }

    public String toFormattedString(String string) {
        if (!this.isValid()) {
            return "[Invalid: could not parse file entry]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        stringBuilder.append(this.formatType());
        stringBuilder.append(this.permissionToString(0));
        stringBuilder.append(this.permissionToString(1));
        stringBuilder.append(this.permissionToString(2));
        formatter.format(" %4d", this.getHardLinkCount());
        formatter.format(" %-8s %-8s", this.getUser(), this.getGroup());
        formatter.format(" %8d", this.getSize());
        Calendar calendar = this.getTimestamp();
        if (calendar != null) {
            TimeZone timeZone;
            if (string != null && !(timeZone = TimeZone.getTimeZone(string)).equals(calendar.getTimeZone())) {
                Date date = calendar.getTime();
                Calendar calendar2 = Calendar.getInstance(timeZone);
                calendar2.setTime(date);
                calendar = calendar2;
            }
            formatter.format(" %1$tY-%1$tm-%1$td", calendar);
            if (calendar.isSet(11)) {
                formatter.format(" %1$tH", calendar);
                if (calendar.isSet(12)) {
                    formatter.format(":%1$tM", calendar);
                    if (calendar.isSet(13)) {
                        formatter.format(":%1$tS", calendar);
                        if (calendar.isSet(14)) {
                            formatter.format(".%1$tL", calendar);
                        }
                    }
                }
                formatter.format(" %1$tZ", calendar);
            }
        }
        stringBuilder.append(' ');
        stringBuilder.append(this.getName());
        formatter.close();
        return stringBuilder.toString();
    }

    private char formatType() {
        switch (this._type) {
            case 0: {
                return '-';
            }
            case 1: {
                return 'd';
            }
            case 2: {
                return 'l';
            }
        }
        return '?';
    }

    private String permissionToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasPermission(n, 0)) {
            stringBuilder.append('r');
        } else {
            stringBuilder.append('-');
        }
        if (this.hasPermission(n, 1)) {
            stringBuilder.append('w');
        } else {
            stringBuilder.append('-');
        }
        if (this.hasPermission(n, 2)) {
            stringBuilder.append('x');
        } else {
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }
}

