/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class SignatureBuilder
extends ClassFileVisitor {
    private boolean foundSome;
    private final Logger logger;
    private List<Pattern> includeClasses;
    private List<Pattern> excludeClasses;
    private final Map<String, Clazz> classes = new TreeMap<String, Clazz>();
    private final ObjectOutputStream oos;

    public static void main(String[] stringArray) throws IOException {
        SignatureBuilder signatureBuilder = new SignatureBuilder(new FileOutputStream("signature"), new PrintWriterLogger(System.out));
        signatureBuilder.process(new File(System.getProperty("java.home"), "lib/rt.jar"));
        signatureBuilder.close();
    }

    public SignatureBuilder(OutputStream outputStream, Logger logger) throws IOException {
        this(null, outputStream, logger);
    }

    public void addInclude(String string) {
        if (this.includeClasses == null) {
            this.includeClasses = new ArrayList<Pattern>();
        }
        this.includeClasses.add(RegexUtils.compileWildcard(string));
    }

    public void addExclude(String string) {
        if (this.excludeClasses == null) {
            this.excludeClasses = new ArrayList<Pattern>();
        }
        this.excludeClasses.add(RegexUtils.compileWildcard(string));
    }

    public SignatureBuilder(InputStream[] inputStreamArray, OutputStream outputStream, Logger logger) throws IOException {
        this.logger = logger;
        if (inputStreamArray != null) {
            block5: for (int i = 0; i < inputStreamArray.length; ++i) {
                try (ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream(inputStreamArray[i]));){
                    while (true) {
                        Clazz clazz;
                        if ((clazz = (Clazz)objectInputStream.readObject()) == null) {
                            continue block5;
                        }
                        this.classes.put(clazz.getName(), clazz);
                    }
                }
            }
        }
        this.oos = new ObjectOutputStream(new GZIPOutputStream(outputStream));
    }

    public void close() throws IOException {
        int n = 0;
        for (Map.Entry<String, Clazz> entry : this.classes.entrySet()) {
            boolean bl;
            String string = entry.getKey().replace('/', '.');
            if (this.includeClasses != null) {
                bl = false;
                for (Pattern pattern : this.includeClasses) {
                    bl |= pattern.matcher(string).matches();
                }
                if (!bl) continue;
            }
            if (this.excludeClasses != null) {
                bl = false;
                for (Pattern pattern : this.excludeClasses) {
                    bl |= pattern.matcher(string).matches();
                }
                if (bl) continue;
            }
            ++n;
            this.logger.debug(string);
            this.oos.writeObject(entry.getValue());
        }
        this.oos.writeObject(null);
        this.logger.info("Wrote signatures for " + n + " classes.");
        this.oos.close();
        if (!this.foundSome) {
            throw new IOException("No index is written");
        }
    }

    @Override
    protected void process(String string, InputStream inputStream) throws IOException {
        this.logger.debug(string);
        this.foundSome = true;
        ClassReader classReader = new ClassReader(inputStream);
        SignatureVisitor signatureVisitor = new SignatureVisitor();
        classReader.accept((ClassVisitor)signatureVisitor, 0);
        signatureVisitor.end();
    }

    private class SignatureVisitor
    extends ClassVisitor {
        private Clazz clazz;

        public SignatureVisitor() {
            super(327680);
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.clazz = new Clazz(string, new HashSet<String>(), string3, stringArray);
        }

        public void end() throws IOException {
            Clazz clazz = (Clazz)SignatureBuilder.this.classes.get(this.clazz.getName());
            if (clazz == null) {
                SignatureBuilder.this.classes.put(this.clazz.getName(), this.clazz);
            } else {
                SignatureBuilder.this.classes.put(this.clazz.getName(), new Clazz(this.clazz, clazz));
            }
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            this.clazz.getSignatures().add(string + string2);
            return null;
        }

        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            this.clazz.getSignatures().add(string + "#" + string2);
            return null;
        }
    }
}

