SCM_GLOBAL_SMOB (scm_tc16_avahi_error_enum, "error", 0);
SCM scm_avahi_error_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_avahi_error_enum, error_print, obj, port, pstate)
{
  scm_puts ("#<avahi-error-enum ", port);
  scm_puts (avahi_strerror (scm_to_avahi_error (obj, 1, "error_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_error_to_string, "error->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{error} value.")
#define FUNC_NAME s_scm_avahi_error_to_string
{
  int c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_error (enumval, 1, FUNC_NAME);
  c_string = avahi_strerror (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_watch_event_enum, "watch-event", 0);
SCM scm_avahi_watch_event_enum_values = SCM_EOL;
static const char *
scm_avahi_watch_event_to_c_string (AvahiWatchEvent c_obj)
{
  static const struct { AvahiWatchEvent value; const char *name; } table[] =
    {
       { AVAHI_WATCH_IN, "in" },
       { AVAHI_WATCH_OUT, "out" },
       { AVAHI_WATCH_ERR, "err" },
       { AVAHI_WATCH_HUP, "hup" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 4; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_watch_event_enum, watch_event_print, obj, port, pstate)
{
  scm_puts ("#<avahi-watch-event-enum ", port);
  scm_puts (scm_avahi_watch_event_to_c_string (scm_to_avahi_watch_event (obj, 1, "watch_event_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_watch_event_to_string, "watch-event->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{watch-event} value.")
#define FUNC_NAME s_scm_avahi_watch_event_to_string
{
  AvahiWatchEvent c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_watch_event (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_watch_event_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_protocol_enum, "protocol", 0);
SCM scm_avahi_protocol_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_avahi_protocol_enum, protocol_print, obj, port, pstate)
{
  scm_puts ("#<avahi-protocol-enum ", port);
  scm_puts (avahi_proto_to_string (scm_to_avahi_protocol (obj, 1, "protocol_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_protocol_to_string, "protocol->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{protocol} value.")
#define FUNC_NAME s_scm_avahi_protocol_to_string
{
  AvahiProtocol c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_protocol (enumval, 1, FUNC_NAME);
  c_string = avahi_proto_to_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_interface_enum, "interface", 0);
SCM scm_avahi_interface_enum_values = SCM_EOL;
static const char *
scm_avahi_interface_to_c_string (AvahiIfIndex c_obj)
{
  static const struct { AvahiIfIndex value; const char *name; } table[] =
    {
       { AVAHI_IF_UNSPEC, "unspec" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 1; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_interface_enum, interface_print, obj, port, pstate)
{
  scm_puts ("#<avahi-interface-enum ", port);
  scm_puts (scm_avahi_interface_to_c_string (scm_to_avahi_interface (obj, 1, "interface_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_interface_to_string, "interface->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{interface} value.")
#define FUNC_NAME s_scm_avahi_interface_to_string
{
  AvahiIfIndex c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_interface (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_interface_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
static inline void
scm_avahi_define_enums (void)
{
  SCM enum_values, enum_smob;
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_OK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/ok", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/failure", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_BAD_STATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/bad-state", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_HOST_NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-host-name", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_DOMAIN_NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-domain-name", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NO_NETWORK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-network", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_TTL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-ttl", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_IS_PATTERN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/is-pattern", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_COLLISION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/collision", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_RECORD);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-record", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_SERVICE_NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-service-name", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_SERVICE_TYPE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-service-type", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_PORT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-port", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_KEY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-key", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_ADDRESS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-address", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_TIMEOUT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/timeout", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_TOO_MANY_CLIENTS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/too-many-clients", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_TOO_MANY_OBJECTS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/too-many-objects", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_TOO_MANY_ENTRIES);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/too-many-entries", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_OS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/os", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_ACCESS_DENIED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/access-denied", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_OPERATION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-operation", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DBUS_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dbus-error", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DISCONNECTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/disconnected", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NO_MEMORY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-memory", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_OBJECT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-object", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NO_DAEMON);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-daemon", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_INTERFACE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-interface", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_PROTOCOL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-protocol", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_FLAGS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-flags", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NOT_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/not-found", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_CONFIG);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-config", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_VERSION_MISMATCH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/version-mismatch", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_SERVICE_SUBTYPE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-service-subtype", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_PACKET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-packet", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_DNS_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-dns-error", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_FORMERR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-formerr", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_SERVFAIL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-servfail", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_NXDOMAIN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-nxdomain", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_NOTIMP);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-notimp", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_REFUSED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-refused", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_YXDOMAIN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-yxdomain", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_YXRRSET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-yxrrset", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_NXRRSET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-nxrrset", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_NOTAUTH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-notauth", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_DNS_NOTZONE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dns-notzone", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_RDATA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-rdata", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_DNS_CLASS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-dns-class", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_DNS_TYPE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-dns-type", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NOT_SUPPORTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/not-supported", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NOT_PERMITTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/not-permitted", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_INVALID_ARGUMENT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-argument", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_IS_EMPTY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/is-empty", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_error_enum, (scm_t_bits) AVAHI_ERR_NO_CHANGE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-change", enum_smob);
  scm_avahi_error_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_watch_event_enum, (scm_t_bits) AVAHI_WATCH_IN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("watch-event/in", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_watch_event_enum, (scm_t_bits) AVAHI_WATCH_OUT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("watch-event/out", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_watch_event_enum, (scm_t_bits) AVAHI_WATCH_ERR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("watch-event/err", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_watch_event_enum, (scm_t_bits) AVAHI_WATCH_HUP);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("watch-event/hup", enum_smob);
  scm_avahi_watch_event_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_protocol_enum, (scm_t_bits) AVAHI_PROTO_INET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/inet", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_protocol_enum, (scm_t_bits) AVAHI_PROTO_INET6);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/inet6", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_protocol_enum, (scm_t_bits) AVAHI_PROTO_UNSPEC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/unspec", enum_smob);
  scm_avahi_protocol_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_interface_enum, (scm_t_bits) AVAHI_IF_UNSPEC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("interface/unspec", enum_smob);
  scm_avahi_interface_enum_values = scm_permanent_object (enum_values);
}
