/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.random;

import org.spaceroots.mantissa.linalg.SymetricalMatrix;

public class VectorialSampleStatistics {
    private int dimension = -1;
    private int n = 0;
    private int[] minIndices = null;
    private double[] min = null;
    private double[] max = null;
    private int[] maxIndices = null;
    private double[] sum = null;
    private double[] sum2 = null;

    public void add(double[] x) {
        if (this.n == 0) {
            this.dimension = x.length;
            this.minIndices = new int[this.dimension];
            this.maxIndices = new int[this.dimension];
            this.min = (double[])x.clone();
            this.max = (double[])x.clone();
            this.sum = (double[])x.clone();
            this.sum2 = new double[this.dimension * (this.dimension + 1) / 2];
            int k = 0;
            for (int i = 0; i < this.dimension; ++i) {
                for (int j = 0; j <= i; ++j) {
                    this.sum2[k++] = x[i] * x[j];
                }
            }
        } else {
            int k = 0;
            for (int i = 0; i < this.dimension; ++i) {
                if (x[i] < this.min[i]) {
                    this.min[i] = x[i];
                    this.minIndices[i] = this.n;
                } else if (x[i] > this.max[i]) {
                    this.max[i] = x[i];
                    this.maxIndices[i] = this.n;
                }
                int n = i;
                this.sum[n] = this.sum[n] + x[i];
                for (int j = 0; j <= i; ++j) {
                    int n2 = k++;
                    this.sum2[n2] = this.sum2[n2] + x[i] * x[j];
                }
            }
        }
        ++this.n;
    }

    public void add(double[][] points) {
        for (int i = 0; i < points.length; ++i) {
            this.add(points[i]);
        }
    }

    public void add(VectorialSampleStatistics s) {
        if (s.n == 0) {
            return;
        }
        if (this.n == 0) {
            this.dimension = s.dimension;
            this.min = (double[])s.min.clone();
            this.minIndices = (int[])s.minIndices.clone();
            this.max = (double[])s.max.clone();
            this.maxIndices = (int[])s.maxIndices.clone();
            this.sum = (double[])s.sum.clone();
            this.sum2 = (double[])s.sum2.clone();
        } else {
            int k = 0;
            for (int i = 0; i < this.dimension; ++i) {
                if (s.min[i] < this.min[i]) {
                    this.min[i] = s.min[i];
                    this.minIndices[i] = this.n;
                } else if (s.max[i] > this.max[i]) {
                    this.max[i] = s.max[i];
                    this.maxIndices[i] = this.n;
                }
                int n = i;
                this.sum[n] = this.sum[n] + s.sum[i];
                for (int j = 0; j <= i; ++j) {
                    int n2 = k;
                    this.sum2[n2] = this.sum2[n2] + s.sum2[k];
                    ++k;
                }
            }
        }
        this.n += s.n;
    }

    public int size() {
        return this.n;
    }

    public double[] getMin() {
        return (double[])this.min.clone();
    }

    public int[] getMinIndices() {
        return (int[])this.minIndices.clone();
    }

    public double[] getMax() {
        return (double[])this.max.clone();
    }

    public int[] getMaxIndices() {
        return (int[])this.maxIndices.clone();
    }

    public double[] getMean() {
        if (this.n == 0) {
            return new double[0];
        }
        double[] mean = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            mean[i] = this.sum[i] / (double)this.n;
        }
        return mean;
    }

    public SymetricalMatrix getCovarianceMatrix(SymetricalMatrix covariance) {
        if (this.n < 2) {
            return null;
        }
        if (covariance == null) {
            covariance = new SymetricalMatrix(this.dimension);
        }
        double c = 1.0 / (double)(this.n * (this.n - 1));
        int k = 0;
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j <= i; ++j) {
                double e = c * ((double)this.n * this.sum2[k] - this.sum[i] * this.sum[j]);
                covariance.setElementAndSymetricalElement(i, j, e);
                ++k;
            }
        }
        return covariance;
    }
}

