/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.optimization;

import org.spaceroots.mantissa.optimization.CostException;
import org.spaceroots.mantissa.optimization.DirectSearchOptimizer;
import org.spaceroots.mantissa.optimization.PointCostPair;

public class MultiDirectional
extends DirectSearchOptimizer {
    private double khi;
    private double gamma;

    public MultiDirectional() {
        this.khi = 2.0;
        this.gamma = 0.5;
    }

    public MultiDirectional(double khi, double gamma) {
        this.khi = khi;
        this.gamma = gamma;
    }

    @Override
    protected void iterateSimplex() throws CostException {
        double originalCost;
        PointCostPair[] original;
        double contractedCost;
        do {
            original = this.simplex;
            originalCost = original[0].cost;
            double reflectedCost = this.evaluateNewSimplex(original, 1.0);
            if (!(reflectedCost < originalCost)) continue;
            PointCostPair[] reflected = this.simplex;
            double expandedCost = this.evaluateNewSimplex(original, this.khi);
            if (reflectedCost <= expandedCost) {
                this.simplex = reflected;
            }
            return;
        } while (!((contractedCost = this.evaluateNewSimplex(original, this.gamma)) < originalCost));
    }

    private double evaluateNewSimplex(PointCostPair[] original, double coeff) throws CostException {
        double[] xSmallest = original[0].point;
        int n = xSmallest.length;
        this.simplex = new PointCostPair[n + 1];
        this.simplex[0] = original[0];
        for (int i = 1; i <= n; ++i) {
            double[] xOriginal = original[i].point;
            double[] xTransformed = new double[n];
            for (int j = 0; j < n; ++j) {
                xTransformed[j] = xSmallest[j] + coeff * (xSmallest[j] - xOriginal[j]);
            }
            this.simplex[i] = new PointCostPair(xTransformed, Double.NaN);
        }
        this.evaluateSimplex();
        return this.simplex[0].cost;
    }
}

