/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.scalar.ComputableFunction;
import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.StepInterpolator;
import org.spaceroots.mantissa.ode.SwitchingFunction;
import org.spaceroots.mantissa.roots.BrentSolver;
import org.spaceroots.mantissa.roots.ConvergenceChecker;

class SwitchState
implements ComputableFunction,
ConvergenceChecker {
    private static final long serialVersionUID = 6944466361876662425L;
    private SwitchingFunction function;
    private double maxCheckInterval;
    private double convergence;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double previousEventTime;
    private boolean increasing;
    private int nextAction;
    private StepInterpolator interpolator;

    public SwitchState(SwitchingFunction function, double maxCheckInterval, double convergence) {
        this.function = function;
        this.maxCheckInterval = maxCheckInterval;
        this.convergence = Math.abs(convergence);
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.previousEventTime = Double.NaN;
        this.increasing = true;
        this.nextAction = 3;
        this.interpolator = null;
    }

    public void reinitializeBegin(double t0, double[] y0) {
        this.t0 = t0;
        this.g0 = this.function.g(t0, y0);
        this.g0Positive = this.g0 >= 0.0;
    }

    public boolean evaluateStep(StepInterpolator interpolator) {
        try {
            this.interpolator = interpolator;
            double t1 = interpolator.getCurrentTime();
            int n = Math.max(1, (int)Math.ceil(Math.abs(t1 - this.t0) / this.maxCheckInterval));
            double h = (t1 - this.t0) / (double)n;
            double ta = this.t0;
            double ga = this.g0;
            double tb = this.t0 + (t1 > this.t0 ? this.convergence : -this.convergence);
            for (int i = 0; i < n; ++i) {
                interpolator.setInterpolatedTime(tb += h);
                double gb = this.function.g(tb, interpolator.getInterpolatedState());
                if (this.g0Positive ^ gb >= 0.0) {
                    this.increasing = gb >= ga;
                    BrentSolver solver = new BrentSolver();
                    if (solver.findRoot(this, this, 1000, ta, ga, tb, gb)) {
                        if (!Double.isNaN(this.previousEventTime) && !(Math.abs(this.previousEventTime - solver.getRoot()) > this.convergence)) continue;
                        this.pendingEventTime = solver.getRoot();
                        if (this.pendingEvent && Math.abs(t1 - this.pendingEventTime) <= this.convergence) {
                            return false;
                        }
                        this.pendingEvent = true;
                        return true;
                    }
                    throw new RuntimeException("internal error");
                }
                ta = tb;
                ga = gb;
            }
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        catch (DerivativeException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        catch (FunctionException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public double getEventTime() {
        return this.pendingEventTime;
    }

    public void stepAccepted(double t, double[] y) {
        this.t0 = t;
        this.g0 = this.function.g(t, y);
        if (this.pendingEvent) {
            this.previousEventTime = t;
            this.g0Positive = this.increasing;
            this.nextAction = this.function.eventOccurred(t, y);
        } else {
            this.g0Positive = this.g0 >= 0.0;
            this.nextAction = 3;
        }
    }

    public boolean stop() {
        return this.nextAction == 0;
    }

    public boolean reset(double t, double[] y) {
        if (!this.pendingEvent) {
            return false;
        }
        if (this.nextAction == 1) {
            this.function.resetState(t, y);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return this.nextAction == 1 || this.nextAction == 2;
    }

    @Override
    public double valueAt(double t) throws FunctionException {
        try {
            this.interpolator.setInterpolatedTime(t);
            return this.function.g(t, this.interpolator.getInterpolatedState());
        }
        catch (DerivativeException e) {
            throw new FunctionException(e);
        }
    }

    @Override
    public int converged(double x0, double y0, double x1, double y1) {
        if (Math.abs(x1 - x0) < this.convergence) {
            return Math.abs(y0) < Math.abs(y1) ? 1 : 2;
        }
        return 0;
    }
}

