/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.fitting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.spaceroots.mantissa.estimation.EstimatedParameter;
import org.spaceroots.mantissa.estimation.EstimationException;
import org.spaceroots.mantissa.estimation.EstimationProblem;
import org.spaceroots.mantissa.estimation.Estimator;
import org.spaceroots.mantissa.estimation.WeightedMeasurement;

public abstract class AbstractCurveFitter
implements EstimationProblem,
Serializable {
    protected EstimatedParameter[] coefficients;
    protected List measurements;
    private Estimator estimator;

    protected AbstractCurveFitter(int n, Estimator estimator) {
        this.coefficients = new EstimatedParameter[n];
        this.measurements = new ArrayList();
        this.estimator = estimator;
    }

    protected AbstractCurveFitter(EstimatedParameter[] coefficients, Estimator estimator) {
        this.coefficients = coefficients;
        this.measurements = new ArrayList();
        this.estimator = estimator;
    }

    public void addWeightedPair(double weight, double x, double y) {
        this.measurements.add(new FitMeasurement(weight, x, y));
    }

    public double[] fit() throws EstimationException {
        this.estimator.estimate(this);
        double[] fittedCoefficients = new double[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            fittedCoefficients[i] = this.coefficients[i].getEstimate();
        }
        return fittedCoefficients;
    }

    @Override
    public WeightedMeasurement[] getMeasurements() {
        return this.measurements.toArray(new FitMeasurement[this.measurements.size()]);
    }

    @Override
    public EstimatedParameter[] getUnboundParameters() {
        return (EstimatedParameter[])this.coefficients.clone();
    }

    @Override
    public EstimatedParameter[] getAllParameters() {
        return (EstimatedParameter[])this.coefficients.clone();
    }

    protected void sortMeasurements() {
        FitMeasurement curr = (FitMeasurement)this.measurements.get(0);
        for (int j = 1; j < this.measurements.size(); ++j) {
            FitMeasurement prec = curr;
            curr = (FitMeasurement)this.measurements.get(j);
            if (!(curr.x < prec.x)) continue;
            int i = j - 1;
            FitMeasurement mI = (FitMeasurement)this.measurements.get(i);
            while (i >= 0 && curr.x < mI.x) {
                this.measurements.set(i + 1, mI);
                if (i-- != 0) {
                    mI = (FitMeasurement)this.measurements.get(i);
                    continue;
                }
                mI = null;
            }
            this.measurements.set(i + 1, curr);
            curr = (FitMeasurement)this.measurements.get(j);
        }
    }

    public abstract double valueAt(double var1);

    public abstract double partial(double var1, EstimatedParameter var3);

    public class FitMeasurement
    extends WeightedMeasurement {
        public final double x;
        private static final long serialVersionUID = -2682582852369995960L;

        public FitMeasurement(double weight, double x, double y) {
            super(weight, y);
            this.x = x;
        }

        @Override
        public double getTheoreticalValue() {
            return AbstractCurveFitter.this.valueAt(this.x);
        }

        @Override
        public double getPartial(EstimatedParameter p) {
            return AbstractCurveFitter.this.partial(this.x, p);
        }
    }
}

