/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bitpedia.collider.core.Bitcollider;
import org.bitpedia.collider.core.Bitprint;
import org.bitpedia.collider.core.Ed2Handler;
import org.bitpedia.collider.core.FormatHandler;
import org.bitpedia.collider.core.FtuuHandler;
import org.bitpedia.collider.core.Id3Handler;
import org.bitpedia.collider.core.KzTreeHandler;
import org.bitpedia.collider.core.Md5Handler;
import org.bitpedia.collider.core.Mp3Handler;
import org.bitpedia.util.ArrayUtils;
import org.bitpedia.util.Base32;

public class Submission {
    private static final String SUBMIT_URL = "http://bitzi.com/lookup/";
    private static final int FIRST_N_HEX = 20;
    private Bitcollider bc;
    private Map attrs = new LinkedHashMap();
    private int numBitprints = 0;
    private String fileName;
    private long fileSize;
    private boolean autoSubmit = true;
    private String checkAsExt = null;
    private int percentComplete = 0;

    public Submission(Bitcollider bitcollider, String string, boolean bl) {
        this.bc = bitcollider;
        this.checkAsExt = string;
        this.autoSubmit = bl;
    }

    public boolean isAutoSubmit() {
        return this.autoSubmit;
    }

    public void setAutoSubmit(boolean bl) {
        this.autoSubmit = bl;
    }

    public String getCheckAsExt() {
        return this.checkAsExt;
    }

    public void setCheckAsExt(String string) {
        this.checkAsExt = string;
    }

    public String getAttribute(String string) {
        return (String)this.attrs.get(string);
    }

    public void addAttribute(String string, String string2) {
        if (null == string2) {
            return;
        }
        if (this.numBitprints > 0) {
            string = this.numBitprints + "." + string;
        }
        if (this.attrs.containsKey(string)) {
            return;
        }
        this.attrs.put(string, string2);
    }

    private void toMultiple() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : this.attrs.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if ("head.".equals(string.substring(0, 5))) {
                if ("head.version".equals(string)) {
                    string2 = "M" + string2.substring(1);
                }
            } else {
                string = "0." + string;
            }
            linkedHashMap.put(string, string2);
        }
        this.attrs = linkedHashMap;
    }

    private boolean calculateHashes(InputStream inputStream, Hashes hashes, Mp3Handler mp3Handler, FormatHandler formatHandler) {
        byte[] byArray;
        Bitprint bitprint = new Bitprint();
        int n = -1;
        Md5Handler md5Handler = new Md5Handler();
        Ed2Handler ed2Handler = new Ed2Handler();
        FtuuHandler ftuuHandler = new FtuuHandler();
        KzTreeHandler kzTreeHandler = new KzTreeHandler();
        if (!bitprint.analyzeInit()) {
            this.bc.setError("The hash functions compiled into this version of the bitcollider utility are faulty!!!");
            return false;
        }
        if (null != mp3Handler) {
            mp3Handler.analyzeInit();
        }
        if (null != formatHandler && formatHandler.supportsMemAnalyze()) {
            formatHandler.analyzeInit();
        }
        if (this.bc.isCalcCrc32()) {
            n = -1;
        }
        if (this.bc.isCalcMd5()) {
            md5Handler.analyzeInit();
        }
        ed2Handler.analyzeInit();
        ftuuHandler.analyzeInit();
        kzTreeHandler.analyzeInit();
        byte[] byArray2 = new byte[4096];
        long l = 0L;
        this.percentComplete = 0;
        if (null != this.bc.getProgress() && !this.bc.isPreview()) {
            this.bc.getProgress().progress(0, this.fileName, null);
        }
        while (true) {
            int n2;
            if (this.bc.isExitNow()) {
                return false;
            }
            int n3 = 0;
            try {
                n3 = inputStream.read(byArray2);
            }
            catch (IOException iOException) {
                n3 = -1;
                iOException.printStackTrace();
            }
            if (n3 <= 0) break;
            l += (long)n3;
            bitprint.analyzeUpdate(byArray2, 0, n3);
            if (null != mp3Handler) {
                mp3Handler.analyzeUpdate(byArray2, 0, n3);
            }
            if (null != formatHandler && formatHandler.supportsMemAnalyze()) {
                formatHandler.analyzeUpdate(byArray2, n3);
            }
            if (this.bc.isCalcCrc32()) {
                n = FtuuHandler.hashSmallHash(byArray2, 0, n3, n);
            }
            if (this.bc.isCalcMd5()) {
                md5Handler.analyzeUpdate(byArray2, n3);
            }
            ed2Handler.analyzeUpdate(byArray2, 0, n3);
            ftuuHandler.analyzeUpdate(byArray2, 0, n3);
            kzTreeHandler.analyzeUpdate(byArray2, 0, n3);
            if (null == this.bc.getProgress() || this.bc.isPreview() || (n2 = (int)(l * 100L / this.fileSize)) == this.percentComplete) continue;
            this.bc.getProgress().progress(n2, null, null);
            this.percentComplete = n2;
        }
        this.percentComplete = 100;
        byte[] byArray3 = bitprint.analyzeFinal();
        String string = Base32.encode(byArray3);
        hashes.bitprint = string.substring(0, 32) + '.' + string.substring(32);
        if (null != mp3Handler) {
            mp3Handler.analyzeFinal();
        }
        if (null != formatHandler && formatHandler.supportsMemAnalyze()) {
            hashes.attrs = formatHandler.analyzeFinal();
        }
        if (this.bc.isCalcCrc32()) {
            hashes.crc32Hex = Integer.toHexString(n ^= 0xFFFFFFFF);
            while (hashes.crc32Hex.length() < 8) {
                hashes.crc32Hex = '0' + hashes.crc32Hex;
            }
        }
        if (this.bc.isCalcMd5()) {
            byArray = md5Handler.analyzeFinal();
            hashes.md5Sum = ArrayUtils.byteArrayToHex(byArray, 0, byArray.length);
        }
        byArray = ed2Handler.analyzeFinal();
        byte[] byArray4 = ftuuHandler.analyzeFinal();
        byte[] byArray5 = kzTreeHandler.analyzeFinal();
        hashes.ed2Kmd4Sum = ArrayUtils.byteArrayToHex(byArray, 0, byArray.length);
        hashes.kzHashSum = ArrayUtils.byteArrayToHex(byArray4, 0, byArray4.length) + ArrayUtils.byteArrayToHex(byArray5, 0, byArray5.length);
        return true;
    }

    private String generateFirstHex(InputStream inputStream, int n) {
        byte[] byArray = new byte[n];
        try {
            n = inputStream.read(byArray);
            if (n < 0) {
                return "";
            }
            return ArrayUtils.byteArrayToHex(byArray, 0, n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBitprintData(String string, Hashes hashes, Mp3Handler mp3Handler, FormatHandler formatHandler) {
        boolean bl = false;
        try {
            File file = new File(string);
            this.fileSize = file.length();
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                bl = this.calculateHashes(fileInputStream, hashes, mp3Handler, formatHandler);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (bl) {
                fileInputStream = new FileInputStream(string);
                try {
                    hashes.firstHex = this.generateFirstHex(fileInputStream, 20);
                    bl = null != hashes.firstHex;
                }
                finally {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.bc.setError("File not found or permission denied.");
            return false;
        }
    }

    public static String extractName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (-1 != n) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String extractExt(String string) {
        string = Submission.extractName(string);
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (-1 != n) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public boolean analyzeFile(String string, boolean bl) {
        Object object;
        Hashes hashes;
        this.bc.setError(null);
        this.bc.setWarning(null);
        this.fileName = string;
        if (this.bc.isExitNow()) {
            return false;
        }
        String string2 = Submission.extractExt(string);
        boolean bl2 = null == this.checkAsExt && "mp3".equalsIgnoreCase(string2);
        string2 = null == this.checkAsExt ? string2 : this.checkAsExt;
        FormatHandler formatHandler = this.bc.getFormatHandler(string2);
        if (bl && null == formatHandler && !bl2) {
            if (null != this.bc.getProgress() && !this.bc.isPreview()) {
                this.bc.getProgress().progress(0, string, "skipped.");
            }
            return false;
        }
        if (this.bc.isPreview()) {
            ++this.numBitprints;
            return true;
        }
        Mp3Handler mp3Handler = null;
        if (bl2) {
            mp3Handler = new Mp3Handler();
        }
        if (!this.getBitprintData(string, hashes = new Hashes(), mp3Handler, formatHandler)) {
            return false;
        }
        if (0 == this.numBitprints) {
            this.addAttribute("head.agent", Bitcollider.getAgentString());
            this.addAttribute("head.version", "S0.4");
        }
        if (1 == this.numBitprints) {
            this.toMultiple();
        }
        this.addAttribute("bitprint", hashes.bitprint);
        this.addAttribute("tag.file.length", "" + new File(string).length());
        this.addAttribute("tag.file.first20", hashes.firstHex);
        this.addAttribute("tag.filename.filename", Submission.extractName(string));
        if (this.bc.isCalcCrc32()) {
            this.addAttribute("tag.crc32.crc32", hashes.crc32Hex);
        }
        if (this.bc.isCalcMd5()) {
            this.addAttribute("tag.md5.md5", hashes.md5Sum);
        }
        this.addAttribute("tag.ed2k.ed2khash", hashes.ed2Kmd4Sum);
        this.addAttribute("tag.kzhash.kzhash", hashes.kzHashSum);
        if (bl2 && 0 == mp3Handler.sampleRate) {
            this.bc.setWarning("This is not an MP3 file. Skipping mp3 information.");
            bl2 = false;
        } else if (bl2) {
            this.addAttribute("tag.mp3.duration", "" + mp3Handler.duration);
            if (0 == mp3Handler.bitRate) {
                this.addAttribute("tag.mp3.bitrate", "" + mp3Handler.avgBitRate);
                this.addAttribute("tag.mp3.vbr", "y");
            } else {
                this.addAttribute("tag.mp3.bitrate", "" + mp3Handler.bitRate);
            }
            this.addAttribute("tag.mp3.samplerate", "" + mp3Handler.sampleRate);
            this.addAttribute("tag.mp3.stereo", mp3Handler.stereo ? "y" : "n");
            this.addAttribute("tag.mp3.audio_sha1", Base32.encode(mp3Handler.audioSha));
            object = Id3Handler.readId3Tags(string);
            if (null != object) {
                this.addAttribute("tag.mp3.encoder", ((Id3Handler.Id3Info)object).encoder);
                this.addAttribute("tag.audiotrack.title", ((Id3Handler.Id3Info)object).title);
                this.addAttribute("tag.audiotrack.artist", ((Id3Handler.Id3Info)object).artist);
                this.addAttribute("tag.audiotrack.album", ((Id3Handler.Id3Info)object).album);
                this.addAttribute("tag.audiotrack.tracknumber", ((Id3Handler.Id3Info)object).trackNumber);
                this.addAttribute("tag.id3genre.genre", ((Id3Handler.Id3Info)object).genre);
                this.addAttribute("tag.audiotrack.year", ((Id3Handler.Id3Info)object).year);
            }
        }
        if (null != hashes.attrs) {
            for (Map.Entry object2 : hashes.attrs.entrySet()) {
                this.addAttribute((String)object2.getKey(), (String)object2.getValue());
            }
        }
        if (null != formatHandler && !formatHandler.supportsMemAnalyze() && formatHandler.supportsFileAnalyze() && !this.bc.isExitNow()) {
            object = formatHandler.analyzeFile(string);
            if (null != object && 0 < object.size()) {
                for (Map.Entry entry : object.entrySet()) {
                    this.addAttribute((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                this.bc.setWarning(formatHandler.getError());
            }
        }
        if (null != this.bc.getProgress() && !this.bc.isPreview() && !this.bc.isExitNow()) {
            this.bc.getProgress().progress(100, null, "ok.");
        }
        ++this.numBitprints;
        return true;
    }

    public int recurseDir(String string, boolean bl, boolean bl2) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                if (!this.analyzeFile(fileArray[i].getPath(), !bl)) continue;
                ++n;
                continue;
            }
            if (fileArray[i].isDirectory()) {
                if (!bl2) continue;
                n += this.recurseDir(fileArray[i].getPath(), bl, bl2);
                continue;
            }
            if (null == this.bc.getProgress()) continue;
            this.bc.getProgress().progress(0, fileArray[i].getName(), "skipped. (not a regular file)");
        }
        return n;
    }

    private static String toEscaped(String string) {
        int n = string.length();
        int n2 = 0;
        block11: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    n2 += 5;
                    continue block11;
                }
                case '&': {
                    n2 += 4;
                    continue block11;
                }
                case '<': 
                case '>': {
                    n2 += 3;
                }
            }
        }
        if (0 == n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block12: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block12;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block12;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block12;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block12;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean makeHtml(PrintWriter printWriter, String string) {
        if (0 == this.numBitprints) {
            this.bc.setError("The submission contained no bitprints.");
            return false;
        }
        string = null == string ? SUBMIT_URL : string;
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
        printWriter.print("<HTML><HEAD><TITLE>");
        if (1 == this.numBitprints) {
            printWriter.println("Bitprint Submission " + this.fileName);
        } else {
            printWriter.println("Multiple [" + this.numBitprints + "] Bitprint Submission");
        }
        printWriter.println("</TITLE>\n</HEAD>");
        if (this.autoSubmit) {
            printWriter.println("<BODY onLoad=\"document.forms[0].submit()\">");
        } else {
            printWriter.println("<BODY>");
        }
        if (1 == this.numBitprints) {
            printWriter.println("<h3>Bitprint Submission " + this.fileName + "</h3><p>");
        } else {
            printWriter.println("<h3>Multiple [" + this.numBitprints + "] Bitprint Submission</h3><p>");
        }
        printWriter.println("You are submitting the following bitprint and tag data to the web location <i>" + string + "</i>. For more information see <a " + "href=\"http://bitzi.com/bitcollider/websubmit\">the Bitzi website.</a>" + "<p>\nIf you are submitting more than a handful of files at once, it " + "may take a while for this page to load and submit.<p>\n" + "This submission should occur automatically. If it does not, you " + "may press the \"submit\" button which will appear at the bottom of " + "the page.<p><HR>");
        printWriter.println("<FORM method=post action=\"" + string + "\">");
        printWriter.println("<PRE>");
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (String string2 : this.attrs.keySet()) {
            String string3 = (String)this.attrs.get(string2);
            try {
                n2 = Integer.parseInt(string2.substring(0, string2.indexOf(".")));
            }
            catch (Throwable throwable) {
                n2 = -1;
            }
            if (n2 != n3 || 2 == n) {
                n3 = n2;
                printWriter.println();
            }
            ++n;
            printWriter.print(string2 + "=<INPUT TYPE=\"hidden\" ");
            String string4 = Submission.toEscaped(string3);
            printWriter.println("NAME=\"" + string2 + "\" VALUE=\"" + string4 + "\">" + string3);
        }
        printWriter.println("\n<INPUT TYPE=\"submit\" NAME=\"Submit\" VALUE=\"Submit\">");
        printWriter.println("</PRE>\n</FORM>\n</BODY>\n</HTML>");
        return true;
    }

    public int getNumBitprints() {
        return this.numBitprints;
    }

    private class Hashes {
        String bitprint;
        String crc32Hex;
        String md5Sum;
        String ed2Kmd4Sum;
        String kzHashSum;
        String firstHex;
        Map attrs;

        private Hashes() {
        }
    }
}

