/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import com.onionnetworks.util.Range;
import com.onionnetworks.util.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RangeSet {
    public static final int DEFAULT_CAPACITY = 16;
    boolean posInf;
    boolean negInf;
    int rangeCount;
    long[] ranges = new long[32];

    public RangeSet() {
    }

    public RangeSet(Range r) {
        this();
        this.add(r);
    }

    public RangeSet union(RangeSet rs) {
        RangeSet result = new RangeSet();
        result.add(this);
        result.add(rs);
        return result;
    }

    public RangeSet intersect(RangeSet rs) {
        RangeSet result = this.complement();
        result.add(rs.complement());
        return result.complement();
    }

    public RangeSet complement() {
        RangeSet rs = new RangeSet();
        if (this.isEmpty()) {
            rs.add(new Range(true, true));
        } else {
            if (!this.negInf) {
                rs.add(new Range(true, this.ranges[0] - 1L));
            }
            for (int i = 0; i < this.rangeCount - 1; ++i) {
                rs.add(this.ranges[i * 2 + 1] + 1L, this.ranges[i * 2 + 2] - 1L);
            }
            if (!this.posInf) {
                rs.add(new Range(this.ranges[(this.rangeCount - 1) * 2 + 1] + 1L, true));
            }
        }
        return rs;
    }

    public boolean contains(long i) {
        int pos = this.binarySearch(i);
        if (pos > 0) {
            return true;
        }
        return (pos = -(pos + 1)) % 2 != 0;
    }

    public boolean contains(Range r) {
        RangeSet rs = new RangeSet();
        rs.add(r);
        return this.intersect(rs).equals(rs);
    }

    public void add(RangeSet rs) {
        Iterator it = rs.iterator();
        while (it.hasNext()) {
            this.add((Range)it.next());
        }
    }

    public void add(Range r) {
        if (r.isMinNegInf()) {
            this.negInf = true;
        }
        if (r.isMaxPosInf()) {
            this.posInf = true;
        }
        this.add(r.getMin(), r.getMax());
    }

    public void add(long i) {
        this.add(i, i);
    }

    public void add(long min, long max) {
        int maxPos;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max");
        }
        if (this.rangeCount == 0) {
            this.insert(min, max, 0);
            return;
        }
        if (min != Long.MIN_VALUE && min - 1L > this.ranges[(this.rangeCount - 1) * 2 + 1]) {
            this.insert(min, max, this.rangeCount);
            return;
        }
        int minPos = this.getMinPos(min);
        if (minPos > (maxPos = this.getMaxPos(max))) {
            if (minPos % 2 == 0) {
                this.insert(min, max, minPos / 2);
            }
        } else {
            this.combine(min, max, minPos / 2, maxPos / 2);
        }
    }

    public void remove(RangeSet r) {
        Iterator it = r.iterator();
        while (it.hasNext()) {
            this.remove((Range)it.next());
        }
    }

    public void remove(Range r) {
        RangeSet rs = new RangeSet();
        rs.add(r);
        rs = this.intersect(rs.complement());
        this.ranges = rs.ranges;
        this.rangeCount = rs.rangeCount;
        this.posInf = rs.posInf;
        this.negInf = rs.negInf;
    }

    public void remove(long i) {
        this.remove(new Range(i, i));
    }

    public void remove(long min, long max) {
        this.remove(new Range(min, max));
    }

    public Iterator iterator() {
        ArrayList<Range> l = new ArrayList<Range>(this.rangeCount);
        for (int i = 0; i < this.rangeCount; ++i) {
            if (this.rangeCount == 1 && this.negInf && this.posInf) {
                l.add(new Range(true, true));
                continue;
            }
            if (i == 0 && this.negInf) {
                l.add(new Range(true, this.ranges[i * 2 + 1]));
                continue;
            }
            if (i == this.rangeCount - 1 && this.posInf) {
                l.add(new Range(this.ranges[i * 2], true));
                continue;
            }
            l.add(new Range(this.ranges[i * 2], this.ranges[i * 2 + 1]));
        }
        return l.iterator();
    }

    public long size() {
        if (this.negInf || this.posInf) {
            return -1L;
        }
        long result = 0L;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            result += ((Range)it.next()).size();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.rangeCount == 0;
    }

    public static RangeSet parse(String s) throws ParseException {
        RangeSet rs = new RangeSet();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            rs.add(Range.parse(st.nextToken()));
        }
        return rs;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.rangeCount * 2; ++i) {
            result = (int)((long)(91 * result) + this.ranges[i]);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangeSet) {
            RangeSet rs = (RangeSet)obj;
            if (this.negInf == rs.negInf && this.posInf == rs.posInf && this.rangeCount == rs.rangeCount && Util.arraysEqual(this.ranges, 0, rs.ranges, 0, this.rangeCount * 2)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public Object clone() {
        RangeSet rs = new RangeSet();
        rs.ranges = new long[this.ranges.length];
        System.arraycopy(this.ranges, 0, rs.ranges, 0, this.ranges.length);
        rs.rangeCount = this.rangeCount;
        rs.posInf = this.posInf;
        rs.negInf = this.negInf;
        return rs;
    }

    private void combine(long min, long max, int minRange, int maxRange) {
        this.ranges[minRange * 2] = Math.min(min, this.ranges[minRange * 2]);
        this.ranges[minRange * 2 + 1] = Math.max(max, this.ranges[maxRange * 2 + 1]);
        if (minRange != maxRange && maxRange != this.rangeCount - 1) {
            System.arraycopy(this.ranges, (maxRange + 1) * 2, this.ranges, (minRange + 1) * 2, (this.rangeCount - 1 - maxRange) * 2);
        }
        this.rangeCount -= maxRange - minRange;
    }

    private int getMinPos(long min) {
        int pos = this.binarySearch(min == Long.MIN_VALUE ? min : min - 1L);
        return pos >= 0 ? pos : -(pos + 1);
    }

    private int getMaxPos(long max) {
        int pos = this.binarySearch(max == Long.MAX_VALUE ? max : max + 1L);
        return pos >= 0 ? pos : -(pos + 1) - 1;
    }

    private int binarySearch(long key) {
        int low = 0;
        int high = this.rangeCount * 2 - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            long midVal = this.ranges[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void insert(long min, long max, int rangeNum) {
        if (this.ranges.length == this.rangeCount * 2) {
            long[] newRanges = new long[this.ranges.length * 2];
            System.arraycopy(this.ranges, 0, newRanges, 0, this.ranges.length);
            this.ranges = newRanges;
        }
        if (rangeNum != this.rangeCount) {
            System.arraycopy(this.ranges, rangeNum * 2, this.ranges, (rangeNum + 1) * 2, (this.rangeCount - rangeNum) * 2);
        }
        this.ranges[rangeNum * 2] = min;
        this.ranges[rangeNum * 2 + 1] = max;
        ++this.rangeCount;
    }

    public static final void main(String[] args) throws Exception {
        RangeSet rs = RangeSet.parse("5-10,15-20,25-30");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println(rs.toString());
            String s = br.readLine();
            if (s.charAt(0) == '~') {
                rs = rs.complement();
                continue;
            }
            if (s.charAt(0) == 'i') {
                rs = rs.intersect(RangeSet.parse(br.readLine()));
                continue;
            }
            rs.add(RangeSet.parse(s));
        }
    }
}

