/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import com.onionnetworks.util.Buffer;
import com.onionnetworks.util.FileIntegrity;
import com.onionnetworks.util.Util;

public class FileIntegrityImpl
implements FileIntegrity {
    private String algo;
    private Buffer fileHash;
    private Buffer[] blockHashes;
    private int blockSize;
    private int blockCount;
    private long fileSize;

    public FileIntegrityImpl(String algorithm, Buffer fileHash, Buffer[] blockHashes, long fileSize, int blockSize) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is null");
        }
        if (fileHash == null) {
            throw new NullPointerException("fileHash is null");
        }
        if (blockHashes == null) {
            throw new NullPointerException("blockHashes are null");
        }
        if (fileSize < 0L) {
            throw new IllegalArgumentException("fileSize < 0");
        }
        if (blockSize < 0) {
            throw new IllegalArgumentException("blockSize < 0");
        }
        this.algo = algorithm;
        this.fileHash = fileHash;
        this.blockHashes = blockHashes;
        this.fileSize = fileSize;
        this.blockSize = blockSize;
        this.blockCount = Util.divideCeil(fileSize, (long)blockSize);
        if (blockHashes.length != this.blockCount) {
            throw new IllegalArgumentException("Incorrect block hash count");
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public Buffer getBlockHash(int blockNum) {
        if (blockNum < 0 || blockNum >= this.blockCount) {
            throw new IllegalArgumentException("Invalide block #" + blockNum);
        }
        return this.blockHashes[blockNum];
    }

    @Override
    public Buffer getFileHash() {
        return this.fileHash;
    }
}

