/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.util.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.IoAdapter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import sun.nio.ch.FileChannelImpl;

public class NIOFileAdapter
extends IoAdapter {
    private int hits = 0;
    private int misses = 0;
    private int _pageSize;
    private FileChannel _channel;
    private MappedByteBuffer _page;
    private int _pageId;
    private long _position;
    private long _size;
    private boolean _dirty;
    private Map _id2Page;
    private LinkedList _lruPages;
    private int _lruLimit;
    private RandomAccessFile _file;

    public NIOFileAdapter(int pageSize, int lruLimit) {
        this._pageSize = pageSize;
        this._lruLimit = lruLimit;
    }

    private NIOFileAdapter(String filename, boolean lockFile, long initialLength, boolean readOnly, int pageSize, int lruLimit) throws Db4oIOException {
        this._pageSize = pageSize;
        try {
            this._file = new RandomAccessFile(filename, readOnly ? "r" : "rw");
            this._channel = this._file.getChannel();
            this._size = this._channel.size();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        this._page = null;
        this._pageId = 0;
        this._position = 0L;
        this._dirty = false;
        this._id2Page = new HashMap();
        this._lruPages = new LinkedList();
        this._lruLimit = lruLimit;
    }

    @Override
    public void seek(long position) throws Db4oIOException {
        this._position = position;
    }

    @Override
    public void close() throws Db4oIOException {
        for (MappedByteBuffer curpage : this._id2Page.values()) {
            this.closePage(curpage);
        }
        this._id2Page.clear();
        this._lruPages.clear();
        this._page = null;
        try {
            this._channel.close();
            this._file.close();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
    }

    @Override
    public void delete(String path) {
        new File(path).delete();
    }

    @Override
    public boolean exists(String path) {
        File existingFile = new File(path);
        return existingFile.exists() && existingFile.length() > 0L;
    }

    @Override
    public long getLength() throws Db4oIOException {
        return this._size;
    }

    @Override
    public int read(byte[] bytes, int length) throws Db4oIOException {
        if (length <= 0) {
            return 0;
        }
        int alreadyRead = 0;
        int stillToRead = length;
        while (stillToRead > 0) {
            this.forcePage();
            try {
                this._page.position(this.pageOffset(this._position));
            }
            catch (IllegalArgumentException exc) {
                return -1;
            }
            int hereToRead = (int)this.min(this._page.limit() - this._page.position(), stillToRead);
            if (hereToRead == 0) break;
            this._page.get(bytes, alreadyRead, hereToRead);
            stillToRead -= hereToRead;
            alreadyRead += hereToRead;
            this._position += (long)hereToRead;
        }
        return alreadyRead > 0 ? alreadyRead : -1;
    }

    @Override
    public void write(byte[] bytes, int length) throws Db4oIOException {
        if (length <= 0) {
            return;
        }
        if (this._position + (long)length > this._size) {
            this._size = this._position + (long)length;
        }
        int alreadyWritten = 0;
        int stillToWrite = length;
        while (stillToWrite > 0) {
            this.forcePage();
            int pageOffset = this.pageOffset(this._position);
            this._page.limit((int)this.min(this._pageSize, pageOffset + length));
            this._page.position(pageOffset);
            int hereToWrite = (int)this.min(this._page.capacity() - this._page.position(), stillToWrite);
            this._page.put(bytes, alreadyWritten, hereToWrite);
            stillToWrite -= hereToWrite;
            alreadyWritten += hereToWrite;
            this._position += (long)hereToWrite;
            this._dirty = true;
        }
    }

    @Override
    public void sync() throws Db4oIOException {
    }

    private void internalSync(MappedByteBuffer page) {
        if (this._dirty && page != null) {
            page.flip();
            page.force();
        }
    }

    public void unlock() {
    }

    public void lock() {
    }

    private MappedByteBuffer page(int pageId) throws Db4oIOException {
        MappedByteBuffer page;
        try {
            page = this._channel.map(FileChannel.MapMode.READ_WRITE, this.pagePosition(pageId), this._pageSize);
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        page.limit(this.pageSize(pageId));
        return page;
    }

    private long pagePosition(int pageId) {
        return (long)pageId * (long)this._pageSize;
    }

    private int pageSize(int pageId) throws Db4oIOException {
        long sizeLeft = this._size - this.pagePosition(pageId);
        return sizeLeft > (long)this._pageSize ? this._pageSize : (int)sizeLeft;
    }

    private void forcePage() throws Db4oIOException {
        int pageId = this.pageId(this._position);
        int pageOffset = this.pageOffset(this._position);
        Integer pageIdKey = new Integer(pageId);
        if (this._id2Page.containsKey(pageIdKey)) {
            this._lruPages.remove(pageIdKey);
            this._lruPages.addFirst(pageIdKey);
            this._page = (MappedByteBuffer)this._id2Page.get(pageIdKey);
            this._page.limit(this.pageSize(pageId));
            ++this.hits;
            return;
        }
        this.closePage();
        this.loadPage(pageId, pageOffset);
        if (this._lruPages.size() == this._lruLimit) {
            Integer dropPageKey = (Integer)this._lruPages.removeLast();
            MappedByteBuffer page = (MappedByteBuffer)this._id2Page.remove(dropPageKey);
            try {
                Method unmap = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
                unmap.setAccessible(true);
                unmap.invoke(null, page);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        Integer addedPageKey = new Integer(this._pageId);
        this._id2Page.put(addedPageKey, this._page);
        this._lruPages.addFirst(addedPageKey);
        this._dirty = false;
        ++this.misses;
    }

    private void closePage() throws Db4oIOException {
        this.closePage(this._page);
        this._page = null;
    }

    private void closePage(MappedByteBuffer page) throws Db4oIOException {
        if (page != null) {
            this.internalSync(page);
        }
    }

    private void loadPage(int pageId, int pageOffset) throws Db4oIOException {
        this._page = this.page(pageId);
        this._pageId = pageId;
        this._dirty = false;
    }

    private int pageId(long position) {
        return (int)(position / (long)this._pageSize);
    }

    private int pageOffset(long position) {
        return (int)(position % (long)this._pageSize);
    }

    private long min(long a, long b) {
        return a > b ? b : a;
    }

    @Override
    public IoAdapter open(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        return new NIOFileAdapter(path, lockFile, initialLength, readOnly, this._pageSize, this._lruLimit);
    }
}

