/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.tools;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Collection4;
import com.db4o.internal.Platform4;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Date;

public class Logger {
    private static final int MAXIMUM_OBJECTS = 20;
    private static final Class[] IGNORE = new Class[]{Class.class};
    private static int maximumDepth = Integer.MAX_VALUE;
    private static PrintStream out = System.out;
    private static String sp = " ";
    private static boolean silent;

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: java com.db4o.tools.Logger <database filename> <class>");
        } else if (!new File(args[0]).exists()) {
            System.out.println("A database file with the name '" + args[0] + "' does not exist.");
        } else {
            Configuration config = Db4o.newConfiguration();
            config.messageLevel(-1);
            ExtObjectContainer con = null;
            try {
                ObjectContainer c = Db4o.openFile(config, args[0]);
                if (c == null) {
                    throw new RuntimeException();
                }
                con = c.ext();
            }
            catch (Exception e) {
                System.out.println("The database file '" + args[0] + "' could not be opened.");
                e.printStackTrace();
                return;
            }
            if (args.length > 1) {
                StoredClass sc = con.storedClass(args[1]);
                if (sc == null) {
                    System.out.println("There is no stored class with the name '" + args[1] + "'.");
                } else {
                    long[] ids = sc.getIDs();
                    for (int i = 0; i < ids.length && i <= 20; ++i) {
                        Object obj = con.getByID(ids[i]);
                        con.activate(obj, Integer.MAX_VALUE);
                        Logger.log(con, obj);
                    }
                    Logger.msgCount(ids.length);
                }
            } else {
                ObjectSet set = con.queryByExample(null);
                int i = 0;
                while (set.hasNext()) {
                    Object obj = set.next();
                    con.activate(obj, Integer.MAX_VALUE);
                    Logger.log(con, obj);
                    if (++i <= 20) continue;
                    break;
                }
                Logger.msgCount(set.size());
            }
            con.close();
        }
    }

    public static void log(ObjectContainer container, Object obj) {
        if (obj == null) {
            Logger.log("[NULL]");
        } else {
            Logger.log(obj.getClass().getName());
            Logger.log(container, obj, 0, new Collection4());
        }
    }

    public static void log(Object obj) {
        Logger.log(null, obj);
    }

    public static void logAll(ObjectContainer container) {
        ObjectSet set = container.queryByExample(null);
        while (set.hasNext()) {
            Logger.log(container, set.next());
        }
    }

    public static void setOut(PrintStream ps) {
        out = ps;
    }

    public static void setMaximumDepth(int depth) {
        maximumDepth = depth;
    }

    private static void msgCount(int count) {
        System.out.println("\n\nLog complete.\nObjects: " + count);
        if (count > 20) {
            System.out.println("Displayed due to setting of " + Logger.class.getName() + "#MAXIMUM_OBJECTS: " + 20);
        }
    }

    private static void log(ObjectContainer a_container, Object a_object, int a_depth, Collection4 a_list) {
        if (a_list.contains(a_object) || a_depth > maximumDepth) {
            return;
        }
        Class<?> clazz = a_object.getClass();
        for (int i = 0; i < IGNORE.length; ++i) {
            if (!clazz.isAssignableFrom(IGNORE[i])) continue;
            return;
        }
        if (Platform4.isSimple(clazz)) {
            Logger.log(a_depth + 1, a_object.getClass().getName(), a_object.toString());
            return;
        }
        a_list.add(a_object);
        Class[] classes = Logger.getClassHierarchy(a_object);
        String spaces = "";
        for (int i = classes.length - 1; i >= 0; --i) {
            String className = spaces = spaces + sp;
            int pos = classes[i].getName().lastIndexOf(".");
            className = pos > 0 ? className + classes[i].getName().substring(pos) : className + classes[i].getName();
            if (classes[i] == Date.class) {
                String fieldName = className + ".getTime";
                Long obj = new Long(((Date)a_object).getTime());
                Logger.log(a_container, obj, fieldName, a_depth + 1, -1, a_list);
                continue;
            }
            Field[] fields = classes[i].getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                Platform4.setAccessible(fields[j]);
                String fieldName = className + "." + fields[j].getName();
                try {
                    Object obj = fields[j].get(a_object);
                    if (obj.getClass().isArray()) {
                        obj = Logger.normalizeNArray(obj);
                        int len = Array.getLength(obj);
                        for (int k = 0; k < len; ++k) {
                            Object element = Array.get(obj, k);
                            Logger.log(a_container, element, fieldName, a_depth + 1, k, a_list);
                        }
                        continue;
                    }
                    Logger.log(a_container, obj, fieldName, a_depth + 1, -1, a_list);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void log(ObjectContainer a_container, Object a_object, String a_fieldName, int a_depth, int a_arrayElement, Collection4 a_list) {
        String fieldName;
        if (a_depth > maximumDepth) {
            return;
        }
        String string = fieldName = a_arrayElement > -1 ? a_fieldName + sp + sp + a_arrayElement : a_fieldName;
        if (a_object != null) {
            if (a_container == null || a_container.ext().isStored(a_object)) {
                if (a_container == null || a_container.ext().isActive(a_object)) {
                    Logger.log(a_depth, fieldName, "");
                    Class<?> clazz = a_object.getClass();
                    boolean found = false;
                    if (Platform4.isSimple(clazz)) {
                        Logger.log(a_depth + 1, a_object.getClass().getName(), a_object.toString());
                        found = true;
                    }
                    if (!found) {
                        Logger.log(a_container, a_object, a_depth, a_list);
                    }
                } else {
                    Logger.log(a_depth, fieldName, "DEACTIVATED " + a_object.getClass().getName());
                }
                return;
            }
            Logger.log(a_depth, fieldName, a_object.toString());
        } else {
            Logger.log(a_depth, fieldName, "[NULL]");
        }
    }

    private static void log(String a_msg) {
        if (!silent) {
            out.println(a_msg);
        }
    }

    private static void log(int indent, String a_property, String a_value) {
        for (int i = 0; i < indent; ++i) {
            a_property = sp + sp + a_property;
        }
        Logger.log(a_property, a_value);
    }

    private static void log(String a_property, String a_value) {
        if (a_value == null) {
            a_value = "[NULL]";
        }
        Logger.log(a_property + ": " + a_value);
    }

    private static Class[] getClassHierarchy(Object a_object) {
        Class[] classes = new Class[]{a_object.getClass()};
        return Logger.getClassHierarchy(classes);
    }

    private static Class[] getClassHierarchy(Class[] a_classes) {
        Class clazz = a_classes[a_classes.length - 1].getSuperclass();
        if (clazz.equals(Object.class)) {
            return a_classes;
        }
        Class[] classes = new Class[a_classes.length + 1];
        System.arraycopy(a_classes, 0, classes, 0, a_classes.length);
        classes[a_classes.length] = clazz;
        return Logger.getClassHierarchy(classes);
    }

    private static Object normalizeNArray(Object a_object) {
        Object first;
        if (Array.getLength(a_object) > 0 && (first = Array.get(a_object, 0)) != null && first.getClass().isArray()) {
            int[] dim = Logger.arrayDimensions(a_object);
            Object[] all = new Object[Logger.arrayElementCount(dim)];
            Logger.normalizeNArray1(a_object, all, 0, dim, 0);
            return all;
        }
        return a_object;
    }

    private static int normalizeNArray1(Object a_object, Object a_all, int a_next, int[] a_dim, int a_index) {
        if (a_index == a_dim.length - 1) {
            for (int i = 0; i < a_dim[a_index]; ++i) {
                Array.set(a_all, a_next++, Array.get(a_object, i));
            }
        } else {
            for (int i = 0; i < a_dim[a_index]; ++i) {
                a_next = Logger.normalizeNArray1(Array.get(a_object, i), a_all, a_next, a_dim, a_index + 1);
            }
        }
        return a_next;
    }

    private static int[] arrayDimensions(Object a_object) {
        int count = 0;
        Class<?> clazz = a_object.getClass();
        while (clazz.isArray()) {
            ++count;
            clazz = clazz.getComponentType();
        }
        int[] dim = new int[count];
        for (int i = 0; i < count; ++i) {
            dim[i] = Array.getLength(a_object);
            a_object = Array.get(a_object, 0);
        }
        return dim;
    }

    private static int arrayElementCount(int[] a_dim) {
        int elements = a_dim[0];
        for (int i = 1; i < a_dim.length; ++i) {
            elements *= a_dim[i];
        }
        return elements;
    }

    private Logger() {
    }
}

