/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.slots.Pointer4;

public class MsgObject
extends MsgD {
    private static final int LENGTH_FOR_ALL = 12;
    private static final int LENGTH_FOR_FIRST = 12;
    private int _id;
    private int _address;

    final MsgD getWriter(Transaction trans, Pointer4 pointer, ByteArrayBuffer buffer, int[] prependInts) {
        int lengthNeeded = buffer.length() + 12;
        if (prependInts != null) {
            lengthNeeded += prependInts.length * 4;
        }
        MsgD message = this.getWriterForLength(trans, lengthNeeded);
        if (prependInts != null) {
            for (int i = 0; i < prependInts.length; ++i) {
                message._payLoad.writeInt(prependInts[i]);
            }
        }
        this.appendPayLoad(message._payLoad, pointer, buffer);
        return message;
    }

    private void appendPayLoad(StatefulBuffer target, Pointer4 pointer, ByteArrayBuffer payLoad) {
        target.writeInt(payLoad.length());
        target.writeInt(pointer.id());
        target.writeInt(pointer.address());
        target.append(payLoad._buffer);
    }

    @Override
    public final MsgD getWriter(StatefulBuffer buffer) {
        return this.getWriter(buffer.transaction(), buffer.pointer(), buffer, null);
    }

    public final MsgD getWriter(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, ByteArrayBuffer buffer) {
        if (classMetadata == null) {
            return this.getWriter(trans, pointer, buffer, new int[]{0});
        }
        return this.getWriter(trans, pointer, buffer, new int[]{classMetadata.getID()});
    }

    public final MsgD getWriter(Transaction trans, Pointer4 pointer, ClassMetadata classMetadata, int param, ByteArrayBuffer buffer) {
        return this.getWriter(trans, pointer, buffer, new int[]{classMetadata.getID(), param});
    }

    public final StatefulBuffer unmarshall() {
        return this.unmarshall(0);
    }

    public final StatefulBuffer unmarshall(int addLengthBeforeFirst) {
        this._payLoad.setTransaction(this.transaction());
        int length = this._payLoad.readInt();
        if (length == 0) {
            return null;
        }
        this._id = this._payLoad.readInt();
        this._address = this._payLoad.readInt();
        this._payLoad.removeFirstBytes(12 + addLengthBeforeFirst);
        this._payLoad.useSlot(this._id, this._address, length);
        return this._payLoad;
    }

    public int getId() {
        return this._id;
    }
}

