/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.P2Collections;
import com.db4o.config.ObjectTranslator;
import com.db4o.config.TCollection;
import com.db4o.config.THashtable;
import com.db4o.config.TMap;
import com.db4o.config.TSerializable;
import com.db4o.config.TTreeMap;
import com.db4o.config.TTreeSet;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ActiveObjectReference;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.JDKReflect;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceQueue4;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandlerConfigurationJDK_1_2;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.net.NetDateTime;
import com.db4o.internal.handlers.net.NetDecimal;
import com.db4o.internal.handlers.net.NetSByte;
import com.db4o.internal.handlers.net.NetUInt;
import com.db4o.internal.handlers.net.NetULong;
import com.db4o.internal.handlers.net.NetUShort;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.types.Db4oCollections;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class JDK_1_2
extends JDKReflect {
    JDK_1_2() {
    }

    @Override
    public Class loadClass(String className, Object loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return Class.forName(className, false, (ClassLoader)loader);
    }

    public static void link() {
        new TCollection();
        new TMap();
        new TSerializable();
        new TTreeMap();
        new TTreeSet();
    }

    @Override
    Db4oCollections collections(Transaction transaction) {
        return new P2Collections(transaction);
    }

    @Override
    Object createReferenceQueue() {
        return new ReferenceQueue4();
    }

    @Override
    public Object createWeakReference(Object obj) {
        return new WeakReference<Object>(obj);
    }

    @Override
    Object createActivateObjectReference(Object a_queue, ObjectReference a_yapObject, Object a_object) {
        return new ActiveObjectReference(a_queue, a_yapObject, a_object);
    }

    @Override
    public void extendConfiguration(Config4Impl config) {
        new TypeHandlerConfigurationJDK_1_2(config).apply();
    }

    @Override
    void forEachCollectionElement(Object a_object, Visitor4 a_visitor) {
        Iterator<Object> i = null;
        if (a_object instanceof Collection) {
            i = ((Collection)a_object).iterator();
        } else if (a_object instanceof Map) {
            i = ((Map)a_object).keySet().iterator();
        }
        if (i != null) {
            while (i.hasNext()) {
                a_visitor.visit(i.next());
            }
        }
    }

    @Override
    Object getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    Object getYapRefObject(Object a_object) {
        if (a_object instanceof ActiveObjectReference) {
            return ((ActiveObjectReference)a_object).get();
        }
        return a_object;
    }

    @Override
    boolean isCollectionTranslator(Config4Class config) {
        ObjectTranslator ot;
        if (config != null && (ot = config.getTranslator()) != null) {
            return ot instanceof TCollection || ot instanceof TMap || ot instanceof THashtable;
        }
        return false;
    }

    @Override
    public int ver() {
        return 2;
    }

    @Override
    void killYapRef(Object obj) {
        if (obj instanceof ActiveObjectReference) {
            ((ActiveObjectReference)obj)._referent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void pollReferenceQueue(ObjectContainerBase container, Object referenceQueue) {
        if (referenceQueue != null) {
            ReferenceQueue4 queue = (ReferenceQueue4)referenceQueue;
            Object object = container.lock();
            synchronized (object) {
                ActiveObjectReference ref;
                while ((ref = queue.yapPoll()) != null) {
                    container.removeFromAllReferenceSystems(ref._referent);
                }
            }
        }
    }

    @Override
    public void registerCollections(GenericReflector reflector) {
        reflector.registerCollection(Collection.class);
        reflector.registerCollection(Map.class);
        reflector.registerCollectionUpdateDepth(Map.class, 3);
    }

    @Override
    void setAccessible(Object a_accessible) {
        try {
            ((AccessibleObject)a_accessible).setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public NetTypeHandler[] netTypes(Reflector reflector) {
        return new NetTypeHandler[]{new NetDateTime(reflector), new NetDecimal(reflector), new NetSByte(reflector), new NetUInt(reflector), new NetULong(reflector), new NetUShort(reflector)};
    }

    @Override
    public Object weakReferenceTarget(Object weakRef) {
        if (weakRef instanceof WeakReference) {
            return ((WeakReference)weakRef).get();
        }
        return weakRef;
    }
}

