/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.collections.AbstractList4;
import java.util.Collection;
import java.util.ConcurrentModificationException;

public class SubArrayList4<E>
extends AbstractList4<E> {
    private AbstractList4<E> _delegate;
    private int _fromIndex;
    private int _size;

    public SubArrayList4(AbstractList4<E> delegate, int fromIndex, int toIndex) {
        this._delegate = delegate;
        this._fromIndex = fromIndex;
        this.syncModCount();
        this.setSize(toIndex - fromIndex);
    }

    @Override
    public void add(int index, E element) {
        this.checkIndex(index, 0, this.size());
        this.checkConcurrentModification();
        this._delegate.add(this.translatedIndex(index), element);
        this.increaseSize(1);
        this.syncModCount();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        this.checkIndex(index, 0, this.size());
        this.checkConcurrentModification();
        boolean changed = this._delegate.addAll(this.translatedIndex(index), collection);
        this.increaseSize(collection.size());
        this.syncModCount();
        return changed;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index, 0, this.size() - 1);
        this.checkConcurrentModification();
        return this._delegate.get(this.translatedIndex(index));
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index, 0, this.size() - 1);
        this.checkConcurrentModification();
        E removed = this._delegate.remove(this.translatedIndex(index));
        this.decreaseSize(1);
        this.syncModCount();
        return removed;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= this.size() || toIndex > this.size() || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        this._delegate.removeRange(fromIndex + this._fromIndex, toIndex + this._fromIndex);
        this.decreaseSize(toIndex - fromIndex);
        this.syncModCount();
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index, 0, this.size() - 1);
        this.checkConcurrentModification();
        E replaced = this._delegate.set(this.translatedIndex(index), element);
        this.syncModCount();
        return replaced;
    }

    @Override
    public int size() {
        return this._size;
    }

    private void checkConcurrentModification() {
        if (this.modCount != this._delegate.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void syncModCount() {
        this.modCount = this._delegate.modCount;
    }

    private int translatedIndex(int index) {
        return index + this._fromIndex;
    }

    private void setSize(int count) {
        this._size = count;
    }

    private void increaseSize(int count) {
        this._size += count;
    }

    private void decreaseSize(int count) {
        this._size -= count;
    }
}

