/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PooledFileRandomAccessBuffer;
import java.io.File;
import java.io.IOException;
import java.util.Random;

public class PooledFileRandomAccessBufferFactory
implements LockableRandomAccessBufferFactory {
    private final FilenameGenerator fg;
    private final Random seedRandom;
    private volatile boolean enableCrypto;

    public PooledFileRandomAccessBufferFactory(FilenameGenerator filenameGenerator, Random seedRandom) {
        this.fg = filenameGenerator;
        this.seedRandom = seedRandom;
    }

    public void enableCrypto(boolean enable) {
        this.enableCrypto = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer makeRAF(long size) throws IOException {
        long id = this.fg.makeRandomFilename();
        File file = this.fg.getFilename(id);
        PooledFileRandomAccessBuffer ret = null;
        try {
            PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = ret = new PooledFileRandomAccessBuffer(file, false, size, this.enableCrypto ? this.seedRandom : null, id, true);
            return pooledFileRandomAccessBuffer;
        }
        finally {
            if (ret == null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer makeRAF(byte[] initialContents, int offset, int size, boolean readOnly) throws IOException {
        long id = this.fg.makeRandomFilename();
        File file = this.fg.getFilename(id);
        PooledFileRandomAccessBuffer ret = null;
        try {
            PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = ret = new PooledFileRandomAccessBuffer(file, "rw", initialContents, offset, size, id, true, readOnly);
            return pooledFileRandomAccessBuffer;
        }
        finally {
            if (ret == null) {
                file.delete();
            }
        }
    }
}

