/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.io.DiskSpaceChecker;
import freenet.support.io.InsufficientDiskSpaceException;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DiskSpaceCheckingOutputStream
extends FilterOutputStream {
    private final File file;
    private final DiskSpaceChecker checker;
    private final int bufferSize;
    private long written;
    private long lastChecked;

    public DiskSpaceCheckingOutputStream(OutputStream out, DiskSpaceChecker checker, File file, int bufferSize) {
        super(out);
        this.checker = checker;
        this.file = file;
        this.bufferSize = bufferSize;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i});
    }

    @Override
    public synchronized void write(byte[] buf, int offset, int length) throws IOException {
        if (this.written + (long)length - this.lastChecked >= (long)this.bufferSize) {
            if (!this.checker.checkDiskSpace(this.file, length, this.bufferSize)) {
                throw new InsufficientDiskSpaceException();
            }
            this.lastChecked = this.written;
        }
        this.out.write(buf, offset, length);
        this.written += (long)length;
    }
}

