/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.DelayedFree;
import freenet.support.io.DelayedFreeRandomAccessBuffer;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class DelayedFreeRandomAccessBucket
implements Bucket,
Serializable,
RandomAccessBucket,
DelayedFree {
    private static final long serialVersionUID = 1L;
    private transient PersistentFileTracker factory;
    private final RandomAccessBucket bucket;
    private boolean freed;
    private transient long createdCommitID;
    private static volatile boolean logMINOR;
    static final int MAGIC = -1567675859;
    static final int VERSION = 1;

    @Override
    public boolean toFree() {
        return this.freed;
    }

    public DelayedFreeRandomAccessBucket(PersistentFileTracker factory, RandomAccessBucket bucket) {
        this.factory = factory;
        this.bucket = bucket;
        this.createdCommitID = factory.commitID();
        if (bucket == null) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        DelayedFreeRandomAccessBucket delayedFreeRandomAccessBucket = this;
        synchronized (delayedFreeRandomAccessBucket) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        return this.bucket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        DelayedFreeRandomAccessBucket delayedFreeRandomAccessBucket = this;
        synchronized (delayedFreeRandomAccessBucket) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        return this.bucket.getOutputStreamUnbuffered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        DelayedFreeRandomAccessBucket delayedFreeRandomAccessBucket = this;
        synchronized (delayedFreeRandomAccessBucket) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        return this.bucket.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        DelayedFreeRandomAccessBucket delayedFreeRandomAccessBucket = this;
        synchronized (delayedFreeRandomAccessBucket) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        return this.bucket.getInputStreamUnbuffered();
    }

    @Override
    public String getName() {
        return this.bucket.getName();
    }

    @Override
    public long size() {
        return this.bucket.size();
    }

    @Override
    public boolean isReadOnly() {
        return this.bucket.isReadOnly();
    }

    @Override
    public void setReadOnly() {
        this.bucket.setReadOnly();
    }

    public synchronized Bucket getUnderlying() {
        if (this.freed) {
            return null;
        }
        return this.bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        DelayedFreeRandomAccessBucket delayedFreeRandomAccessBucket = this;
        synchronized (delayedFreeRandomAccessBucket) {
            if (this.freed) {
                return;
            }
            this.freed = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Freeing " + this + " underlying=" + this.bucket, (Throwable)new Exception("debug"));
        }
        this.factory.delayedFree(this, this.createdCommitID);
    }

    public String toString() {
        return super.toString() + ":" + this.bucket;
    }

    @Override
    public RandomAccessBucket createShadow() {
        return this.bucket.createShadow();
    }

    @Override
    public void realFree() {
        this.bucket.free();
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.factory = context.persistentBucketFactory;
        this.bucket.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-1567675859);
        dos.writeInt(1);
        this.bucket.storeTo(dos);
    }

    protected DelayedFreeRandomAccessBucket(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws StorageFormatException, IOException, ResumeFailedException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.bucket = (RandomAccessBucket)BucketTools.restoreFrom(dis, fg, persistentFileTracker, masterKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() throws IOException {
        DelayedFreeRandomAccessBucket delayedFreeRandomAccessBucket = this;
        synchronized (delayedFreeRandomAccessBucket) {
            if (this.freed) {
                throw new IOException("Already freed");
            }
        }
        this.setReadOnly();
        return new DelayedFreeRandomAccessBuffer(this.bucket.toRandomAccessBuffer(), this.factory);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

