/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.compress.CompressJob;
import freenet.support.io.NativeThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;

public class RealCompressor {
    private final ExecutorService executorService = Executors.newFixedThreadPool(RealCompressor.getMaxRunningCompressionThreads(), new CompressorThreadFactory());
    private ClientContext context;
    private static volatile boolean logMINOR;

    public void setClientContext(ClientContext context) {
        this.context = context;
    }

    public void enqueueNewJob(final CompressJob j) {
        if (logMINOR) {
            Logger.minor(this, "Enqueueing compression job: " + j);
        }
        Future<String> task = null;
        while (!this.executorService.isShutdown() && task == null) {
            try {
                task = this.executorService.submit(new PrioRunnable(){

                    @Override
                    public void run() {
                        Logger.OSThread.logPID(this);
                        try {
                            try {
                                j.tryCompress(RealCompressor.this.context);
                            }
                            catch (InsertException e) {
                                j.onFailure(e, null, RealCompressor.this.context);
                            }
                            catch (Throwable t) {
                                Logger.error(this, "Caught in OffThreadCompressor: " + t, t);
                                System.err.println("Caught in OffThreadCompressor: " + t);
                                t.printStackTrace();
                                j.onFailure(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, t, null), null, RealCompressor.this.context);
                            }
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught " + t + " in " + this, t);
                        }
                    }

                    @Override
                    public int getPriority() {
                        return NativeThread.MIN_PRIORITY;
                    }
                }, "Compressor thread for " + j);
                if (!logMINOR) continue;
                Logger.minor(this, "Compression job: " + j + "has been enqueued.");
            }
            catch (RejectedExecutionException e) {
                Logger.error(this, "RejectedExectutionException for " + j, (Throwable)e);
                task = null;
            }
        }
    }

    private static int getMaxRunningCompressionThreads() {
        int maxRunningThreads = 1;
        String osName = System.getProperty("os.name");
        if (!osName.contains("Windows") && osName.toLowerCase().indexOf("mac os x") > 0 || !NativeThread.usingNativeCode()) {
            maxRunningThreads = 1;
        } else {
            Runtime r = Runtime.getRuntime();
            int max = r.availableProcessors();
            long maxMemory = r.maxMemory();
            max = maxMemory < 0x8000000L ? 1 : Math.min(max, (int)Math.min(Integer.MAX_VALUE, maxMemory / 0x8000000L));
            maxRunningThreads = max;
        }
        Logger.minor(RealCompressor.class, "Maximum Compressor threads: " + maxRunningThreads);
        return maxRunningThreads;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    static {
        Logger.registerClass(RealCompressor.class);
    }

    public static class CompressorThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            return new NativeThread(r, "Compressor thread", NativeThread.MIN_PRIORITY, true);
        }
    }
}

