/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.FetchResult;
import freenet.client.async.USKRetriever;
import freenet.client.async.USKRetrieverCallback;
import freenet.crypt.BlockCipher;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.ECDSA;
import freenet.crypt.Global;
import freenet.crypt.HMAC;
import freenet.crypt.KeyAgreementSchemeContext;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.AddressTracker;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.SocketHandler;
import freenet.io.xfer.PacketThrottle;
import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.USK;
import freenet.node.BasePeerNode;
import freenet.node.BlockedTooLongException;
import freenet.node.DarknetPeerNode;
import freenet.node.DecodingMessageGroup;
import freenet.node.FNPPacketMangler;
import freenet.node.FSParseException;
import freenet.node.Location;
import freenet.node.MessageItem;
import freenet.node.NewPacketFormat;
import freenet.node.NewPacketFormatKeyContext;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.NodePinger;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PacketFormat;
import freenet.node.PeerLocation;
import freenet.node.PeerManager;
import freenet.node.PeerMessageQueue;
import freenet.node.PeerNodeBackoffStatusChecker;
import freenet.node.PeerNodeStatus;
import freenet.node.PeerNodeUnlocked;
import freenet.node.PeerTooOldException;
import freenet.node.RequestTag;
import freenet.node.SeedServerPeerNode;
import freenet.node.SessionKey;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.UIDTag;
import freenet.node.Version;
import freenet.node.VersionParseException;
import freenet.support.Base64;
import freenet.support.BooleanLastTrueTracker;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.WeakHashSet;
import freenet.support.math.MersenneTwister;
import freenet.support.math.RunningAverage;
import freenet.support.math.SimpleRunningAverage;
import freenet.support.math.TimeDecayingRunningAverage;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.IPUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class PeerNode
implements USKRetrieverCallback,
BasePeerNode,
PeerNodeUnlocked {
    private String lastGoodVersion;
    protected boolean unroutableOlderVersion;
    protected boolean unroutableNewerVersion;
    protected boolean disableRouting;
    protected boolean disableRoutingHasBeenSetLocally;
    protected boolean disableRoutingHasBeenSetRemotely;
    private byte[] jfkBuffer;
    protected byte[] jfkKa;
    protected byte[] incommingKey;
    protected byte[] jfkKe;
    protected byte[] outgoingKey;
    protected byte[] jfkMyRef;
    protected byte[] hmacKey;
    protected byte[] ivKey;
    protected byte[] ivNonce;
    protected int ourInitialSeqNum;
    protected int theirInitialSeqNum;
    protected int ourInitialMsgID;
    protected int theirInitialMsgID;
    protected long jfkContextLifetime;
    private Peer detectedPeer;
    private final OutgoingPacketMangler outgoingMangler;
    protected List<Peer> nominalPeer;
    private Peer remoteDetectedPeer;
    public final boolean testnetEnabled;
    private SessionKey currentTracker;
    private SessionKey previousTracker;
    private long timeLastRekeyed;
    private long totalBytesExchangedWithCurrentTracker;
    private boolean isRekeying;
    private SessionKey unverifiedTracker;
    private long timeLastSentPacket;
    private long timeLastReceivedPacket;
    private long timeLastReceivedDataPacket;
    private long timeLastReceivedAck;
    private long timeLastRoutable;
    private long timeAddedOrRestarted;
    private long countSelectionsSinceConnected;
    public static final long SELECTION_SAMPLING_PERIOD = TimeUnit.MINUTES.toMillis(5L);
    public static final int SELECTION_PERCENTAGE_WARNING = 30;
    public static final int SELECTION_MIN_PEERS = 5;
    public static final int SELECTION_MAX_SAMPLES = (int)(10L * TimeUnit.SECONDS.convert(SELECTION_SAMPLING_PERIOD, TimeUnit.MILLISECONDS));
    private final BooleanLastTrueTracker isConnected;
    private boolean isRoutable;
    private boolean wasDisconnected;
    private boolean removed;
    private USKRetriever arkFetcher;
    private USK myARK;
    private int handshakeCount;
    private static final int MAX_HANDSHAKE_COUNT = 2;
    final PeerLocation location;
    final byte[] identity;
    final String identityAsBase64String;
    final byte[] identityHash;
    final byte[] identityHashHash;
    final long swapIdentifier;
    int[] negTypes;
    final int hashCode;
    final Node node;
    final PeerManager peers;
    private final PeerMessageQueue messageQueue;
    private long timeLastReceivedSwapRequest;
    private final RunningAverage swapRequestsInterval;
    private long timeLastReceivedProbeRequest;
    private final RunningAverage probeRequestsInterval;
    final boolean decrementHTLAtMaximum;
    final boolean decrementHTLAtMinimum;
    protected long sendHandshakeTime;
    private String version;
    private long totalInputSinceStartup;
    private long totalOutputSinceStartup;
    public final ECPublicKey peerECDSAPubKey;
    public final byte[] peerECDSAPubKeyHash;
    private boolean isSignatureVerificationSuccessfull;
    final byte[] incomingSetupKey;
    final byte[] outgoingSetupKey;
    final BlockCipher incomingSetupCipher;
    final BlockCipher outgoingSetupCipher;
    final BlockCipher anonymousInitiatorSetupCipher;
    private KeyAgreementSchemeContext ctx;
    private final AtomicLong bootID;
    private long myBootID;
    private long myLastSuccessfulBootID;
    private boolean bogusNoderef;
    private long connectedTime;
    public int peerNodeStatus;
    static final long CHECK_FOR_SWAPPED_TRACKERS_INTERVAL = FNPPacketMangler.SESSION_KEY_REKEYING_INTERVAL / 30L;
    static final byte[] TEST_AS_BYTES;
    private final Hashtable<String, Long> localNodeSentMessageTypes;
    private final Hashtable<String, Long> localNodeReceivedMessageTypes;
    private Peer[] handshakeIPs;
    private long lastAttemptedHandshakeIPUpdateTime;
    protected boolean neverConnected;
    protected long peerAddedTime;
    private TimeDecayingRunningAverage pRejected;
    private final long bytesInAtStartup;
    private final long bytesOutAtStartup;
    private long hadRoutableConnectionCount;
    private long routableConnectionCheckCount;
    private long clockDelta;
    private byte uptime;
    private static final long MAX_CLOCK_DELTA;
    private static final long CLEAR_MESSAGE_QUEUE_AFTER;
    final WeakReference<PeerNode> myRef;
    private boolean disconnecting;
    long timeLastDisconnect;
    long timePrevDisconnect;
    private boolean isBursting;
    private int listeningHandshakeBurstCount;
    private int listeningHandshakeBurstSize;
    private Set<PeerManager.PeerStatusChangeListener> listeners;
    protected final NodeCrypto crypto;
    public static final long BLACK_MAGIC_BACKOFF_PRUNING_TIME;
    public static final double BLACK_MAGIC_BACKOFF_PRUNING_PERCENTAGE = 0.9;
    protected final LinkedList<byte[]> jfkNoncesSent;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private PacketFormat packetFormat;
    MersenneTwister paddingGen;
    protected SimpleFieldSet fullFieldSet;
    boolean firstHandshake;
    private boolean burstNow;
    private long timeSetBurstNow;
    static final long UPDATE_BURST_NOW_PERIOD;
    static final int P_BURST_IF_DEFINITELY_FORWARDED = 20;
    private String shortToString;
    private final Object arkFetcherSync;
    boolean sentInitialMessages;
    private int simpleVersion;
    long routingBackedOffUntilRT;
    long routingBackedOffUntilBulk;
    static final int INITIAL_ROUTING_BACKOFF_LENGTH;
    static final int BACKOFF_MULTIPLIER = 2;
    static final int MAX_ROUTING_BACKOFF_LENGTH;
    long transferBackedOffUntilRT;
    long transferBackedOffUntilBulk;
    static final int INITIAL_TRANSFER_BACKOFF_LENGTH;
    static final int TRANSFER_BACKOFF_MULTIPLIER = 2;
    static final int MAX_TRANSFER_BACKOFF_LENGTH;
    int transferBackoffLengthRT;
    int transferBackoffLengthBulk;
    int routingBackoffLengthRT;
    int routingBackoffLengthBulk;
    String lastRoutingBackoffReasonRT;
    String lastRoutingBackoffReasonBulk;
    String previousRoutingBackoffReasonRT;
    String previousRoutingBackoffReasonBulk;
    public final RunningAverage backedOffPercent;
    public final RunningAverage backedOffPercentRT;
    public final RunningAverage backedOffPercentBulk;
    private long lastSampleTime;
    long mandatoryBackoffUntilRT;
    int mandatoryBackoffLengthRT;
    long mandatoryBackoffUntilBulk;
    int mandatoryBackoffLengthBulk;
    static final int INITIAL_MANDATORY_BACKOFF_LENGTH;
    static final int MANDATORY_BACKOFF_MULTIPLIER = 2;
    static final int MAX_MANDATORY_BACKOFF_LENGTH;
    Object pingSync;
    static final int MAX_PINGS = 5;
    long pingNumber;
    private final RunningAverage pingAverage;
    private boolean reportedRTT;
    private double SRTT;
    private double RTTVAR;
    private double RTO;
    private final Runnable checkStatusAfterBackoff;
    private final PacketThrottle _lastThrottle;
    static final int MAX_SIMULTANEOUS_ANNOUNCEMENTS = 1;
    static final int MAX_ANNOUNCE_DELAY = 1000;
    private long timeLastAcceptedAnnouncement;
    private long[] runningAnnounceUIDs;
    private int handshakeIPAlternator;
    static final long MAX_RTO;
    static final long MIN_RTO;
    private int consecutiveRTOBackoffs;
    private static final int CLOCK_GRANULARITY = 20;
    static final int MAX_CONSECUTIVE_RTO_BACKOFFS = 5;
    private long resendBytesSent;
    public final ByteCounter resendByteCounter;
    private volatile long offeredMainJarVersion;
    private long lastFailedRevocationTransfer;
    private int countFailedRevocationTransfers;
    private final Object routedToLock;
    final LoadSender loadSenderRealTime;
    final LoadSender loadSenderBulk;
    OutputLoadTracker outputLoadTrackerRealTime;
    OutputLoadTracker outputLoadTrackerBulk;
    private static final NodeStats.RequestType[] RequestType_values;
    protected boolean sendingUOMMainJar;
    protected boolean sendingUOMLegacyExtJar;
    private int uomCount;
    private long lastSentUOM;
    private long lastIncomingRekey;
    static final long THROTTLE_REKEY = 1000L;
    private int consecutiveGuaranteedRejectsRT;
    private int consecutiveGuaranteedRejectsBulk;
    private static final int CONSECUTIVE_REJECTS_MANDATORY_BACKOFF = 5;

    protected boolean ignoreLastGoodVersion() {
        return false;
    }

    public PeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, boolean fromLocal) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        block55: {
            int i;
            String identityString;
            byte[] pub;
            this.jfkContextLifetime = 0L;
            this.totalBytesExchangedWithCurrentTracker = 0L;
            this.isRekeying = false;
            this.countSelectionsSinceConnected = 0L;
            this.wasDisconnected = true;
            this.peerNodeStatus = 5;
            this.localNodeSentMessageTypes = new Hashtable();
            this.localNodeReceivedMessageTypes = new Hashtable();
            this.peerAddedTime = 1L;
            this.listeners = Collections.synchronizedSet(new WeakHashSet());
            this.jfkNoncesSent = new LinkedList();
            this.firstHandshake = true;
            this.arkFetcherSync = new Object();
            this.routingBackedOffUntilRT = -1L;
            this.routingBackedOffUntilBulk = -1L;
            this.transferBackedOffUntilRT = -1L;
            this.transferBackedOffUntilBulk = -1L;
            this.transferBackoffLengthRT = INITIAL_TRANSFER_BACKOFF_LENGTH;
            this.transferBackoffLengthBulk = INITIAL_TRANSFER_BACKOFF_LENGTH;
            this.routingBackoffLengthRT = INITIAL_ROUTING_BACKOFF_LENGTH;
            this.routingBackoffLengthBulk = INITIAL_ROUTING_BACKOFF_LENGTH;
            this.lastSampleTime = Long.MAX_VALUE;
            this.mandatoryBackoffUntilRT = -1L;
            this.mandatoryBackoffLengthRT = INITIAL_MANDATORY_BACKOFF_LENGTH;
            this.mandatoryBackoffUntilBulk = -1L;
            this.mandatoryBackoffLengthBulk = INITIAL_MANDATORY_BACKOFF_LENGTH;
            this.pingSync = new Object();
            this.SRTT = 1000.0;
            this.RTTVAR = 0.0;
            this.RTO = 1000.0;
            this._lastThrottle = new PacketThrottle(1024);
            this.runningAnnounceUIDs = new long[0];
            this.resendByteCounter = new ByteCounter(){

                @Override
                public void receivedBytes(int x) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sentBytes(int x) {
                    PeerNode peerNode = PeerNode.this;
                    synchronized (peerNode) {
                        PeerNode.this.resendBytesSent += x;
                    }
                    PeerNode.this.node.nodeStats.resendByteCounter.sentBytes(x);
                }

                @Override
                public void sentPayload(int x) {
                }
            };
            this.routedToLock = new Object();
            this.loadSenderRealTime = new LoadSender(true);
            this.loadSenderBulk = new LoadSender(false);
            this.outputLoadTrackerRealTime = new OutputLoadTracker(true);
            this.outputLoadTrackerBulk = new OutputLoadTracker(false);
            this.consecutiveGuaranteedRejectsRT = 0;
            this.consecutiveGuaranteedRejectsBulk = 0;
            boolean noSig = false;
            if (fromLocal || this.fromAnonymousInitiator()) {
                noSig = true;
            }
            this.myRef = new WeakReference<PeerNode>(this);
            this.checkStatusAfterBackoff = new PeerNodeBackoffStatusChecker(this.myRef);
            this.outgoingMangler = crypto.packetMangler;
            this.node = node2;
            this.crypto = crypto;
            assert (crypto.isOpennet == this.isOpennetForNoderef());
            this.peers = this.node.peers;
            this.backedOffPercent = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, this.node);
            this.backedOffPercentRT = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, this.node);
            this.backedOffPercentBulk = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, this.node);
            this.myBootID = node2.bootID;
            this.bootID = new AtomicLong();
            this.version = fs.get("version");
            Version.seenVersion(this.version);
            try {
                this.simpleVersion = Version.getArbitraryBuildNumber(this.version);
            }
            catch (VersionParseException e2) {
                throw new FSParseException("Invalid version " + this.version + " : " + e2);
            }
            String locationString = fs.get("location");
            this.location = new PeerLocation(locationString);
            this.disableRoutingHasBeenSetLocally = false;
            this.disableRouting = false;
            this.disableRoutingHasBeenSetRemotely = false;
            this.lastGoodVersion = fs.get("lastGoodVersion");
            this.updateVersionRoutablity();
            this.testnetEnabled = fs.getBoolean("testnet", false);
            if (this.testnetEnabled) {
                String err = "Ignoring incompatible testnet node " + this.detectedPeer;
                Logger.error(this, err);
                throw new PeerParseException(err);
            }
            this.negTypes = fs.getIntArray("auth.negTypes");
            if (this.negTypes == null || this.negTypes.length == 0) {
                if (this.fromAnonymousInitiator()) {
                    this.negTypes = this.outgoingMangler.supportedNegTypes(false);
                } else {
                    throw new FSParseException("No negTypes!");
                }
            }
            if (fs.getBoolean("opennet", false) != this.isOpennetForNoderef()) {
                throw new FSParseException("Trying to parse a darknet peer as opennet or an opennet peer as darknet isOpennet=" + this.isOpennetForNoderef() + " boolean = " + fs.getBoolean("opennet", false) + " string = \"" + fs.get("opennet") + "\"");
            }
            SimpleFieldSet sfs = fs.subset("ecdsa.P256");
            if (sfs == null) {
                GregorianCalendar gc = new GregorianCalendar(2013, 6, 20);
                gc.setTimeZone(TimeZone.getTimeZone("GMT"));
                throw new PeerTooOldException("No ECC support", 1449, gc.getTime());
            }
            try {
                pub = Base64.decode(sfs.get("pub"));
            }
            catch (IllegalBase64Exception e) {
                Logger.error(this, "Caught " + e + " parsing ECC pubkey", (Throwable)e);
                throw new FSParseException(e);
            }
            if (pub.length > ECDSA.Curves.P256.modulusSize) {
                throw new FSParseException("ecdsa.P256.pub is not the right size!");
            }
            ECPublicKey key = ECDSA.getPublicKey(pub, ECDSA.Curves.P256);
            if (key == null) {
                throw new FSParseException("ecdsa.P256.pub is invalid!");
            }
            this.peerECDSAPubKey = key;
            this.peerECDSAPubKeyHash = SHA256.digest(this.peerECDSAPubKey.getEncoded());
            if (noSig || this.verifyReferenceSignature(fs)) {
                this.isSignatureVerificationSuccessfull = true;
            }
            if ((identityString = fs.get("identity")) == null && this.isDarknet()) {
                throw new PeerParseException("No identity!");
            }
            try {
                if (identityString != null) {
                    this.identity = Base64.decode(identityString);
                } else {
                    sfs = fs.subset("dsaPubKey");
                    this.identity = SHA256.digest(DSAPublicKey.create(sfs, Global.DSAgroupBigA).asBytes());
                }
            }
            catch (NumberFormatException e) {
                throw new FSParseException(e);
            }
            catch (IllegalBase64Exception e) {
                throw new FSParseException(e);
            }
            if (this.identity == null) {
                throw new FSParseException("No identity");
            }
            this.identityAsBase64String = Base64.encode(this.identity);
            this.identityHash = SHA256.digest(this.identity);
            this.identityHashHash = SHA256.digest(this.identityHash);
            this.swapIdentifier = Fields.bytesToLong(this.identityHashHash);
            this.hashCode = Fields.hashCode(this.peerECDSAPubKeyHash);
            byte[] nodeKey = crypto.identityHash;
            byte[] nodeKeyHash = crypto.identityHashHash;
            int digestLength = SHA256.getDigestLength();
            this.incomingSetupKey = new byte[digestLength];
            for (i = 0; i < this.incomingSetupKey.length; ++i) {
                this.incomingSetupKey[i] = (byte)(nodeKey[i] ^ this.identityHashHash[i]);
            }
            this.outgoingSetupKey = new byte[digestLength];
            for (i = 0; i < this.outgoingSetupKey.length; ++i) {
                this.outgoingSetupKey[i] = (byte)(nodeKeyHash[i] ^ this.identityHash[i]);
            }
            if (logMINOR) {
                Logger.minor(this, "Keys:\nIdentity:  " + HexUtil.bytesToHex(crypto.myIdentity) + "\nThisIdent: " + HexUtil.bytesToHex(this.identity) + "\nNode:      " + HexUtil.bytesToHex(nodeKey) + "\nNode hash: " + HexUtil.bytesToHex(nodeKeyHash) + "\nThis:      " + HexUtil.bytesToHex(this.identityHash) + "\nThis hash: " + HexUtil.bytesToHex(this.identityHashHash) + "\nFor:       " + this.getPeer());
            }
            try {
                this.incomingSetupCipher = new Rijndael(256, 256);
                this.incomingSetupCipher.initialize(this.incomingSetupKey);
                this.outgoingSetupCipher = new Rijndael(256, 256);
                this.outgoingSetupCipher.initialize(this.outgoingSetupKey);
                this.anonymousInitiatorSetupCipher = new Rijndael(256, 256);
                this.anonymousInitiatorSetupCipher.initialize(this.identityHash);
            }
            catch (UnsupportedCipherException e1) {
                Logger.error(this, "Caught: " + e1);
                throw new Error(e1);
            }
            this.nominalPeer = new ArrayList<Peer>();
            try {
                String[] physical = fs.getAll("physical.udp");
                if (physical == null) break block55;
                for (String phys : physical) {
                    Peer p;
                    try {
                        p = new Peer(phys, true, true);
                    }
                    catch (HostnameSyntaxException e) {
                        if (fromLocal) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing peer reference in local peers list: " + phys);
                        }
                        System.err.println("Invalid hostname or IP Address syntax error while parsing peer reference: " + phys);
                        continue;
                    }
                    catch (PeerParseException e) {
                        if (fromLocal) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing peer reference in local peers list: " + phys);
                        }
                        System.err.println("Invalid hostname or IP Address syntax error while parsing peer reference: " + phys);
                        continue;
                    }
                    catch (UnknownHostException e) {
                        if (fromLocal) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing peer reference in local peers list: " + phys);
                        }
                        System.err.println("Invalid hostname or IP Address syntax error while parsing peer reference: " + phys);
                        continue;
                    }
                    if (this.nominalPeer.contains(p)) continue;
                    this.nominalPeer.add(p);
                }
            }
            catch (Exception e1) {
                throw new FSParseException(e1);
            }
        }
        if (this.nominalPeer.isEmpty()) {
            Logger.normal(this, "No IP addresses found for identity '" + this.identityAsBase64String + "', possibly at location '" + this.location + ": " + this.userToString());
            this.detectedPeer = null;
        } else {
            this.detectedPeer = this.nominalPeer.get(0);
        }
        this.updateShortToString();
        this.currentTracker = null;
        this.previousTracker = null;
        this.timeLastSentPacket = -1L;
        this.timeLastReceivedPacket = -1L;
        this.timeLastReceivedSwapRequest = -1L;
        this.timeLastRoutable = -1L;
        this.timeAddedOrRestarted = System.currentTimeMillis();
        this.swapRequestsInterval = new SimpleRunningAverage(50, Node.MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS);
        this.probeRequestsInterval = new SimpleRunningAverage(50, Node.MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS);
        this.messageQueue = new PeerMessageQueue();
        this.decrementHTLAtMaximum = (double)this.node.random.nextFloat() < 0.5;
        this.decrementHTLAtMinimum = (double)this.node.random.nextFloat() < 0.25;
        this.pingNumber = this.node.random.nextLong();
        this.pingAverage = new TimeDecayingRunningAverage(1.0, TimeUnit.SECONDS.toMillis(30L), 0.0, NodePinger.CRAZY_MAX_PING_TIME, this.node);
        this.pRejected = new TimeDecayingRunningAverage(0.0, TimeUnit.MINUTES.toMillis(4L), 0.0, 1.0, this.node);
        this.parseARK(fs, true, false);
        long now = System.currentTimeMillis();
        if (fromLocal) {
            SimpleFieldSet metadata = fs.subset("metadata");
            if (metadata != null) {
                Peer p;
                this.location.setPeerLocations(fs.getAll("peersLocation"));
                try {
                    String detectedUDPString = metadata.get("detected.udp");
                    p = null;
                    if (detectedUDPString != null) {
                        p = new Peer(detectedUDPString, false);
                    }
                }
                catch (UnknownHostException e) {
                    p = null;
                    Logger.error(this, "detected.udp = " + metadata.get("detected.udp") + " - " + e, (Throwable)e);
                }
                catch (PeerParseException e) {
                    p = null;
                    Logger.error(this, "detected.udp = " + metadata.get("detected.udp") + " - " + e, (Throwable)e);
                }
                if (p != null) {
                    this.detectedPeer = p;
                }
                this.updateShortToString();
                this.timeLastReceivedPacket = metadata.getLong("timeLastReceivedPacket", -1L);
                long timeLastConnected = metadata.getLong("timeLastConnected", -1L);
                this.timeLastRoutable = metadata.getLong("timeLastRoutable", -1L);
                if (timeLastConnected < 1L && this.timeLastReceivedPacket > 1L) {
                    timeLastConnected = this.timeLastReceivedPacket;
                }
                this.isConnected = new BooleanLastTrueTracker(timeLastConnected);
                if (this.timeLastRoutable < 1L && this.timeLastReceivedPacket > 1L) {
                    this.timeLastRoutable = this.timeLastReceivedPacket;
                }
                this.peerAddedTime = metadata.getLong("peerAddedTime", 0L);
                this.neverConnected = metadata.getBoolean("neverConnected", false);
                this.maybeClearPeerAddedTimeOnRestart(now);
                this.hadRoutableConnectionCount = metadata.getLong("hadRoutableConnectionCount", 0L);
                this.routableConnectionCheckCount = metadata.getLong("routableConnectionCheckCount", 0L);
            } else {
                this.isConnected = new BooleanLastTrueTracker();
            }
        } else {
            this.isConnected = new BooleanLastTrueTracker();
            this.neverConnected = true;
            this.peerAddedTime = now;
        }
        this.lastAttemptedHandshakeIPUpdateTime = 0L;
        this.maybeUpdateHandshakeIPs(true);
        this.listeningHandshakeBurstCount = 0;
        this.listeningHandshakeBurstSize = 1 + this.node.random.nextInt(3);
        if (this.isBurstOnly()) {
            Logger.minor(this, "First BurstOnly mode handshake in " + (this.sendHandshakeTime - now) + "ms for " + this.shortToString() + " (count: " + this.listeningHandshakeBurstCount + ", size: " + this.listeningHandshakeBurstSize + ')');
        }
        if (fromLocal) {
            this.innerCalcNextHandshake(false, false, now);
        } else {
            this.sendHandshakeTime = now;
        }
        this.bytesInAtStartup = fs.getLong("totalInput", 0L);
        this.bytesOutAtStartup = fs.getLong("totalOutput", 0L);
        byte[] buffer = new byte[16];
        this.node.random.nextBytes(buffer);
        this.paddingGen = new MersenneTwister(buffer);
        if (fromLocal) {
            SimpleFieldSet f = fs.subset("full");
            if (this.fullFieldSet == null && f != null) {
                this.fullFieldSet = f;
            }
        }
        this.writePeers();
    }

    protected boolean fromAnonymousInitiator() {
        return false;
    }

    abstract boolean dontKeepFullFieldSet();

    protected abstract void maybeClearPeerAddedTimeOnRestart(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseARK(SimpleFieldSet fs, boolean onStartup, boolean forDiffNodeRef) {
        USK ark;
        block12: {
            ark = null;
            long arkNo = 0L;
            try {
                String arkPubKey = fs.get("ark.pubURI");
                arkNo = fs.getLong("ark.number", -1L);
                if (arkPubKey == null && arkNo <= -1L) {
                    return false;
                }
                if (arkPubKey != null && arkNo > -1L) {
                    if (onStartup) {
                        ++arkNo;
                    }
                    FreenetURI uri = new FreenetURI(arkPubKey);
                    ClientSSK ssk = new ClientSSK(uri);
                    ark = new USK(ssk, arkNo);
                    break block12;
                }
                if (forDiffNodeRef && arkPubKey == null && this.myARK != null && arkNo > -1L) {
                    ark = this.myARK.copy(arkNo);
                    break block12;
                }
                if (forDiffNodeRef && arkPubKey != null && this.myARK != null && arkNo <= -1L) {
                    Logger.error(this, "Got a differential node reference from " + this + " with an arkPubKey but no ARK edition");
                    return false;
                }
                return false;
            }
            catch (MalformedURLException e) {
                Logger.error(this, "Couldn't parse ARK info for " + this + ": " + e, (Throwable)e);
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Couldn't parse ARK info for " + this + ": " + e, (Throwable)e);
            }
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (ark != null && (this.myARK == null || this.myARK != ark && !this.myARK.equals(ark))) {
                this.myARK = ark;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Peer getPeer() {
        return this.detectedPeer;
    }

    protected synchronized Peer[] getHandshakeIPs() {
        return this.handshakeIPs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handshakeIPsToString() {
        Peer[] localHandshakeIPs;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            localHandshakeIPs = this.handshakeIPs;
        }
        if (localHandshakeIPs == null) {
            return "null";
        }
        StringBuilder toOutputString = new StringBuilder(1024);
        toOutputString.append("[ ");
        if (localHandshakeIPs.length != 0) {
            for (Peer localHandshakeIP : localHandshakeIPs) {
                if (localHandshakeIP == null) {
                    toOutputString.append("null, ");
                    continue;
                }
                toOutputString.append('\'');
                toOutputString.append(localHandshakeIP.getAddress(false));
                toOutputString.append('\'');
                toOutputString.append(", ");
            }
            toOutputString.deleteCharAt(toOutputString.length() - 1);
            toOutputString.deleteCharAt(toOutputString.length() - 1);
        }
        toOutputString.append(" ]");
        return toOutputString.toString();
    }

    private Peer[] updateHandshakeIPs(Peer[] localHandshakeIPs, boolean ignoreHostnames) {
        for (Peer localHandshakeIP : localHandshakeIPs) {
            if (ignoreHostnames) {
                if (logMINOR) {
                    Logger.debug(this, "updateHandshakeIPs: calling getAddress(false) on Peer '" + localHandshakeIP + "' for " + this.shortToString() + " (" + ignoreHostnames + ')');
                }
                localHandshakeIP.getAddress(false);
                continue;
            }
            if (logMINOR) {
                Logger.debug(this, "updateHandshakeIPs: calling getHandshakeAddress() on Peer '" + localHandshakeIP + "' for " + this.shortToString() + " (" + ignoreHostnames + ')');
            }
            localHandshakeIP.getHandshakeAddress();
        }
        HashSet<Peer> ret = new HashSet<Peer>();
        for (Peer localHandshakeIP : localHandshakeIPs) {
            ret.add(localHandshakeIP);
        }
        return ret.toArray(new Peer[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateHandshakeIPs(boolean ignoreHostnames) {
        Peer[] localHandshakeIPs;
        Peer[] myNominalPeer;
        long now = System.currentTimeMillis();
        Peer localDetectedPeer = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            localDetectedPeer = this.detectedPeer;
            if (now - this.lastAttemptedHandshakeIPUpdateTime < TimeUnit.MINUTES.toMillis(5L)) {
                return;
            }
            if (!ignoreHostnames) {
                this.lastAttemptedHandshakeIPUpdateTime = now;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Updating handshake IPs for peer '" + this.shortToString() + "' (" + ignoreHostnames + ')');
        }
        PeerNode peerNode2 = this;
        synchronized (peerNode2) {
            myNominalPeer = this.nominalPeer.toArray(new Peer[this.nominalPeer.size()]);
        }
        if (myNominalPeer.length == 0) {
            if (localDetectedPeer == null) {
                PeerNode peerNode3 = this;
                synchronized (peerNode3) {
                    this.handshakeIPs = null;
                }
                if (logMINOR) {
                    Logger.minor(this, "1: maybeUpdateHandshakeIPs got a result of: " + this.handshakeIPsToString());
                }
                return;
            }
            localHandshakeIPs = new Peer[]{localDetectedPeer};
            localHandshakeIPs = this.updateHandshakeIPs(localHandshakeIPs, ignoreHostnames);
            PeerNode peerNode4 = this;
            synchronized (peerNode4) {
                this.handshakeIPs = localHandshakeIPs;
            }
            if (logMINOR) {
                Logger.minor(this, "2: maybeUpdateHandshakeIPs got a result of: " + this.handshakeIPsToString());
            }
            return;
        }
        FreenetInetAddress localhost = this.node.fLocalhostAddress;
        Peer[] nodePeers = this.outgoingMangler.getPrimaryIPAddress();
        ArrayList<Peer> localPeers = null;
        PeerNode peerNode5 = this;
        synchronized (peerNode5) {
            localPeers = new ArrayList<Peer>(this.nominalPeer);
        }
        boolean addedLocalhost = false;
        Peer detectedDuplicate = null;
        for (Peer p : myNominalPeer) {
            FreenetInetAddress addr;
            if (p == null) continue;
            if (localDetectedPeer != null && p != localDetectedPeer && p.equals(localDetectedPeer)) {
                detectedDuplicate = p;
            }
            if ((addr = p.getFreenetAddress()).equals(localhost)) {
                if (addedLocalhost) continue;
                addedLocalhost = true;
            }
            for (Peer nodePeer : nodePeers) {
                FreenetInetAddress myAddr = nodePeer.getFreenetAddress();
                if (!myAddr.equals(addr)) continue;
                if (!addedLocalhost) {
                    localPeers.add(new Peer(localhost, p.getPort()));
                }
                addedLocalhost = true;
            }
            if (localPeers.contains(p)) continue;
            localPeers.add(p);
        }
        localHandshakeIPs = localPeers.toArray(new Peer[localPeers.size()]);
        localHandshakeIPs = this.updateHandshakeIPs(localHandshakeIPs, ignoreHostnames);
        PeerNode peerNode6 = this;
        synchronized (peerNode6) {
            this.handshakeIPs = localHandshakeIPs;
            if (detectedDuplicate != null && detectedDuplicate.equals(localDetectedPeer)) {
                localDetectedPeer = this.detectedPeer = detectedDuplicate;
            }
            this.updateShortToString();
        }
        if (logMINOR) {
            if (localDetectedPeer != null) {
                Logger.minor(this, "3: detectedPeer = " + localDetectedPeer + " (" + localDetectedPeer.getAddress(false) + ')');
            }
            Logger.minor(this, "3: maybeUpdateHandshakeIPs got a result of: " + this.handshakeIPsToString());
        }
    }

    @Override
    public double getLocation() {
        return this.location.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBeExcludedFromPeerList() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (0.9 < this.backedOffPercent.currentValue()) {
                return true;
            }
            return BLACK_MAGIC_BACKOFF_PRUNING_TIME + now < this.getRoutingBackedOffUntilMax();
            {
            }
        }
    }

    double[] getPeersLocationArray() {
        return this.location.getPeersLocationArray();
    }

    public double getClosestPeerLocation(double l, Set<Double> exclude) {
        return this.location.getClosestPeerLocation(l, exclude);
    }

    public long getLocSetTime() {
        return this.location.getLocationSetTime();
    }

    public int getIdentityHash() {
        return this.hashCode;
    }

    public synchronized boolean isUnroutableOlderVersion() {
        return this.unroutableOlderVersion;
    }

    public synchronized boolean isUnroutableNewerVersion() {
        return this.unroutableNewerVersion;
    }

    @Override
    public boolean isRoutable() {
        if (!this.isConnected() || !this.isRoutingCompatible()) {
            return false;
        }
        return this.location.isValidLocation();
    }

    synchronized boolean isInMandatoryBackoff(long now, boolean realTime) {
        long mandatoryBackoffUntil;
        long l = mandatoryBackoffUntil = realTime ? this.mandatoryBackoffUntilRT : this.mandatoryBackoffUntilBulk;
        if (mandatoryBackoffUntil > -1L && now < mandatoryBackoffUntil) {
            if (logMINOR) {
                Logger.minor(this, "In mandatory backoff");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoutingCompatible() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.isRoutable && !this.disableRouting) {
                this.timeLastRoutable = now;
                return true;
            }
            if (logMINOR) {
                Logger.minor(this, "Not routing compatible");
            }
            return false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected.isTrue();
    }

    @Override
    public MessageItem sendAsync(Message msg, AsyncMessageCallback cb, ByteCounter ctr) throws NotConnectedException {
        AsyncMessageCallback[] asyncMessageCallbackArray;
        if (ctr == null) {
            Logger.error(this, "ByteCounter null, so bandwidth usage cannot be logged. Refusing to send.", (Throwable)new Exception("debug"));
        }
        if (logMINOR) {
            Logger.minor(this, "Sending async: " + msg + " : " + cb + " on " + this + " for " + this.node.getDarknetPortNumber() + " priority " + msg.getPriority());
        }
        if (!this.isConnected()) {
            if (cb != null) {
                cb.disconnected();
            }
            throw new NotConnectedException();
        }
        if (msg.getSource() != null) {
            Logger.error(this, "Messages should NOT be relayed as-is, they should always be re-created to clear any sub-messages etc, see comments in Message.java!: " + msg, (Throwable)new Exception("error"));
        }
        this.addToLocalNodeSentMessagesToStatistic(msg);
        if (cb == null) {
            asyncMessageCallbackArray = null;
        } else {
            AsyncMessageCallback[] asyncMessageCallbackArray2 = new AsyncMessageCallback[1];
            asyncMessageCallbackArray = asyncMessageCallbackArray2;
            asyncMessageCallbackArray2[0] = cb;
        }
        MessageItem item = new MessageItem(msg, asyncMessageCallbackArray, ctr);
        long now = System.currentTimeMillis();
        this.reportBackoffStatus(now);
        int maxSize = this.getMaxPacketSize();
        int x = this.messageQueue.queueAndEstimateSize(item, maxSize);
        if (x > maxSize || !this.node.enablePacketCoalescing) {
            this.wakeUpSender();
        }
        return item;
    }

    @Override
    public void wakeUpSender() {
        if (logMINOR) {
            Logger.minor(this, "Waking up PacketSender");
        }
        this.node.ps.wakeUp();
    }

    @Override
    public boolean unqueueMessage(MessageItem message) {
        if (logMINOR) {
            Logger.minor(this, "Unqueueing message on " + this + " : " + message);
        }
        return this.messageQueue.removeMessage(message);
    }

    public long getMessageQueueLengthBytes() {
        return this.messageQueue.getMessageQueueLengthBytes();
    }

    public long getProbableSendQueueTime() {
        double bandwidth = this.getThrottle().getBandwidth() + 1.0;
        if (this.shouldThrottle()) {
            bandwidth = Math.min(bandwidth, (double)(this.node.getOutputBandwidthLimit() / 2));
        }
        long length = this.getMessageQueueLengthBytes();
        return (long)(1000.0 * (double)length / bandwidth);
    }

    public synchronized long lastReceivedPacketTime() {
        return this.timeLastReceivedPacket;
    }

    public synchronized long lastReceivedDataPacketTime() {
        return this.timeLastReceivedDataPacket;
    }

    public synchronized long lastReceivedAckTime() {
        return this.timeLastReceivedAck;
    }

    public long timeLastConnected(long now) {
        return this.isConnected.getTimeLastTrue(now);
    }

    public synchronized long timeLastRoutable() {
        return this.timeLastRoutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeRekey() {
        long now = System.currentTimeMillis();
        boolean shouldDisconnect = false;
        boolean shouldReturn = false;
        boolean shouldRekey = false;
        long timeWhenRekeyingShouldOccur = 0L;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            timeWhenRekeyingShouldOccur = this.timeLastRekeyed + FNPPacketMangler.SESSION_KEY_REKEYING_INTERVAL;
            shouldDisconnect = timeWhenRekeyingShouldOccur + FNPPacketMangler.MAX_SESSION_KEY_REKEYING_DELAY < now && this.isRekeying;
            shouldReturn = this.isRekeying || !this.isConnected();
            boolean bl = shouldRekey = timeWhenRekeyingShouldOccur < now;
            if (!shouldRekey && this.totalBytesExchangedWithCurrentTracker > 0x40000000L) {
                shouldRekey = true;
                timeWhenRekeyingShouldOccur = now;
            }
        }
        if (shouldDisconnect) {
            String time = TimeUtil.formatTime(FNPPacketMangler.MAX_SESSION_KEY_REKEYING_DELAY);
            System.err.println("The peer (" + this + ") has been asked to rekey " + time + " ago... force disconnect.");
            Logger.error(this, "The peer (" + this + ") has been asked to rekey " + time + " ago... force disconnect.");
            this.forceDisconnect();
        } else {
            if (shouldReturn || this.hasLiveHandshake(now)) {
                return;
            }
            if (shouldRekey) {
                this.startRekeying();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRekeying() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.isRekeying) {
                return;
            }
            this.isRekeying = true;
            this.sendHandshakeTime = now;
            this.ctx = null;
        }
        Logger.normal(this, "We are asking for the key to be renewed (" + this.detectedPeer + ')');
    }

    public synchronized long getPeerAddedTime() {
        return this.peerAddedTime;
    }

    public synchronized long timeSinceAddedOrRestarted() {
        return System.currentTimeMillis() - this.timeAddedOrRestarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnected(boolean dumpMessageQueue, boolean dumpTrackers) {
        OpennetManager om;
        SessionKey unv;
        SessionKey prev;
        SessionKey cur;
        boolean ret;
        assert (dumpMessageQueue || !dumpTrackers);
        final long now = System.currentTimeMillis();
        if (this.isRealConnection()) {
            Logger.normal(this, "Disconnected " + this, (Throwable)new Exception("debug"));
        } else if (logMINOR) {
            Logger.minor(this, "Disconnected " + this, (Throwable)new Exception("debug"));
        }
        this.node.usm.onDisconnect(this);
        if (dumpMessageQueue) {
            this.node.tracker.onRestartOrDisconnect(this);
        }
        this.node.failureTable.onDisconnect(this);
        this.node.peers.disconnected(this);
        this.node.nodeUpdater.disconnected(this);
        MessageItem[] messagesTellDisconnected = null;
        List<MessageItem> moreMessagesTellDisconnected = null;
        PacketFormat oldPacketFormat = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.disconnecting = false;
            ret = this.isConnected.set(false, now);
            this.isRoutable = false;
            this.isRekeying = false;
            cur = this.currentTracker;
            prev = this.previousTracker;
            unv = this.unverifiedTracker;
            if (dumpTrackers) {
                this.currentTracker = null;
                this.previousTracker = null;
                this.unverifiedTracker = null;
            }
            this.sendHandshakeTime = now;
            this.countFailedRevocationTransfers = 0;
            this.timePrevDisconnect = this.timeLastDisconnect;
            this.timeLastDisconnect = now;
            if (dumpMessageQueue) {
                this.myBootID = this.node.fastWeakRandom.nextLong();
                messagesTellDisconnected = this.grabQueuedMessageItems();
                oldPacketFormat = this.packetFormat;
                this.packetFormat = null;
            }
        }
        if (oldPacketFormat != null) {
            moreMessagesTellDisconnected = oldPacketFormat.onDisconnect();
        }
        if (messagesTellDisconnected != null) {
            if (logMINOR) {
                Logger.minor(this, "Messages to dump: " + messagesTellDisconnected.length);
            }
            for (MessageItem mi : messagesTellDisconnected) {
                mi.onDisconnect();
            }
        }
        if (moreMessagesTellDisconnected != null) {
            if (logMINOR) {
                Logger.minor(this, "Messages to dump: " + moreMessagesTellDisconnected.size());
            }
            for (MessageItem mi : moreMessagesTellDisconnected) {
                mi.onDisconnect();
            }
        }
        if (cur != null) {
            cur.disconnected();
        }
        if (prev != null) {
            prev.disconnected();
        }
        if (unv != null) {
            unv.disconnected();
        }
        if (this._lastThrottle != null) {
            this._lastThrottle.maybeDisconnected();
        }
        this.node.lm.lostOrRestartedNode(this);
        if (this.peers.havePeer(this)) {
            this.setPeerNodeStatus(now);
        }
        if (!dumpMessageQueue) {
            this.node.getTicker().queueTimedJob(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!PeerNode.this.isConnected() && PeerNode.this.timeLastDisconnect == now) {
                        List<MessageItem> moreMessagesTellDisconnected;
                        PacketFormat oldPacketFormat = null;
                        2 var2_2 = this;
                        synchronized (var2_2) {
                            if (PeerNode.this.isConnected()) {
                                return;
                            }
                            PeerNode.this.myBootID = PeerNode.this.node.fastWeakRandom.nextLong();
                            oldPacketFormat = PeerNode.this.packetFormat;
                            PeerNode.this.packetFormat = null;
                        }
                        MessageItem[] messagesTellDisconnected = PeerNode.this.grabQueuedMessageItems();
                        if (messagesTellDisconnected != null) {
                            for (MessageItem mi : messagesTellDisconnected) {
                                mi.onDisconnect();
                            }
                        }
                        if (oldPacketFormat != null && (moreMessagesTellDisconnected = oldPacketFormat.onDisconnect()) != null) {
                            if (logMINOR) {
                                Logger.minor(this, "Messages to dump: " + moreMessagesTellDisconnected.size());
                            }
                            for (MessageItem mi : moreMessagesTellDisconnected) {
                                mi.onDisconnect();
                            }
                        }
                    }
                }
            }, CLEAR_MESSAGE_QUEUE_AFTER);
        }
        if ((om = this.node.getOpennet()) != null) {
            om.onDisconnect(this);
        }
        this.outputLoadTrackerRealTime.failSlotWaiters(true);
        this.outputLoadTrackerBulk.failSlotWaiters(true);
        this.loadSenderRealTime.onDisconnect();
        this.loadSenderBulk.onDisconnect();
        return ret;
    }

    @Override
    public void forceDisconnect() {
        Logger.error(this, "Forcing disconnect on " + this, (Throwable)new Exception("debug"));
        this.disconnected(true, true);
    }

    public MessageItem[] grabQueuedMessageItems() {
        return this.messageQueue.grabQueuedMessageItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextUrgentTime(long now) {
        PacketFormat pf;
        SessionKey cur;
        long t = Long.MAX_VALUE;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (!this.isConnected()) {
                return Long.MAX_VALUE;
            }
            cur = this.currentTracker;
            SessionKey prev = this.previousTracker;
            pf = this.packetFormat;
            if (cur == null && prev == null) {
                return Long.MAX_VALUE;
            }
        }
        if (pf != null) {
            long l;
            boolean canSend;
            boolean bl = canSend = cur != null && pf.canSend(cur);
            if (canSend) {
                l = this.messageQueue.getNextUrgentTime(t, 0L);
                if (t >= now && l < now && logMINOR) {
                    Logger.minor(this, "Next urgent time from message queue less than now");
                } else if (logDEBUG) {
                    Logger.debug(this, "Next urgent time is " + (l - now) + "ms on " + this);
                }
                t = l;
            }
            if ((l = pf.timeNextUrgent(canSend, now)) < now && logMINOR) {
                Logger.minor(this, "Next urgent time from packet format less than now on " + this);
            }
            t = Math.min(t, l);
        }
        return t;
    }

    public long lastSentPacketTime() {
        return this.timeLastSentPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSendHandshake() {
        long now = System.currentTimeMillis();
        boolean tempShouldSendHandshake = false;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.disconnecting) {
                return false;
            }
            tempShouldSendHandshake = now > this.sendHandshakeTime && this.handshakeIPs != null && (this.isRekeying || !this.isConnected());
        }
        if (logMINOR) {
            Logger.minor(this, "shouldSendHandshake(): initial = " + tempShouldSendHandshake);
        }
        if (tempShouldSendHandshake && this.hasLiveHandshake(now)) {
            tempShouldSendHandshake = false;
        }
        if (tempShouldSendHandshake) {
            if (this.isBurstOnly()) {
                peerNode = this;
                synchronized (peerNode) {
                    this.isBursting = true;
                }
                this.setPeerNodeStatus(System.currentTimeMillis());
            } else {
                return true;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "shouldSendHandshake(): final = " + tempShouldSendHandshake);
        }
        return tempShouldSendHandshake;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeSendHandshake(long now) {
        if (this.hasLiveHandshake(now)) {
            return Long.MAX_VALUE;
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.disconnecting) {
                return Long.MAX_VALUE;
            }
            if (this.handshakeIPs == null) {
                return Long.MAX_VALUE;
            }
            if (!this.isRekeying && this.isConnected()) {
                return Long.MAX_VALUE;
            }
            return this.sendHandshakeTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiveHandshake(long now) {
        KeyAgreementSchemeContext c = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            c = this.ctx;
        }
        if (c != null && logDEBUG) {
            Logger.minor(this, "Last used (handshake): " + (now - c.lastUsedTime()));
        }
        return c != null && now - c.lastUsedTime() <= (long)Node.HANDSHAKE_TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean innerCalcNextHandshake(boolean successfulHandshakeSend, boolean dontFetchARK, long now) {
        if (this.isBurstOnly()) {
            return this.calcNextHandshakeBurstOnly(now);
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long delay = this.unroutableOlderVersion || this.unroutableNewerVersion || this.disableRouting ? (long)(Node.MIN_TIME_BETWEEN_VERSION_SENDS + this.node.random.nextInt(Node.RANDOMIZED_TIME_BETWEEN_VERSION_SENDS)) : (this.invalidVersion() && !this.firstHandshake ? (long)(Node.MIN_TIME_BETWEEN_VERSION_PROBES + this.node.random.nextInt(Node.RANDOMIZED_TIME_BETWEEN_VERSION_PROBES)) : (long)(Node.MIN_TIME_BETWEEN_HANDSHAKE_SENDS + this.node.random.nextInt(Node.RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS)));
            if ((delay /= (long)(this.handshakeIPs == null ? 1 : this.handshakeIPs.length)) < 3000L) {
                delay = 3000L;
            }
            this.sendHandshakeTime = now + delay;
            if (logMINOR) {
                Logger.minor(this, "Next handshake in " + delay + " on " + this);
            }
            if (successfulHandshakeSend) {
                this.firstHandshake = false;
            }
            ++this.handshakeCount;
            return this.handshakeCount == 2;
        }
    }

    private synchronized boolean calcNextHandshakeBurstOnly(long now) {
        long delay;
        boolean fetchARKFlag = false;
        ++this.listeningHandshakeBurstCount;
        if (this.isBurstOnly() && this.listeningHandshakeBurstCount >= this.listeningHandshakeBurstSize) {
            this.listeningHandshakeBurstCount = 0;
            fetchARKFlag = true;
        }
        if (this.listeningHandshakeBurstCount == 0) {
            delay = Node.MIN_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS + this.node.random.nextInt(Node.RANDOMIZED_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS);
            this.listeningHandshakeBurstSize = 1 + this.node.random.nextInt(3);
            this.isBursting = false;
        } else {
            delay = Node.MIN_TIME_BETWEEN_HANDSHAKE_SENDS + this.node.random.nextInt(Node.RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS);
        }
        if ((delay /= (long)(this.handshakeIPs == null ? 1 : this.handshakeIPs.length)) < 3000L) {
            delay = 3000L;
        }
        this.sendHandshakeTime = now + delay;
        if (logMINOR) {
            Logger.minor(this, "Next BurstOnly mode handshake in " + (this.sendHandshakeTime - now) + "ms for " + this.shortToString() + " (count: " + this.listeningHandshakeBurstCount + ", size: " + this.listeningHandshakeBurstSize + ") on " + this, (Throwable)new Exception("double-called debug"));
        }
        return fetchARKFlag;
    }

    protected void calcNextHandshake(boolean successfulHandshakeSend, boolean dontFetchARK, boolean notRegistered) {
        long now = System.currentTimeMillis();
        boolean fetchARKFlag = false;
        fetchARKFlag = this.innerCalcNextHandshake(successfulHandshakeSend, dontFetchARK, now);
        if (!notRegistered) {
            this.setPeerNodeStatus(now);
        }
        if (fetchARKFlag && !dontFetchARK) {
            long arkFetcherStartTime1 = System.currentTimeMillis();
            this.startARKFetcher();
            long arkFetcherStartTime2 = System.currentTimeMillis();
            if (arkFetcherStartTime2 - arkFetcherStartTime1 > 500L) {
                Logger.normal(this, "arkFetcherStartTime2 is more than half a second after arkFetcherStartTime1 (" + (arkFetcherStartTime2 - arkFetcherStartTime1) + ") working on " + this.shortToString());
            }
        }
    }

    public boolean isBurstOnly() {
        AddressTracker.Status status = this.outgoingMangler.getConnectivityStatus();
        if (status == AddressTracker.Status.DONT_KNOW) {
            return false;
        }
        if (status == AddressTracker.Status.DEFINITELY_NATED || status == AddressTracker.Status.MAYBE_NATED) {
            return false;
        }
        if (status == AddressTracker.Status.MAYBE_PORT_FORWARDED) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.timeSetBurstNow > UPDATE_BURST_NOW_PERIOD) {
            this.burstNow = this.node.random.nextInt(20) == 0;
            this.timeSetBurstNow = now;
        }
        return this.burstNow;
    }

    public void sentHandshake(boolean notRegistered) {
        if (logMINOR) {
            Logger.minor(this, "sentHandshake(): " + this);
        }
        this.calcNextHandshake(true, false, notRegistered);
    }

    public void couldNotSendHandshake(boolean notRegistered) {
        if (logMINOR) {
            Logger.minor(this, "couldNotSendHandshake(): " + this);
        }
        this.calcNextHandshake(false, false, notRegistered);
    }

    public long maxTimeBetweenReceivedPackets() {
        return Node.MAX_PEER_INACTIVITY;
    }

    public long maxTimeBetweenReceivedAcks() {
        return Node.MAX_PEER_INACTIVITY;
    }

    public boolean ping(int pingID) throws NotConnectedException {
        Message msg;
        Message ping = DMT.createFNPPing(pingID);
        this.node.usm.send(this, ping, this.node.dispatcher.pingCounter);
        try {
            msg = this.node.usm.waitFor(MessageFilter.create().setTimeout(2000L).setType(DMT.FNPPong).setField("pingSequenceNumber", pingID), null);
        }
        catch (DisconnectedException e) {
            throw new NotConnectedException("Disconnected while waiting for pong");
        }
        return msg != null;
    }

    public short decrementHTL(short htl) {
        short max = this.node.maxHTL();
        if (htl > max) {
            htl = max;
        }
        if (htl <= 0) {
            return 0;
        }
        if (htl == max) {
            if (this.decrementHTLAtMaximum || this.node.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        if (htl == 1) {
            if (this.decrementHTLAtMinimum || this.node.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        htl = (short)(htl - 1);
        return htl;
    }

    public void sendSync(Message req, ByteCounter ctr, boolean realTime) throws NotConnectedException, SyncSendWaitedTooLongException {
        SyncMessageCallback cb = new SyncMessageCallback();
        MessageItem item = this.sendAsync(req, cb, ctr);
        cb.waitForSend(TimeUnit.MINUTES.toMillis(1L));
        if (!cb.done) {
            Logger.warning(this, "Waited too long for a blocking send for " + req + " to " + this, (Throwable)new Exception("error"));
            this.localRejectedOverload("SendSyncTimeout", realTime);
            if (!this.messageQueue.removeMessage(item)) {
                cb.waitForSend(TimeUnit.SECONDS.toMillis(10L));
                if (!cb.done) {
                    Logger.error(this, "Waited too long for blocking send and then could not unqueue for " + req + " to " + this, (Throwable)new Exception("error"));
                    this.fatalTimeout();
                } else {
                    return;
                }
            }
            throw new SyncSendWaitedTooLongException();
        }
    }

    public int getDegree() {
        return this.location.getDegree();
    }

    public void updateLocation(double newLoc, double[] newLocs) {
        boolean anythingChanged = this.location.updateLocation(newLoc, newLocs);
        this.node.peers.updatePMUserAlert();
        if (anythingChanged) {
            this.writePeers();
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    protected abstract void writePeers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRejectSwapRequest() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.timeLastReceivedSwapRequest > 0L) {
                long timeSinceLastTime = now - this.timeLastReceivedSwapRequest;
                this.swapRequestsInterval.report(timeSinceLastTime);
                double averageInterval = this.swapRequestsInterval.currentValue();
                if (averageInterval >= (double)Node.MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS) {
                    this.timeLastReceivedSwapRequest = now;
                    return false;
                }
                return true;
            }
            this.timeLastReceivedSwapRequest = now;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRejectProbeRequest() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.timeLastReceivedProbeRequest > 0L) {
                long timeSinceLastTime = now - this.timeLastReceivedProbeRequest;
                this.probeRequestsInterval.report(timeSinceLastTime);
                double averageInterval = this.probeRequestsInterval.currentValue();
                if (averageInterval >= (double)Node.MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS) {
                    this.timeLastReceivedProbeRequest = now;
                    return false;
                }
                return true;
            }
            this.timeLastReceivedProbeRequest = now;
        }
        return false;
    }

    public void changedIP(Peer newPeer) {
        this.setDetectedPeer(newPeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDetectedPeer(Peer newPeer) {
        Peer p = newPeer;
        if ((newPeer = newPeer.dropHostName()) == null) {
            Logger.error(this, "Impossible: No address for detected peer! " + p + " on " + this);
            return;
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            Peer oldPeer = this.detectedPeer;
            if (!(newPeer == null || oldPeer != null && oldPeer.equals(newPeer))) {
                this.detectedPeer = newPeer;
                this.updateShortToString();
                this.lastAttemptedHandshakeIPUpdateTime = 0L;
                if (!this.isConnected()) {
                    return;
                }
            } else {
                return;
            }
        }
        this.getThrottle().maybeDisconnected();
        this.sendIPAddressMessage();
    }

    @Override
    public synchronized SessionKey getCurrentKeyTracker() {
        return this.currentTracker;
    }

    @Override
    public synchronized SessionKey getPreviousKeyTracker() {
        return this.previousTracker;
    }

    @Override
    public synchronized SessionKey getUnverifiedKeyTracker() {
        return this.unverifiedTracker;
    }

    private void updateShortToString() {
        this.shortToString = super.toString() + '@' + this.detectedPeer + '@' + HexUtil.bytesToHex(this.peerECDSAPubKeyHash);
    }

    @Override
    public String shortToString() {
        return this.shortToString;
    }

    public String toString() {
        return this.shortToString() + '@' + Integer.toHexString(super.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedPacket(boolean dontLog, boolean dataPacket) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (!this.isConnected() && !dontLog) {
                if (this.unverifiedTracker == null && this.currentTracker == null && !this.disconnecting) {
                    Logger.error(this, "Received packet while disconnected!: " + this, (Throwable)new Exception("error"));
                } else if (logMINOR) {
                    Logger.minor(this, "Received packet while disconnected on " + this + " - recently disconnected() ?");
                }
            } else if (logMINOR) {
                Logger.minor(this, "Received packet on " + this);
            }
        }
        long now = System.currentTimeMillis();
        PeerNode peerNode2 = this;
        synchronized (peerNode2) {
            this.timeLastReceivedPacket = now;
            if (dataPacket) {
                this.timeLastReceivedDataPacket = now;
            }
        }
    }

    @Override
    public synchronized void receivedAck(long now) {
        if (this.timeLastReceivedAck < now) {
            this.timeLastReceivedAck = now;
        }
    }

    @Override
    public void sentPacket() {
        this.timeLastSentPacket = System.currentTimeMillis();
    }

    public synchronized KeyAgreementSchemeContext getKeyAgreementSchemeContext() {
        return this.ctx;
    }

    public synchronized void setKeyAgreementSchemeContext(KeyAgreementSchemeContext ctx2) {
        this.ctx = ctx2;
        if (logMINOR) {
            Logger.minor(this, "setKeyAgreementSchemeContext(" + ctx2 + ") on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long completedHandshake(long thisBootID, byte[] data, int offset, int length, BlockCipher outgoingCipher, byte[] outgoingKey, BlockCipher incommingCipher, byte[] incommingKey, Peer replyTo, boolean unverified, int negType, long trackerID, boolean isJFK4, boolean jfk4SameAsOld, byte[] hmacKey, BlockCipher ivCipher, byte[] ivNonce, int ourInitialSeqNum, int theirInitialSeqNum, int ourInitialMsgID, int theirInitialMsgID) {
        PacketThrottle throttle;
        List<MessageItem> tellDisconnect;
        long now = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Tracker ID " + trackerID + " isJFK4=" + isJFK4 + " jfk4SameAsOld=" + jfk4SameAsOld);
        }
        if (trackerID < 0L) {
            trackerID = Math.abs(this.node.random.nextLong());
        }
        if (!this.isSeed() || !(this instanceof SeedServerPeerNode)) {
            this.calcNextHandshake(true, true, false);
        }
        this.stopARKFetcher();
        try {
            this.processNewNoderef(data, offset, length);
        }
        catch (FSParseException e1) {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.bogusNoderef = true;
                this.isConnected.set(false, now);
            }
            Logger.error(this, "Failed to parse new noderef for " + this + ": " + e1, (Throwable)e1);
            this.node.peers.disconnected(this);
            return -1L;
        }
        boolean routable = true;
        boolean newer = false;
        boolean older = false;
        if (this.isSeed()) {
            routable = false;
            if (logMINOR) {
                Logger.minor(this, "Not routing traffic to " + this + " it's for announcement.");
            }
        } else if (this.bogusNoderef) {
            Logger.normal(this, "Not routing traffic to " + this + " - bogus noderef");
            routable = false;
        } else if (this.reverseInvalidVersion()) {
            Logger.normal(this, "Not routing traffic to " + this + " - reverse invalid version " + Version.getVersionString() + " for peer's lastGoodversion: " + this.getLastGoodVersion());
            newer = true;
        } else {
            newer = false;
        }
        if (this.forwardInvalidVersion()) {
            Logger.normal(this, "Not routing traffic to " + this + " - invalid version " + this.getVersion());
            older = true;
            routable = false;
        } else if (Math.abs(this.clockDelta) > MAX_CLOCK_DELTA) {
            Logger.normal(this, "Not routing traffic to " + this + " - clock problems");
            routable = false;
        } else {
            older = false;
        }
        this.changedIP(replyTo);
        boolean bootIDChanged = false;
        boolean wasARekey = false;
        SessionKey oldPrev = null;
        SessionKey oldCur = null;
        MessageItem[] messagesTellDisconnected = null;
        PacketFormat oldPacketFormat = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.disconnecting = false;
            if (this.currentTracker != null && Arrays.equals(outgoingKey, this.currentTracker.outgoingKey) && Arrays.equals(incommingKey, this.currentTracker.incommingKey)) {
                Logger.error(this, "completedHandshake() with identical key to current, maybe replayed JFK(4)?");
                return -1L;
            }
            if (this.previousTracker != null && Arrays.equals(outgoingKey, this.previousTracker.outgoingKey) && Arrays.equals(incommingKey, this.previousTracker.incommingKey)) {
                Logger.error(this, "completedHandshake() with identical key to previous, maybe replayed JFK(4)?");
                return -1L;
            }
            if (this.unverifiedTracker != null && Arrays.equals(outgoingKey, this.unverifiedTracker.outgoingKey) && Arrays.equals(incommingKey, this.unverifiedTracker.incommingKey)) {
                Logger.error(this, "completedHandshake() with identical key to unverified, maybe replayed JFK(4)?");
                return -1L;
            }
            this.handshakeCount = 0;
            this.bogusNoderef = false;
            if (!this.isConnected()) {
                this.connectedTime = now;
                this.countSelectionsSinceConnected = 0L;
                this.sentInitialMessages = false;
            } else {
                wasARekey = true;
            }
            this.disableRouting = this.disableRoutingHasBeenSetLocally || this.disableRoutingHasBeenSetRemotely;
            this.isRoutable = routable;
            this.unroutableNewerVersion = newer;
            this.unroutableOlderVersion = older;
            boolean notReusingTracker = false;
            long oldBootID = this.bootID.getAndSet(thisBootID);
            boolean bl = bootIDChanged = oldBootID != thisBootID;
            if (this.myLastSuccessfulBootID != this.myBootID) {
                bootIDChanged = true;
                this.myLastSuccessfulBootID = this.myBootID;
            }
            if (bootIDChanged && wasARekey) {
                Logger.normal(this, "Changed boot ID while rekeying! from " + oldBootID + " to " + thisBootID + " for " + this.getPeer());
                wasARekey = false;
                this.connectedTime = now;
                this.countSelectionsSinceConnected = 0L;
                this.sentInitialMessages = false;
            } else if (bootIDChanged && logMINOR) {
                Logger.minor(this, "Changed boot ID from " + oldBootID + " to " + thisBootID + " for " + this.getPeer());
            }
            if (bootIDChanged) {
                oldPrev = this.previousTracker;
                oldCur = this.currentTracker;
                this.previousTracker = null;
                this.currentTracker = null;
                messagesTellDisconnected = this.grabQueuedMessageItems();
                this.offeredMainJarVersion = 0L;
                oldPacketFormat = this.packetFormat;
                this.packetFormat = null;
            }
            SessionKey newTracker = new SessionKey(this, outgoingCipher, outgoingKey, incommingCipher, incommingKey, ivCipher, ivNonce, hmacKey, new NewPacketFormatKeyContext(ourInitialSeqNum, theirInitialSeqNum), trackerID);
            if (logMINOR) {
                Logger.minor(this, "New key tracker in completedHandshake: " + newTracker + " for " + this.shortToString() + " neg type " + negType);
            }
            if (unverified) {
                if (this.unverifiedTracker != null && this.previousTracker == null) {
                    this.previousTracker = this.unverifiedTracker;
                }
                this.unverifiedTracker = newTracker;
            } else {
                oldPrev = this.previousTracker;
                this.previousTracker = this.currentTracker;
                this.currentTracker = newTracker;
                this.neverConnected = false;
                this.maybeClearPeerAddedTimeOnConnect();
            }
            this.isConnected.set(this.currentTracker != null, now);
            this.ctx = null;
            this.isRekeying = false;
            this.timeLastRekeyed = now - (unverified ? 0L : FNPPacketMangler.MAX_SESSION_KEY_REKEYING_DELAY / 2L);
            this.totalBytesExchangedWithCurrentTracker = 0L;
            if (this.currentTracker != null && this.previousTracker != null && Arrays.equals(this.currentTracker.outgoingKey, this.previousTracker.outgoingKey) && Arrays.equals(this.currentTracker.incommingKey, this.previousTracker.incommingKey)) {
                Logger.error(this, "currentTracker key equals previousTracker key: cur " + this.currentTracker + " prev " + this.previousTracker);
            }
            if (this.previousTracker != null && this.unverifiedTracker != null && Arrays.equals(this.previousTracker.outgoingKey, this.unverifiedTracker.outgoingKey) && Arrays.equals(this.previousTracker.incommingKey, this.unverifiedTracker.incommingKey)) {
                Logger.error(this, "previousTracker key equals unverifiedTracker key: prev " + this.previousTracker + " unv " + this.unverifiedTracker);
            }
            this.timeLastSentPacket = now;
            if (this.packetFormat == null) {
                this.packetFormat = new NewPacketFormat(this, ourInitialMsgID, theirInitialMsgID);
            }
            this.timeLastReceivedPacket = now;
            this.timeLastReceivedDataPacket = now;
            this.timeLastReceivedAck = now;
        }
        if (messagesTellDisconnected != null) {
            for (MessageItem item : messagesTellDisconnected) {
                item.onDisconnect();
            }
        }
        if (bootIDChanged) {
            this.node.lm.lostOrRestartedNode(this);
            this.node.usm.onRestart(this);
            this.node.tracker.onRestartOrDisconnect(this);
        }
        if (oldPrev != null) {
            oldPrev.disconnected();
        }
        if (oldCur != null) {
            oldCur.disconnected();
        }
        if (oldPacketFormat != null && (tellDisconnect = oldPacketFormat.onDisconnect()) != null) {
            for (MessageItem item : tellDisconnect) {
                item.onDisconnect();
            }
        }
        PeerNode peerNode2 = this;
        synchronized (peerNode2) {
            throttle = this._lastThrottle;
        }
        if (throttle != null) {
            throttle.maybeDisconnected();
        }
        Logger.normal(this, "Completed handshake with " + this + " on " + replyTo + " - current: " + this.currentTracker + " old: " + this.previousTracker + " unverified: " + this.unverifiedTracker + " bootID: " + thisBootID + (bootIDChanged ? "(changed) " : "") + " for " + this.shortToString());
        this.setPeerNodeStatus(now);
        if (newer || older || !this.isConnected()) {
            this.node.peers.disconnected(this);
        } else if (!wasARekey) {
            this.node.peers.addConnectedPeer(this);
            this.maybeOnConnect();
        }
        this.crypto.maybeBootConnection(this, replyTo.getFreenetAddress());
        return trackerID;
    }

    protected abstract void maybeClearPeerAddedTimeOnConnect();

    @Override
    public long getBootID() {
        return this.bootID.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startARKFetcher() {
        if (!this.node.enableARKs) {
            return;
        }
        Object object = this.arkFetcherSync;
        synchronized (object) {
            if (this.myARK == null) {
                Logger.minor(this, "No ARK for " + this + " !!!!");
                return;
            }
            if (this.arkFetcher == null) {
                Logger.minor(this, "Starting ARK fetcher for " + this + " : " + this.myARK);
                this.arkFetcher = this.node.clientCore.uskManager.subscribeContent(this.myARK, this, true, this.node.arkFetcherContext, (short)2, this.node.nonPersistentClientRT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopARKFetcher() {
        USKRetriever ret;
        if (!this.node.enableARKs) {
            return;
        }
        Logger.minor(this, "Stopping ARK fetcher for " + this + " : " + this.myARK);
        Object object = this.arkFetcherSync;
        synchronized (object) {
            if (this.arkFetcher == null) {
                if (logMINOR) {
                    Logger.minor(this, "ARK fetcher not running for " + this);
                }
                return;
            }
            ret = this.arkFetcher;
            this.arkFetcher = null;
        }
        final USKRetriever unsub = ret;
        this.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                PeerNode.this.node.clientCore.uskManager.unsubscribeContent(PeerNode.this.myARK, unsub, true);
            }
        });
    }

    @Override
    public short getPollingPriorityNormal() {
        return 2;
    }

    @Override
    public short getPollingPriorityProgress() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeSendInitialMessages() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.sentInitialMessages) {
                return;
            }
            if (this.currentTracker == null) {
                return;
            }
            this.sentInitialMessages = true;
        }
        this.sendInitialMessages();
    }

    protected void sendInitialMessages() {
        this.loadSender(true).setSendASAP();
        this.loadSender(false).setSendASAP();
        Message locMsg = DMT.createFNPLocChangeNotificationNew(this.node.lm.getLocation(), this.node.peers.getPeerLocationDoubles(true));
        Message ipMsg = DMT.createFNPDetectedIPAddress(this.detectedPeer);
        Message timeMsg = DMT.createFNPTime(System.currentTimeMillis());
        Message dRoutingMsg = DMT.createRoutingStatus(!this.disableRoutingHasBeenSetLocally);
        Message uptimeMsg = DMT.createFNPUptime((byte)(100.0 * this.node.uptime.getUptime()));
        try {
            if (this.isRealConnection()) {
                this.sendAsync(locMsg, null, this.node.nodeStats.initialMessagesCtr);
            }
            this.sendAsync(ipMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(timeMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(dRoutingMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(uptimeMsg, null, this.node.nodeStats.initialMessagesCtr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Completed handshake with " + this.getPeer() + " but disconnected (" + this.isConnected + ':' + this.currentTracker + "!!!: " + e, (Throwable)e);
        }
        this.sendConnectedDiffNoderef();
    }

    private void sendIPAddressMessage() {
        Message ipMsg = DMT.createFNPDetectedIPAddress(this.detectedPeer);
        try {
            this.sendAsync(ipMsg, null, this.node.nodeStats.changedIPCtr);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Sending IP change message to " + this + " but disconnected: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verified(SessionKey tracker) {
        SessionKey completelyDeprecatedTracker;
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (tracker == this.unverifiedTracker) {
                if (logMINOR) {
                    Logger.minor(this, "Promoting unverified tracker " + tracker + " for " + this.getPeer());
                }
            } else {
                return;
            }
            completelyDeprecatedTracker = this.previousTracker;
            this.previousTracker = this.currentTracker;
            this.currentTracker = this.unverifiedTracker;
            this.unverifiedTracker = null;
            this.isConnected.set(true, now);
            this.neverConnected = false;
            this.maybeClearPeerAddedTimeOnConnect();
            this.ctx = null;
        }
        this.maybeSendInitialMessages();
        this.setPeerNodeStatus(now);
        this.node.peers.addConnectedPeer(this);
        this.maybeOnConnect();
        if (completelyDeprecatedTracker != null) {
            completelyDeprecatedTracker.disconnected();
        }
    }

    private synchronized boolean invalidVersion() {
        return this.bogusNoderef || this.forwardInvalidVersion() || this.reverseInvalidVersion();
    }

    private synchronized boolean forwardInvalidVersion() {
        return !Version.checkGoodVersion(this.version);
    }

    private synchronized boolean reverseInvalidVersion() {
        if (this.ignoreLastGoodVersion()) {
            return false;
        }
        return !Version.checkArbitraryGoodVersion(Version.getVersionString(), this.lastGoodVersion);
    }

    public boolean publicInvalidVersion() {
        return this.unroutableOlderVersion;
    }

    public synchronized boolean publicReverseInvalidVersion() {
        return this.unroutableNewerVersion;
    }

    public synchronized boolean dontRoute() {
        return this.disableRouting;
    }

    public void processDiffNoderef(SimpleFieldSet fs) throws FSParseException {
        this.processNewNoderef(fs, false, true, false);
        if (this.isRealConnection()) {
            this.node.nodeUpdater.maybeSendUOMAnnounce(this);
        }
    }

    private void processNewNoderef(byte[] data, int offset, int length) throws FSParseException {
        SimpleFieldSet fs = PeerNode.compressedNoderefToFieldSet(data, offset, length);
        this.processNewNoderef(fs, false, false, false);
    }

    static SimpleFieldSet compressedNoderefToFieldSet(byte[] data, int offset, int length) throws FSParseException {
        InputStreamReader isr;
        if (length <= 5) {
            throw new FSParseException("Too short");
        }
        byte firstByte = data[offset];
        ++offset;
        --length;
        if ((firstByte & 2) == 2) {
            int groupIndex = data[offset] & 0xFF;
            ++offset;
            --length;
        }
        if ((firstByte & 1) == 1) {
            try {
                Inflater i = new Inflater();
                i.setInput(data, offset, length);
                byte[] output = new byte[4096];
                length = i.inflate(output, 0, output.length);
                data = output;
                offset = 0;
                if (logMINOR) {
                    Logger.minor(PeerNode.class, "We have decompressed a " + length + " bytes big reference.");
                }
            }
            catch (DataFormatException e) {
                throw new FSParseException("Invalid compressed data");
            }
        }
        if (logMINOR) {
            Logger.minor(PeerNode.class, "Reference: " + HexUtil.bytesToHex(data, offset, length) + '(' + length + ')');
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, length);
        try {
            isr = new InputStreamReader((InputStream)bais, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e1, e1);
        }
        BufferedReader br = new BufferedReader(isr);
        try {
            SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
            return fs;
        }
        catch (IOException e) {
            throw (FSParseException)new FSParseException("Impossible: " + e).initCause(e);
        }
    }

    protected void processNewNoderef(SimpleFieldSet fs, boolean forARK, boolean forDiffNodeRef, boolean forFullNodeRef) throws FSParseException {
        boolean changedAnything;
        if (logMINOR) {
            Logger.minor(this, "Parsing: \n" + fs);
        }
        boolean bl = changedAnything = this.innerProcessNewNoderef(fs, forARK, forDiffNodeRef, forFullNodeRef) || forARK;
        if (changedAnything && !this.isSeed()) {
            this.writePeers();
        }
    }

    protected synchronized boolean innerProcessNewNoderef(SimpleFieldSet fs, boolean forARK, boolean forDiffNodeRef, boolean forFullNodeRef) throws FSParseException {
        SimpleFieldSet sfs;
        boolean changedAnything;
        boolean shouldUpdatePeerCounts;
        block60: {
            String newLastGoodVersion;
            String newVersion;
            String identityString;
            shouldUpdatePeerCounts = false;
            if (forFullNodeRef) {
                try {
                    if (!this.verifyReferenceSignature(fs)) {
                        throw new FSParseException("Invalid signature");
                    }
                }
                catch (ReferenceSignatureVerificationException e) {
                    throw new FSParseException("Invalid signature");
                }
            }
            changedAnything = false;
            if (!forDiffNodeRef && fs.getBoolean("testnet", false)) {
                String err = "Preventing connection to node " + this.detectedPeer + " - testnet is enabled!";
                Logger.error(this, err);
                throw new FSParseException(err);
            }
            String s = fs.get("opennet");
            if (s == null && forFullNodeRef) {
                throw new FSParseException("No opennet ref");
            }
            if (s != null) {
                try {
                    boolean b = Fields.stringToBool(s);
                    if (b != this.isOpennetForNoderef()) {
                        throw new FSParseException("Changed opennet status?!?!?!? expected=" + this.isOpennetForNoderef() + " but got " + b + " (" + s + ") on " + this);
                    }
                }
                catch (NumberFormatException e) {
                    throw new FSParseException("Cannot parse opennet=\"" + s + "\"", e);
                }
            }
            if ((identityString = fs.get("identity")) == null && forFullNodeRef) {
                if (this.isDarknet()) {
                    throw new FSParseException("No identity!");
                }
                if (logMINOR) {
                    Logger.minor(this, "didn't send an identity; let's assume it's pre-1471");
                }
            } else if (identityString != null) {
                try {
                    byte[] id = Base64.decode(identityString);
                    if (!Arrays.equals(id, this.identity)) {
                        throw new FSParseException("Changing the identity");
                    }
                }
                catch (NumberFormatException e) {
                    throw new FSParseException(e);
                }
                catch (IllegalBase64Exception e) {
                    throw new FSParseException(e);
                }
            }
            if ((newVersion = fs.get("version")) == null) {
                if (!forARK && !forDiffNodeRef) {
                    throw new FSParseException("No version");
                }
            } else {
                if (!newVersion.equals(this.version)) {
                    changedAnything = true;
                }
                this.version = newVersion;
                if (this.version != null) {
                    try {
                        this.simpleVersion = Version.getArbitraryBuildNumber(this.version);
                    }
                    catch (VersionParseException e) {
                        Logger.error(this, "Bad version: " + this.version + " : " + e, (Throwable)e);
                    }
                }
                Version.seenVersion(newVersion);
            }
            if ((newLastGoodVersion = fs.get("lastGoodVersion")) != null) {
                this.lastGoodVersion = newLastGoodVersion;
            } else if (forFullNodeRef) {
                throw new FSParseException("No lastGoodVersion");
            }
            this.updateVersionRoutablity();
            String locationString = fs.get("location");
            if (locationString != null) {
                double newLoc = Location.getLocation(locationString);
                if (!Location.isValid(newLoc)) {
                    if (logMINOR) {
                        Logger.minor(this, "Invalid or null location, waiting for FNPLocChangeNotification: locationString=" + locationString);
                    }
                } else {
                    double oldLoc = this.location.setLocation(newLoc);
                    if (!Location.equals(oldLoc, newLoc)) {
                        if (!Location.isValid(oldLoc)) {
                            shouldUpdatePeerCounts = true;
                        }
                        changedAnything = true;
                    }
                }
            }
            try {
                String[] physical = fs.getAll("physical.udp");
                if (physical != null) {
                    List<Peer> oldNominalPeer = this.nominalPeer;
                    this.nominalPeer = new ArrayList<Peer>(physical.length);
                    Object[] oldPeers = oldNominalPeer.toArray(new Peer[oldNominalPeer.size()]);
                    for (String phys : physical) {
                        Peer p;
                        try {
                            p = new Peer(phys, true, true);
                        }
                        catch (HostnameSyntaxException e) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing new peer reference: " + phys);
                            continue;
                        }
                        catch (PeerParseException e) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing new peer reference: " + phys);
                            continue;
                        }
                        catch (UnknownHostException e) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing new peer reference: " + phys);
                            continue;
                        }
                        if (this.nominalPeer.contains(p)) continue;
                        if (oldNominalPeer.contains(p)) {
                            // empty if block
                        }
                        this.nominalPeer.add(p);
                    }
                    if (!Arrays.equals(oldPeers, this.nominalPeer.toArray(new Peer[this.nominalPeer.size()]))) {
                        changedAnything = true;
                        if (logMINOR) {
                            Logger.minor(this, "Got new physical.udp for " + this + " : " + Arrays.toString(this.nominalPeer.toArray()));
                        }
                        this.lastAttemptedHandshakeIPUpdateTime = 0L;
                        this.jfkNoncesSent.clear();
                    }
                    break block60;
                }
                if (forARK || forFullNodeRef) {
                    Logger.error(this, "ARK noderef has no physical.udp for " + this + " : forDiffNodeRef=" + forDiffNodeRef + " forARK=" + forARK);
                    if (forFullNodeRef) {
                        throw new FSParseException("ARK noderef has no physical.udp");
                    }
                }
            }
            catch (Exception e1) {
                Logger.error(this, "Caught " + e1, (Throwable)e1);
                throw new FSParseException(e1);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Parsed successfully; changedAnything = " + changedAnything);
        }
        int[] newNegTypes = fs.getIntArray("auth.negTypes");
        boolean refHadNegTypes = false;
        if (newNegTypes == null || newNegTypes.length == 0) {
            newNegTypes = new int[]{0};
        } else {
            refHadNegTypes = true;
        }
        if (!(forDiffNodeRef && !refHadNegTypes || Arrays.equals(this.negTypes, newNegTypes))) {
            changedAnything = true;
            this.negTypes = newNegTypes;
        }
        if ((sfs = fs.subset("ecdsa.P256")) != null) {
            byte[] pub;
            try {
                pub = Base64.decode(sfs.get("pub"));
            }
            catch (IllegalBase64Exception e) {
                Logger.error(this, "Caught " + e + " parsing ECC pubkey", (Throwable)e);
                throw new FSParseException(e);
            }
            if (pub.length > ECDSA.Curves.P256.modulusSize) {
                throw new FSParseException("ecdsa.P256.pub is not the right size!");
            }
            ECPublicKey key = ECDSA.getPublicKey(pub, ECDSA.Curves.P256);
            if (key == null) {
                throw new FSParseException("ecdsa.P256.pub is invalid!");
            }
            if (!key.equals(this.peerECDSAPubKey)) {
                Logger.error(this, "Tried to change ECDSA key on " + this.userToString() + " - did neighbour try to downgrade? Rejecting...");
                throw new FSParseException("Changing ECDSA key not allowed!");
            }
        }
        if (this.parseARK(fs, false, forDiffNodeRef)) {
            changedAnything = true;
        }
        if (shouldUpdatePeerCounts) {
            this.node.executor.execute(new Runnable(){

                @Override
                public void run() {
                    PeerNode.this.node.peers.updatePMUserAlert();
                }
            });
        }
        return changedAnything;
    }

    public abstract PeerNodeStatus getStatus(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTMCIPeerInfo() {
        long now = System.currentTimeMillis();
        int idle = -1;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            idle = (int)((now - this.timeLastReceivedPacket) / 1000L);
        }
        if (this.getPeerNodeStatus() == 6 && this.getPeerAddedTime() > 1L) {
            idle = (int)((now - this.getPeerAddedTime()) / 1000L);
        }
        return String.valueOf(this.getPeer()) + '\t' + this.getIdentityString() + '\t' + this.getLocation() + '\t' + this.getPeerNodeStatusString() + '\t' + idle;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    private synchronized String getLastGoodVersion() {
        return this.lastGoodVersion;
    }

    public int getSimpleVersion() {
        return this.simpleVersion;
    }

    public void write(Writer w) throws IOException {
        SimpleFieldSet fs = this.exportFieldSet();
        SimpleFieldSet meta = this.exportMetadataFieldSet(System.currentTimeMillis());
        if (!meta.isEmpty()) {
            fs.put("metadata", meta);
        }
        fs.writeTo(w);
    }

    public synchronized SimpleFieldSet exportDiskFieldSet() {
        SimpleFieldSet fs = this.exportFieldSet();
        SimpleFieldSet meta = this.exportMetadataFieldSet(System.currentTimeMillis());
        if (!meta.isEmpty()) {
            fs.put("metadata", meta);
        }
        if (this.fullFieldSet != null) {
            fs.put("full", this.fullFieldSet);
        }
        return fs;
    }

    public synchronized SimpleFieldSet exportMetadataFieldSet(long now) {
        double[] peerLocs;
        long timeLastConnected;
        SimpleFieldSet fs = new SimpleFieldSet(true);
        if (this.detectedPeer != null) {
            fs.putSingle("detected.udp", this.detectedPeer.toStringPrefNumeric());
        }
        if (this.lastReceivedPacketTime() > 0L) {
            fs.put("timeLastReceivedPacket", this.timeLastReceivedPacket);
        }
        if (this.lastReceivedAckTime() > 0L) {
            fs.put("timeLastReceivedAck", this.timeLastReceivedAck);
        }
        if ((timeLastConnected = this.isConnected.getTimeLastTrue(now)) > 0L) {
            fs.put("timeLastConnected", timeLastConnected);
        }
        if (this.timeLastRoutable() > 0L) {
            fs.put("timeLastRoutable", this.timeLastRoutable);
        }
        if (this.getPeerAddedTime() > 0L && this.shouldExportPeerAddedTime()) {
            fs.put("peerAddedTime", this.peerAddedTime);
        }
        if (this.neverConnected) {
            fs.putSingle("neverConnected", "true");
        }
        if (this.hadRoutableConnectionCount > 0L) {
            fs.put("hadRoutableConnectionCount", this.hadRoutableConnectionCount);
        }
        if (this.routableConnectionCheckCount > 0L) {
            fs.put("routableConnectionCheckCount", this.routableConnectionCheckCount);
        }
        if ((peerLocs = this.getPeersLocationArray()) != null) {
            fs.put("peersLocation", peerLocs);
        }
        return fs;
    }

    protected abstract boolean shouldExportPeerAddedTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet exportVolatileFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            fs.put("averagePingTime", this.averagePingTime());
            long idle = now - this.lastReceivedPacketTime();
            if (idle > TimeUnit.SECONDS.toMillis(60L) && -1L != this.lastReceivedPacketTime()) {
                fs.put("idle", idle);
            }
            if (this.peerAddedTime > 1L) {
                fs.put("peerAddedTime", this.peerAddedTime);
            }
            fs.putSingle("lastRoutingBackoffReasonRT", this.lastRoutingBackoffReasonRT);
            fs.putSingle("lastRoutingBackoffReasonBulk", this.lastRoutingBackoffReasonBulk);
            fs.put("routingBackoffPercent", this.backedOffPercent.currentValue() * 100.0);
            fs.put("routingBackoffRT", Math.max(Math.max(this.routingBackedOffUntilRT, this.transferBackedOffUntilRT) - now, 0L));
            fs.put("routingBackoffBulk", Math.max(Math.max(this.routingBackedOffUntilBulk, this.transferBackedOffUntilBulk) - now, 0L));
            fs.put("routingBackoffLengthRT", this.routingBackoffLengthRT);
            fs.put("routingBackoffLengthBulk", this.routingBackoffLengthBulk);
            fs.put("overloadProbability", this.getPRejected() * 100.0);
            fs.put("percentTimeRoutableConnection", this.getPercentTimeRoutableConnection() * 100.0);
        }
        fs.putSingle("status", this.getPeerNodeStatusString());
        return fs;
    }

    public synchronized SimpleFieldSet exportFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        if (this.getLastGoodVersion() != null) {
            fs.putSingle("lastGoodVersion", this.lastGoodVersion);
        }
        for (int i = 0; i < this.nominalPeer.size(); ++i) {
            fs.putAppend("physical.udp", this.nominalPeer.get(i).toString());
        }
        fs.put("auth.negTypes", this.negTypes);
        fs.putSingle("identity", this.getIdentityString());
        fs.put("location", this.getLocation());
        fs.put("testnet", this.testnetEnabled);
        fs.putSingle("version", this.version);
        fs.put("ecdsa", ECDSA.Curves.P256.getSFS(this.peerECDSAPubKey));
        if (this.myARK != null) {
            fs.put("ark.number", this.myARK.suggestedEdition - 1L);
            fs.putSingle("ark.pubURI", this.myARK.getBaseSSK().toString(false, false));
        }
        fs.put("opennet", this.isOpennetForNoderef());
        fs.put("seed", this.isSeed());
        fs.put("totalInput", this.getTotalInputBytes());
        fs.put("totalOutput", this.getTotalOutputBytes());
        return fs;
    }

    public abstract boolean isDarknet();

    public abstract boolean isOpennet();

    public abstract boolean isOpennetForNoderef();

    public abstract boolean isSeed();

    public synchronized long timeLastConnectionCompleted() {
        return this.connectedTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PeerNode) {
            PeerNode pn = (PeerNode)o;
            return Arrays.equals(pn.peerECDSAPubKeyHash, this.peerECDSAPubKeyHash);
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoutingBackedOff(long ignoreBackoffUnder, boolean realTime) {
        double pingTime;
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long transferBackedOffUntil;
            long routingBackedOffUntil;
            long l = routingBackedOffUntil = realTime ? this.routingBackedOffUntilRT : this.routingBackedOffUntilBulk;
            if (now < routingBackedOffUntil && routingBackedOffUntil - now >= ignoreBackoffUnder) {
                return true;
            }
            long l2 = transferBackedOffUntil = realTime ? this.transferBackedOffUntilRT : this.transferBackedOffUntilBulk;
            if (now < transferBackedOffUntil && transferBackedOffUntil - now >= ignoreBackoffUnder) {
                return true;
            }
            if (this.isInMandatoryBackoff(now, realTime)) {
                return true;
            }
            pingTime = this.averagePingTime();
        }
        return pingTime > (double)this.maxPeerPingTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoutingBackedOff(boolean realTime) {
        double pingTime;
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long transferBackedOffUntil;
            long routingBackedOffUntil = realTime ? this.routingBackedOffUntilRT : this.routingBackedOffUntilBulk;
            long l = transferBackedOffUntil = realTime ? this.transferBackedOffUntilRT : this.transferBackedOffUntilBulk;
            if (now < routingBackedOffUntil || now < transferBackedOffUntil) {
                return true;
            }
            pingTime = this.averagePingTime();
        }
        return pingTime > (double)this.maxPeerPingTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoutingBackedOffEither() {
        double pingTime;
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long routingBackedOffUntil = Math.max(this.routingBackedOffUntilRT, this.routingBackedOffUntilBulk);
            long transferBackedOffUntil = Math.max(this.transferBackedOffUntilRT, this.transferBackedOffUntilBulk);
            if (now < routingBackedOffUntil || now < transferBackedOffUntil) {
                return true;
            }
            pingTime = this.averagePingTime();
        }
        return pingTime > (double)this.maxPeerPingTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterMandatoryBackoff(String reason, boolean realTime) {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            int mandatoryBackoffLength;
            long mandatoryBackoffUntil = realTime ? this.mandatoryBackoffUntilRT : this.mandatoryBackoffUntilBulk;
            int n = mandatoryBackoffLength = realTime ? this.mandatoryBackoffLengthRT : this.mandatoryBackoffLengthBulk;
            if (mandatoryBackoffUntil > -1L && mandatoryBackoffUntil > now) {
                return;
            }
            Logger.error(this, "Entering mandatory backoff for " + this + (realTime ? " (realtime)" : " (bulk)"));
            mandatoryBackoffUntil = now + (long)(mandatoryBackoffLength / 2) + (long)this.node.fastWeakRandom.nextInt(mandatoryBackoffLength / 2);
            mandatoryBackoffLength *= 2;
            this.node.nodeStats.reportMandatoryBackoff(reason, mandatoryBackoffUntil - now, realTime);
            if (realTime) {
                this.mandatoryBackoffLengthRT = mandatoryBackoffLength;
                this.mandatoryBackoffUntilRT = mandatoryBackoffUntil;
            } else {
                this.mandatoryBackoffLengthBulk = mandatoryBackoffLength;
                this.mandatoryBackoffUntilBulk = mandatoryBackoffUntil;
            }
            this.setLastBackoffReason(reason, realTime);
        }
        if (realTime) {
            this.outputLoadTrackerRealTime.failSlotWaiters(true);
        } else {
            this.outputLoadTrackerBulk.failSlotWaiters(true);
        }
    }

    public synchronized void resetMandatoryBackoff(boolean realTime) {
        if (realTime) {
            this.mandatoryBackoffLengthRT = INITIAL_MANDATORY_BACKOFF_LENGTH;
        } else {
            this.mandatoryBackoffLengthBulk = INITIAL_MANDATORY_BACKOFF_LENGTH;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportBackoffStatus(long now) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (now > this.lastSampleTime) {
                double report = 0.0;
                if (now > this.routingBackedOffUntilRT) {
                    if (this.lastSampleTime > this.routingBackedOffUntilRT) {
                        this.backedOffPercentRT.report(0.0);
                        report = 0.0;
                    } else if (this.routingBackedOffUntilRT > 0L) {
                        report = (double)(this.routingBackedOffUntilRT - this.lastSampleTime) / (double)(now - this.lastSampleTime);
                        this.backedOffPercentRT.report(report);
                    }
                } else {
                    report = 0.0;
                    this.backedOffPercentRT.report(1.0);
                }
                if (now > this.routingBackedOffUntilBulk) {
                    if (this.lastSampleTime > this.routingBackedOffUntilBulk) {
                        report = 0.0;
                        this.backedOffPercentBulk.report(0.0);
                    } else if (this.routingBackedOffUntilBulk > 0L) {
                        double myReport = (double)(this.routingBackedOffUntilBulk - this.lastSampleTime) / (double)(now - this.lastSampleTime);
                        this.backedOffPercentBulk.report(myReport);
                        if (report > myReport) {
                            report = myReport;
                        }
                    }
                } else {
                    this.backedOffPercentBulk.report(1.0);
                }
                this.backedOffPercent.report(report);
            }
            this.lastSampleTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localRejectedOverload(String reason, boolean realTime) {
        assert (reason.indexOf(32) == -1);
        this.pRejected.report(1.0);
        if (logMINOR) {
            Logger.minor(this, "Local rejected overload (" + reason + ") on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        long now = System.currentTimeMillis();
        Peer peer = this.getPeer();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            int routingBackoffLength;
            long routingBackedOffUntil = realTime ? this.routingBackedOffUntilRT : this.routingBackedOffUntilBulk;
            int n = routingBackoffLength = realTime ? this.routingBackoffLengthRT : this.routingBackoffLengthBulk;
            if (now > routingBackedOffUntil) {
                if ((routingBackoffLength *= 2) > MAX_ROUTING_BACKOFF_LENGTH) {
                    routingBackoffLength = MAX_ROUTING_BACKOFF_LENGTH;
                }
                int x = this.node.random.nextInt(routingBackoffLength);
                routingBackedOffUntil = now + (long)x;
                this.node.nodeStats.reportRoutingBackoff(reason, x, realTime);
                if (logMINOR) {
                    String reasonWrapper = "";
                    if (0 < reason.length()) {
                        reasonWrapper = " because of '" + reason + '\'';
                    }
                    Logger.minor(this, "Backing off" + reasonWrapper + ": routingBackoffLength=" + routingBackoffLength + ", until " + x + "ms on " + peer);
                }
                if (realTime) {
                    this.routingBackedOffUntilRT = routingBackedOffUntil;
                    this.routingBackoffLengthRT = routingBackoffLength;
                } else {
                    this.routingBackedOffUntilBulk = routingBackedOffUntil;
                    this.routingBackoffLengthBulk = routingBackoffLength;
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring localRejectedOverload: " + (routingBackedOffUntil - now) + "ms remaining on routing backoff on " + peer);
                }
                return;
            }
            this.setLastBackoffReason(reason, realTime);
        }
        this.setPeerNodeStatus(now);
        if (realTime) {
            this.outputLoadTrackerRealTime.failSlotWaiters(true);
        } else {
            this.outputLoadTrackerBulk.failSlotWaiters(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void successNotOverload(boolean realTime) {
        this.pRejected.report(0.0);
        if (logMINOR) {
            Logger.minor(this, "Success not overload on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        Peer peer = this.getPeer();
        long now = System.currentTimeMillis();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long until = realTime ? this.routingBackedOffUntilRT : this.routingBackedOffUntilBulk;
            if (now > until) {
                if (realTime) {
                    this.routingBackoffLengthRT = INITIAL_ROUTING_BACKOFF_LENGTH;
                } else {
                    this.routingBackoffLengthBulk = INITIAL_ROUTING_BACKOFF_LENGTH;
                }
                if (logMINOR) {
                    Logger.minor(this, "Resetting routing backoff on " + peer);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring successNotOverload: " + (until - now) + "ms remaining on routing backoff on " + peer);
                }
                return;
            }
        }
        this.setPeerNodeStatus(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFailed(String reason, boolean realTime) {
        assert (reason.indexOf(32) == -1);
        this.pRejected.report(1.0);
        if (logMINOR) {
            Logger.minor(this, "Transfer failed (" + reason + ") on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        long now = System.currentTimeMillis();
        Peer peer = this.getPeer();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            int transferBackoffLength;
            long transferBackedOffUntil = realTime ? this.transferBackedOffUntilRT : this.transferBackedOffUntilBulk;
            int n = transferBackoffLength = realTime ? this.transferBackoffLengthRT : this.transferBackoffLengthBulk;
            if (now > transferBackedOffUntil) {
                if ((transferBackoffLength *= 2) > MAX_TRANSFER_BACKOFF_LENGTH) {
                    transferBackoffLength = MAX_TRANSFER_BACKOFF_LENGTH;
                }
                int x = this.node.random.nextInt(transferBackoffLength);
                transferBackedOffUntil = now + (long)x;
                this.node.nodeStats.reportTransferBackoff(reason, x, realTime);
                if (logMINOR) {
                    String reasonWrapper = "";
                    if (0 < reason.length()) {
                        reasonWrapper = " because of '" + reason + '\'';
                    }
                    Logger.minor(this, "Backing off (transfer)" + reasonWrapper + ": transferBackoffLength=" + transferBackoffLength + ", until " + x + "ms on " + peer);
                }
                if (realTime) {
                    this.transferBackedOffUntilRT = transferBackedOffUntil;
                    this.transferBackoffLengthRT = transferBackoffLength;
                } else {
                    this.transferBackedOffUntilBulk = transferBackedOffUntil;
                    this.transferBackoffLengthBulk = transferBackoffLength;
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transfer failure: " + (transferBackedOffUntil - now) + "ms remaining on transfer backoff on " + peer);
                }
                return;
            }
            this.setLastBackoffReason(reason, realTime);
        }
        if (realTime) {
            this.outputLoadTrackerRealTime.failSlotWaiters(true);
        } else {
            this.outputLoadTrackerBulk.failSlotWaiters(true);
        }
        this.setPeerNodeStatus(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferSuccess(boolean realTime) {
        this.pRejected.report(0.0);
        if (logMINOR) {
            Logger.minor(this, "Transfer success on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        Peer peer = this.getPeer();
        long now = System.currentTimeMillis();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long until = realTime ? this.transferBackedOffUntilRT : this.transferBackedOffUntilBulk;
            if (now > until) {
                if (realTime) {
                    this.transferBackoffLengthRT = INITIAL_TRANSFER_BACKOFF_LENGTH;
                } else {
                    this.transferBackoffLengthBulk = INITIAL_TRANSFER_BACKOFF_LENGTH;
                }
                if (logMINOR) {
                    Logger.minor(this, "Resetting transfer backoff on " + peer);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transfer success: " + (until - now) + "ms remaining on transfer backoff on " + peer);
                }
                return;
            }
        }
        this.setPeerNodeStatus(now);
    }

    public double getPRejected() {
        return this.pRejected.currentValue();
    }

    @Override
    public double averagePingTime() {
        return this.pingAverage.currentValue();
    }

    @Override
    public synchronized double averagePingTimeCorrected() {
        return this.RTO;
    }

    @Override
    public void reportThrottledPacketSendTime(long timeDiff, boolean realTime) {
        if (logMINOR) {
            Logger.minor(this, "Reporting throttled packet send time: " + timeDiff + " to " + this.getPeer() + " (" + (realTime ? "realtime" : "bulk") + ")");
        }
    }

    public void setRemoteDetectedPeer(Peer p) {
        this.remoteDetectedPeer = p;
    }

    public Peer getRemoteDetectedPeer() {
        return this.remoteDetectedPeer;
    }

    public synchronized long getRoutingBackoffLength(boolean realTime) {
        return realTime ? (long)this.routingBackoffLengthRT : (long)this.routingBackoffLengthBulk;
    }

    public synchronized long getRoutingBackedOffUntil(boolean realTime) {
        return Math.max(realTime ? this.mandatoryBackoffUntilRT : this.mandatoryBackoffUntilBulk, Math.max(realTime ? this.routingBackedOffUntilRT : this.routingBackedOffUntilBulk, realTime ? this.transferBackedOffUntilRT : this.transferBackedOffUntilBulk));
    }

    public synchronized long getRoutingBackedOffUntilMax() {
        return Math.max(Math.max(this.mandatoryBackoffUntilRT, this.mandatoryBackoffUntilBulk), Math.max(Math.max(this.routingBackedOffUntilRT, this.routingBackedOffUntilBulk), Math.max(this.transferBackedOffUntilRT, this.transferBackedOffUntilBulk)));
    }

    public synchronized long getRoutingBackedOffUntilRT() {
        return Math.max(this.routingBackedOffUntilRT, this.transferBackedOffUntilRT);
    }

    public synchronized long getRoutingBackedOffUntilBulk() {
        return Math.max(this.routingBackedOffUntilBulk, this.transferBackedOffUntilBulk);
    }

    public synchronized String getLastBackoffReason(boolean realTime) {
        return realTime ? this.lastRoutingBackoffReasonRT : this.lastRoutingBackoffReasonBulk;
    }

    public synchronized String getPreviousBackoffReason(boolean realTime) {
        return realTime ? this.previousRoutingBackoffReasonRT : this.previousRoutingBackoffReasonBulk;
    }

    public synchronized void setLastBackoffReason(String s, boolean realTime) {
        if (realTime) {
            this.lastRoutingBackoffReasonRT = s;
        } else {
            this.lastRoutingBackoffReasonBulk = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLocalNodeSentMessagesToStatistic(Message m) {
        String messageSpecName = m.getSpec().getName();
        Hashtable<String, Long> hashtable = this.localNodeSentMessageTypes;
        synchronized (hashtable) {
            Long count = this.localNodeSentMessageTypes.get(messageSpecName);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            this.localNodeSentMessageTypes.put(messageSpecName, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLocalNodeReceivedMessagesFromStatistic(Message m) {
        String messageSpecName = m.getSpec().getName();
        Hashtable<String, Long> hashtable = this.localNodeReceivedMessageTypes;
        synchronized (hashtable) {
            Long count = this.localNodeReceivedMessageTypes.get(messageSpecName);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            this.localNodeReceivedMessageTypes.put(messageSpecName, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Long> getLocalNodeSentMessagesToStatistic() {
        Hashtable<String, Long> hashtable = this.localNodeSentMessageTypes;
        synchronized (hashtable) {
            return new Hashtable<String, Long>(this.localNodeSentMessageTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Long> getLocalNodeReceivedMessagesFromStatistic() {
        Hashtable<String, Long> hashtable = this.localNodeReceivedMessageTypes;
        synchronized (hashtable) {
            return new Hashtable<String, Long>(this.localNodeReceivedMessageTypes);
        }
    }

    synchronized USK getARK() {
        return this.myARK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotARK(SimpleFieldSet fs, long fetchedEdition) {
        try {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.handshakeCount = 0;
                if (this.myARK.suggestedEdition < fetchedEdition + 1L) {
                    this.myARK = this.myARK.copy(fetchedEdition + 1L);
                }
            }
            this.processNewNoderef(fs, true, false, false);
        }
        catch (FSParseException e) {
            Logger.error(this, "Invalid ARK update: " + e, (Throwable)e);
            Logger.error(this, "Data was: \n" + fs.toString());
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.handshakeCount = 2;
            }
        }
    }

    public synchronized int getPeerNodeStatus() {
        return this.peerNodeStatus;
    }

    public String getPeerNodeStatusString() {
        int status = this.getPeerNodeStatus();
        return PeerNode.getPeerNodeStatusString(status);
    }

    public static String getPeerNodeStatusString(int status) {
        if (status == 1) {
            return "CONNECTED";
        }
        if (status == 2) {
            return "BACKED OFF";
        }
        if (status == 3) {
            return "TOO NEW";
        }
        if (status == 4) {
            return "TOO OLD";
        }
        if (status == 5) {
            return "DISCONNECTED";
        }
        if (status == 6) {
            return "NEVER CONNECTED";
        }
        if (status == 7) {
            return "DISABLED";
        }
        if (status == 11) {
            return "CLOCK PROBLEM";
        }
        if (status == 12) {
            return "CONNECTION ERROR";
        }
        if (status == 14) {
            return "ROUTING DISABLED";
        }
        if (status == 10) {
            return "LISTEN ONLY";
        }
        if (status == 9) {
            return "LISTENING";
        }
        if (status == 8) {
            return "BURSTING";
        }
        if (status == 13) {
            return "DISCONNECTING";
        }
        if (status == 15) {
            return "NO LOAD STATS";
        }
        return "UNKNOWN STATUS";
    }

    public String getPeerNodeStatusCSSClassName() {
        int status = this.getPeerNodeStatus();
        return PeerNode.getPeerNodeStatusCSSClassName(status);
    }

    public static String getPeerNodeStatusCSSClassName(int status) {
        if (status == 1) {
            return "peer_connected";
        }
        if (status == 2) {
            return "peer_backed_off";
        }
        if (status == 3) {
            return "peer_too_new";
        }
        if (status == 4) {
            return "peer_too_old";
        }
        if (status == 5) {
            return "peer_disconnected";
        }
        if (status == 6) {
            return "peer_never_connected";
        }
        if (status == 7) {
            return "peer_disabled";
        }
        if (status == 14) {
            return "peer_routing_disabled";
        }
        if (status == 8) {
            return "peer_bursting";
        }
        if (status == 11) {
            return "peer_clock_problem";
        }
        if (status == 9) {
            return "peer_listening";
        }
        if (status == 10) {
            return "peer_listen_only";
        }
        if (status == 13) {
            return "peer_disconnecting";
        }
        if (status == 15) {
            return "peer_no_load_stats";
        }
        return "peer_unknown_status";
    }

    protected synchronized int getPeerNodeStatus(long now, long routingBackedOffUntilRT, long localRoutingBackedOffUntilBulk, boolean overPingTime, boolean noLoadStats) {
        if (this.disconnecting) {
            return 13;
        }
        boolean isConnected = this.isConnected();
        if (this.isRoutable()) {
            if (noLoadStats) {
                this.peerNodeStatus = 15;
            } else {
                this.peerNodeStatus = 1;
                if (overPingTime && (this.lastRoutingBackoffReasonRT == null || now >= routingBackedOffUntilRT)) {
                    this.lastRoutingBackoffReasonRT = "TooHighPing";
                }
                if (now < routingBackedOffUntilRT || overPingTime || this.isInMandatoryBackoff(now, true)) {
                    this.peerNodeStatus = 2;
                    if (!this.lastRoutingBackoffReasonRT.equals(this.previousRoutingBackoffReasonRT) || this.previousRoutingBackoffReasonRT == null) {
                        if (this.previousRoutingBackoffReasonRT != null) {
                            this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReasonRT, this, true);
                        }
                        this.peers.addPeerNodeRoutingBackoffReason(this.lastRoutingBackoffReasonRT, this, true);
                        this.previousRoutingBackoffReasonRT = this.lastRoutingBackoffReasonRT;
                    }
                } else if (this.previousRoutingBackoffReasonRT != null) {
                    this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReasonRT, this, true);
                    this.previousRoutingBackoffReasonRT = null;
                }
                if (overPingTime && (this.lastRoutingBackoffReasonBulk == null || now >= this.routingBackedOffUntilBulk)) {
                    this.lastRoutingBackoffReasonBulk = "TooHighPing";
                }
                if (now < this.routingBackedOffUntilBulk || overPingTime || this.isInMandatoryBackoff(now, false)) {
                    this.peerNodeStatus = 2;
                    if (!this.lastRoutingBackoffReasonBulk.equals(this.previousRoutingBackoffReasonBulk) || this.previousRoutingBackoffReasonBulk == null) {
                        if (this.previousRoutingBackoffReasonBulk != null) {
                            this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReasonBulk, this, false);
                        }
                        this.peers.addPeerNodeRoutingBackoffReason(this.lastRoutingBackoffReasonBulk, this, false);
                        this.previousRoutingBackoffReasonBulk = this.lastRoutingBackoffReasonBulk;
                    }
                } else if (this.previousRoutingBackoffReasonBulk != null) {
                    this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReasonBulk, this, false);
                    this.previousRoutingBackoffReasonBulk = null;
                }
            }
        } else if (isConnected && this.bogusNoderef) {
            this.peerNodeStatus = 12;
        } else if (isConnected && this.unroutableNewerVersion) {
            this.peerNodeStatus = 3;
        } else if (isConnected && this.unroutableOlderVersion) {
            this.peerNodeStatus = 4;
        } else if (isConnected && this.disableRouting) {
            this.peerNodeStatus = 14;
        } else if (isConnected && Math.abs(this.clockDelta) > MAX_CLOCK_DELTA) {
            this.peerNodeStatus = 11;
        } else if (this.neverConnected) {
            this.peerNodeStatus = 6;
        } else {
            if (this.isBursting) {
                return 8;
            }
            this.peerNodeStatus = 5;
        }
        if (!isConnected && this.previousRoutingBackoffReasonRT != null) {
            this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReasonRT, this, true);
            this.previousRoutingBackoffReasonRT = null;
        }
        if (!isConnected && this.previousRoutingBackoffReasonBulk != null) {
            this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReasonBulk, this, false);
            this.previousRoutingBackoffReasonBulk = null;
        }
        return this.peerNodeStatus;
    }

    public int setPeerNodeStatus(long now) {
        return this.setPeerNodeStatus(now, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPeerNodeStatus(long now, boolean noLog) {
        long delta;
        int oldPeerNodeStatus;
        long localRoutingBackedOffUntilRT = this.getRoutingBackedOffUntil(true);
        long localRoutingBackedOffUntilBulk = this.getRoutingBackedOffUntil(true);
        long threshold = this.maxPeerPingTime();
        boolean noLoadStats = this.noLoadStats();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            oldPeerNodeStatus = this.peerNodeStatus;
            this.peerNodeStatus = this.getPeerNodeStatus(now, localRoutingBackedOffUntilRT, localRoutingBackedOffUntilBulk, this.averagePingTime() > (double)threshold, noLoadStats);
            if (this.peerNodeStatus != oldPeerNodeStatus && this.recordStatus()) {
                this.peers.changePeerNodeStatus(this, oldPeerNodeStatus, this.peerNodeStatus, noLog);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Peer node status now " + this.peerNodeStatus + " was " + oldPeerNodeStatus);
        }
        if (this.peerNodeStatus != oldPeerNodeStatus) {
            if (oldPeerNodeStatus == 2) {
                this.outputLoadTrackerRealTime.maybeNotifySlotWaiter();
                this.outputLoadTrackerBulk.maybeNotifySlotWaiter();
            }
            this.notifyPeerNodeStatusChangeListeners();
        }
        if (this.peerNodeStatus == 2 && (delta = Math.max(localRoutingBackedOffUntilRT, localRoutingBackedOffUntilBulk) - now + 1L) > 0L) {
            this.node.ticker.queueTimedJob(this.checkStatusAfterBackoff, "Update status for " + this, delta, true, true);
        }
        return this.peerNodeStatus;
    }

    private boolean noLoadStats() {
        if (this.node.enableNewLoadManagement(false) || this.node.enableNewLoadManagement(true)) {
            if (this.outputLoadTrackerRealTime.getLastIncomingLoadStats() == null) {
                if (this.isRoutable()) {
                    Logger.normal(this, "No realtime load stats on " + this);
                }
                return true;
            }
            if (this.outputLoadTrackerBulk.getLastIncomingLoadStats() == null) {
                if (this.isRoutable()) {
                    Logger.normal(this, "No bulk load stats on " + this);
                }
                return true;
            }
        }
        return false;
    }

    public abstract boolean recordStatus();

    public String getIdentityString() {
        return this.identityAsBase64String;
    }

    public boolean isFetchingARK() {
        return this.arkFetcher != null;
    }

    public synchronized int getHandshakeCount() {
        return this.handshakeCount;
    }

    synchronized void updateVersionRoutablity() {
        this.unroutableOlderVersion = this.forwardInvalidVersion();
        this.unroutableNewerVersion = this.reverseInvalidVersion();
    }

    public synchronized boolean noLongerRoutable() {
        return this.unroutableNewerVersion || this.unroutableOlderVersion || this.disableRouting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invalidate(long now) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.isRoutable = false;
        }
        Logger.normal(this, "Invalidated " + this);
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeOnConnect() {
        if (this.wasDisconnected && this.isConnected()) {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.wasDisconnected = false;
            }
            this.onConnect();
        } else if (!this.isConnected()) {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.wasDisconnected = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnect() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.uomCount = 0;
            this.lastSentUOM = -1L;
            this.sendingUOMMainJar = false;
            this.sendingUOMLegacyExtJar = false;
        }
        OpennetManager om = this.node.getOpennet();
        if (om != null) {
            om.onConnectedPeer(this);
        }
    }

    @Override
    public void onFound(USK origUSK, long edition, FetchResult result) {
        String ref;
        byte[] data;
        if (this.isConnected() || this.myARK.suggestedEdition > edition) {
            result.asBucket().free();
            return;
        }
        try {
            data = result.asByteArray();
        }
        catch (IOException e) {
            Logger.error(this, "I/O error reading fetched ARK: " + e, (Throwable)e);
            result.asBucket().free();
            return;
        }
        try {
            ref = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result.asBucket().free();
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        try {
            SimpleFieldSet fs = new SimpleFieldSet(ref, false, true, false);
            if (logMINOR) {
                Logger.minor(this, "Got ARK for " + this);
            }
            this.gotARK(fs, edition);
        }
        catch (IOException e) {
            Logger.error(this, "Corrupt ARK reference? Fetched " + this.myARK.copy(edition) + " got while parsing: " + e + " from:\n" + ref, (Throwable)e);
        }
        result.asBucket().free();
    }

    public synchronized boolean noContactDetails() {
        return this.handshakeIPs == null || this.handshakeIPs.length == 0;
    }

    @Override
    public synchronized void reportIncomingBytes(int length) {
        this.totalInputSinceStartup += (long)length;
        this.totalBytesExchangedWithCurrentTracker += (long)length;
    }

    @Override
    public synchronized void reportOutgoingBytes(int length) {
        this.totalOutputSinceStartup += (long)length;
        this.totalBytesExchangedWithCurrentTracker += (long)length;
    }

    public synchronized long getTotalInputBytes() {
        return this.bytesInAtStartup + this.totalInputSinceStartup;
    }

    public synchronized long getTotalOutputBytes() {
        return this.bytesOutAtStartup + this.totalOutputSinceStartup;
    }

    public synchronized long getTotalInputSinceStartup() {
        return this.totalInputSinceStartup;
    }

    public synchronized long getTotalOutputSinceStartup() {
        return this.totalOutputSinceStartup;
    }

    public boolean isSignatureVerificationSuccessfull() {
        return this.isSignatureVerificationSuccessfull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRoutableConnectionStatus() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.isRoutable()) {
                ++this.hadRoutableConnectionCount;
            }
            ++this.routableConnectionCheckCount;
            if (this.routableConnectionCheckCount >= 200000L) {
                this.hadRoutableConnectionCount /= 2L;
                this.routableConnectionCheckCount /= 2L;
            }
        }
    }

    public synchronized double getPercentTimeRoutableConnection() {
        if (this.hadRoutableConnectionCount == 0L) {
            return 0.0;
        }
        return (double)this.hadRoutableConnectionCount / (double)this.routableConnectionCheckCount;
    }

    @Override
    public int getVersionNumber() {
        return Version.getArbitraryBuildNumber(this.getVersion(), -1);
    }

    @Override
    public PacketThrottle getThrottle() {
        return this._lastThrottle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNegType(OutgoingPacketMangler mangler) {
        int[] hisNegTypes;
        int[] myNegTypes = mangler.supportedNegTypes(false);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            hisNegTypes = this.negTypes;
        }
        int bestNegType = -1;
        block3: for (int negType : myNegTypes) {
            for (int hisNegType : hisNegTypes) {
                if (hisNegType != negType) continue;
                bestNegType = negType;
                continue block3;
            }
        }
        return bestNegType;
    }

    public String userToString() {
        return String.valueOf(this.getPeer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeDelta(long delta) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.clockDelta = delta;
            if (Math.abs(this.clockDelta) > MAX_CLOCK_DELTA) {
                this.isRoutable = false;
            }
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    public long getClockDelta() {
        return this.clockDelta;
    }

    @Override
    public void offer(Key key) {
        byte[] keyBytes = key.getFullKey();
        byte[] authenticator = HMAC.macWithSHA256(this.node.failureTable.offerAuthenticatorKey, keyBytes);
        Message msg = DMT.createFNPOfferKey(key, authenticator);
        try {
            this.sendAsync(msg, null, this.node.nodeStats.sendOffersCtr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    @Override
    public OutgoingPacketMangler getOutgoingMangler() {
        return this.outgoingMangler;
    }

    @Override
    public SocketHandler getSocketHandler() {
        return this.outgoingMangler.getSocketHandler();
    }

    public boolean isDisabled() {
        return false;
    }

    public boolean allowLocalAddresses() {
        return this.outgoingMangler.alwaysAllowLocalAddresses();
    }

    public boolean isIgnoreSource() {
        return false;
    }

    public static PeerNode create(SimpleFieldSet fs, Node node2, NodeCrypto crypto, OpennetManager opennet, PeerManager manager) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        if (crypto.isOpennet) {
            return new OpennetPeerNode(fs, node2, crypto, opennet, true);
        }
        return new DarknetPeerNode(fs, node2, crypto, true, null, null);
    }

    public boolean neverConnected() {
        return this.neverConnected;
    }

    public abstract void onSuccess(boolean var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyDisconnecting(boolean dumpMessageQueue) {
        MessageItem[] messagesTellDisconnected = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.disconnecting) {
                return true;
            }
            this.disconnecting = true;
            this.jfkNoncesSent.clear();
            if (dumpMessageQueue) {
                this.myBootID = this.node.fastWeakRandom.nextLong();
                messagesTellDisconnected = this.grabQueuedMessageItems();
            }
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        if (messagesTellDisconnected != null) {
            if (logMINOR) {
                Logger.minor(this, "Messages to dump: " + messagesTellDisconnected.length);
            }
            for (MessageItem mi : messagesTellDisconnected) {
                mi.onDisconnect();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCancelDisconnecting() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.removed = false;
            if (!this.disconnecting) {
                return;
            }
            this.disconnecting = false;
        }
        this.setPeerNodeStatus(System.currentTimeMillis(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.removed = true;
        }
        this.node.getTicker().removeQueuedJob(this.checkStatusAfterBackoff);
        this.disconnected(true, true);
        this.stopARKFetcher();
    }

    synchronized boolean cachedRemoved() {
        return this.removed;
    }

    public synchronized boolean isDisconnecting() {
        return this.disconnecting;
    }

    protected byte[] getJFKBuffer() {
        return this.jfkBuffer;
    }

    protected void setJFKBuffer(byte[] bufferJFK) {
        this.jfkBuffer = bufferJFK;
    }

    public synchronized boolean shouldAcceptAnnounce(long uid) {
        long now = System.currentTimeMillis();
        if (this.runningAnnounceUIDs.length < 1 && now - this.timeLastAcceptedAnnouncement > 1000L) {
            long[] newList = new long[this.runningAnnounceUIDs.length + 1];
            if (this.runningAnnounceUIDs.length > 0) {
                System.arraycopy(this.runningAnnounceUIDs, 0, newList, 0, this.runningAnnounceUIDs.length);
            }
            newList[this.runningAnnounceUIDs.length] = uid;
            this.timeLastAcceptedAnnouncement = now;
            return true;
        }
        return false;
    }

    public synchronized boolean completedAnnounce(long uid) {
        int runningAnnounceUIDsLength = this.runningAnnounceUIDs.length;
        if (runningAnnounceUIDsLength < 1) {
            return false;
        }
        long[] newList = new long[runningAnnounceUIDsLength - 1];
        int x = 0;
        for (int i = 0; i < this.runningAnnounceUIDs.length; ++i) {
            if (i == this.runningAnnounceUIDs.length) {
                return false;
            }
            long l = this.runningAnnounceUIDs[i];
            if (l == uid) continue;
            newList[x++] = l;
        }
        this.runningAnnounceUIDs = newList;
        if (x < this.runningAnnounceUIDs.length) {
            assert (false);
            this.runningAnnounceUIDs = Arrays.copyOf(this.runningAnnounceUIDs, x);
        }
        return true;
    }

    public synchronized long timeLastDisconnect() {
        return this.timeLastDisconnect;
    }

    public abstract boolean isRealConnection();

    public abstract boolean canAcceptAnnouncements();

    public boolean handshakeUnknownInitiator() {
        return false;
    }

    public int handshakeSetupType() {
        return -1;
    }

    public WeakReference<PeerNode> getWeakRef() {
        return this.myRef;
    }

    public Peer getHandshakeIP() {
        Peer ret;
        if (!this.shouldSendHandshake()) {
            if (logMINOR) {
                Logger.minor(this, "Not sending handshake to " + this.getPeer() + " because pn.shouldSendHandshake() returned false");
            }
            return null;
        }
        long firstTime = System.currentTimeMillis();
        Peer[] localHandshakeIPs = this.getHandshakeIPs();
        long secondTime = System.currentTimeMillis();
        if (secondTime - firstTime > 1000L) {
            Logger.error(this, "getHandshakeIPs() took more than a second to execute (" + (secondTime - firstTime) + ") working on " + this.userToString());
        }
        if (localHandshakeIPs.length == 0) {
            long thirdTime = System.currentTimeMillis();
            if (thirdTime - secondTime > 1000L) {
                Logger.error(this, "couldNotSendHandshake() (after getHandshakeIPs()) took more than a second to execute (" + (thirdTime - secondTime) + ") working on " + this.userToString());
            }
            return null;
        }
        long loopTime1 = System.currentTimeMillis();
        ArrayList<Peer> validIPs = new ArrayList<Peer>(localHandshakeIPs.length);
        boolean allowLocalAddresses = this.allowLocalAddresses();
        for (Peer peer : localHandshakeIPs) {
            FreenetInetAddress addr = peer.getFreenetAddress();
            if (peer.getAddress(false) == null) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not sending handshake to " + peer + " for " + this.getPeer() + " because the DNS lookup failed or it's a currently unsupported IPv6 address");
                continue;
            }
            if (!peer.isRealInternetAddress(false, false, allowLocalAddresses)) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not sending handshake to " + peer + " for " + this.getPeer() + " because it's not a real Internet address and metadata.allowLocalAddresses is not true");
                continue;
            }
            if (!this.isConnected() && !this.outgoingMangler.allowConnection(this, addr)) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not sending handshake packet to " + peer + " for " + this);
                continue;
            }
            validIPs.add(peer);
        }
        if (validIPs.isEmpty()) {
            ret = null;
        } else if (validIPs.size() == 1) {
            ret = (Peer)validIPs.get(0);
        } else {
            this.handshakeIPAlternator %= validIPs.size();
            ret = (Peer)validIPs.get(this.handshakeIPAlternator);
            ++this.handshakeIPAlternator;
        }
        long loopTime2 = System.currentTimeMillis();
        if (loopTime2 - loopTime1 > 1000L) {
            Logger.normal(this, "loopTime2 is more than a second after loopTime1 (" + (loopTime2 - loopTime1) + ") working on " + this.userToString());
        }
        return ret;
    }

    public void sendNodeToNodeMessage(SimpleFieldSet fs, int n2nType, boolean includeSentTime, long now, boolean queueOnNotConnected) {
        fs.putOverwrite("n2nType", Integer.toString(n2nType));
        if (includeSentTime) {
            fs.put("sentTime", now);
        }
        try {
            Message n2nm = DMT.createNodeToNodeMessage(n2nType, fs.toString().getBytes("UTF-8"));
            try {
                this.sendAsync(n2nm, null, this.node.nodeStats.nodeToNodeCounter);
            }
            catch (NotConnectedException e) {
                if (includeSentTime) {
                    fs.removeValue("sentTime");
                }
                if (this.isDarknet() && queueOnNotConnected) {
                    this.queueN2NM(fs);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    public void queueN2NM(SimpleFieldSet fs) {
    }

    protected SimpleFieldSet getLocalNoderef() {
        return this.crypto.exportPublicFieldSet();
    }

    protected void sendConnectedDiffNoderef() {
        String[] physicalUDPEntries;
        SimpleFieldSet fs = new SimpleFieldSet(true);
        SimpleFieldSet nfs = this.getLocalNoderef();
        if (null == nfs) {
            return;
        }
        String s = nfs.get("ark.pubURI");
        if (null != s) {
            fs.putOverwrite("ark.pubURI", s);
        }
        if (null != (s = nfs.get("ark.number"))) {
            fs.putOverwrite("ark.number", s);
        }
        if (this.isDarknet() && null != (s = nfs.get("myName"))) {
            fs.putOverwrite("myName", s);
        }
        if ((physicalUDPEntries = nfs.getAll("physical.udp")) != null) {
            fs.putOverwrite("physical.udp", physicalUDPEntries);
        }
        if (!fs.isEmpty()) {
            if (logMINOR) {
                Logger.minor(this, "fs is '" + fs.toString() + "'");
            }
            this.sendNodeToNodeMessage(fs, 2, false, 0L, false);
        } else if (logMINOR) {
            Logger.minor(this, "fs is empty");
        }
    }

    @Override
    public boolean shouldThrottle() {
        return PeerNode.shouldThrottle(this.getPeer(), this.node);
    }

    public static boolean shouldThrottle(Peer peer, Node node) {
        if (node.throttleLocalData) {
            return true;
        }
        if (peer == null) {
            return true;
        }
        InetAddress addr = peer.getAddress(false);
        if (addr == null) {
            return true;
        }
        return IPUtil.isValidAddress(addr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportPing(long t) {
        this.pingAverage.report(t);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.consecutiveRTOBackoffs = 0;
            if (!this.reportedRTT) {
                double oldRTO = this.RTO;
                this.SRTT = t;
                this.RTTVAR = t / 2L;
                this.RTO = this.SRTT + Math.max(20.0, this.RTTVAR * 4.0);
                if (this.RTO < (double)MIN_RTO) {
                    this.RTO = MIN_RTO;
                }
                if (this.RTO > (double)MAX_RTO) {
                    this.RTO = MAX_RTO;
                }
                this.reportedRTT = true;
                if (logMINOR) {
                    Logger.minor(this, "Received first packet on " + this.shortToString() + " setting RTO to " + this.RTO);
                }
                if (oldRTO > this.RTO && logMINOR) {
                    Logger.minor(this, "Received first packet after backing off on resend. RTO is " + this.RTO + " but was " + oldRTO);
                }
            } else {
                this.RTTVAR = 0.75 * this.RTTVAR + 0.25 * Math.abs(this.SRTT - (double)t);
                this.SRTT = 0.875 * this.SRTT + 0.125 * (double)t;
                this.RTO = this.SRTT + Math.max(20.0, this.RTTVAR * 4.0);
                if (this.RTO < (double)MIN_RTO) {
                    this.RTO = MIN_RTO;
                }
                if (this.RTO > (double)MAX_RTO) {
                    this.RTO = MAX_RTO;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Reported ping " + t + " avg is now " + this.pingAverage.currentValue() + " RTO is " + this.RTO + " SRTT is " + this.SRTT + " RTTVAR is " + this.RTTVAR + " for " + this.shortToString());
            }
        }
    }

    @Override
    public synchronized void backoffOnResend() {
        if (this.RTO >= (double)MAX_RTO) {
            Logger.error(this, "Major packet loss on " + this + " - RTO is already at limit and still losing packets!");
        }
        this.RTO *= 2.0;
        if (this.RTO > (double)MAX_RTO) {
            this.RTO = MAX_RTO;
        }
        ++this.consecutiveRTOBackoffs;
        if (this.consecutiveRTOBackoffs > 5) {
            Logger.warning(this, "Resetting RTO for " + this + " after " + this.consecutiveRTOBackoffs + " consecutive backoffs due to packet loss");
            this.consecutiveRTOBackoffs = 0;
            this.reportedRTT = false;
        }
        if (logMINOR) {
            Logger.minor(this, "Backed off on resend, RTO is now " + this.RTO + " for " + this.shortToString() + " consecutive RTO backoffs is " + this.consecutiveRTOBackoffs);
        }
    }

    public long getResendBytesSent() {
        return this.resendBytesSent;
    }

    public boolean shouldDisconnectAndRemoveNow() {
        return false;
    }

    public void setUptime(byte uptime2) {
        this.uptime = uptime2;
    }

    public short getUptime() {
        return (short)(this.uptime & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumberOfSelections(long time) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            ++this.countSelectionsSinceConnected;
        }
    }

    public synchronized double selectionRate() {
        long timeSinceConnected = System.currentTimeMillis() - this.connectedTime;
        if (timeSinceConnected < TimeUnit.SECONDS.toMillis(10L)) {
            return 0.0;
        }
        return (double)this.countSelectionsSinceConnected / (double)timeSinceConnected;
    }

    public void setMainJarOfferedVersion(long mainJarVersion) {
        this.offeredMainJarVersion = mainJarVersion;
    }

    public long getMainJarOfferedVersion() {
        return this.offeredMainJarVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeSendPacket(long now, boolean ackOnly) throws BlockedTooLongException {
        PacketFormat pf;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.packetFormat == null) {
                return false;
            }
            pf = this.packetFormat;
        }
        return pf.maybeSendPacket(now, ackOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReusableTrackerID() {
        SessionKey cur;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            cur = this.currentTracker;
        }
        if (cur == null) {
            if (logMINOR) {
                Logger.minor(this, "getReusableTrackerID(): cur = null on " + this);
            }
            return -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "getReusableTrackerID(): " + cur.trackerID + " on " + this);
        }
        return cur.trackerID;
    }

    public void failedRevocationTransfer() {
        this.lastAttemptedHandshakeIPUpdateTime = System.currentTimeMillis();
        ++this.countFailedRevocationTransfers;
    }

    public int countFailedRevocationTransfers() {
        return this.countFailedRevocationTransfers;
    }

    public void registerPeerNodeStatusChangeListener(PeerManager.PeerStatusChangeListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPeerNodeStatusChangeListeners() {
        Set<PeerManager.PeerStatusChangeListener> set = this.listeners;
        synchronized (set) {
            for (PeerManager.PeerStatusChangeListener l : this.listeners) {
                l.onPeerStatusChange();
            }
        }
    }

    public boolean isLowUptime() {
        return this.getUptime() < 40;
    }

    public void setAddedReason(OpennetManager.ConnectionType connectionType) {
    }

    public synchronized OpennetManager.ConnectionType getAddedReason() {
        return null;
    }

    void removeUIDsFromMessageQueues(Long[] list) {
        this.messageQueue.removeUIDsFromMessageQueues(list);
    }

    public void onSetMaxOutputTransfers(boolean realTime, int maxOutputTransfers) {
        (realTime ? this.loadSenderRealTime : this.loadSenderBulk).onSetMaxOutputTransfers(maxOutputTransfers);
    }

    public void onSetMaxOutputTransfersPeerLimit(boolean realTime, int maxOutputTransfers) {
        (realTime ? this.loadSenderRealTime : this.loadSenderBulk).onSetMaxOutputTransfersPeerLimit(maxOutputTransfers);
    }

    public void onSetPeerAllocation(boolean input, int thisAllocation, int transfersPerInsert, int maxOutputTransfers, boolean realTime) {
        (realTime ? this.loadSenderRealTime : this.loadSenderBulk).onSetPeerAllocation(input, thisAllocation, transfersPerInsert);
    }

    public OutputLoadTracker outputLoadTracker(boolean realTime) {
        return realTime ? this.outputLoadTrackerRealTime : this.outputLoadTrackerBulk;
    }

    public void reportLoadStatus(NodeStats.PeerLoadStats stat) {
        this.outputLoadTracker(stat.realTime).reportLoadStatus(stat);
        this.node.executor.execute(this.checkStatusAfterBackoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noLongerRoutingTo(UIDTag tag, boolean offeredKey) {
        if (offeredKey && !(tag instanceof RequestTag)) {
            throw new IllegalArgumentException("Only requests can have offeredKey=true");
        }
        Object object = this.routedToLock;
        synchronized (object) {
            if (offeredKey) {
                tag.removeFetchingOfferedKeyFrom(this);
            } else {
                tag.removeRoutingTo(this);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "No longer routing " + tag + " to " + this);
        }
        this.outputLoadTracker(tag.realTimeFlag).maybeNotifySlotWaiter();
    }

    public void postUnlock(UIDTag tag) {
        this.outputLoadTracker(tag.realTimeFlag).maybeNotifySlotWaiter();
    }

    static SlotWaiter createSlotWaiter(UIDTag tag, NodeStats.RequestType type, boolean offeredKey, boolean realTime, PeerNode source) {
        return new SlotWaiter(tag, type, offeredKey, realTime, source);
    }

    public IncomingLoadSummaryStats getIncomingLoadStats(boolean realTime) {
        return this.outputLoadTracker(realTime).getIncomingLoadStats();
    }

    public LoadSender loadSender(boolean realtime) {
        return realtime ? this.loadSenderRealTime : this.loadSenderBulk;
    }

    public void fatalTimeout(UIDTag tag, boolean offeredKey) {
        this.noLongerRoutingTo(tag, offeredKey);
        this.fatalTimeout();
    }

    public abstract void fatalTimeout();

    public abstract boolean shallWeRouteAccordingToOurPeersLocation(int var1);

    @Override
    public PeerMessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleReceivedPacket(byte[] buf, int offset, int length, long now, Peer replyTo) {
        PacketFormat pf;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            pf = this.packetFormat;
            if (pf == null) {
                return false;
            }
        }
        return pf.handleReceivedPacket(buf, offset, length, now, replyTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForLostPackets() {
        PacketFormat pf;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            pf = this.packetFormat;
            if (pf == null) {
                return;
            }
        }
        pf.checkForLostPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeCheckForLostPackets() {
        PacketFormat pf;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            pf = this.packetFormat;
            if (pf == null) {
                return Long.MAX_VALUE;
            }
        }
        return pf.timeCheckForLostPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTracker(SessionKey brokenKey) {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.currentTracker == brokenKey) {
                this.currentTracker = null;
                this.isConnected.set(false, now);
            } else if (this.previousTracker == brokenKey) {
                this.previousTracker = null;
            } else if (this.unverifiedTracker == brokenKey) {
                this.unverifiedTracker = null;
            }
        }
        this.isConnected();
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    @Override
    public void handleMessage(Message m) {
        this.node.usm.checkFilters(m, this.crypto.socket);
    }

    @Override
    public void sendEncryptedPacket(byte[] data) throws Peer.LocalAddressException {
        this.crypto.socket.sendPacket(data, this.getPeer(), this.allowLocalAddresses());
    }

    @Override
    public int getMaxPacketSize() {
        return this.crypto.socket.getMaxPacketSize();
    }

    @Override
    public boolean shouldPadDataPackets() {
        return this.crypto.config.paddDataPackets();
    }

    @Override
    public void sentThrottledBytes(int count) {
        this.node.outputThrottle.forceGrab(count);
    }

    @Override
    public void onNotificationOnlyPacketSent(int length) {
        this.node.nodeStats.reportNotificationOnlyPacketSent(length);
    }

    @Override
    public void resentBytes(int length) {
        this.resendByteCounter.sentBytes(length);
    }

    @Override
    public Random paddingGen() {
        return this.paddingGen;
    }

    public synchronized boolean matchesPeerAndPort(Peer peer) {
        if (this.detectedPeer != null && this.detectedPeer.laxEquals(peer)) {
            return true;
        }
        if (this.nominalPeer != null) {
            for (Peer p : this.nominalPeer) {
                if (p == null || !p.laxEquals(peer)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean matchesIP(FreenetInetAddress addr, boolean strict) {
        FreenetInetAddress a;
        if (this.detectedPeer != null && (a = this.detectedPeer.getFreenetAddress()) != null && (strict ? a.equals(addr) : a.laxEquals(addr))) {
            return true;
        }
        if (!strict && this.nominalPeer != null) {
            for (Peer p : this.nominalPeer) {
                FreenetInetAddress a2;
                if (p == null || (a2 = p.getFreenetAddress()) == null || !a2.laxEquals(addr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MessageItem makeLoadStats(boolean realtime, boolean boostPriority, boolean noRemember) {
        return null;
    }

    @Override
    public boolean grabSendLoadStatsASAP(boolean realtime) {
        return this.loadSender(realtime).grabSendASAP();
    }

    @Override
    public void setSendLoadStatsASAP(boolean realtime) {
        this.loadSender(realtime).setSendASAP();
    }

    @Override
    public DecodingMessageGroup startProcessingDecryptedMessages(int size) {
        return new MyDecodingMessageGroup(size);
    }

    public boolean isLowCapacity(boolean isRealtime) {
        NodeStats.PeerLoadStats stats = this.outputLoadTracker(isRealtime).getLastIncomingLoadStats();
        if (stats == null) {
            return false;
        }
        NodePinger pinger = this.node.nodeStats.nodePinger;
        if (pinger == null) {
            return false;
        }
        if (pinger.capacityThreshold(isRealtime, true) > stats.peerLimit(true)) {
            return true;
        }
        return pinger.capacityThreshold(isRealtime, false) > stats.peerLimit(false);
    }

    public void reportRoutedTo(double target, boolean isLocal, boolean realTime, PeerNode prev, Set<PeerNode> routedTo, int htl) {
        double distance = Location.distance(target, this.getLocation());
        double myLoc = this.node.getLocation();
        double prevLoc = prev != null ? prev.getLocation() : -1.0;
        HashSet<Double> excludeLocations = new HashSet<Double>();
        excludeLocations.add(myLoc);
        excludeLocations.add(prevLoc);
        for (PeerNode routedToNode : routedTo) {
            excludeLocations.add(routedToNode.getLocation());
        }
        if (this.shallWeRouteAccordingToOurPeersLocation(htl)) {
            double newDiff;
            double l = this.getClosestPeerLocation(target, excludeLocations);
            if (!Double.isNaN(l) && (newDiff = Location.distance(l, target)) < distance) {
                distance = newDiff;
            }
            if (logMINOR) {
                Logger.minor(this, "The peer " + this + " has published his peer's locations and the closest we have found to the target is " + distance + " away.");
            }
        }
        this.node.nodeStats.routingMissDistanceOverall.report(distance);
        (isLocal ? this.node.nodeStats.routingMissDistanceLocal : this.node.nodeStats.routingMissDistanceRemote).report(distance);
        (realTime ? this.node.nodeStats.routingMissDistanceRT : this.node.nodeStats.routingMissDistanceBulk).report(distance);
        this.node.peers.incrementSelectionSamples(System.currentTimeMillis(), this);
    }

    private long maxPeerPingTime() {
        if (this.node == null) {
            return NodeStats.DEFAULT_MAX_PING_TIME * 2L;
        }
        NodeStats stats = this.node.nodeStats;
        if (this.node.nodeStats == null) {
            return NodeStats.DEFAULT_MAX_PING_TIME * 2L;
        }
        return stats.maxPeerPingTime();
    }

    public synchronized boolean sendingUOMJar(boolean isExt) {
        if (isExt) {
            if (this.sendingUOMLegacyExtJar) {
                return false;
            }
            this.sendingUOMLegacyExtJar = true;
        } else {
            if (this.sendingUOMMainJar) {
                return false;
            }
            this.sendingUOMMainJar = true;
        }
        return true;
    }

    public synchronized void finishedSendingUOMJar(boolean isExt) {
        if (isExt) {
            this.sendingUOMLegacyExtJar = false;
            if (!this.sendingUOMMainJar && this.uomCount <= 0) {
                this.lastSentUOM = System.currentTimeMillis();
            }
        } else {
            this.sendingUOMMainJar = false;
            if (!this.sendingUOMLegacyExtJar && this.uomCount <= 0) {
                this.lastSentUOM = System.currentTimeMillis();
            }
        }
    }

    protected synchronized long timeSinceSentUOM() {
        if (this.sendingUOMMainJar || this.sendingUOMLegacyExtJar) {
            return 0L;
        }
        if (this.uomCount > 0) {
            return 0L;
        }
        if (this.lastSentUOM <= 0L) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() - this.lastSentUOM;
    }

    public synchronized void incrementUOMSends() {
        ++this.uomCount;
    }

    public synchronized void decrementUOMSends() {
        --this.uomCount;
        if (this.uomCount == 0 && !this.sendingUOMMainJar && !this.sendingUOMLegacyExtJar) {
            this.lastSentUOM = System.currentTimeMillis();
        }
    }

    public synchronized long getOutgoingBootID() {
        return this.myBootID;
    }

    public synchronized boolean throttleRekey() {
        long now = System.currentTimeMillis();
        if (now - this.lastIncomingRekey < 1000L) {
            Logger.error(this, "Two rekeys initiated by other side within 1000ms");
            return true;
        }
        this.lastIncomingRekey = now;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fullPacketQueued() {
        PacketFormat pf;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            pf = this.packetFormat;
            if (pf == null) {
                return false;
            }
        }
        return pf.fullPacketQueued(this.getMaxPacketSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeSendAcks() {
        PacketFormat pf;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            pf = this.packetFormat;
            if (pf == null) {
                return Long.MAX_VALUE;
            }
        }
        return pf.timeSendAcks();
    }

    public int calculateMaxTransfersOut(int timeout, double nonOverheadFraction) {
        double bandwidth = this.getThrottle().getBandwidth() + 1.0;
        if (this.shouldThrottle()) {
            bandwidth = Math.min(bandwidth, (double)(this.node.getOutputBandwidthLimit() / 2));
        }
        double packetsPerSecond = (bandwidth *= nonOverheadFraction) / 1024.0;
        return (int)Math.max(1.0, Math.min(packetsPerSecond * (double)timeout, 2.147483647E9));
    }

    public synchronized boolean hasFullNoderef() {
        return this.fullFieldSet != null;
    }

    public synchronized SimpleFieldSet getFullNoderef() {
        return this.fullFieldSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectedGuaranteed(boolean realTimeFlag) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (realTimeFlag) {
                ++this.consecutiveGuaranteedRejectsRT;
                if (this.consecutiveGuaranteedRejectsRT != 5) {
                    return;
                }
                this.consecutiveGuaranteedRejectsRT = 0;
            } else {
                ++this.consecutiveGuaranteedRejectsBulk;
                if (this.consecutiveGuaranteedRejectsBulk != 5) {
                    return;
                }
                this.consecutiveGuaranteedRejectsBulk = 0;
            }
        }
        this.enterMandatoryBackoff("Mandatory:RejectedGUARANTEED", realTimeFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptedAny(boolean realTimeFlag) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (realTimeFlag) {
                this.consecutiveGuaranteedRejectsRT = 0;
            } else {
                this.consecutiveGuaranteedRejectsBulk = 0;
            }
        }
    }

    @Override
    public int getThrottleWindowSize() {
        PacketThrottle throttle = this.getThrottle();
        if (throttle != null) {
            return (int)Math.min(throttle.getWindowSize(), 2.147483647E9);
        }
        return Integer.MAX_VALUE;
    }

    private boolean verifyReferenceSignature(SimpleFieldSet fs) throws ReferenceSignatureVerificationException {
        boolean failed = true;
        String signatureP256 = fs.get("sigP256");
        try {
            fs.removeValue("sig");
            byte[] toVerifyDSA = fs.toOrderedString().getBytes("UTF-8");
            fs.removeValue("sigP256");
            byte[] toVerifyECDSA = fs.toOrderedString().getBytes("UTF-8");
            boolean isECDSAsigPresent = signatureP256 != null && this.peerECDSAPubKey != null;
            boolean verifyECDSA = false;
            if (isECDSAsigPresent) {
                fs.putSingle("sigP256", signatureP256);
                verifyECDSA = ECDSA.verify(ECDSA.Curves.P256, this.peerECDSAPubKey, Base64.decode(signatureP256), new byte[][]{toVerifyECDSA});
            }
            boolean hasNoSignature = !isECDSAsigPresent;
            boolean isECDSAsigInvalid = isECDSAsigPresent && !verifyECDSA;
            boolean bl = failed = hasNoSignature || isECDSAsigInvalid;
            if (failed) {
                String errCause = "";
                if (hasNoSignature) {
                    errCause = errCause + " (No signature)";
                }
                if (isECDSAsigInvalid) {
                    errCause = errCause + " (ECDSA signature is invalid)";
                }
                if (failed) {
                    errCause = errCause + " (VERIFICATION FAILED)";
                }
                Logger.error(this, "The integrity of the reference has been compromised!" + errCause + " fs was\n" + fs.toOrderedString());
                this.isSignatureVerificationSuccessfull = false;
                throw new ReferenceSignatureVerificationException("The integrity of the reference has been compromised!" + errCause);
            }
            this.isSignatureVerificationSuccessfull = true;
            if (!this.dontKeepFullFieldSet()) {
                this.fullFieldSet = fs;
            }
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Invalid reference: " + e, (Throwable)e);
            throw new ReferenceSignatureVerificationException("The node reference you added is invalid: It does not have a valid ECDSA signature.");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        return !failed;
    }

    protected final byte[] getPubKeyHash() {
        return this.peerECDSAPubKeyHash;
    }

    static {
        try {
            TEST_AS_BYTES = "test".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        MAX_CLOCK_DELTA = TimeUnit.DAYS.toMillis(1L);
        CLEAR_MESSAGE_QUEUE_AFTER = TimeUnit.HOURS.toMillis(1L);
        BLACK_MAGIC_BACKOFF_PRUNING_TIME = TimeUnit.MINUTES.toMillis(5L);
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        UPDATE_BURST_NOW_PERIOD = TimeUnit.MINUTES.toMillis(5L);
        INITIAL_ROUTING_BACKOFF_LENGTH = (int)TimeUnit.SECONDS.toMillis(1L);
        MAX_ROUTING_BACKOFF_LENGTH = (int)TimeUnit.HOURS.toMillis(3L);
        INITIAL_TRANSFER_BACKOFF_LENGTH = (int)TimeUnit.SECONDS.toMillis(30L);
        MAX_TRANSFER_BACKOFF_LENGTH = (int)TimeUnit.HOURS.toMillis(3L);
        INITIAL_MANDATORY_BACKOFF_LENGTH = (int)TimeUnit.SECONDS.toMillis(1L);
        MAX_MANDATORY_BACKOFF_LENGTH = (int)TimeUnit.MINUTES.toMillis(5L);
        MAX_RTO = TimeUnit.SECONDS.toMillis(60L);
        MIN_RTO = TimeUnit.SECONDS.toMillis(1L);
        RequestType_values = NodeStats.RequestType.values();
    }

    class MyDecodingMessageGroup
    implements DecodingMessageGroup {
        private final ArrayList<Message> messages;
        private final ArrayList<Message> messagesWantSomething;

        public MyDecodingMessageGroup(int size) {
            this.messages = new ArrayList(size);
            this.messagesWantSomething = new ArrayList(size);
        }

        @Override
        public void processDecryptedMessage(byte[] data, int offset, int length, int overhead) {
            Message m = PeerNode.this.node.usm.decodeSingleMessage(data, offset, length, PeerNode.this, overhead);
            if (m == null) {
                if (logMINOR) {
                    Logger.minor(this, "Message not decoded from " + PeerNode.this + " (" + PeerNode.this.getVersionNumber() + ")");
                }
                return;
            }
            if (DMT.isPeerLoadStatusMessage(m)) {
                PeerNode.this.handleMessage(m);
                return;
            }
            if (DMT.isLoadLimitedRequest(m)) {
                this.messagesWantSomething.add(m);
            } else {
                this.messages.add(m);
            }
        }

        @Override
        public void complete() {
            for (Message msg : this.messages) {
                PeerNode.this.handleMessage(msg);
            }
            for (Message msg : this.messagesWantSomething) {
                PeerNode.this.handleMessage(msg);
            }
        }
    }

    class OutputLoadTracker {
        final boolean realTime;
        private NodeStats.PeerLoadStats lastIncomingLoadStats;
        private boolean dontSendUnlessGuaranteed;
        private long totalFatalTimeouts;
        private long totalAllocated;
        private final EnumMap<NodeStats.RequestType, SlotWaiterList> slotWaiters = new EnumMap(NodeStats.RequestType.class);
        private int slotWaiterTypeCounter = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reportLoadStatus(NodeStats.PeerLoadStats stat) {
            if (logMINOR) {
                Logger.minor(this, "Got load status : " + stat);
            }
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                this.lastIncomingLoadStats = stat;
            }
            this.maybeNotifySlotWaiter();
        }

        synchronized void reportFatalTimeoutInWait(boolean local) {
            if (!local) {
                ++this.totalFatalTimeouts;
            }
            PeerNode.this.node.nodeStats.reportFatalTimeoutInWait(local);
        }

        synchronized void reportAllocated(boolean local) {
            if (!local) {
                ++this.totalAllocated;
            }
            PeerNode.this.node.nodeStats.reportAllocatedSlot(local);
        }

        public synchronized double proportionTimingOutFatallyInWait() {
            if (this.totalFatalTimeouts == 1L && this.totalAllocated == 0L) {
                return 0.5;
            }
            return (double)this.totalFatalTimeouts / (double)(this.totalFatalTimeouts + this.totalAllocated);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NodeStats.PeerLoadStats getLastIncomingLoadStats() {
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                return this.lastIncomingLoadStats;
            }
        }

        OutputLoadTracker(boolean realTime) {
            this.realTime = realTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncomingLoadSummaryStats getIncomingLoadStats() {
            NodeStats.PeerLoadStats loadStats;
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                if (this.lastIncomingLoadStats == null) {
                    return null;
                }
                loadStats = this.lastIncomingLoadStats;
            }
            NodeStats.RunningRequestsSnapshot runningRequests = PeerNode.this.node.nodeStats.getRunningRequestsTo(PeerNode.this, loadStats.averageTransfersOutPerInsert, this.realTime);
            NodeStats.RunningRequestsSnapshot otherRunningRequests = loadStats.getOtherRunningRequests();
            boolean ignoreLocalVsRemoteBandwidthLiability = PeerNode.this.node.nodeStats.ignoreLocalVsRemoteBandwidthLiability();
            return new IncomingLoadSummaryStats(runningRequests.totalRequests(), loadStats.outputBandwidthPeerLimit, loadStats.inputBandwidthPeerLimit, loadStats.outputBandwidthUpperLimit, loadStats.inputBandwidthUpperLimit, runningRequests.calculate(ignoreLocalVsRemoteBandwidthLiability, false), runningRequests.calculate(ignoreLocalVsRemoteBandwidthLiability, true), otherRunningRequests.calculate(ignoreLocalVsRemoteBandwidthLiability, false), otherRunningRequests.calculate(ignoreLocalVsRemoteBandwidthLiability, true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestLikelyAcceptedState tryRouteTo(UIDTag tag, RequestLikelyAcceptedState worstAcceptable, boolean offeredKey) {
            boolean ignoreLocalVsRemote = PeerNode.this.node.nodeStats.ignoreLocalVsRemoteBandwidthLiability();
            if (!PeerNode.this.isRoutable()) {
                return null;
            }
            if (PeerNode.this.isInMandatoryBackoff(System.currentTimeMillis(), this.realTime)) {
                return null;
            }
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                NodeStats.PeerLoadStats loadStats = this.lastIncomingLoadStats;
                if (loadStats == null) {
                    Logger.error(this, "Accepting because no load stats from " + PeerNode.this.shortToString() + " (" + PeerNode.this.getVersionNumber() + ")");
                    if (tag.addRoutedTo(PeerNode.this, offeredKey)) {
                        return RequestLikelyAcceptedState.UNKNOWN;
                    }
                    return null;
                }
                if (this.dontSendUnlessGuaranteed) {
                    worstAcceptable = RequestLikelyAcceptedState.GUARANTEED;
                }
                NodeStats.RunningRequestsSnapshot runningRequests = PeerNode.this.node.nodeStats.getRunningRequestsTo(PeerNode.this, loadStats.averageTransfersOutPerInsert, this.realTime);
                runningRequests.log(PeerNode.this);
                NodeStats.RunningRequestsSnapshot otherRunningRequests = loadStats.getOtherRunningRequests();
                RequestLikelyAcceptedState acceptState = this.getRequestLikelyAcceptedState(runningRequests, otherRunningRequests, ignoreLocalVsRemote, loadStats);
                if (logMINOR) {
                    Logger.minor(this, "Predicted acceptance state for request: " + (Object)((Object)acceptState) + " must beat " + (Object)((Object)worstAcceptable));
                }
                if (acceptState.ordinal() > worstAcceptable.ordinal()) {
                    return null;
                }
                if (tag.addRoutedTo(PeerNode.this, offeredKey)) {
                    return acceptState;
                }
                if (logMINOR) {
                    Logger.minor(this, "Already routed to peer");
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean queueSlotWaiter(SlotWaiter waiter) {
            if (!PeerNode.this.isRoutable()) {
                if (logMINOR) {
                    Logger.minor(this, "Not routable, so not queueing");
                }
                return false;
            }
            if (PeerNode.this.isInMandatoryBackoff(System.currentTimeMillis(), this.realTime)) {
                if (logMINOR) {
                    Logger.minor(this, "In mandatory backoff, so not queueing");
                }
                return false;
            }
            boolean noLoadStats = false;
            PeerNode[] all = null;
            boolean queued = false;
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                boolean bl = noLoadStats = this.lastIncomingLoadStats == null;
                if (!noLoadStats) {
                    SlotWaiterList list = this.makeSlotWaiters(waiter.requestType);
                    list.put(waiter);
                    if (logMINOR) {
                        Logger.minor(this, "Queued slot " + waiter + " waiter for " + (Object)((Object)waiter.requestType) + " on " + list + " on " + this + " for " + PeerNode.this);
                    }
                    queued = true;
                } else {
                    if (logMINOR) {
                        Logger.minor(this, "Not waiting for " + this + " as no load stats");
                    }
                    all = waiter.innerOnWaited(PeerNode.this, RequestLikelyAcceptedState.UNKNOWN);
                }
            }
            if (all != null) {
                this.reportAllocated(waiter.isLocal());
                waiter.unregister(null, all);
            } else if (queued && (!PeerNode.this.isRoutable() || PeerNode.this.isInMandatoryBackoff(System.currentTimeMillis(), this.realTime))) {
                if (logMINOR) {
                    Logger.minor(this, "Queued but not routable or in mandatory backoff, failing");
                }
                waiter.onFailed(PeerNode.this, true);
                return false;
            }
            return true;
        }

        private SlotWaiterList makeSlotWaiters(NodeStats.RequestType requestType) {
            SlotWaiterList slots = this.slotWaiters.get((Object)requestType);
            if (slots == null) {
                slots = new SlotWaiterList();
                this.slotWaiters.put(requestType, slots);
            }
            return slots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unqueueSlotWaiter(SlotWaiter waiter) {
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                SlotWaiterList map = this.slotWaiters.get((Object)waiter.requestType);
                if (map == null) {
                    return;
                }
                map.remove(waiter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void failSlotWaiters(boolean reallyFailed) {
            for (NodeStats.RequestType type : RequestType_values) {
                SlotWaiterList slots;
                Object object = PeerNode.this.routedToLock;
                synchronized (object) {
                    slots = this.slotWaiters.get((Object)type);
                    if (slots == null) {
                        continue;
                    }
                    this.slotWaiters.remove((Object)type);
                }
                for (SlotWaiter w : slots.values()) {
                    w.onFailed(PeerNode.this, reallyFailed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeNotifySlotWaiter() {
            boolean foundNone;
            if (!PeerNode.this.isRoutable()) {
                return;
            }
            boolean ignoreLocalVsRemote = PeerNode.this.node.nodeStats.ignoreLocalVsRemoteBandwidthLiability();
            if (logMINOR) {
                Logger.minor(this, "Maybe waking up slot waiters for " + this + " realtime=" + this.realTime + " for " + PeerNode.this.shortToString());
            }
            do {
                int typeNum;
                NodeStats.PeerLoadStats loadStats;
                foundNone = true;
                Object object = PeerNode.this.routedToLock;
                synchronized (object) {
                    loadStats = this.lastIncomingLoadStats;
                    if (this.slotWaiters.isEmpty()) {
                        if (logMINOR) {
                            Logger.minor(this, "No slot waiters for " + this);
                        }
                        return;
                    }
                    typeNum = this.slotWaiterTypeCounter;
                }
                if (++typeNum == RequestType_values.length) {
                    typeNum = 0;
                }
                for (int i = 0; i < RequestType_values.length; ++i) {
                    PeerNode[] peersForSuccessfulSlot;
                    SlotWaiter slot;
                    RequestLikelyAcceptedState acceptState;
                    NodeStats.RequestType type = RequestType_values[typeNum];
                    if (logMINOR) {
                        Logger.minor(this, "Checking slot waiter list for " + (Object)((Object)type));
                    }
                    Object object2 = PeerNode.this.routedToLock;
                    synchronized (object2) {
                        SlotWaiterList list = this.slotWaiters.get((Object)type);
                        if (list == null) {
                            if (logMINOR) {
                                Logger.minor(this, "No list");
                            }
                            if (++typeNum == RequestType_values.length) {
                                typeNum = 0;
                            }
                            continue;
                        }
                        if (list.isEmpty()) {
                            if (logMINOR) {
                                Logger.minor(this, "List empty");
                            }
                            if (++typeNum == RequestType_values.length) {
                                typeNum = 0;
                            }
                            continue;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Checking slot waiters for " + (Object)((Object)type));
                        }
                        foundNone = false;
                        NodeStats.RunningRequestsSnapshot runningRequests = PeerNode.this.node.nodeStats.getRunningRequestsTo(PeerNode.this, loadStats.averageTransfersOutPerInsert, this.realTime);
                        runningRequests.log(PeerNode.this);
                        NodeStats.RunningRequestsSnapshot otherRunningRequests = loadStats.getOtherRunningRequests();
                        acceptState = this.getRequestLikelyAcceptedState(runningRequests, otherRunningRequests, ignoreLocalVsRemote, loadStats);
                        if (acceptState == null || acceptState == RequestLikelyAcceptedState.UNLIKELY) {
                            if (logMINOR) {
                                Logger.minor(this, "Accept state is " + (Object)((Object)acceptState) + " - not waking up - type is " + (Object)((Object)type));
                            }
                            return;
                        }
                        if (this.dontSendUnlessGuaranteed && acceptState != RequestLikelyAcceptedState.GUARANTEED) {
                            if (logMINOR) {
                                Logger.minor(this, "Not accepting until guaranteed for " + PeerNode.this + " realtime=" + this.realTime);
                            }
                            return;
                        }
                        if (list.isEmpty()) {
                            continue;
                        }
                        slot = list.removeFirst();
                        if (logMINOR) {
                            Logger.minor(this, "Accept state is " + (Object)((Object)acceptState) + " for " + slot + " - waking up on " + this);
                        }
                        if ((peersForSuccessfulSlot = slot.innerOnWaited(PeerNode.this, acceptState)) == null) {
                            continue;
                        }
                        this.reportAllocated(slot.isLocal());
                        this.slotWaiterTypeCounter = typeNum;
                    }
                    slot.unregister(PeerNode.this, peersForSuccessfulSlot);
                    if (logMINOR) {
                        Logger.minor(this, "Accept state is " + (Object)((Object)acceptState) + " for " + slot + " - waking up");
                    }
                    if (++typeNum != RequestType_values.length) continue;
                    typeNum = 0;
                }
            } while (!foundNone);
        }

        private RequestLikelyAcceptedState getRequestLikelyAcceptedState(NodeStats.RunningRequestsSnapshot runningRequests, NodeStats.RunningRequestsSnapshot otherRunningRequests, boolean ignoreLocalVsRemote, NodeStats.PeerLoadStats stats) {
            RequestLikelyAcceptedState outputState = this.getRequestLikelyAcceptedStateBandwidth(false, runningRequests, otherRunningRequests, ignoreLocalVsRemote, stats);
            RequestLikelyAcceptedState inputState = this.getRequestLikelyAcceptedStateBandwidth(true, runningRequests, otherRunningRequests, ignoreLocalVsRemote, stats);
            RequestLikelyAcceptedState transfersState = this.getRequestLikelyAcceptedStateTransfers(runningRequests, otherRunningRequests, ignoreLocalVsRemote, stats);
            RequestLikelyAcceptedState ret = inputState;
            if (outputState.ordinal() > ret.ordinal()) {
                ret = outputState;
            }
            if (transfersState.ordinal() > ret.ordinal()) {
                ret = transfersState;
            }
            return ret;
        }

        private RequestLikelyAcceptedState getRequestLikelyAcceptedStateBandwidth(boolean input, NodeStats.RunningRequestsSnapshot runningRequests, NodeStats.RunningRequestsSnapshot otherRunningRequests, boolean ignoreLocalVsRemote, NodeStats.PeerLoadStats stats) {
            double ourUsage = runningRequests.calculate(ignoreLocalVsRemote, input);
            if (logMINOR) {
                Logger.minor(this, "Our usage is " + ourUsage + " peer limit is " + stats.peerLimit(input) + " lower limit is " + stats.lowerLimit(input) + " realtime " + this.realTime + " input " + input);
            }
            if (ourUsage < stats.peerLimit(input)) {
                return RequestLikelyAcceptedState.GUARANTEED;
            }
            otherRunningRequests.log(PeerNode.this);
            double theirUsage = otherRunningRequests.calculate(ignoreLocalVsRemote, input);
            if (logMINOR) {
                Logger.minor(this, "Their usage is " + theirUsage);
            }
            if (ourUsage + theirUsage < stats.lowerLimit(input)) {
                return RequestLikelyAcceptedState.LIKELY;
            }
            return RequestLikelyAcceptedState.UNLIKELY;
        }

        private RequestLikelyAcceptedState getRequestLikelyAcceptedStateTransfers(NodeStats.RunningRequestsSnapshot runningRequests, NodeStats.RunningRequestsSnapshot otherRunningRequests, boolean ignoreLocalVsRemote, NodeStats.PeerLoadStats stats) {
            int ourUsage = runningRequests.totalOutTransfers();
            int maxTransfersOutPeerLimit = Math.min(stats.maxTransfersOutPeerLimit, stats.maxTransfersOut);
            if (logMINOR) {
                Logger.minor(this, "Our usage is " + ourUsage + " peer limit is " + maxTransfersOutPeerLimit + " lower limit is " + stats.maxTransfersOutLowerLimit + " realtime " + this.realTime);
            }
            if (ourUsage < maxTransfersOutPeerLimit) {
                return RequestLikelyAcceptedState.GUARANTEED;
            }
            otherRunningRequests.log(PeerNode.this);
            int theirUsage = otherRunningRequests.totalOutTransfers();
            if (logMINOR) {
                Logger.minor(this, "Their usage is " + theirUsage);
            }
            if (ourUsage + theirUsage < stats.maxTransfersOutLowerLimit) {
                return RequestLikelyAcceptedState.LIKELY;
            }
            return RequestLikelyAcceptedState.UNLIKELY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDontSendUnlessGuaranteed() {
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                if (!this.dontSendUnlessGuaranteed) {
                    Logger.error(this, "Setting don't-send-unless-guaranteed for " + PeerNode.this + " realtime=" + this.realTime);
                    this.dontSendUnlessGuaranteed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearDontSendUnlessGuaranteed() {
            Object object = PeerNode.this.routedToLock;
            synchronized (object) {
                if (this.dontSendUnlessGuaranteed) {
                    Logger.error(this, "Clearing don't-send-unless-guaranteed for " + PeerNode.this + " realtime=" + this.realTime);
                    this.dontSendUnlessGuaranteed = false;
                }
            }
        }
    }

    static class SlotWaiterList {
        private final LinkedHashMap<PeerNode, TreeMap<Long, SlotWaiter>> lru = new LinkedHashMap();

        SlotWaiterList() {
        }

        public synchronized void put(SlotWaiter waiter) {
            PeerNode source = waiter.source;
            TreeMap<Long, SlotWaiter> map = this.lru.get(source);
            if (map == null) {
                map = new TreeMap();
                this.lru.put(source, map);
            }
            map.put(waiter.counter, waiter);
        }

        public synchronized void remove(SlotWaiter waiter) {
            PeerNode source = waiter.source;
            TreeMap<Long, SlotWaiter> map = this.lru.get(source);
            if (map == null) {
                if (logMINOR) {
                    Logger.minor(this, "SlotWaiter " + waiter + " was not queued");
                }
                return;
            }
            map.remove(waiter.counter);
            if (map.isEmpty()) {
                this.lru.remove(source);
            }
        }

        public synchronized boolean isEmpty() {
            return this.lru.isEmpty();
        }

        public synchronized SlotWaiter removeFirst() {
            if (this.lru.isEmpty()) {
                return null;
            }
            PeerNode source = this.lru.keySet().iterator().next();
            TreeMap<Long, SlotWaiter> map = this.lru.get(source);
            Long key = map.firstKey();
            SlotWaiter ret = map.get(key);
            map.remove(key);
            this.lru.remove(source);
            if (!map.isEmpty()) {
                this.lru.put(source, map);
            }
            return ret;
        }

        public synchronized ArrayList<SlotWaiter> values() {
            ArrayList<SlotWaiter> list = new ArrayList<SlotWaiter>();
            for (TreeMap<Long, SlotWaiter> map : this.lru.values()) {
                list.addAll(map.values());
            }
            return list;
        }

        public String toString() {
            return super.toString() + ":peers=" + this.lru.size();
        }
    }

    static class SlotWaiterFailedException
    extends Exception {
        final PeerNode pn;
        final boolean fatal;

        SlotWaiterFailedException(PeerNode p, boolean f) {
            this.pn = p;
            this.fatal = f;
        }
    }

    public static class SlotWaiter {
        final PeerNode source;
        private final HashSet<PeerNode> waitingFor;
        private PeerNode acceptedBy;
        private RequestLikelyAcceptedState acceptedState;
        final UIDTag tag;
        final boolean offeredKey;
        final NodeStats.RequestType requestType;
        private boolean failed;
        private SlotWaiterFailedException fe;
        final boolean realTime;
        final long counter;
        private static long waiterCounter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SlotWaiter(UIDTag tag, NodeStats.RequestType type, boolean offeredKey, boolean realTime, PeerNode source) {
            this.tag = tag;
            this.requestType = type;
            this.offeredKey = offeredKey;
            this.waitingFor = new HashSet();
            this.realTime = realTime;
            this.source = source;
            Class<SlotWaiter> clazz = SlotWaiter.class;
            synchronized (SlotWaiter.class) {
                this.counter = waiterCounter++;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addWaitingFor(PeerNode peer) {
            boolean cantQueue = !peer.isRoutable() || peer.isInMandatoryBackoff(System.currentTimeMillis(), this.realTime);
            SlotWaiter slotWaiter = this;
            synchronized (slotWaiter) {
                if (this.acceptedBy != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Not adding " + peer.shortToString + " because already matched on " + this);
                    }
                    return true;
                }
                if (this.failed) {
                    if (logMINOR) {
                        Logger.minor(this, "Not adding " + peer.shortToString + " because already failed on " + this);
                    }
                    return true;
                }
                if (this.waitingFor.contains(peer)) {
                    return true;
                }
                if (cantQueue) {
                    return false;
                }
                this.waitingFor.add(peer);
                this.tag.setWaitingForSlot();
            }
            if (!peer.outputLoadTracker(this.realTime).queueSlotWaiter(this)) {
                slotWaiter = this;
                synchronized (slotWaiter) {
                    this.waitingFor.remove(peer);
                    if (this.acceptedBy != null || this.failed) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        synchronized PeerNode[] innerOnWaited(PeerNode peer, RequestLikelyAcceptedState state) {
            if (logMINOR) {
                Logger.minor(this, "Waking slot waiter " + this + " on " + peer);
            }
            if (this.acceptedBy != null) {
                if (logMINOR) {
                    Logger.minor(this, "Already accepted on " + this);
                }
                if (this.acceptedBy != peer) {
                    if (this.offeredKey) {
                        this.tag.removeFetchingOfferedKeyFrom(peer);
                    } else {
                        this.tag.removeRoutingTo(peer);
                    }
                }
                return null;
            }
            if (!this.waitingFor.contains(peer)) {
                if (logMINOR) {
                    Logger.minor(this, "Not waiting for peer " + peer + " on " + this);
                }
                if (this.acceptedBy != peer) {
                    if (this.offeredKey) {
                        this.tag.removeFetchingOfferedKeyFrom(peer);
                    } else {
                        this.tag.removeRoutingTo(peer);
                    }
                }
                return null;
            }
            this.acceptedBy = peer;
            this.acceptedState = state;
            if (!this.tag.addRoutedTo(peer, this.offeredKey)) {
                Logger.normal(this, "onWaited for " + this + " added on " + this.tag + " but already added - race condition?");
            }
            this.notifyAll();
            PeerNode[] toUnreg = this.waitingFor.toArray(new PeerNode[this.waitingFor.size()]);
            this.waitingFor.clear();
            this.tag.clearWaitingForSlot();
            return toUnreg;
        }

        void unregister(PeerNode exclude, PeerNode[] all) {
            if (all == null) {
                return;
            }
            for (PeerNode p : all) {
                if (p == exclude) continue;
                p.outputLoadTracker(this.realTime).unqueueSlotWaiter(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onFailed(PeerNode peer, boolean reallyFailed) {
            if (logMINOR) {
                Logger.minor(this, "onFailed() on " + this + " reallyFailed=" + reallyFailed);
            }
            SlotWaiter slotWaiter = this;
            synchronized (slotWaiter) {
                if (this.acceptedBy != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Already matched on " + this);
                    }
                    return;
                }
                this.failed = true;
                this.fe = new SlotWaiterFailedException(peer, reallyFailed);
                this.tag.clearWaitingForSlot();
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashSet<PeerNode> waitingForList() {
            SlotWaiter slotWaiter = this;
            synchronized (slotWaiter) {
                return new HashSet<PeerNode>(this.waitingFor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PeerNode waitForAny(long maxWait, boolean timeOutIsFatal) throws SlotWaiterFailedException {
            PeerNode[] all;
            PeerNode ret = null;
            boolean grabbed = false;
            SlotWaiterFailedException f = null;
            SlotWaiter slotWaiter = this;
            synchronized (slotWaiter) {
                if (this.shouldGrab()) {
                    if (logMINOR) {
                        Logger.minor(this, "Already matched on " + this);
                    }
                    ret = this.grab();
                    grabbed = true;
                }
                if (this.fe != null) {
                    f = this.fe;
                    this.fe = null;
                    grabbed = true;
                }
                all = this.waitingFor.toArray(new PeerNode[this.waitingFor.size()]);
                if (ret != null) {
                    this.waitingFor.clear();
                }
                if (grabbed || all.length == 0) {
                    this.tag.clearWaitingForSlot();
                }
            }
            if (grabbed) {
                this.unregister(ret, all);
                if (f != null && ret == null) {
                    throw f;
                }
                return ret;
            }
            if (all.length == 0) {
                if (logMINOR) {
                    Logger.minor(this, "None to wait for on " + this);
                }
                return null;
            }
            long now = System.currentTimeMillis();
            boolean anyValid = false;
            PeerNode[] peerNodeArray = all;
            int len$ = peerNodeArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PeerNode[] unreg;
                PeerNode p = peerNodeArray[i$];
                if (!p.isRoutable() || p.isInMandatoryBackoff(now, this.realTime)) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Peer is not valid in waitForAny(): " + p);
                    continue;
                }
                anyValid = true;
                RequestLikelyAcceptedState accept = p.outputLoadTracker(this.realTime).tryRouteTo(this.tag, RequestLikelyAcceptedState.LIKELY, this.offeredKey);
                if (accept == null) continue;
                if (logMINOR) {
                    Logger.minor(this, "tryRouteTo() pre-wait check returned " + (Object)((Object)accept));
                }
                PeerNode other = null;
                SlotWaiter slotWaiter2 = this;
                synchronized (slotWaiter2) {
                    if (logMINOR) {
                        Logger.minor(this, "tryRouteTo() succeeded to " + p + " on " + this + " with " + (Object)((Object)accept) + " - checking whether we have already accepted.");
                    }
                    if ((unreg = this.innerOnWaited(p, accept)) == null && this.shouldGrab()) {
                        other = this.grab();
                    }
                    if (other == null) {
                        if (logMINOR) {
                            Logger.minor(this, "Trying the original tryRouteTo() on " + this);
                        }
                        this.acceptedBy = null;
                        this.failed = false;
                        this.fe = null;
                    }
                    this.tag.clearWaitingForSlot();
                }
                this.unregister(null, unreg);
                if (other != null) {
                    Logger.normal(this, "Race condition: tryRouteTo() succeeded on " + p.shortToString() + " but already matched on " + other.shortToString() + " on " + this);
                    this.tag.removeRoutingTo(p);
                    return other;
                }
                p.outputLoadTracker(this.realTime).reportAllocated(this.isLocal());
                return p;
            }
            if (maxWait == 0L) {
                return null;
            }
            if (!anyValid) {
                SlotWaiter slotWaiter3 = this;
                synchronized (slotWaiter3) {
                    if (this.fe != null) {
                        f = this.fe;
                        this.fe = null;
                    }
                    if (this.shouldGrab()) {
                        ret = this.grab();
                    }
                    all = this.waitingFor.toArray(new PeerNode[this.waitingFor.size()]);
                    this.waitingFor.clear();
                    this.failed = false;
                    this.acceptedBy = null;
                }
                if (logMINOR) {
                    Logger.minor(this, "None valid to wait for on " + this);
                }
                this.unregister(ret, all);
                if (f != null && ret == null) {
                    throw f;
                }
                this.tag.clearWaitingForSlot();
                return ret;
            }
            SlotWaiter slotWaiter4 = this;
            synchronized (slotWaiter4) {
                if (logMINOR) {
                    Logger.minor(this, "Waiting for any node to wake up " + this + " : " + Arrays.toString(this.waitingFor.toArray()) + " (for up to " + maxWait + "ms)");
                }
                long waitStart = System.currentTimeMillis();
                long deadline = waitStart + maxWait;
                boolean timedOut = false;
                while (this.acceptedBy == null && !this.waitingFor.isEmpty() && !this.failed) {
                    try {
                        if (maxWait == Long.MAX_VALUE) {
                            this.wait();
                            continue;
                        }
                        int wait = (int)Math.min(Integer.MAX_VALUE, deadline - System.currentTimeMillis());
                        if (wait > 0) {
                            this.wait(wait);
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Maximum wait time exceeded on " + this);
                        }
                        if (this.shouldGrab()) break;
                        timedOut = true;
                        all = this.waitingFor.toArray(new PeerNode[this.waitingFor.size()]);
                        this.waitingFor.clear();
                        break;
                    }
                    catch (InterruptedException wait) {
                    }
                }
                if (!timedOut) {
                    long waitEnd = System.currentTimeMillis();
                    if (waitEnd - waitStart > (long)(this.realTime ? 6000 : 60000)) {
                        Logger.warning(this, "Waited " + (waitEnd - waitStart) + "ms for " + this);
                    } else if (waitEnd - waitStart > (long)(this.realTime ? 1000 : 10000)) {
                        Logger.normal(this, "Waited " + (waitEnd - waitStart) + "ms for " + this);
                    } else if (logMINOR) {
                        Logger.minor(this, "Waited " + (waitEnd - waitStart) + "ms for " + this);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Returning after waiting: accepted by " + this.acceptedBy + " waiting for " + this.waitingFor.size() + " failed " + this.failed + " on " + this);
                }
                ret = this.acceptedBy;
                this.acceptedBy = null;
                all = this.waitingFor.toArray(new PeerNode[this.waitingFor.size()]);
                this.waitingFor.clear();
                this.failed = false;
                this.fe = null;
                this.tag.clearWaitingForSlot();
            }
            if (timeOutIsFatal && all != null) {
                for (PeerNode pn : all) {
                    pn.outputLoadTracker(this.realTime).reportFatalTimeoutInWait(this.isLocal());
                }
            }
            this.unregister(ret, all);
            return ret;
        }

        final boolean isLocal() {
            return this.source == null;
        }

        private boolean shouldGrab() {
            return this.acceptedBy != null || this.waitingFor.isEmpty() || this.failed;
        }

        private synchronized PeerNode grab() {
            if (logMINOR) {
                Logger.minor(this, "Returning in first check: accepted by " + this.acceptedBy + " waiting for " + this.waitingFor.size() + " failed " + this.failed + " accepted state " + (Object)((Object)this.acceptedState));
            }
            this.failed = false;
            PeerNode got = this.acceptedBy;
            this.acceptedBy = null;
            return got;
        }

        public synchronized RequestLikelyAcceptedState getAcceptedState() {
            return this.acceptedState;
        }

        public String toString() {
            return super.toString() + ":" + this.counter + ":" + (Object)((Object)this.requestType) + ":" + this.realTime;
        }

        public synchronized int waitingForCount() {
            return this.waitingFor.size();
        }
    }

    static enum RequestLikelyAcceptedState {
        GUARANTEED,
        LIKELY,
        UNLIKELY,
        UNKNOWN;

    }

    public class IncomingLoadSummaryStats {
        public final int runningRequestsTotal;
        public final int peerCapacityOutputBytes;
        public final int peerCapacityInputBytes;
        public final int totalCapacityOutputBytes;
        public final int totalCapacityInputBytes;
        public final int usedCapacityOutputBytes;
        public final int usedCapacityInputBytes;
        public final int othersUsedCapacityOutputBytes;
        public final int othersUsedCapacityInputBytes;

        public IncomingLoadSummaryStats(int totalRequests, double outputBandwidthPeerLimit, double inputBandwidthPeerLimit, double outputBandwidthTotalLimit, double inputBandwidthTotalLimit, double usedOutput, double usedInput, double othersUsedOutput, double othersUsedInput) {
            this.runningRequestsTotal = totalRequests;
            this.peerCapacityOutputBytes = (int)outputBandwidthPeerLimit;
            this.peerCapacityInputBytes = (int)inputBandwidthPeerLimit;
            this.totalCapacityOutputBytes = (int)outputBandwidthTotalLimit;
            this.totalCapacityInputBytes = (int)inputBandwidthTotalLimit;
            this.usedCapacityOutputBytes = (int)usedOutput;
            this.usedCapacityInputBytes = (int)usedInput;
            this.othersUsedCapacityOutputBytes = (int)othersUsedOutput;
            this.othersUsedCapacityInputBytes = (int)othersUsedInput;
        }
    }

    class LoadSender {
        private int lastSentAllocationInput;
        private int lastSentAllocationOutput;
        private int lastSentMaxOutputTransfers = Integer.MAX_VALUE;
        private int lastSentMaxOutputTransfersPeerLimit = Integer.MAX_VALUE;
        private long timeLastSentAllocationNotice;
        private long countAllocationNotices;
        private NodeStats.PeerLoadStats lastFullStats;
        private final boolean realTimeFlag;
        private boolean sendASAP;

        LoadSender(boolean realTimeFlag) {
            this.realTimeFlag = realTimeFlag;
        }

        public void onDisconnect() {
            this.lastSentAllocationInput = 0;
            this.lastSentAllocationOutput = 0;
            this.timeLastSentAllocationNotice = -1L;
            this.lastFullStats = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSetPeerAllocation(boolean input, int thisAllocation, int transfersPerInsert) {
            boolean mustSend = false;
            long now = System.currentTimeMillis();
            LoadSender loadSender = this;
            synchronized (loadSender) {
                int last;
                int n = last = input ? this.lastSentAllocationInput : this.lastSentAllocationOutput;
                if (now - this.timeLastSentAllocationNotice > 5000L) {
                    if (logMINOR) {
                        Logger.minor(this, "Last sent allocation " + TimeUtil.formatTime(now - this.timeLastSentAllocationNotice));
                    }
                    mustSend = true;
                } else if ((double)thisAllocation > (double)last * 1.05) {
                    if (logMINOR) {
                        Logger.minor(this, "Last allocation was " + last + " this is " + thisAllocation);
                    }
                    mustSend = true;
                } else if ((double)thisAllocation < (double)last * 0.9) {
                    if (logMINOR) {
                        Logger.minor(this, "Last allocation was " + last + " this is " + thisAllocation);
                    }
                    mustSend = true;
                }
                if (!mustSend) {
                    return;
                }
                this.sendASAP = true;
            }
            if (!mustSend) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSetMaxOutputTransfers(int maxOutputTransfers) {
            LoadSender loadSender = this;
            synchronized (loadSender) {
                if (maxOutputTransfers == this.lastSentMaxOutputTransfers) {
                    return;
                }
                if (this.lastSentMaxOutputTransfers == Integer.MAX_VALUE || this.lastSentMaxOutputTransfers == 0) {
                    this.sendASAP = true;
                } else if ((double)maxOutputTransfers > (double)this.lastSentMaxOutputTransfers * 1.05 || (double)maxOutputTransfers < (double)this.lastSentMaxOutputTransfers * 0.9) {
                    this.sendASAP = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSetMaxOutputTransfersPeerLimit(int maxOutputTransfersPeerLimit) {
            LoadSender loadSender = this;
            synchronized (loadSender) {
                if (maxOutputTransfersPeerLimit == this.lastSentMaxOutputTransfersPeerLimit) {
                    return;
                }
                if (this.lastSentMaxOutputTransfersPeerLimit == Integer.MAX_VALUE || this.lastSentMaxOutputTransfersPeerLimit == 0) {
                    this.sendASAP = true;
                } else if ((double)maxOutputTransfersPeerLimit > (double)this.lastSentMaxOutputTransfersPeerLimit * 1.05 || (double)maxOutputTransfersPeerLimit < (double)this.lastSentMaxOutputTransfersPeerLimit * 0.9) {
                    this.sendASAP = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Message makeLoadStats(long now, int transfersPerInsert, boolean noRemember) {
            NodeStats.PeerLoadStats stats = PeerNode.this.node.nodeStats.createPeerLoadStats(PeerNode.this, transfersPerInsert, this.realTimeFlag);
            LoadSender loadSender = this;
            synchronized (loadSender) {
                this.lastSentAllocationInput = (int)stats.inputBandwidthPeerLimit;
                this.lastSentAllocationOutput = (int)stats.outputBandwidthPeerLimit;
                this.lastSentMaxOutputTransfers = stats.maxTransfersOut;
                if (!noRemember) {
                    if (this.lastFullStats != null && this.lastFullStats.equals(stats)) {
                        return null;
                    }
                    this.lastFullStats = stats;
                }
                this.timeLastSentAllocationNotice = now;
                ++this.countAllocationNotices;
                if (logMINOR) {
                    Logger.minor(this, "Sending allocation notice to " + this + " allocation is " + this.lastSentAllocationInput + " input " + this.lastSentAllocationOutput + " output.");
                }
            }
            Message msg = DMT.createFNPPeerLoadStatus(stats);
            return msg;
        }

        public synchronized boolean grabSendASAP() {
            boolean send = this.sendASAP;
            this.sendASAP = false;
            return send;
        }

        public synchronized void setSendASAP() {
            this.sendASAP = true;
        }
    }

    private class SyncMessageCallback
    implements AsyncMessageCallback {
        private boolean done = false;
        private boolean disconnected = false;
        private boolean sent = false;

        private SyncMessageCallback() {
        }

        public synchronized void waitForSend(long maxWaitInterval) throws NotConnectedException {
            long now = System.currentTimeMillis();
            long end = now + maxWaitInterval;
            while ((now = System.currentTimeMillis()) < end) {
                if (this.done) {
                    if (this.disconnected) {
                        throw new NotConnectedException();
                    }
                    return;
                }
                int waitTime = (int)Math.min(end - now, Integer.MAX_VALUE);
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acknowledged() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                if (!this.done) {
                    if (!this.sent) {
                        Logger.normal(this, "Acknowledged but not sent?! on " + this + " for " + PeerNode.this + " - lag ???");
                    }
                } else {
                    return;
                }
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnected() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                this.done = true;
                this.disconnected = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fatalError() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sent() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                this.sent = true;
            }
        }
    }
}

