/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import freenet.crypt.BlockCipher;
import freenet.crypt.JceLoader;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael_Algorithm;
import freenet.support.Logger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Rijndael
implements BlockCipher {
    private Object sessionKey;
    private final int keysize;
    private final int blocksize;
    public static final Provider AesCtrProvider = Rijndael.getAesCtrProvider();

    public static String getProviderName() {
        return AesCtrProvider != null ? AesCtrProvider.getName() : null;
    }

    private static long benchmark(Cipher cipher, SecretKeySpec key, IvParameterSpec IV) throws GeneralSecurityException {
        int i;
        long times = Long.MAX_VALUE;
        byte[] input = new byte[1024];
        byte[] output = new byte[input.length * 32];
        cipher.init(1, (Key)key, IV);
        for (i = 0; i < 32; ++i) {
            cipher.doFinal(input, 0, input.length, output, 0);
            System.arraycopy(output, 0, input, 0, input.length);
        }
        for (i = 0; i < 128; ++i) {
            long startTime = System.nanoTime();
            cipher.init(1, (Key)key, IV);
            for (int j = 0; j < 4; ++j) {
                int ofs = 0;
                for (int k = 0; k < 32; ++k) {
                    ofs += cipher.update(input, 0, input.length, output, ofs);
                }
                cipher.doFinal(output, ofs);
            }
            long endTime = System.nanoTime();
            times = Math.min(endTime - startTime, times);
            System.arraycopy(output, 0, input, 0, input.length);
        }
        return times;
    }

    private static Provider getAesCtrProvider() {
        try {
            String algo = "AES/CTR/NOPADDING";
            Provider bcastle = JceLoader.BouncyCastle;
            Class<Rijndael> clazz = Rijndael.class;
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            byte[] plaintext = new byte[16];
            SecretKeySpec k = new SecretKeySpec(key, "AES");
            IvParameterSpec IV = new IvParameterSpec(iv);
            Cipher c = Cipher.getInstance("AES/CTR/NOPADDING");
            c.init(1, (Key)k, IV);
            Provider provider = c.getProvider();
            if (bcastle != null) {
                try {
                    Cipher bcastle_cipher = Cipher.getInstance("AES/CTR/NOPADDING", bcastle);
                    bcastle_cipher.init(1, (Key)k, IV);
                    Provider bcastle_provider = bcastle_cipher.getProvider();
                    if (provider != bcastle_provider) {
                        long time_def = Rijndael.benchmark(c, k, IV);
                        long time_bcastle = Rijndael.benchmark(bcastle_cipher, k, IV);
                        System.out.println("AES/CTR/NOPADDING (" + provider + "): " + time_def + "ns");
                        System.out.println("AES/CTR/NOPADDING (" + bcastle_provider + "): " + time_bcastle + "ns");
                        Logger.minor(clazz, "AES/CTR/NOPADDING/" + provider + ": " + time_def + "ns");
                        Logger.minor(clazz, "AES/CTR/NOPADDING/" + bcastle_provider + ": " + time_bcastle + "ns");
                        if (time_bcastle < time_def) {
                            provider = bcastle_provider;
                            c = bcastle_cipher;
                        }
                    }
                }
                catch (GeneralSecurityException e) {
                    Logger.warning(clazz, "AES/CTR/NOPADDING@" + bcastle + " benchmark failed", (Throwable)e);
                }
                catch (Throwable e) {
                    Logger.error(clazz, "AES/CTR/NOPADDING@" + bcastle + " benchmark failed", e);
                }
            }
            c = Cipher.getInstance("AES/CTR/NOPADDING", provider);
            c.init(1, (Key)k, IV);
            c.doFinal(plaintext);
            Logger.normal(Rijndael.class, "Using JCA: provider " + provider);
            System.out.println("Using JCA cipher provider: " + provider);
            return provider;
        }
        catch (GeneralSecurityException e) {
            Logger.warning(Rijndael.class, "Not using JCA as it is crippled (can't use 256-bit keys). Will use built-in encryption. ", (Throwable)e);
            return null;
        }
    }

    public Rijndael(int keysize, int blocksize) throws UnsupportedCipherException {
        if (keysize != 128 && keysize != 192 && keysize != 256) {
            throw new UnsupportedCipherException("Invalid keysize");
        }
        if (blocksize != 128 && blocksize != 256) {
            throw new UnsupportedCipherException("Invalid blocksize");
        }
        this.keysize = keysize;
        this.blocksize = blocksize;
    }

    public Rijndael() {
        this.keysize = 128;
        this.blocksize = 128;
    }

    @Override
    public final int getBlockSize() {
        return this.blocksize;
    }

    @Override
    public final int getKeySize() {
        return this.keysize;
    }

    @Override
    public final void initialize(byte[] key) {
        try {
            byte[] nkey = new byte[this.keysize >> 3];
            System.arraycopy(key, 0, nkey, 0, nkey.length);
            this.sessionKey = Rijndael_Algorithm.makeKey(nkey, this.blocksize / 8);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            Logger.error(this, "Invalid key");
        }
    }

    @Override
    public final synchronized void encipher(byte[] block, byte[] result) {
        if (block.length != this.blocksize / 8) {
            throw new IllegalArgumentException();
        }
        Rijndael_Algorithm.blockEncrypt(block, result, 0, this.sessionKey, this.blocksize / 8);
    }

    @Override
    public final synchronized void decipher(byte[] block, byte[] result) {
        if (block.length != this.blocksize / 8) {
            throw new IllegalArgumentException();
        }
        Rijndael_Algorithm.blockDecrypt(block, result, 0, this.sessionKey, this.blocksize / 8);
    }
}

