/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;

public class FCPConnectionOutputHandler
implements Runnable {
    final FCPConnectionHandler handler;
    final Deque<FCPMessage> outQueue;
    private boolean closedOutputQueue;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;

    public FCPConnectionOutputHandler(FCPConnectionHandler handler) {
        this.handler = handler;
        this.outQueue = new ArrayDeque<FCPMessage>();
    }

    void start() {
        if (this.handler.sock == null) {
            return;
        }
        this.handler.server.node.executor.execute(this, "FCP output handler for " + this.handler.sock.getRemoteSocketAddress() + ':' + this.handler.sock.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (IOException e) {
            if (logMINOR) {
                Logger.minor(this, "Caught " + e, (Throwable)e);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
        finally {
            Deque<FCPMessage> e = this.outQueue;
            synchronized (e) {
                this.closedOutputQueue = true;
            }
        }
        this.handler.close();
        this.handler.closedOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void realRun() throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(this.handler.sock.getOutputStream(), 4096);
        while (true) {
            boolean closed;
            FCPMessage msg = null;
            boolean flushed = false;
            while (true) {
                closed = this.handler.isClosed();
                boolean shouldFlush = false;
                Deque<FCPMessage> deque = this.outQueue;
                synchronized (deque) {
                    block13: {
                        block12: {
                            if (!this.outQueue.isEmpty()) break block12;
                            if (closed) {
                                this.closedOutputQueue = true;
                                this.outQueue.notifyAll();
                                break;
                            }
                            if (!flushed) {
                                shouldFlush = true;
                                break block13;
                            } else {
                                try {
                                    this.outQueue.wait(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                continue;
                            }
                        }
                        msg = this.outQueue.removeFirst();
                    }
                    if (!shouldFlush) break;
                }
                if (logMINOR) {
                    Logger.minor(this, "Flushing");
                }
                ((OutputStream)os).flush();
                flushed = true;
            }
            if (msg == null) {
                if (!closed) continue;
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Sending " + msg);
            }
            msg.send(os);
            flushed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void queue(FCPMessage msg) {
        if (logDEBUG) {
            Logger.debug(this, "Queueing " + msg, (Throwable)new Exception("debug"));
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        boolean neverDropAMessage = this.handler.server.neverDropAMessage();
        int MAX_QUEUE_LENGTH = this.handler.server.maxMessageQueueLength();
        Deque<FCPMessage> deque = this.outQueue;
        synchronized (deque) {
            if (this.closedOutputQueue) {
                Logger.error(this, "Closed already: " + this + " queueing message " + msg);
                return;
            }
            if (this.outQueue.size() >= MAX_QUEUE_LENGTH) {
                if (neverDropAMessage) {
                    Logger.error(this, "FCP message queue length is " + this.outQueue.size() + " for " + this.handler + " - not dropping message as configured...");
                } else {
                    Logger.error(this, "Dropping FCP message to " + this.handler + " : " + this.outQueue.size() + " messages queued - maybe client died?", (Throwable)new Exception("debug"));
                    return;
                }
            }
            this.outQueue.add(msg);
            this.outQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed() {
        Deque<FCPMessage> deque = this.outQueue;
        synchronized (deque) {
            this.outQueue.notifyAll();
            while (!this.outQueue.isEmpty()) {
                if (this.closedOutputQueue) {
                    return;
                }
                try {
                    this.outQueue.wait(1500L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueHalfFull() {
        int MAX_QUEUE_LENGTH = this.handler.server.maxMessageQueueLength();
        Deque<FCPMessage> deque = this.outQueue;
        synchronized (deque) {
            return this.outQueue.size() > MAX_QUEUE_LENGTH / 2;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

