/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.DefaultMIMETypes;
import freenet.clients.fcp.ClientPutDirMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.api.ManifestElement;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ClientPutDiskDirMessage
extends ClientPutDirMessage {
    public static final String NAME = "ClientPutDiskDir";
    final File dirname;
    final boolean allowUnreadableFiles;
    final boolean includeHiddenFiles;
    private static volatile boolean logMINOR;

    public ClientPutDiskDirMessage(SimpleFieldSet fs) throws MessageInvalidException {
        super(fs);
        this.allowUnreadableFiles = fs.getBoolean("AllowUnreadableFiles", false);
        this.includeHiddenFiles = fs.getBoolean("includeHiddenFiles", false);
        String fnam = fs.get("Filename");
        if (fnam == null) {
            throw new MessageInvalidException(5, "Filename missing", this.identifier, this.global);
        }
        this.dirname = new File(fnam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.server.core.allowUploadFrom(this.dirname)) {
            throw new MessageInvalidException(24, "Not allowed to upload from " + this.dirname, this.identifier, this.global);
        }
        HashMap<String, Object> buckets = this.makeBucketsByName(this.dirname, "");
        handler.startClientPutDir(this, buckets, true);
    }

    private HashMap<String, Object> makeBucketsByName(File thisdir, String prefix) throws MessageInvalidException {
        if (logMINOR) {
            Logger.minor(this, "Listing directory: " + thisdir);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        File[] filelist = thisdir.listFiles();
        if (filelist == null) {
            throw new MessageInvalidException(9, "No such directory!", this.identifier, this.global);
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isHidden() && !this.includeHiddenFiles) continue;
            if (filelist[i].canRead() && filelist[i].exists()) {
                if (filelist[i].isFile()) {
                    File f = filelist[i];
                    FileBucket bucket = new FileBucket(f, true, false, false, false);
                    ret.put(f.getName(), new ManifestElement(f.getName(), prefix + f.getName(), bucket, DefaultMIMETypes.guessMIMEType(f.getName(), true), f.length()));
                    continue;
                }
                if (filelist[i].isDirectory()) {
                    HashMap<String, Object> subdir = this.makeBucketsByName(new File(thisdir, filelist[i].getName()), prefix + filelist[i].getName() + '/');
                    ret.put(filelist[i].getName(), subdir);
                    continue;
                }
                if (this.allowUnreadableFiles) continue;
                throw new MessageInvalidException(9, "Not directory and not file: " + filelist[i], this.identifier, this.global);
            }
            if (this.allowUnreadableFiles) continue;
            throw new MessageInvalidException(9, "Not readable or doesn't exist: " + filelist[i], this.identifier, this.global);
        }
        return ret;
    }

    @Override
    long dataLength() {
        return 0L;
    }

    String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

