/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequester;
import freenet.clients.fcp.ClientPutBase;
import freenet.clients.fcp.ClientPutMessage;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.NotAllowedException;
import freenet.clients.fcp.PersistentPut;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.RequestIdentifier;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.RequestStatusCache;
import freenet.clients.fcp.SimpleProgressMessage;
import freenet.clients.fcp.UploadFileRequestStatus;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.support.Base64;
import freenet.support.CurrentTimeUTC;
import freenet.support.IllegalBase64Exception;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.Closer;
import freenet.support.io.ResumeFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;

public class ClientPut
extends ClientPutBase {
    private static final long serialVersionUID = 1L;
    ClientPutter putter;
    private final ClientPutBase.UploadFrom uploadFrom;
    private final File origFilename;
    private final FreenetURI targetURI;
    private RandomAccessBucket data;
    private final ClientMetadata clientMetadata;
    private long finishedSize;
    private final String targetFilename;
    private final boolean binaryBlob;
    private transient boolean compressing;
    private boolean compressed;
    private static volatile boolean logMINOR;

    public ClientPut(PersistentRequestClient globalClient, FreenetURI uri, String identifier, int verbosity, String charset, short priorityClass, ClientRequest.Persistence persistence, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, ClientPutBase.UploadFrom uploadFromType, File origFilename, String contentType, RandomAccessBucket data, FreenetURI redirectTarget, String targetFilename, boolean earlyEncode, boolean canWriteClientCache, boolean forkOnCacheable, int extraInsertsSingleBlock, int extraInsertsSplitfileHeaderBlock, boolean realTimeFlag, InsertContext.CompatibilityMode compatMode, byte[] overrideSplitfileKey, boolean binaryBlob, NodeClientCore core) throws IdentifierCollisionException, NotAllowedException, MetadataUnresolvedException, IOException {
        uri = ClientPut.checkEmptySSK(uri, targetFilename, core.clientContext);
        super(uri, identifier, verbosity, charset, null, globalClient, priorityClass, persistence, null, true, getCHKOnly, dontCompress, maxRetries, earlyEncode, canWriteClientCache, forkOnCacheable, false, extraInsertsSingleBlock, extraInsertsSplitfileHeaderBlock, realTimeFlag, null, compatMode, false, core);
        if (uploadFromType == ClientPutBase.UploadFrom.DISK) {
            if (!core.allowUploadFrom(origFilename)) {
                throw new NotAllowedException();
            }
            if (!origFilename.exists() || !origFilename.canRead()) {
                throw new FileNotFoundException();
            }
        }
        this.binaryBlob = binaryBlob;
        if (binaryBlob) {
            contentType = null;
        }
        this.targetFilename = targetFilename;
        this.uploadFrom = uploadFromType;
        this.origFilename = origFilename;
        String mimeType = contentType;
        this.clientToken = clientToken;
        RandomAccessBucket tempData = data;
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        if (logMINOR) {
            Logger.minor(this, "data = " + tempData + ", uploadFrom = " + (Object)((Object)this.uploadFrom));
        }
        if (this.uploadFrom == ClientPutBase.UploadFrom.REDIRECT) {
            this.targetURI = redirectTarget;
            Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, this.targetURI, cm);
            tempData = m.toBucket(core.clientContext.getBucketFactory(this.isPersistentForever()));
            isMetadata = true;
        } else {
            this.targetURI = null;
        }
        this.data = tempData;
        this.clientMetadata = cm;
        this.putter = new ClientPutter(this, data, this.uri, cm, this.ctx, priorityClass, isMetadata, this.uri.getDocName() == null ? targetFilename : null, binaryBlob, core.clientContext, overrideSplitfileKey, -1L);
    }

    public ClientPut(FCPConnectionHandler handler, ClientPutMessage message, FCPServer server) throws IdentifierCollisionException, MessageInvalidException, IOException {
        super(ClientPut.checkEmptySSK(message.uri, message.targetFilename, server.core.clientContext), message.identifier, message.verbosity, null, handler, message.priorityClass, message.persistence, message.clientToken, message.global, message.getCHKOnly, message.dontCompress, message.localRequestOnly, message.maxRetries, message.earlyEncode, message.canWriteClientCache, message.forkOnCacheable, message.compressorDescriptor, message.extraInsertsSingleBlock, message.extraInsertsSplitfileHeaderBlock, message.realTimeFlag, message.compatibilityMode, message.ignoreUSKDatehints, server);
        String salt = null;
        byte[] saltedHash = null;
        this.binaryBlob = message.binaryBlob;
        if (message.uploadFromType == ClientPutBase.UploadFrom.DISK) {
            if (!handler.server.core.allowUploadFrom(message.origFilename)) {
                throw new MessageInvalidException(24, "Not allowed to upload from " + message.origFilename, this.identifier, this.global);
            }
            if (message.fileHash != null) {
                try {
                    salt = handler.connectionIdentifier + '-' + message.identifier + '-';
                    saltedHash = Base64.decodeStandard(message.fileHash);
                }
                catch (IllegalBase64Exception e) {
                    try {
                        saltedHash = Base64.decode(message.fileHash);
                    }
                    catch (IllegalBase64Exception e1) {
                        throw new MessageInvalidException(8, "Can't base64 decode FileHash", this.identifier, this.global);
                    }
                }
            } else if (!handler.allowDDAFrom(message.origFilename, false)) {
                throw new MessageInvalidException(25, "Not allowed to upload from " + message.origFilename + ". Have you done a testDDA previously ?", this.identifier, this.global);
            }
        }
        this.targetFilename = message.targetFilename;
        this.uploadFrom = message.uploadFromType;
        this.origFilename = message.origFilename;
        String mimeType = message.contentType;
        if (this.binaryBlob && mimeType != null && !mimeType.equals("application/x-freenet-binary-blob")) {
            throw new MessageInvalidException(8, "No MIME type allowed when inserting a binary blob", this.identifier, this.global);
        }
        if (mimeType == null && this.origFilename != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.origFilename.getName(), true);
        }
        if (mimeType == null && this.targetFilename != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.targetFilename, true);
        }
        if (mimeType != null && mimeType.equals("")) {
            mimeType = null;
        }
        if (mimeType != null && !DefaultMIMETypes.isPlausibleMIMEType(mimeType)) {
            throw new MessageInvalidException(35, "Bad MIME type in Metadata.ContentType", this.identifier, this.global);
        }
        this.clientToken = message.clientToken;
        RandomAccessBucket tempData = message.getRandomAccessBucket();
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        if (logMINOR) {
            Logger.minor(this, "data = " + tempData + ", uploadFrom = " + (Object)((Object)this.uploadFrom));
        }
        if (this.uploadFrom == ClientPutBase.UploadFrom.REDIRECT) {
            this.targetURI = message.redirectTarget;
            Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, this.targetURI, cm);
            try {
                tempData = m.toBucket(server.core.clientContext.getBucketFactory(this.isPersistentForever()));
            }
            catch (MetadataUnresolvedException e) {
                Logger.error(this, "Impossible: " + e, (Throwable)e);
                this.data = null;
                this.clientMetadata = cm;
                this.putter = null;
                throw new MessageInvalidException(17, "Impossible: metadata unresolved: " + e, this.identifier, this.global);
            }
            isMetadata = true;
        } else {
            this.targetURI = null;
        }
        this.data = tempData;
        this.clientMetadata = cm;
        if (salt != null) {
            MessageDigest md = SHA256.getMessageDigest();
            try {
                md.update(salt.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            InputStream is = null;
            try {
                is = this.data.getInputStream();
                SHA256.hash(is, md);
            }
            catch (IOException e) {
                SHA256.returnMessageDigest(md);
                Logger.error(this, "Got IOE: " + e.getMessage(), (Throwable)e);
                throw new MessageInvalidException(26, "Unable to access file: " + e, this.identifier, this.global);
            }
            finally {
                Closer.close(is);
            }
            byte[] foundHash = md.digest();
            SHA256.returnMessageDigest(md);
            if (logMINOR) {
                Logger.minor(this, "FileHash result : we found " + Base64.encode(foundHash) + " and were given " + Base64.encode(saltedHash) + '.');
            }
            if (!Arrays.equals(saltedHash, foundHash)) {
                throw new MessageInvalidException(25, "The hash doesn't match! (salt used : \"" + salt + "\")", this.identifier, this.global);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "data = " + this.data + ", uploadFrom = " + (Object)((Object)this.uploadFrom));
        }
        this.putter = new ClientPutter(this, this.data, this.uri, cm, this.ctx, this.priorityClass, isMetadata, this.uri.getDocName() == null ? this.targetFilename : null, this.binaryBlob, server.core.clientContext, message.overrideSplitfileCryptoKey, message.metadataThreshold);
    }

    protected ClientPut() {
        this.uploadFrom = null;
        this.origFilename = null;
        this.targetURI = null;
        this.clientMetadata = null;
        this.finishedSize = 0L;
        this.targetFilename = null;
        this.binaryBlob = false;
    }

    @Override
    void register(boolean noTags) throws IdentifierCollisionException {
        if (this.persistence != ClientRequest.Persistence.CONNECTION) {
            this.client.register(this);
        }
        if (this.persistence != ClientRequest.Persistence.CONNECTION && !noTags) {
            FCPMessage msg = this.persistentTagMessage();
            this.client.queueClientRequestMessage(msg, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " : " + this.identifier);
        }
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.finished) {
                return;
            }
        }
        try {
            RequestStatusCache cache;
            Object msg;
            this.putter.start(false, context);
            if (this.persistence != ClientRequest.Persistence.CONNECTION && !this.finished) {
                msg = this.persistentTagMessage();
                this.client.queueClientRequestMessage((FCPMessage)msg, 0);
            }
            msg = this;
            synchronized (msg) {
                this.started = true;
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStarted(this.identifier, true);
            }
        }
        catch (InsertException e) {
            ClientPut clientPut2 = this;
            synchronized (clientPut2) {
                this.started = true;
            }
            this.onFailure(e, null);
        }
        catch (Throwable t) {
            ClientPut clientPut3 = this;
            synchronized (clientPut3) {
                this.started = true;
            }
            this.onFailure(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, t, null), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData() {
        RandomAccessBucket d;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            d = this.data;
            this.data = null;
            if (d == null) {
                return;
            }
            this.finishedSize = d.size();
        }
        d.free();
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    protected FCPMessage persistentTagMessage() {
        if (this.putter == null) {
            Logger.error(this, "putter == null", (Throwable)new Exception("error"));
        }
        return new PersistentPut(this.identifier, this.publicURI, this.uri, this.verbosity, this.priorityClass, this.uploadFrom, this.targetURI, this.persistence, this.origFilename, this.clientMetadata.getMIMEType(), this.client.isGlobalQueue, this.getDataSize(), this.clientToken, this.started, this.ctx.maxInsertRetries, this.targetFilename, this.binaryBlob, this.ctx.getCompatibilityMode(), this.ctx.dontCompress, this.ctx.compressorDescriptor, this.isRealTime(), this.putter != null ? this.putter.getSplitfileCryptoKey() : null);
    }

    private boolean isRealTime() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
            return false;
        }
        return this.lowLevelClient.realTimeFlag();
    }

    @Override
    protected String getTypeName() {
        return "PUT";
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public FreenetURI getFinalURI() {
        return this.generatedURI;
    }

    public boolean isDirect() {
        return this.uploadFrom == ClientPutBase.UploadFrom.DIRECT;
    }

    public File getOrigFilename() {
        if (this.uploadFrom != ClientPutBase.UploadFrom.DISK) {
            return null;
        }
        return this.origFilename;
    }

    public long getDataSize() {
        if (this.data == null) {
            return this.finishedSize;
        }
        return this.data.size();
    }

    public String getMIMEType() {
        return this.clientMetadata.getMIMEType();
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return this.putter.canRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restart(ClientContext context, boolean disableFilterData) {
        if (!this.canRestart()) {
            return false;
        }
        this.setVarsRestart();
        try {
            Object cache;
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                ((RequestStatusCache)cache).updateStarted(this.identifier, false);
            }
            if (this.putter.restart(context)) {
                cache = this;
                synchronized (cache) {
                    this.generatedURI = null;
                    this.started = true;
                }
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                ((RequestStatusCache)cache).updateStarted(this.identifier, true);
            }
            return true;
        }
        catch (InsertException e) {
            this.onFailure(e, null);
            return false;
        }
    }

    @Override
    public void setVarsRestart() {
        RequestStatusCache cache;
        super.setVarsRestart();
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateCompressionStatus(this.identifier, this.isCompressing());
        }
    }

    @Override
    public void requestWasRemoved(ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            this.putter = null;
        }
        super.requestWasRemoved(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COMPRESS_STATE isCompressing() {
        if (this.ctx.dontCompress) {
            return COMPRESS_STATE.WORKING;
        }
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (!this.compressed) {
                return COMPRESS_STATE.WAITING;
            }
            if (this.compressing) {
                return COMPRESS_STATE.COMPRESSING;
            }
            return COMPRESS_STATE.WORKING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStartCompressing() {
        RequestStatusCache cache;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.compressed) {
                return;
            }
            this.compressing = true;
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateCompressionStatus(this.identifier, COMPRESS_STATE.COMPRESSING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStopCompressing() {
        RequestStatusCache cache;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.compressed) {
                return;
            }
            this.compressing = false;
            this.compressed = true;
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateCompressionStatus(this.identifier, COMPRESS_STATE.WORKING);
        }
    }

    @Override
    RequestStatus getStatus() {
        File fnam;
        FreenetURI finalURI = this.getFinalURI();
        InsertException.InsertExceptionMode failureCode = null;
        String failureReasonShort = null;
        String failureReasonLong = null;
        if (this.putFailedMessage != null) {
            failureCode = this.putFailedMessage.code;
            failureReasonShort = this.putFailedMessage.getShortFailedMessage();
            failureReasonShort = this.putFailedMessage.getLongFailedMessage();
        }
        String mimeType = null;
        if (this.persistence == ClientRequest.Persistence.FOREVER) {
            mimeType = this.clientMetadata.getMIMEType();
        }
        if ((fnam = this.getOrigFilename()) != null) {
            fnam = new File(fnam.getPath());
        }
        int total = 0;
        int min = 0;
        int fetched = 0;
        int fatal = 0;
        int failed = 0;
        Date latestSuccess = CurrentTimeUTC.get();
        Date latestFailure = null;
        boolean totalFinalized = false;
        if (this.progressMessage != null && this.progressMessage instanceof SimpleProgressMessage) {
            SimpleProgressMessage msg = (SimpleProgressMessage)this.progressMessage;
            total = (int)msg.getTotalBlocks();
            min = (int)msg.getMinBlocks();
            fetched = (int)msg.getFetchedBlocks();
            latestSuccess = msg.getLatestSuccess();
            fatal = (int)msg.getFatalyFailedBlocks();
            failed = (int)msg.getFailedBlocks();
            latestFailure = msg.getLatestFailure();
            totalFinalized = msg.isTotalFinalized();
        }
        return new UploadFileRequestStatus(this.identifier, this.persistence, this.started, this.finished, this.succeeded, total, min, fetched, latestSuccess, fatal, failed, latestFailure, totalFinalized, this.priorityClass, finalURI, this.uri, failureCode, failureReasonShort, failureReasonLong, this.getDataSize(), mimeType, fnam, this.isCompressing());
    }

    @Override
    public void innerResume(ClientContext context) throws ResumeFailedException {
        if (this.data != null) {
            this.data.onResume(context);
        }
    }

    @Override
    RequestIdentifier.RequestType getType() {
        return RequestIdentifier.RequestType.PUT;
    }

    @Override
    public boolean fullyResumed() {
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static enum COMPRESS_STATE {
        WAITING,
        COMPRESSING,
        WORKING;

    }
}

