/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.upnp;

import plugins.UPnP.org.cybergarage.upnp.AllowedValue;
import plugins.UPnP.org.cybergarage.upnp.AllowedValueList;
import plugins.UPnP.org.cybergarage.upnp.AllowedValueRange;
import plugins.UPnP.org.cybergarage.upnp.Service;
import plugins.UPnP.org.cybergarage.upnp.UPnPStatus;
import plugins.UPnP.org.cybergarage.upnp.control.QueryListener;
import plugins.UPnP.org.cybergarage.upnp.control.QueryRequest;
import plugins.UPnP.org.cybergarage.upnp.control.QueryResponse;
import plugins.UPnP.org.cybergarage.upnp.xml.NodeData;
import plugins.UPnP.org.cybergarage.upnp.xml.StateVariableData;
import plugins.UPnP.org.cybergarage.util.Debug;
import plugins.UPnP.org.cybergarage.xml.Node;

public class StateVariable
extends NodeData {
    public static final String ELEM_NAME = "stateVariable";
    private Node stateVariableNode;
    private Node serviceNode;
    private static final String NAME = "name";
    private static final String DATATYPE = "dataType";
    private static final String SENDEVENTS = "sendEvents";
    private static final String SENDEVENTS_YES = "yes";
    private static final String SENDEVENTS_NO = "no";
    private UPnPStatus upnpStatus = new UPnPStatus();

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public Service getService() {
        Node serviceNode = this.getServiceNode();
        if (serviceNode == null) {
            return null;
        }
        return new Service(serviceNode);
    }

    public Node getStateVariableNode() {
        return this.stateVariableNode;
    }

    public StateVariable() {
        this.serviceNode = null;
        this.stateVariableNode = new Node();
    }

    public StateVariable(Node serviceNode, Node stateVarNode) {
        this.serviceNode = serviceNode;
        this.stateVariableNode = stateVarNode;
    }

    public static boolean isStateVariableNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setName(String value) {
        this.getStateVariableNode().setNode(NAME, value);
    }

    public String getName() {
        return this.getStateVariableNode().getNodeValue(NAME);
    }

    public void setDataType(String value) {
        this.getStateVariableNode().setNode(DATATYPE, value);
    }

    public String getDataType() {
        return this.getStateVariableNode().getNodeValue(DATATYPE);
    }

    public void setSendEvents(boolean state) {
        this.getStateVariableNode().setAttribute(SENDEVENTS, state ? SENDEVENTS_YES : SENDEVENTS_NO);
    }

    public boolean isSendEvents() {
        String state = this.getStateVariableNode().getAttributeValue(SENDEVENTS);
        if (state == null) {
            return false;
        }
        return state.equalsIgnoreCase(SENDEVENTS_YES);
    }

    public void set(StateVariable stateVar) {
        this.setName(stateVar.getName());
        this.setValue(stateVar.getValue());
        this.setDataType(stateVar.getDataType());
        this.setSendEvents(stateVar.isSendEvents());
    }

    public StateVariableData getStateVariableData() {
        Node node = this.getStateVariableNode();
        StateVariableData userData = (StateVariableData)node.getUserData();
        if (userData == null) {
            userData = new StateVariableData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    public void setValue(String value) {
        String currValue = this.getStateVariableData().getValue();
        if (currValue != null && currValue.equals(value)) {
            return;
        }
        this.getStateVariableData().setValue(value);
        Service service = this.getService();
        if (service == null) {
            return;
        }
        if (!this.isSendEvents()) {
            return;
        }
        service.notify(this);
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public void setValue(long value) {
        this.setValue(Long.toString(value));
    }

    public String getValue() {
        return this.getStateVariableData().getValue();
    }

    public AllowedValueList getAllowedValueList() {
        AllowedValueList valueList = new AllowedValueList();
        Node valueListNode = this.getStateVariableNode().getNode("allowedValueList");
        if (valueListNode == null) {
            return valueList;
        }
        int nNode = valueListNode.getNNodes();
        for (int n = 0; n < nNode; ++n) {
            Node node = valueListNode.getNode(n);
            if (!AllowedValue.isAllowedValueNode(node)) continue;
            AllowedValue allowedVal = new AllowedValue(node);
            valueList.add(allowedVal);
        }
        return valueList;
    }

    public boolean hasAllowedValueList() {
        AllowedValueList valueList = this.getAllowedValueList();
        return 0 < valueList.size();
    }

    public AllowedValueRange getAllowedValueRange() {
        Node valueRangeNode = this.getStateVariableNode().getNode("allowedValueRange");
        if (valueRangeNode == null) {
            return null;
        }
        return new AllowedValueRange(valueRangeNode);
    }

    public boolean hasAllowedValueRange() {
        return this.getAllowedValueRange() != null;
    }

    public QueryListener getQueryListener() {
        return this.getStateVariableData().getQueryListener();
    }

    public void setQueryListener(QueryListener listener) {
        this.getStateVariableData().setQueryListener(listener);
    }

    public boolean performQueryListener(QueryRequest queryReq) {
        QueryListener listener = this.getQueryListener();
        if (listener == null) {
            return false;
        }
        QueryResponse queryRes = new QueryResponse();
        StateVariable retVar = new StateVariable();
        retVar.set(this);
        retVar.setValue("");
        retVar.setStatus(404);
        if (listener.queryControlReceived(retVar)) {
            queryRes.setResponse(retVar);
        } else {
            UPnPStatus upnpStatus = retVar.getStatus();
            queryRes.setFaultResponse(upnpStatus.getCode(), upnpStatus.getDescription());
        }
        queryReq.post(queryRes);
        return true;
    }

    public QueryResponse getQueryResponse() {
        return this.getStateVariableData().getQueryResponse();
    }

    private void setQueryResponse(QueryResponse res) {
        this.getStateVariableData().setQueryResponse(res);
    }

    public UPnPStatus getQueryStatus() {
        return this.getQueryResponse().getUPnPError();
    }

    public boolean postQuerylAction() {
        QueryRequest queryReq = new QueryRequest();
        queryReq.setRequest(this);
        if (Debug.isOn()) {
            queryReq.print();
        }
        QueryResponse queryRes = queryReq.post();
        if (Debug.isOn()) {
            queryRes.print();
        }
        this.setQueryResponse(queryRes);
        if (!queryRes.isSuccessful()) {
            this.setValue(queryRes.getReturnValue());
            return false;
        }
        this.setValue(queryRes.getReturnValue());
        return true;
    }

    public void setStatus(int code, String descr) {
        this.upnpStatus.setCode(code);
        this.upnpStatus.setDescription(descr);
    }

    public void setStatus(int code) {
        this.setStatus(code, UPnPStatus.code2String(code));
    }

    public UPnPStatus getStatus() {
        return this.upnpStatus;
    }
}

